/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.jrtasks;

import guitools.toolkit.JDebug;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.JSvrResource;
import jet.ReportEnv;
import jet.cs.CSUtil;
import jet.cs.CustomTaskManager;
import jet.cs.ValueTrigger;
import jet.exception.EngingPreinitException;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.SecurityContext;
import jet.server.api.TaskListenerException;
import jet.server.intf.engine.ReportEngine;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.jrtasks.RunRptTaskRoot;

public class ValueTriggerTask
extends RunRptTaskRoot {
    private Vector I = null;
    private boolean[] P_TASK_VALUE_TRIGGER = null;
    private long SEDU = 0L;
    private long WARNING = 0L;
    ReportEngine reportEngine = null;

    @Override
    public void init(Properties properties) throws Exception {
        super.init(properties);
        this.I = ValueTrigger.getTriggers(properties);
        if (this.I == null || this.I.size() == 0) {
            throw new RptServerException(196628, new Object[]{this.toString(), properties.toString()}, null);
        }
        this.SEDU = System.currentTimeMillis();
        this.WARNING = CSUtil.parseLong((String)properties.get("jrs.submit_time"));
        this.setServerInfo(properties);
    }

    public long getLongSubmitTime() {
        return this.WARNING;
    }

    public long getLongStartRunTime() {
        return this.SEDU;
    }

    @Override
    public void run() {
        try {
            if (this.hasListener) {
                try {
                    ServiceLogger.logDebug(6600043, this.listenerClass, 6);
                }
                catch (Throwable throwable) {
                    JDebug.WARNING((Throwable)throwable);
                }
                if (!this.taskListener.beforeRun(this.serverInfo)) {
                    try {
                        ServiceLogger.logDebug(6600042, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    TaskListenerException taskListenerException = new TaskListenerException(600001, (Object[])new String[]{this.listenerClass}, null);
                    this.appendError(SchdTools.getStackTraceString((Throwable)((Object)taskListenerException)));
                    throw taskListenerException;
                }
            }
            this.getJRTaskManager().delToMonitorRunningReport(this.getId());
            this.getJRTaskManager().addMonitorThreadRunningReport(this.getLaunchType(), this.getTaskClass(), new Date(), this.getSubmitTime(), this.getUid(), this.getCatalog(), this.getReport(), this.getParamFile(), this.getId(), this.getRunName(), this.getRunPort(), this.getPublishType());
            this.checkValues();
            try {
                if (this.hasListener && this.taskListener != null) {
                    String string = this.engineContext.getLocalHost();
                    String string2 = this.engineContext.getLocalPort();
                    boolean bl = this.engineContext.isLocal();
                    Properties properties = this.serverInfo.getTaskProperties();
                    if (properties == null) {
                        properties = new Properties();
                    }
                    if (string != null) {
                        properties.put("jrs.exec_host", string);
                    }
                    if (string2 != null) {
                        properties.put("jrs.exec_port", string2);
                    }
                    properties.put("jrs.is_local", bl + "");
                    this.taskListener.afterRun(this.serverInfo);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 3);
        }
    }

    public void checkValues() throws Throwable {
        block41: {
            try {
                ServiceLogger.logDebug(6600036, this, 6);
                ServiceLogger.logDebug(4600181, new Object[]{this.getRunTaskKey(), this.getTaskName(), this.getUid(), this.getCatalog(), this.getReport()}, 4);
            }
            catch (Throwable throwable) {
                JDebug.WARNING((Throwable)throwable);
            }
            this.createEngineContext();
            try {
                this.errId = false;
                if (this.getJRTaskManager().canRunReport(this)) {
                    Object object;
                    this.engineContext.setTaskID(this.getId());
                    this.engineContext.setSequenceID(this.sequenceID);
                    this.getJRTaskManager().addWaitingTaskToMonitor(this.getSequenceID(), this.getId(), "", 0, "", System.currentTimeMillis(), "", "", 3);
                    this.engineContext.createJREngine(this.uid, ReportEnv.getuid(), ReportEnv.gp(), "89Sfdswer470eGs190dfew324C", false, false);
                    this.getJRTaskManager().addRunningTaskToMonitor(this.getSequenceID(), this.getId(), this.getRunName() == null ? "" : this.getRunName(), this.getRunPort() == null ? "-1" : this.getRunPort(), System.currentTimeMillis(), 5);
                    ServiceLogger.logEngine(6600066, 4);
                    ServiceLogger.logEngine(6600129, this.engineContext, 4);
                    this.engineContext.setSingleThread(ServerEnv.getEngineSingleThread());
                    this.engineContext.setPriority(ServerEnv.getEnginePriority());
                    if (this.getLanguage() != null) {
                        this.engineContext.setLocale(this.getLanguage());
                    }
                    if (this.getEncoding() != null) {
                        this.engineContext.setEncoding(this.getEncoding());
                    }
                    this.engineContext.setUserName(this.getUid());
                    if (this.getRemoteHost() != null) {
                        this.engineContext.setClientName(this.getRemoteHost());
                    }
                    this.engineContext.setConnectionInfoProvider(this.getJRTaskManager().getConnectionInfoProvider());
                    this.engineContext.setConnection(this.getDBJdbcUrl(), this.getDBUser(), this.getDBPassword(), this.getDBJdbcDriver(), this.isGetJDBCSupportInfo());
                    this.getJRTaskManager().incRptTaskRef(this);
                    this.engineContext.setThrowException(true);
                    this.engineContext.addEngineListener(this.getId());
                    this.engineContext.setServerInfo(this.serverInfo);
                    if (this.cat != null && this.rpt != null) {
                        String string = JRTUtil.getRealPath(this.uid, this.cat, this.getJRTaskManager().getResourceManager());
                        String string2 = JRTUtil.getRealPath(this.uid, this.rpt, this.getJRTaskManager().getResourceManager());
                        this.engineContext.setReportName(this.uid, this.cat, -1, this.rpt, -1);
                        if (this.paramFile != null) {
                            this.engineContext.setParamFile(this.paramFile);
                        }
                        if (this.namedWherePortion != null && this.namedWherePortion.length() != 0) {
                            this.engineContext.setNamedWherePortion(this.namedWherePortion);
                        }
                        if (this.wherePortion != null && this.wherePortion.length() != 0) {
                            this.engineContext.setWherePortion(this.wherePortion);
                        }
                        if ((object = this.getJRTaskManager().getSecurityContext(ServerEnv.getActiveRealm(), this.uid, this.rpt, this.rptVerNum)) != null) {
                            this.engineContext.setSecurityContext((SecurityContext)object);
                        }
                        this.engineContext.setStableSecurityData(UserDataToolkit.getSecurityDataStableImpl(this.uid));
                        this.getJRTaskManager().addRunningTaskToMonitor(this.getSequenceID(), this.getId(), "", "-1", -1L, 6);
                        this.currentReport = this.engineContext.getCurrentReport().getName();
                        this.reportSetEngine = this.engineContext.getReportSetEngine(new String[]{this.currentReport}, null, null);
                        try {
                            this.manager.afterLoadReport(this.engineContext);
                        }
                        catch (Throwable throwable) {
                            JDebug.WARNING((Throwable)throwable);
                        }
                        this.reportEngine = this.engineContext.createReportEngine(this.currentReport);
                        this.reportEngine.runReport();
                        try {
                            ServiceLogger.logEngine(6600114, new Object[]{string2, string, this.paramFile, this.namedWherePortion, this.wherePortion}, 6);
                        }
                        catch (Throwable throwable) {
                            JDebug.WARNING((Throwable)throwable);
                        }
                    }
                    int n = this.I.size();
                    for (int i = 0; i < n; ++i) {
                        object = this.I.elementAt(i);
                        if (!(object instanceof ValueTrigger)) continue;
                        ValueTrigger valueTrigger = (ValueTrigger)object;
                        try {
                            ServiceLogger.logDebug(6600130, new Object[]{this.rpt, this.cat, this.paramFile, this.namedWherePortion, this.wherePortion, valueTrigger}, 6);
                        }
                        catch (Throwable throwable) {
                            JDebug.WARNING((Throwable)throwable);
                        }
                        boolean bl = this.engineContext.getBooleanReturnValue(valueTrigger.getName());
                        if (bl == valueTrigger.getValue()) {
                            try {
                                String string = this.getJRTaskManager().getSchedulingService().submitScheduledTask(this.uid, valueTrigger.getTask());
                            }
                            catch (Throwable throwable) {
                                this.appendError(SchdTools.getStackTraceString(throwable));
                                ServiceLogger.logDebug(6600131, new Object[]{valueTrigger.getTask(), this, valueTrigger}, 4);
                            }
                        }
                        ServiceLogger.logDebug(6600132, new Object[]{this.rpt, this.cat, this.paramFile, this.namedWherePortion, this.wherePortion, valueTrigger}, 6);
                    }
                    this.getJRTaskManager().addRunningTaskToMonitor(this.getSequenceID(), this.getId(), "", "-1", -1L, 7);
                    if (this.ifPrint) {
                        String string = this.reportEngine.getCom();
                        ServiceLogger.logDebug(6600123, new Object[]{this.rpt, this.cat, this.paramFile, this.whereClause, this.namedWherePortion, this.wherePortion, string, this.printer, this.engineContext}, 6);
                        this.reportEngine.print(this.currentReport, this.printer);
                        ServiceLogger.logDebug(6600124, new Object[]{this.rpt, this.cat, this.paramFile, this.whereClause, this.namedWherePortion, this.wherePortion, string, this.printer, this.engineContext}, 6);
                    }
                    this.getJRTaskManager().delToMonitorRunningReport(this.getId());
                    Hashtable hashtable = this.engineContext.getJREngineProperty();
                    if (this.engineContext != null) {
                        this.getJRTaskManager().addToMonitorFinishedReport(this.getId(), this.getTaskClass(), this.getLaunchType(), this.getUid(), this.serverInfo.getRemoteAddress(), this.getCatalog(), this.getReport(), this.getParamFile(), this.getParamValues(), null, null, Integer.parseInt((String)hashtable.get("totalPageNumber")), (String)hashtable.get("reason"), this.getLongSubmitTime(), this.getLongStartRunTime(), System.currentTimeMillis(), this.getWaitTime(), this.getRunName(), this.getRunPort(), this.getPublishType());
                    }
                    this.getJRTaskManager().addRunningTaskToMonitor(this.getSequenceID(), this.getId(), "", "-1", -1L, 8);
                    this.getJRTaskManager().decRptTaskRef(this);
                    if (!this.hasError()) {
                        this.getJRTaskManager().addFinishedTaskToMonitor(this.getSequenceID(), this.getId(), this.getRunName() == null ? "" : this.getRunName(), this.getRunPort() == null ? "-1" : this.getRunPort(), System.currentTimeMillis(), Integer.parseInt((String)hashtable.get("totalPageNumber")), "[Value Trigger Task]", (String)hashtable.get("reason"), (String)hashtable.get("status"), this.getReport());
                    }
                    this.engineContext.engineExit();
                    ServiceLogger.logEngine(6600125, this.engineContext, 4);
                    break block41;
                }
                this.appendError(JSvrResource.getDebug(6600126, String.valueOf(ValueTriggerTask.getMaxReports())));
                ServiceLogger.logDebug(6600127, new Object[]{String.valueOf(ValueTriggerTask.getMaxReports()), this.rpt, this.cat, this.paramFile, this.namedWherePortion, this.wherePortion}, 4);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                ServiceLogger.logDebug(SchdTools.getStackTraceString(throwable), 4);
                this.getJRTaskManager().delToMonitorRunningReport(this.getId());
                this.getJRTaskManager().decRptTaskRef(this);
                if (this.engineContext != null) {
                    this.engineContext.decRptEngineRef();
                }
                if (throwable instanceof ThreadDeath) {
                    this.engineContext = null;
                    throw throwable;
                }
                if (throwable instanceof EngingPreinitException && ((EngingPreinitException)throwable).getException() instanceof OutOfMemoryError) {
                    throwable2 = ((EngingPreinitException)throwable).getException();
                }
                if (throwable2 instanceof OutOfMemoryError) {
                    if (this.engineContext != null) {
                        this.engineContext.stopEngineReport();
                        this.engineContext.engineExit();
                        this.engineContext = null;
                    }
                    System.gc();
                    Runtime runtime = Runtime.getRuntime();
                    int n = 0;
                    while (runtime.freeMemory() < 1000000L) {
                        try {
                            System.gc();
                            if (n++ > 5) break;
                            Thread.currentThread().wait(1000L);
                        }
                        catch (Exception exception) {
                            ServiceLogger.logError(exception, 3);
                        }
                    }
                }
                if (!this.isThrowExcp) {
                    this.appendError(SchdTools.getStackTraceString(throwable2));
                }
                this.engineContext = null;
                throw throwable2;
            }
        }
        this.engineContext = null;
        if (ServerEnv.exeGC) {
            System.gc();
        }
        if (this.thrdThrow != null) {
            if (!this.isThrowExcp) {
                this.appendError(SchdTools.getStackTraceString(this.thrdThrow));
            } else {
                throw this.thrdThrow;
            }
        }
        try {
            ServiceLogger.logDebug(6600040, this, 6);
            ServiceLogger.logDebug(4600190, this.getRunTaskKey(), 4);
        }
        catch (Throwable throwable) {
            JDebug.WARNING((Throwable)throwable);
        }
    }

    @Override
    public Properties toProperties(Properties properties) {
        Properties properties2 = super.toProperties(properties);
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2 = ValueTrigger.toProperties(this.I, properties2);
        return properties2;
    }

    @Override
    protected void finalize() throws Throwable {
        this.I = null;
        super.finalize();
    }

    static {
        try {
            CustomTaskManager.registerCustomTask(CSUtil.P_TASK_VALUE_TRIGGER, ValueTriggerTask.class.getName(), null);
        }
        catch (Exception exception) {
            JDebug.WARNING((Throwable)exception);
        }
    }
}

