/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.dataengine.api.query.DatabaseMetadataInfo;
import jet.server.log.ServiceLogger;
import jet.server.util.DatabaseMetadataInfoMaker;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConnectionInfo {
    private String SEDU;
    private boolean get;
    private String getBoolean;
    private String getJSONObject;
    private String getName;
    private String getNames;
    private String getProperty;
    private boolean getString;
    private String has;
    private DatabaseMetadataInfo length;

    ConnectionInfo(String string) {
        this.SEDU = string;
    }

    public String getName() {
        return this.SEDU;
    }

    public boolean isUseDefaultUser() {
        return this.get;
    }

    public void setUseDefaultUser(boolean bl) {
        this.get = bl;
    }

    public String getUser() {
        if (this.get) {
            return null;
        }
        return this.getBoolean;
    }

    public void setUser(String string) {
        this.getBoolean = string;
    }

    public String getPassword() {
        if (!this.getString) {
            return this.getJSONObject;
        }
        return this.has;
    }

    public void setPassword(String string) {
        this.getJSONObject = string;
    }

    public String getJndiName() {
        return this.getName;
    }

    public void setJndiName(String string) {
        this.getName = string;
    }

    public String getJdbcUrl() {
        return this.getNames;
    }

    public void setJdbcUrl(String string) {
        this.getNames = string;
    }

    public String getJdbcDriver() {
        return this.getProperty;
    }

    public void setJdbcDriver(String string) {
        this.getProperty = string;
    }

    public boolean isUseNewPassword() {
        return this.getString;
    }

    public void setUseNewPassword(boolean bl) {
        this.getString = bl;
    }

    public String getNewPassword() {
        return this.has;
    }

    public void setNewPassword(String string) {
        this.has = string;
    }

    public DatabaseMetadataInfo getMetadataInfo() {
        return this.length;
    }

    public void setMetadataInfo(DatabaseMetadataInfo databaseMetadataInfo) {
        this.length = databaseMetadataInfo;
    }

    public JSONObject toJSONObject() {
        Properties properties = this.toProperties();
        properties.put("jrs.connection_name", this.SEDU);
        return new JSONObject((Map)properties);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.put("jrs.use_def_ds_pswd", String.valueOf(this.get));
        if (this.getBoolean != null) {
            properties.put("jrs.ds_user", this.getBoolean);
        }
        if (this.getJSONObject != null) {
            properties.put("jrs.ds_pswd", this.getJSONObject);
        }
        if (this.getNames != null) {
            properties.put("jrs._ds_url", this.getNames);
        }
        if (this.getProperty != null) {
            properties.put("jrs._ds_driver", this.getProperty);
        }
        if (this.getName != null) {
            properties.put("jrs.jndi_datasource", this.getName);
        }
        properties.put("jrs.use_new_ds_pswd", String.valueOf(this.getString));
        if (this.has != null) {
            properties.put("jrs.new_ds_pswd", this.has);
        }
        if (this.length != null) {
            properties.putAll((Map<?, ?>)DatabaseMetadataInfoMaker.toProperties(this.length));
        }
        return properties;
    }

    private static ConnectionInfo SEDU(JSONObject jSONObject) throws JSONException {
        ConnectionInfo connectionInfo = null;
        String string = jSONObject.getString("jrs.connection_name");
        if (string != null && string.length() > 0) {
            connectionInfo = new ConnectionInfo(string);
            connectionInfo.setUseDefaultUser(jSONObject.has("jrs.use_def_ds_pswd") ? jSONObject.getBoolean("jrs.use_def_ds_pswd") : false);
            connectionInfo.setUser(jSONObject.has("jrs.ds_user") ? jSONObject.getString("jrs.ds_user") : null);
            connectionInfo.setPassword(jSONObject.has("jrs.ds_pswd") ? jSONObject.getString("jrs.ds_pswd") : null);
            connectionInfo.setJdbcUrl(jSONObject.has("jrs._ds_url") ? jSONObject.getString("jrs._ds_url") : null);
            connectionInfo.setJdbcDriver(jSONObject.has("jrs._ds_driver") ? jSONObject.getString("jrs._ds_driver") : null);
            connectionInfo.setJndiName(jSONObject.has("jrs.jndi_datasource") ? jSONObject.getString("jrs.jndi_datasource") : null);
            connectionInfo.setUseNewPassword(jSONObject.has("jrs.use_new_ds_pswd") ? jSONObject.getBoolean("jrs.use_new_ds_pswd") : false);
            connectionInfo.setNewPassword(jSONObject.has("jrs.new_ds_pswd") ? jSONObject.getString("jrs.new_ds_pswd") : null);
            String[] stringArray = JSONObject.getNames((JSONObject)jSONObject);
            Properties properties = new Properties();
            for (String string2 : stringArray) {
                properties.put(string2, jSONObject.get(string2).toString());
            }
            connectionInfo.setMetadataInfo(DatabaseMetadataInfoMaker.make(properties));
        }
        return connectionInfo;
    }

    public static HashMap convertConnInfos(JSONArray jSONArray) {
        HashMap<String, ConnectionInfo> hashMap = null;
        if (jSONArray != null) {
            hashMap = new HashMap<String, ConnectionInfo>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    ConnectionInfo connectionInfo = ConnectionInfo.SEDU(jSONArray.getJSONObject(i));
                    if (connectionInfo == null) continue;
                    hashMap.put(connectionInfo.getName(), connectionInfo);
                    continue;
                }
                catch (JSONException jSONException) {
                    ServiceLogger.logError(jSONException, 3);
                }
            }
        }
        return hashMap;
    }

    public static ConnectionInfo convertConnInfo(Properties properties) {
        ConnectionInfo connectionInfo = new ConnectionInfo(null);
        connectionInfo.setUseDefaultUser(CSUtil.getBoolean(properties.getProperty("jrs.use_def_ds_pswd"), true));
        connectionInfo.setUser(properties.getProperty("jrs.ds_user"));
        connectionInfo.setPassword(properties.getProperty("jrs.ds_pswd"));
        connectionInfo.setJdbcUrl(properties.getProperty("jrs._ds_url"));
        connectionInfo.setJdbcDriver(properties.getProperty("jrs._ds_driver"));
        connectionInfo.setJndiName(properties.getProperty("jrs.jndi_datasource"));
        connectionInfo.setUseNewPassword(CSUtil.getBoolean(properties.getProperty("jrs.use_new_ds_pswd"), false));
        connectionInfo.setNewPassword(properties.getProperty("jrs.new_ds_pswd"));
        connectionInfo.setMetadataInfo(DatabaseMetadataInfoMaker.make(properties));
        return connectionInfo;
    }
}

