/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.util;

import java.util.ArrayList;
import java.util.Map;
import jet.cs.CSUtil;
import jet.server.log.ServiceLogger;
import jet.server.schedule.util.ConnectionInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DatasourceInfo {
    private String SEDU;
    private Map add;
    private ConnectionInfo convertConnInfo;

    DatasourceInfo(String string) {
        this.SEDU = string;
    }

    public String getName() {
        return this.SEDU;
    }

    public Map getConnectionInfos() {
        return this.add;
    }

    public void setConnectionInfos(Map map) {
        this.add = map;
    }

    public void setDefaultConnectionInfo(ConnectionInfo connectionInfo) {
        this.convertConnInfo = connectionInfo;
    }

    public ConnectionInfo getDefaultConnectionInfo() {
        return this.convertConnInfo;
    }

    public JSONObject toJSONObject() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("jrs.data_source_name", (Object)this.SEDU);
            if (this.add != null) {
                JSONArray jSONArray = new JSONArray();
                for (ConnectionInfo connectionInfo : this.add.values()) {
                    jSONArray.put((Object)connectionInfo.toJSONObject());
                }
                jSONObject.put("jrs.connections", (Object)jSONArray);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            ServiceLogger.logError(jSONException, 3);
            return null;
        }
    }

    private static DatasourceInfo SEDU(JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("jrs.data_source_name");
            if (string == null || string.length() == 0) {
                return null;
            }
            DatasourceInfo datasourceInfo = new DatasourceInfo(string);
            datasourceInfo.setConnectionInfos(ConnectionInfo.convertConnInfos(jSONObject.getJSONArray("jrs.connections")));
            return datasourceInfo;
        }
        catch (JSONException jSONException) {
            ServiceLogger.logError(jSONException, 3);
            return null;
        }
    }

    public static DatasourceInfo parse(String string, String string2) {
        DatasourceInfo datasourceInfo = new DatasourceInfo(string);
        datasourceInfo.setDefaultConnectionInfo(ConnectionInfo.convertConnInfo(CSUtil.parseQuery(string2)));
        return datasourceInfo;
    }

    public static ArrayList parseJSonStr(String string) {
        ArrayList<DatasourceInfo> arrayList = null;
        if (string != null) {
            arrayList = new ArrayList<DatasourceInfo>();
            try {
                JSONObject jSONObject = new JSONObject(string);
                JSONArray jSONArray = jSONObject.getJSONArray("jrs.datasources");
                if (jSONArray != null) {
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        DatasourceInfo datasourceInfo = DatasourceInfo.SEDU(jSONArray.getJSONObject(i));
                        if (datasourceInfo == null) continue;
                        arrayList.add(datasourceInfo);
                    }
                }
            }
            catch (JSONException jSONException) {
                ServiceLogger.logError(jSONException, 3);
            }
        }
        return arrayList;
    }
}

