/*
 * Decompiled with CFR 0.152.
 */
package jet.server.servlets;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.JCliResource;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.Permissions;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.http.HttpUtil;
import jet.server.jrserver.http.JRStringBufferPrintWriter;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.servlets.JRServlet;
import jet.server.servlets.OperationBase;
import jet.server.servlets.ServletUtil;
import jet.server.util.ServerUtil;
import jet.server.util.WebSecurityUtil;

public class ServletOperation
extends OperationBase {
    public ServletOperation(JRServlet jRServlet) {
        super(jRServlet);
    }

    public void responseTempResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable, String string, boolean bl) throws Exception {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        if ((string = WebSecurityUtil.validateSubPath(string)) == null) {
            this.sendError(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_43"), hashtable);
            return;
        }
        boolean bl2 = string.toLowerCase().endsWith(".html");
        if (!string.trim().equalsIgnoreCase("chart.jar")) {
            string6 = string;
            if (!APIUtil.getBoolean((String)hashtable.get("jrs.check_fullname"), false)) {
                string6 = ServletUtil.getTempResultKey(string);
            }
            if (!this.jrservlet.getHttpRptServer().getTempResultOwnerManager().isOwner(this.jrservlet.getUser(httpServletRequest), string6)) {
                this.sendError(httpServletRequest, httpServletResponse, 403, JSvrResource.getMessage("SLT_ERR_45", string), hashtable);
                return;
            }
        }
        string6 = WebSecurityUtil.validateSubPath((String)hashtable.get("jrs.html_temp_dir"));
        File file = new File(this.jrservlet.getTempDir() + string);
        if (string6 != null) {
            file = new File(this.jrservlet.getTempDir() + string6 + File.separator + string);
        }
        if ((string5 = WebSecurityUtil.validateSubPath((String)hashtable.get("jrs.pdf_temp_dir"))) != null) {
            file = new File(this.jrservlet.getTempDir() + string5 + File.separator + string);
        }
        if ((string4 = WebSecurityUtil.validateSubPath((String)hashtable.get("jrs.rtf_temp_dir"))) != null) {
            file = new File(this.jrservlet.getTempDir() + string4 + File.separator + string);
        }
        if ((string3 = WebSecurityUtil.validateSubPath((String)hashtable.get("jrs.xml_temp_dir"))) != null) {
            file = new File(this.jrservlet.getTempDir() + string3 + File.separator + string);
        }
        if (!this.testTempResultReadyWithWait(string)) {
            this.P_EXECUTE(httpServletRequest, httpServletResponse, hashtable, string);
            return;
        }
        if (string != null && (string2 = (String)ServletUtil.realPathTempHashtable.get(string)) != null) {
            file = new File(string2);
            if (file.exists() && !string2.startsWith(this.jrservlet.getTempDir())) {
                this.P_DELETE(file.getParent(), this.jrservlet.getTempDir());
            }
            ServletUtil.realPathTempHashtable.remove(string);
        }
        if (bl2) {
            this.responseHtmlData(httpServletRequest, httpServletResponse, file);
            return;
        }
        if (!file.exists()) {
            this.sendError(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_29", string), hashtable);
            return;
        }
        HttpUtil.processPartialRequest(httpServletRequest, httpServletResponse, file, hashtable);
    }

    private void P_DELETE(String string, String string2) throws IOException {
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Object object;
                Object object2;
                if (!fileArray[i].isDirectory()) {
                    object2 = new FileInputStream(fileArray[i].toString());
                    object = new FileOutputStream(string2 + File.separator + fileArray[i].getName());
                    byte[] byArray = new byte[((FileInputStream)object2).available()];
                    ((FileInputStream)object2).read(byArray);
                    ((FileOutputStream)object).write(byArray);
                    ((FileInputStream)object2).close();
                    ((FileOutputStream)object).close();
                    continue;
                }
                object2 = string2 + File.separator + fileArray[i].getName();
                object = new File((String)object2);
                if (!((File)object).exists()) {
                    ((File)object).mkdir();
                }
                this.P_DELETE(fileArray[i].getPath(), (String)object2);
            }
        }
    }

    public boolean testTempResultReadyWithWait(String string) throws Exception {
        if (!this.jrservlet.getHttpRptServer().isTempResultReady(string)) {
            Thread.currentThread();
            Thread.yield();
            Thread.currentThread();
            Thread.sleep(2000L);
            return this.jrservlet.getHttpRptServer().isTempResultReady(string);
        }
        return true;
    }

    public boolean testTempResultReady(String string) throws Exception {
        return this.jrservlet.getHttpRptServer().isTempResultReady(string);
    }

    private void P_EXECUTE(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable, String string) throws Exception {
        if (string == null) {
            this.sendError(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_43"), hashtable);
            return;
        }
        this.sendError(httpServletRequest, httpServletResponse, 202, JSvrResource.getMessage("SLT_ERR_44", string), hashtable);
    }

    public void responseHtmlData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file) throws Exception {
        httpServletResponse.setContentType("text/html");
        this.sendFile(httpServletRequest, httpServletResponse, file);
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), this.jrservlet.getUser(httpServletRequest), this.jrservlet.getSessionId(httpServletRequest), 5680055, file.getCanonicalPath(), 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[65536];
        try {
            int n = fileInputStream.read(byArray);
            if (n <= 0) {
                this.sendError(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_37"), null);
            } else {
                httpServletResponse.setStatus(200);
                httpServletResponse.setContentLength((int)file.length());
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                while (n >= 0) {
                    servletOutputStream.write(byArray, 0, n);
                    n = fileInputStream.read(byArray);
                }
                servletOutputStream.close();
            }
        }
        catch (SocketException socketException) {
            throw socketException;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        finally {
            fileInputStream.close();
        }
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), this.jrservlet.getUser(httpServletRequest), this.jrservlet.getSessionId(httpServletRequest), 5680043, file.getCanonicalPath(), 5);
    }

    public void sendImage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        try {
            File file = WebSecurityUtil.validateFilePath(string);
            if (file == null || !file.exists()) {
                ServiceLogger.logError(2680056, string, 2);
                return;
            }
            httpServletResponse.setContentType("image/gif");
            try {
                if (ServerUtil.isFileNotModified(file, httpServletRequest, httpServletResponse)) {
                    return;
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = fileInputStream.available();
            httpServletResponse.setContentLength(n);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());
            byte[] byArray = new byte[n];
            try {
                fileInputStream.read(byArray);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(2680057, string, 2);
                fileInputStream.close();
                bufferedOutputStream.close();
                return;
            }
            bufferedOutputStream.write(byArray, 0, n);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            ServiceLogger.logError(2680056, string, 2);
        }
    }

    public void responseFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file, Hashtable hashtable) throws Exception {
        if (file == null || !file.exists()) {
            this.sendError(httpServletRequest, httpServletResponse, 404, hashtable);
            return;
        }
        if (file.isDirectory()) {
            this.sendError(httpServletRequest, httpServletResponse, 403, JSvrResource.getMessage("SLT_ERR_4"), hashtable);
            return;
        }
        String string = file.getName();
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n);
        }
        String string3 = this.jrservlet.getHttpRptServer().getResourceManager().getMIMEType(string2);
        httpServletResponse.setContentType(string3);
        String string4 = WebSecurityUtil.validateResponseHeader(string);
        if (ServerEnv.hasForce()) {
            if (string3.toLowerCase().endsWith("excel") && ServerEnv.isForceExcel()) {
                httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + string4 + "\"");
            } else if (string3.toLowerCase().endsWith("pdf") && ServerEnv.isForcePdf()) {
                httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + string4 + "\"");
            } else if (string3.toLowerCase().endsWith("rtf") && ServerEnv.isForceRtf()) {
                httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + string4 + "\"");
            } else if (string3.toLowerCase().endsWith("postscript") && ServerEnv.isForcePs()) {
                httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + string4 + "\"");
            } else if (string3.toLowerCase().endsWith("xml") && ServerEnv.isForceXml()) {
                httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + string4 + "\"");
            } else if (string3.toLowerCase().endsWith("plain") && ServerEnv.isForceText()) {
                httpServletResponse.setHeader("Content-Disposition", "attachment;filename=\"" + string4 + "\"");
            }
        }
        this.sendFile(httpServletRequest, httpServletResponse, file);
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), this.jrservlet.getUser(httpServletRequest), this.jrservlet.getSessionId(httpServletRequest), 6680058, file, 6);
    }

    public void sendError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, Hashtable hashtable) {
        this.sendError(httpServletRequest, httpServletResponse, n, HttpUtil.isJRClient(httpServletRequest, hashtable) ? "HTTP " + n : null, null);
    }

    public void sendError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string, Hashtable hashtable) {
        this.sendError(httpServletRequest, httpServletResponse, n, string, null, hashtable);
    }

    public void sendError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, Throwable throwable, Hashtable hashtable) {
        this.sendError(httpServletRequest, httpServletResponse, n, null, throwable, hashtable);
    }

    public void sendError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string, Throwable throwable, Hashtable hashtable) {
        Object object;
        String string2;
        String string3 = string2 = string == null ? "" : string;
        if (throwable != null) {
            if (string2 != null) {
                string2 = string2 + " -" + JSvrResource.getMessage("SLT_ERR_65") + ": \n";
            }
            string2 = string2 + APIUtil.getStackTraceString(throwable);
        }
        if (HttpUtil.isJRClient(httpServletRequest, hashtable)) {
            httpServletResponse.setStatus(n);
            httpServletResponse.setHeader("JRS-MESSAGE", HttpUtil.encodeEsc(string2));
            httpServletResponse.setContentLength(0);
        } else {
            try {
                if (n == 200) {
                    httpServletResponse.setStatus(n);
                    httpServletResponse.setContentType("text/html");
                    object = this.jrservlet.getWriter(httpServletResponse);
                    this.P_GRANT(httpServletRequest, (JRStringBufferPrintWriter)object, JSvrResource.getMessage("SLT_ERR_66"));
                    ((JRStringBufferPrintWriter)object).println("<b>" + JSvrResource.getMessage("SLT_ERR_67") + "</b><br><pre>");
                    ((JRStringBufferPrintWriter)object).println(string2);
                    ((JRStringBufferPrintWriter)object).println("</pre></body>");
                    ((JRStringBufferPrintWriter)object).println("</html>");
                    ((JRStringBufferPrintWriter)object).close();
                } else {
                    httpServletResponse.sendError(n, string2);
                }
            }
            catch (Throwable throwable2) {
                ServiceLogger.logError(throwable2);
            }
        }
        if (n != 200 && ServiceLogger.isLoggable(0, 5)) {
            object = null;
            try {
                object = this.jrservlet.getUser(httpServletRequest);
            }
            catch (Throwable throwable3) {
                ServiceLogger.logError(throwable3);
            }
            ServiceLogger.logAccessFailEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), (String)object, this.jrservlet.getSessionId(httpServletRequest), 5680059, new Object[]{String.valueOf(n), string2}, 5);
        }
    }

    protected void sendPathError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string, Hashtable hashtable) {
        String string2 = string == null ? "" : string;
        try {
            if (n == 200) {
                JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
                this.P_GRANT(httpServletRequest, jRStringBufferPrintWriter, JSvrResource.getMessage("SLT_ERR_66"));
                jRStringBufferPrintWriter.println("<b>" + JSvrResource.getMessage("SLT_ERR_67") + "</b><br><pre>");
                jRStringBufferPrintWriter.println(string2);
                jRStringBufferPrintWriter.println("</pre></body>");
                jRStringBufferPrintWriter.println("</html>");
                jRStringBufferPrintWriter.close();
            } else {
                httpServletResponse.sendError(n, string2);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    private void P_GRANT(HttpServletRequest httpServletRequest, JRStringBufferPrintWriter jRStringBufferPrintWriter, String string) throws Exception {
        this.writePageIndex(httpServletRequest, jRStringBufferPrintWriter, string);
    }

    protected void writePageIndex(HttpServletRequest httpServletRequest, JRStringBufferPrintWriter jRStringBufferPrintWriter, String string) throws Exception {
        String string2 = this.jrservlet.getBaseQ(httpServletRequest, false);
        jRStringBufferPrintWriter.println("<html>");
        jRStringBufferPrintWriter.println("<head>");
        jRStringBufferPrintWriter.println("<title>" + string + "</title>");
        jRStringBufferPrintWriter.println("</head>");
        jRStringBufferPrintWriter.println("<body>");
    }

    protected void sendErrorNoRetcodeMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string, Throwable throwable, Hashtable hashtable) {
        Object object;
        String string2;
        String string3 = string2 = string == null ? "" : string;
        if (throwable != null) {
            if (string2 != null) {
                string2 = string2 + " -" + JSvrResource.getMessage("SLT_ERR_65") + ": \n";
            }
            string2 = string2 + APIUtil.getStackTraceString(throwable);
        }
        if (HttpUtil.isJRClient(httpServletRequest, hashtable)) {
            httpServletResponse.setStatus(n);
            httpServletResponse.setHeader("JRS-MESSAGE", HttpUtil.encodeEsc(string2));
            httpServletResponse.setContentLength(0);
        } else {
            try {
                if (n == 200) {
                    httpServletResponse.setStatus(n);
                    httpServletResponse.setContentType("text/html");
                    object = this.jrservlet.getWriter(httpServletResponse);
                    this.P_GRANT(httpServletRequest, (JRStringBufferPrintWriter)object, JSvrResource.getMessage("SLT_ERR_66"));
                    ((JRStringBufferPrintWriter)object).println(string2);
                    ((JRStringBufferPrintWriter)object).println("</pre></body>");
                    ((JRStringBufferPrintWriter)object).println("</html>");
                    ((JRStringBufferPrintWriter)object).close();
                } else {
                    httpServletResponse.sendError(n, string2);
                }
            }
            catch (Throwable throwable2) {
                ServiceLogger.logError(throwable2);
            }
        }
        if (n != 200 && ServiceLogger.isLoggable(0, 5)) {
            object = null;
            try {
                object = this.jrservlet.getUser(httpServletRequest);
            }
            catch (Throwable throwable3) {
                ServiceLogger.logError(throwable3);
            }
            ServiceLogger.logAccessFailEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), (String)object, this.jrservlet.getSessionId(httpServletRequest), 5680059, new Object[]{String.valueOf(n), string2}, 5);
        }
    }

    public void testBeforeDeployCat(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        Object object;
        String string = this.jrservlet.getTempDir() + System.currentTimeMillis() + File.separator;
        this.jrservlet.setDeployTempDir(string);
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        } else {
            SchdTools.deleteTempFiles(string);
        }
        String string2 = WebSecurityUtil.validateResponseHeader(this.jrservlet.getPathInfo(httpServletRequest));
        try {
            object = this.jrservlet.getHttpRptServer().getResourceManager().getPathInfo(this.jrservlet.getUser(httpServletRequest), string2);
            if (!object.isResourceNode()) {
                httpServletResponse.setHeader("Resource", "Reource" + string2 + " is not a Folder");
                return;
            }
        }
        catch (Exception exception) {
            httpServletResponse.setHeader("Resource", "Resource " + string2 + " does not exist");
            exception.printStackTrace();
        }
        httpServletResponse.setStatus(200);
        object = this.jrservlet.getWriter(httpServletResponse);
        ((JRStringBufferPrintWriter)object).close();
    }

    public void testBeforeDeployFont(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        Hashtable<String, String> hashtable2 = null;
        String string = (String)hashtable.get("fnt");
        Vector vector = JRServlet.getElements(string, ",");
        File file = WebSecurityUtil.validateFilePath(this.jrservlet.getFontPath());
        if (file.exists() && file.isDirectory()) {
            try {
                hashtable2 = ServletUtil.testBeforeDeployFont(file.getCanonicalPath(), vector);
                hashtable2.put("rc", "1");
            }
            catch (IOException iOException) {
                hashtable2 = new Hashtable<String, String>(2);
                hashtable2.put("rc", "0");
                hashtable2.put("em", iOException.getMessage());
            }
        } else {
            hashtable2 = new Hashtable<String, String>(2);
            hashtable2.put("rc", "0");
            hashtable2.put("em", JSvrResource.getMessage("SLT_ERR_41"));
        }
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            jRStringBufferPrintWriter.println(string2 + "=" + (String)hashtable2.get(string2));
        }
        jRStringBufferPrintWriter.close();
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), this.jrservlet.getUser(httpServletRequest), this.jrservlet.getSessionId(httpServletRequest), 6680060, hashtable2.toString(), 6);
    }

    public void testBeforeDeployStyleGroup(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        Hashtable<String, String> hashtable2 = null;
        String string = (String)hashtable.get("stl");
        Vector vector = JRServlet.getElements(string, ",");
        File file = new File(this.jrservlet.getHttpRptServer().getServerEnv().getHomePath(), ServerEnv.getStyleFolder());
        if (file.exists() && file.isDirectory()) {
            try {
                hashtable2 = ServletUtil.testBeforeDeployStyleGroup(file.getCanonicalPath(), vector);
                hashtable2.put("rc", "1");
            }
            catch (IOException iOException) {
                hashtable2 = new Hashtable<String, String>(2);
                hashtable2.put("rc", "0");
                hashtable2.put("em", iOException.getMessage());
            }
        } else {
            hashtable2 = new Hashtable<String, String>(2);
            hashtable2.put("rc", "0");
            hashtable2.put("em", JSvrResource.getMessage("SLT_ERR_84"));
        }
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            jRStringBufferPrintWriter.println(string2 + "=" + (String)hashtable2.get(string2));
        }
        jRStringBufferPrintWriter.close();
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), this.jrservlet.getUser(httpServletRequest), this.jrservlet.getSessionId(httpServletRequest), 6680061, hashtable2.toString(), 6);
    }

    public void sendFileWithMime(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file, String string) throws Exception {
        if (string == null || string.trim().length() == 0) {
            string = "application/octet-stream";
        }
        httpServletResponse.setContentType(string);
        this.sendFile(httpServletRequest, httpServletResponse, file);
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), this.jrservlet.getUser(httpServletRequest), this.jrservlet.getSessionId(httpServletRequest), 5680062, new Object[]{file.getCanonicalPath(), string}, 5);
    }

    public void sendTempFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        File file;
        String string = (String)hashtable.get("jrs.file");
        if (string != null) {
            string = string.trim();
        }
        if (!(file = new File(this.jrservlet.getTempDir() + string)).exists()) {
            this.sendError(httpServletRequest, httpServletResponse, 500, JSvrResource.getMessage("SLT_ERR_35", file.getCanonicalPath()), hashtable);
            return;
        }
        this.responseFile(httpServletRequest, httpServletResponse, file, null);
    }

    public void returnBuildNumber(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println("" + this.jrservlet.getHttpRptServer().getServerEnv().getBuildNumber());
        jRStringBufferPrintWriter.close();
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), this.jrservlet.getUser(httpServletRequest), this.jrservlet.getSessionId(httpServletRequest), 6680063, 6);
    }

    public void responseAddDeployFilesToResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = this.jrservlet.getPathInfo(httpServletRequest);
        if (string == null || string.length() == 0) {
            string = "/";
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        String string2 = null;
        String string3 = null;
        File file = new File(this.jrservlet.getDeployTempDir());
        String[] stringArray = file.list();
        StringBuffer stringBuffer = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            string3 = this.jrservlet.getDeployTempDir() + string2;
            if (string2.endsWith(".cat") || string2.endsWith(".cat.xml")) {
                hashtable2.put("jrs.node_type", String.valueOf(2));
                hashtable2.put("jrs.catalog", string3);
                hashtable2.put("jrs.node_name", string2);
                this.jrservlet.getHttpRptServer().getResourceManager().addResource(this.jrservlet.getUser(httpServletRequest), string, hashtable2);
            } else if (string2.endsWith(".cls") || string2.endsWith(".cls.xml") || string2.endsWith(".clx")) {
                hashtable2.put("jrs.node_type", String.valueOf(0));
                hashtable2.put("jrs.report", string3);
                hashtable2.put("jrs.node_name", string2);
                this.jrservlet.getHttpRptServer().getResourceManager().addResource(this.jrservlet.getUser(httpServletRequest), string, hashtable2);
            }
            hashtable2.clear();
        }
        CSUtil.deleteUploadedFiles(this.jrservlet.getDeployTempDir());
        if (stringBuffer != null) {
            throw new Exception(stringBuffer.substring(0, stringBuffer.length() - 2));
        }
    }

    public Hashtable[] savePropPermission(String string, Hashtable hashtable) {
        String string2;
        Vector<Permission> vector;
        String string3;
        if (hashtable == null) {
            return null;
        }
        if (!APIUtil.getBoolean((String)hashtable.get("jrs.define_permission"), false)) {
            return null;
        }
        Hashtable[] hashtableArray = null;
        Vector vector2 = new Vector();
        try {
            vector2 = this.jrservlet.getHttpRptServer().getResourceManager().getReferUsers(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException));
        }
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                String string4 = (String)vector2.elementAt(i);
                string3 = "";
                vector = new Vector<Permission>();
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string4 + "." + "read"))) {
                    vector.addElement(Permissions.P_READ);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string4 + "." + "write"))) {
                    vector.addElement(Permissions.P_WRITE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string4 + "." + "delete"))) {
                    vector.addElement(Permissions.P_DELETE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string4 + "." + "visible"))) {
                    vector.addElement(Permissions.P_VISIBLE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string4 + "." + "execute"))) {
                    vector.addElement(Permissions.P_EXECUTE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string4 + "." + "schedule"))) {
                    vector.addElement(Permissions.P_SCHEDULE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.user_permission$" + string4 + "." + "grant"))) {
                    vector.addElement(Permissions.P_GRANT);
                }
                if (vector.size() == 0) continue;
                if (hashtableArray == null) {
                    hashtableArray = new Hashtable[3];
                }
                if (hashtableArray[0] == null) {
                    hashtableArray[0] = new Hashtable();
                }
                hashtableArray[0].put(string4, vector);
            }
        }
        Vector vector3 = new Vector();
        try {
            vector3 = this.jrservlet.getHttpRptServer().getResourceManager().getReferRoles(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException));
        }
        if (vector3 != null) {
            for (int i = 0; i < vector3.size(); ++i) {
                string3 = (String)vector3.elementAt(i);
                string2 = "";
                vector = new Vector();
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string3 + "." + "read"))) {
                    vector.addElement(Permissions.P_READ);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string3 + "." + "write"))) {
                    vector.addElement(Permissions.P_WRITE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string3 + "." + "delete"))) {
                    vector.addElement(Permissions.P_DELETE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string3 + "." + "visible"))) {
                    vector.addElement(Permissions.P_VISIBLE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string3 + "." + "execute"))) {
                    vector.addElement(Permissions.P_EXECUTE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string3 + "." + "schedule"))) {
                    vector.addElement(Permissions.P_SCHEDULE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.role_permission$" + string3 + "." + "grant"))) {
                    vector.addElement(Permissions.P_GRANT);
                }
                if (vector.size() == 0) continue;
                if (hashtableArray == null) {
                    hashtableArray = new Hashtable[3];
                }
                if (hashtableArray[1] == null) {
                    hashtableArray[1] = new Hashtable();
                }
                hashtableArray[1].put(string3, vector);
            }
        }
        Vector vector4 = new Vector();
        try {
            vector4 = this.jrservlet.getHttpRptServer().getResourceManager().getReferGroups(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException));
        }
        if (vector4 != null) {
            for (int i = 0; i < vector4.size(); ++i) {
                string2 = (String)vector4.elementAt(i);
                String string5 = "";
                vector = new Vector();
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "read"))) {
                    vector.addElement(Permissions.P_READ);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "write"))) {
                    vector.addElement(Permissions.P_WRITE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "delete"))) {
                    vector.addElement(Permissions.P_DELETE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "visible"))) {
                    vector.addElement(Permissions.P_VISIBLE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "execute"))) {
                    vector.addElement(Permissions.P_EXECUTE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "schedule"))) {
                    vector.addElement(Permissions.P_SCHEDULE);
                }
                if (APIUtil.getBoolean((String)hashtable.get("jrs.group_permission$" + string2 + "." + "grant"))) {
                    vector.addElement(Permissions.P_GRANT);
                }
                if (vector.size() == 0) continue;
                if (hashtableArray == null) {
                    hashtableArray = new Hashtable[3];
                }
                if (hashtableArray[2] == null) {
                    hashtableArray[2] = new Hashtable();
                }
                hashtableArray[2].put(string2, vector);
            }
        }
        return hashtableArray;
    }

    public void printInitFailMsg(HttpServletResponse httpServletResponse) throws IOException {
        String string = this.jrservlet.getInitflag() > 0 ? JSvrResource.getMessage("SLT_ERR_1") : JSvrResource.getMessage("SLT_ERR_2");
        httpServletResponse.setStatus(500);
        httpServletResponse.setContentType("text/html");
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println("<html>");
        jRStringBufferPrintWriter.println("<head>");
        jRStringBufferPrintWriter.println("<title>" + JSvrResource.getMessage("SLT_PG_1") + "</title>");
        jRStringBufferPrintWriter.println("</head>");
        jRStringBufferPrintWriter.println("<body>");
        jRStringBufferPrintWriter.println("<small><font face=\"Arial\">");
        jRStringBufferPrintWriter.println("<h1>500 " + JSvrResource.getMessage("SLT_PG_1") + "</h1><p>");
        jRStringBufferPrintWriter.println(string);
        jRStringBufferPrintWriter.println("<p>");
        jRStringBufferPrintWriter.println("</font></small>");
        jRStringBufferPrintWriter.println("</body>");
        jRStringBufferPrintWriter.println("</html>");
        jRStringBufferPrintWriter.close();
        ServiceLogger.logError(string);
    }

    public void responseLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        this.jrservlet.logout(httpServletRequest, httpServletResponse, hashtable);
        this.sendError(httpServletRequest, httpServletResponse, 200, JSvrResource.getMessage("SLT_ERR_53"), hashtable);
    }

    public void responseStop(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        this.jrservlet.stop();
        this.sendError(httpServletRequest, httpServletResponse, 200, JSvrResource.getMessage("SLT_ERR_54"), hashtable);
    }

    public void responseRestart(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        this.jrservlet.restart();
        this.sendError(httpServletRequest, httpServletResponse, 200, JSvrResource.getMessage("SLT_ERR_55"), hashtable);
    }

    public void generateWaitInQueue(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, String string) throws Exception {
        String string2;
        String string3;
        String string4 = this.jrservlet.getUser(httpServletRequest);
        String string5 = this.jrservlet.getPathInfo(httpServletRequest);
        httpServletResponse.setStatus(200);
        if (bl) {
            string3 = "jrs.wait_user";
            httpServletResponse.setHeader("wait", "waituser");
            string2 = JCliResource.getMessage("CS_MSG_147");
        } else {
            string3 = "jrs.wait_report";
            httpServletResponse.setHeader("wait", "waitreport");
            string2 = JCliResource.getMessage("CS_MSG_148");
        }
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        String string6 = this.jrservlet.getBaseQ(httpServletRequest, true);
        Properties properties = string == null || string.length() == 0 ? HttpUtil.getParameters(httpServletRequest) : CSUtil.parseQuery(string);
        boolean bl2 = HttpUtil.isJRClient(httpServletRequest, properties);
        if (bl2) {
            jRStringBufferPrintWriter.println("jrs.cmd=" + string3);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string7 = (String)enumeration.nextElement();
                if (string7.equals("jrs.cmd")) {
                    jRStringBufferPrintWriter.println(string7 + "1" + "=" + properties.get(string7));
                    continue;
                }
                jRStringBufferPrintWriter.println(string7 + "=" + properties.get(string7));
            }
            jRStringBufferPrintWriter.println("isWait=true");
        } else {
            httpServletResponse.setContentType("text/html");
            this.P_GRANT(httpServletRequest, jRStringBufferPrintWriter, "Prompt");
            jRStringBufferPrintWriter.println("<font face=\"Arial\"><small>");
            jRStringBufferPrintWriter.println("<form method=\"POST\" action=\"" + string6 + "\">");
            jRStringBufferPrintWriter.println("<table style=\"font-family:Arial;font-size:10pt;\" border=\"0\" width=\"100%\">");
            jRStringBufferPrintWriter.println("<tr bgcolor=\"#000000\"><td align=\"left\"><b><font color=\"#ECECEC\">" + string2 + "</b></td></tr>");
            jRStringBufferPrintWriter.println("</table>");
            jRStringBufferPrintWriter.print("<input type=hidden name=jrs.cmd value=\"" + string3 + "\">");
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string8 = (String)enumeration.nextElement();
                if (string8.equals("jrs.cmd")) {
                    jRStringBufferPrintWriter.print("<input type=hidden name=" + string8 + "1" + " value=\"" + (String)properties.get(string8) + "\">");
                    continue;
                }
                jRStringBufferPrintWriter.print("<input type=hidden name=" + string8 + " value=\"" + (String)properties.get(string8) + "\">");
            }
            jRStringBufferPrintWriter.print("<input type=hidden name=\"isWait\" value=\"true\">");
            jRStringBufferPrintWriter.println("<p><input type=\"submit\" value=\"Yes\" name=\"Submit_Btn\">");
            jRStringBufferPrintWriter.println("<input type=\"submit\" value=\"No\" name=\"B2\"></p>");
            jRStringBufferPrintWriter.println("</form>");
            jRStringBufferPrintWriter.println("</small></font>");
            jRStringBufferPrintWriter.println("</body>");
            jRStringBufferPrintWriter.println("</html>");
        }
        jRStringBufferPrintWriter.close();
    }
}

