/*
 * Decompiled with CFR 0.152.
 */
package jet.server.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jet.server.storage.StorageEnv;
import jet.server.storage.StorageException;
import jet.server.storage.UnavailableStorageException;

public interface Storage {
    public static final String separator = "/";

    public StorageEnv getStorageEnv() throws StorageException;

    public void add(String var1, File var2) throws IOException, StorageException;

    public void add(StorageRoot var1, String var2, File var3) throws IOException, StorageException;

    public void add(StorageRoot var1, String var2, int var3, boolean var4) throws IOException, StorageException;

    public File get(String var1) throws IOException, StorageException, UnavailableStorageException;

    public File get(StorageRoot var1, String var2) throws IOException, StorageException, UnavailableStorageException;

    public void delete(String var1) throws IOException, StorageException;

    public void delete(StorageRoot var1, String var2) throws IOException, StorageException;

    public ArrayList list(StorageRoot var1, String var2) throws StorageException;

    public ArrayList listAll(StorageRoot var1, String var2) throws StorageException;

    public File map(String var1) throws IOException, StorageException;

    public File map(StorageRoot var1, String var2) throws IOException, StorageException;

    public boolean exists(String var1) throws IOException, StorageException;

    public boolean exists(StorageRoot var1, String var2) throws IOException, StorageException;

    public void cleanup(StorageRoot var1) throws IOException, StorageException;

    public static enum StorageRoot {
        HISTORY,
        REALM,
        PROPERTIES,
        JREPORTS,
        TEMP,
        FONT,
        STYLE,
        GISINFO,
        CRD_CACHE,
        DYNAMICCLASSES;


        public String getRootPath() {
            return Storage.separator + this.toString();
        }
    }
}

