/*
 * Decompiled with CFR 0.152.
 */
package jet.server.storage.impl;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.server.api.RemoteFileService;
import jet.server.api.cluster.ClusterException;
import jet.server.api.db.Database;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.cluster.core.JRMessage;
import jet.server.cluster.core.JRView;
import jet.server.cluster.core.Topic;
import jet.server.cluster.core.Transceiver;
import jet.server.db.storage.StorageRecord;
import jet.server.db.storage.StorageResourceTable;
import jet.server.jrc.JRMember;
import jet.server.jrc.JRRemoteFileService;
import jet.server.log.ServiceLogger;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.storage.StorageException;
import jet.server.storage.StoragePathInfo;
import jet.server.storage.UnavailableStorageException;
import jet.server.storage.impl.PATH;
import jet.server.storage.impl.StorageMessage;
import jet.server.storage.util.StorageUtil;

public class StorageTransceiver
extends Transceiver {
    private static final int REALM = 1;
    private static final int SEDU = 2;
    private static final int STORAGE = 3;
    private static final int StorageResources = 4;
    private StorageResourceTable TEMP;
    private ClusterMap abs;
    private Hashtable access$002;
    private final int access$600;
    private Set access$700 = new HashSet();
    private FileCopyThread access$800 = new FileCopyThread();

    public StorageTransceiver(Database database) throws ClusterException, InstantiationException, SQLException {
        super(Topic.STORAGE);
        this.access$600 = super.getLocalMember().getID();
        this.TEMP = new StorageResourceTable(database);
        this.access$002 = new Hashtable();
        this.abs = MapFactory.getMap(MapAttr.StorageResources);
        this.abs.addListener(new StorageMapListener());
        if (this.isCoordinator()) {
            this.REALM();
        } else {
            this.STORAGE();
        }
        this.viewAccepted(super.getView());
        this.access$800.start();
    }

    private void REALM() {
        HashMap<String, StorageRecord> hashMap = new HashMap<String, StorageRecord>();
        for (StorageRecord storageRecord : this.TEMP.getAll()) {
            hashMap.put(storageRecord.getPath(), storageRecord);
        }
        this.abs.putAll(hashMap);
        this.STORAGE();
    }

    private void STORAGE() {
        if (this.abs.isResourceNode()) {
            this.access$002.clear();
            for (Map.Entry entry : this.abs.entrySet()) {
                String string = (String)entry.getKey();
                if (!string.startsWith(Storage.StorageRoot.REALM.getRootPath())) continue;
                this.access$002.put(string, entry.getValue());
            }
        }
    }

    @Override
    public void beforeClose() {
        if (this.TEMP != null) {
            this.TEMP.close();
            this.TEMP = null;
            this.access$800.SEDU = true;
        }
        this.access$002 = null;
        this.abs = null;
    }

    public void add(PATH pATH, int n, boolean bl) throws IOException, ClusterException {
        StorageRecord storageRecord = (StorageRecord)this.abs.get(pATH.getPath());
        if (n == -1 || n == this.access$600) {
            n = this.access$600;
            bl = pATH.getFile().isDirectory();
        }
        if (storageRecord == null) {
            storageRecord = new StorageRecord();
            storageRecord.setPath(pATH.getPath());
            storageRecord.setDirectory(bl);
        } else {
            storageRecord.getMembers().clear();
        }
        if (pATH.getRoot() != Storage.StorageRoot.TEMP) {
            this.TEMP.addFile(storageRecord, n);
        }
        storageRecord.getMembers().add(n);
        this.abs(pATH.getPath());
        StorageMessage storageMessage = StorageMessage.forCopy(storageRecord, n, this.TEMP(pATH, storageRecord));
        this.abs.put(pATH.getPath(), storageRecord, MapFlags.create(false, storageMessage).forceDests(storageMessage.getDst()));
    }

    public boolean get(PATH pATH) throws IOException, ClusterException, UnavailableStorageException {
        StorageRecord storageRecord = (StorageRecord)this.abs.get(pATH.getPath());
        if (storageRecord == null) {
            return false;
        }
        if (storageRecord.getMembers().contains(this.access$600) && pATH.getFile().exists()) {
            return true;
        }
        this.access$800.add(pATH.getPath());
        this.access$800(StorageMessage.forCopy(storageRecord, -1, this.access$600));
        return true;
    }

    public void delete(PATH pATH) throws IOException, ClusterException {
        StorageRecord storageRecord = (StorageRecord)this.abs.get(pATH.getPath());
        if (storageRecord == null) {
            ServiceLogger.logDebug(4670137, pATH.getPath(), 4);
            return;
        }
        if (pATH.getRoot() != Storage.StorageRoot.TEMP) {
            this.TEMP.deleteFile(storageRecord);
        }
        this.abs.remove((Object)pATH.getPath(), MapFlags.create().forceDests(storageRecord.getMembers()));
    }

    public boolean exists(PATH pATH) {
        StorageRecord storageRecord = (StorageRecord)this.abs.get(pATH.getPath());
        return storageRecord != null;
    }

    public void cleanup(Storage.StorageRoot storageRoot) throws ClusterException {
        ServiceLogger.logDebug(4670138, new Object[0], 4);
    }

    @Override
    public void viewAccepted(JRView jRView) {
        if (jRView.size() == 1) {
            return;
        }
        if (((JRMember)jRView.getMembers().get(jRView.size() - 1)).getID() != this.access$600) {
            return;
        }
        if (this.abs.isResourceNode()) {
            this.StorageResources();
        } else {
            try {
                super.sendMessage(super.getMemberService().getDefaultShareMemoryNode().getID(), new JRMessage(4, null));
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError((Throwable)((Object)clusterException));
            }
        }
    }

    private void StorageResources() {
        ArrayList<StorageMessage> arrayList = new ArrayList<StorageMessage>();
        for (StorageRecord storageRecord : this.abs.values()) {
            try {
                int n = this.TEMP(PATH.parse(storageRecord.getPath()), storageRecord);
                if (n == -1) continue;
                StorageMessage storageMessage = StorageMessage.forCopy(storageRecord, -1, n);
                ServiceLogger.logDebug(4670149, new Object[]{n, storageRecord}, 5);
                arrayList.add(storageMessage);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
        this.access$800.access$900(arrayList);
    }

    @Override
    public void handleMessage(JRMessage jRMessage) {
        switch (jRMessage.getFlag()) {
            case 3: {
                StorageMessage storageMessage = (StorageMessage)jRMessage.getObject();
                this.access$800.SEDU(storageMessage);
                break;
            }
            case 4: {
                this.StorageResources();
            }
        }
    }

    @Override
    public Serializable handleRequest(JRMessage jRMessage) {
        switch (jRMessage.getFlag()) {
            case 1: {
                try {
                    String string = (String)((Object)jRMessage.getObject());
                    ServiceLogger.logDebug(6670139, string, 6);
                    if (((StorageRecord)this.abs.get(string)).getMembers().contains(this.access$600)) {
                        return PATH.parseEntry(string).getFile().getCanonicalPath();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                break;
            }
            case 2: {
                try {
                    StorageMessage storageMessage = (StorageMessage)jRMessage.getObject();
                    ServiceLogger.logDebug("Storage:: handle list: " + storageMessage.getPath());
                    return this.addFile(storageMessage.getPath(), storageMessage.getRecursive());
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
            }
        }
        return null;
    }

    private int TEMP(PATH pATH, StorageRecord storageRecord) {
        ArrayList arrayList = new ArrayList(super.getMembersIdSet());
        ArrayList arrayList2 = new ArrayList(arrayList);
        arrayList2.retainAll(storageRecord.getMembers());
        if (arrayList2.size() == 0) {
            return -1;
        }
        int n = StorageEnv.getCopies(pATH.getRoot());
        if (n < 0) {
            n = Math.max(1, Math.round(Math.abs((float)n / 100.0f) * (float)arrayList.size()));
        }
        if (n == 0 || n > arrayList2.size()) {
            ArrayList arrayList3 = new ArrayList(arrayList);
            arrayList3.removeAll(storageRecord.getMembers());
            if (arrayList3.size() > 0) {
                if (arrayList3.contains(this.access$600)) {
                    return this.access$600;
                }
                for (JRMember jRMember : super.getMemberService().getShareMemoryNodes()) {
                    if (!arrayList3.contains(new Integer(jRMember.getID()))) continue;
                    return jRMember.getID();
                }
                return (Integer)arrayList3.get(0);
            }
        }
        return -1;
    }

    private void abs(String string) {
        this.access$800.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void access$002(String string) {
        Set set = this.access$700;
        synchronized (set) {
            while (this.access$700.contains(string)) {
                try {
                    this.access$700.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.access$700.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void access$600(String string) {
        Set set = this.access$700;
        synchronized (set) {
            this.access$700.remove(string);
            this.access$700.notifyAll();
        }
    }

    private void access$700(PATH pATH, JRMember jRMember) throws IOException, ClusterException {
        RemoteFileService remoteFileService;
        long l = System.currentTimeMillis();
        StorageEnv storageEnv = StorageEnv.getStorageEnv(jRMember.getID());
        String string = PATH.replaceRootDiskPath(pATH, storageEnv.getDiskDir(pATH.getRoot()), storageEnv.getFileSeprator());
        String string2 = pATH.getFile().getCanonicalPath();
        try {
            remoteFileService = JRRemoteFileService.getRemoteFileService(jRMember.getHost(), jRMember.getPort());
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        remoteFileService.copyFromRemote(string, string2, true);
        long l2 = System.currentTimeMillis() - l;
        ServiceLogger.logDebug(6670143, new Object[]{l2, 0, pATH.getPath(), string}, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void access$800(StorageMessage storageMessage) throws IOException, UnavailableStorageException {
        StorageRecord storageRecord = storageMessage.getStroageRecord();
        if (storageMessage.getDst() != -1 && storageMessage.getDst() != this.access$600) {
            try {
                if (storageMessage.getSrc() == -1 && storageRecord.getMembers().contains(this.access$600)) {
                    storageMessage.setSrc(this.access$600);
                }
                super.sendMessage(storageMessage.getDst(), new JRMessage(3, storageMessage));
                return;
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError((Throwable)((Object)clusterException), 3);
            }
        }
        this.access$002(storageMessage.getPath());
        try {
            ServiceLogger.logDebug(6670144, new Object[]{storageMessage.getPath(), storageMessage.getSrc()}, 6);
            List list = StorageUtil.randomList(storageRecord.getMembers());
            if (storageMessage.getSrc() != -1 && list.remove(new Integer(storageMessage.getSrc()))) {
                list.add(0, storageMessage.getSrc());
            }
            PATH pATH = PATH.parseEntry(storageMessage.getPath());
            String string = pATH.getFile().getCanonicalPath();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                try {
                    JRMember jRMember = this.getMemberByID(n);
                    if (jRMember == null || jRMember.equals(this.getLocalMember())) continue;
                    this.access$700(pATH, jRMember);
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable, 3);
                    continue;
                }
                if (pATH.getRoot() != Storage.StorageRoot.TEMP && !this.TEMP.addMember(storageRecord, this.access$600)) {
                    return;
                }
                storageRecord.getMembers().add(this.access$600);
                int n2 = this.TEMP(pATH, storageRecord);
                if (n2 != -1) {
                    storageMessage.setSrc(this.access$600);
                    storageMessage.setDst(n2);
                    this.abs.put(storageMessage.getPath(), storageRecord, MapFlags.create(true, storageMessage).forceDests(n2));
                } else {
                    this.abs.put(storageMessage.getPath(), storageRecord, MapFlags.create(true, null));
                }
                return;
            }
        }
        finally {
            this.access$600(storageMessage.getPath());
        }
        ServiceLogger.logDebug(6670141, storageRecord, 6);
        throw new UnavailableStorageException(storageMessage.getPath());
    }

    private StoragePathInfo add(StorageRecord storageRecord) {
        StoragePathInfo storagePathInfo = new StoragePathInfo();
        storagePathInfo.setPath(storageRecord.getPath());
        storagePathInfo.setIsDir(storageRecord.isDirectory());
        storagePathInfo.setLastModified(storageRecord.getLastModified());
        return storagePathInfo;
    }

    public ArrayList list(String string, boolean bl) throws StorageException {
        if (this.abs.isResourceNode()) {
            return this.addFile(string, bl);
        }
        try {
            return (ArrayList)super.sendRequest(this.getMemberService().getDefaultShareMemoryNode().getID(), new JRMessage(2, StorageMessage.forList(string, bl)), 0L);
        }
        catch (ClusterException clusterException) {
            throw new StorageException((Throwable)((Object)clusterException));
        }
    }

    private ArrayList addFile(String string, boolean bl) throws StorageException {
        StorageRecord storageRecord = (StorageRecord)this.abs.get(string);
        if (storageRecord != null && !storageRecord.isDirectory()) {
            return new ArrayList();
        }
        ArrayList<StoragePathInfo> arrayList = new ArrayList<StoragePathInfo>();
        for (String string2 : this.access$002.keySet()) {
            if (!string2.startsWith(string + "/") || !bl && string2.indexOf("/", string.length() + 1) != -1) continue;
            arrayList.add(this.add((StorageRecord)this.access$002.get(string2)));
        }
        return arrayList;
    }

    class FileCopyThread
    extends Thread {
        private boolean SEDU;
        private List access$900;

        FileCopyThread() {
            super("StorageFileCopy");
            this.access$900 = new ArrayList();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.SEDU) {
                try {
                    StorageTransceiver.this.access$800(this.addAll());
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable, 3);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void SEDU(StorageMessage storageMessage) {
            List list = this.access$900;
            synchronized (list) {
                this.access$900.remove(storageMessage);
                this.access$900.add(storageMessage);
                this.access$900.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void access$900(List list) {
            if (list == null || list.size() == 0) {
                return;
            }
            List list2 = this.access$900;
            synchronized (list2) {
                this.access$900.removeAll(list);
                this.access$900.addAll(list);
                this.access$900.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(String string) {
            if (string == null) {
                return;
            }
            List list = this.access$900;
            synchronized (list) {
                for (StorageMessage storageMessage : this.access$900) {
                    if (!string.equals(storageMessage.getPath())) continue;
                    this.access$900.remove(storageMessage);
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StorageMessage addAll() throws InterruptedException {
            List list = this.access$900;
            synchronized (list) {
                if (this.access$900.isEmpty()) {
                    this.access$900.wait();
                }
                return (StorageMessage)this.access$900.remove(0);
            }
        }
    }

    class StorageMapListener
    extends MapListenerAdapter {
        StorageMapListener() {
        }

        @Override
        public void afterInit(String string, int n, int n2) {
            if (n2 == 0) {
                StorageTransceiver.this.REALM();
            } else {
                StorageTransceiver.this.STORAGE();
            }
        }

        public void afterPut(String string, int n, String string2, StorageRecord storageRecord, StorageRecord storageRecord2, MapFlags mapFlags) {
            if (string2.startsWith(Storage.StorageRoot.REALM.getRootPath())) {
                StorageTransceiver.this.access$002.put(string2, storageRecord);
            }
            StorageTransceiver.this.abs(string2);
            Object[] objectArray = MapFlags.getUserFlags(mapFlags);
            if (objectArray != null) {
                StorageMessage storageMessage;
                boolean bl = (Boolean)objectArray[0];
                if (bl && storageRecord2 != null) {
                    storageRecord.getMembers().addAll(storageRecord2.getMembers());
                }
                if ((storageMessage = (StorageMessage)objectArray[1]) != null && storageMessage.getDst() == StorageTransceiver.this.getLocalMember().getID()) {
                    StorageTransceiver.this.access$800.SEDU(storageMessage);
                }
            }
        }

        public void afterRemove(String string, int n, String string2, StorageRecord storageRecord, MapFlags mapFlags) {
            if (string2.startsWith(Storage.StorageRoot.REALM.getRootPath())) {
                StorageTransceiver.this.access$002.remove(string2);
            }
            if (storageRecord != null) {
                try {
                    StorageTransceiver.this.abs(string2);
                    StorageUtil.delete(PATH.parseEntry(string2).getFile());
                    ServiceLogger.logDebug(6670140, string2, 6);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
            }
        }
    }
}

