/*
 * Decompiled with CFR 0.152.
 */
package jet.server.tools;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import jet.server.ServerEnv;
import jet.server.api.db.DBManager;
import jet.server.api.db.Database;
import jet.server.api.db.Workspace;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.GlobalDataService;

public final class DBMaintain {
    public static void main(String[] stringArray) {
        Object object;
        Properties properties = new Properties();
        int n = stringArray.length;
        if (n < 1) {
            DBMaintain.SEDU();
            return;
        }
        for (int i = 0; i < n; ++i) {
            object = stringArray[i];
            if ("-?".equals(object)) {
                DBMaintain.SEDU();
                return;
            }
            if ("-cleanup".equalsIgnoreCase((String)object)) {
                properties.setProperty("check.realmtables", "true");
                continue;
            }
            if (((String)object).startsWith("-Bsystemtables:")) {
                properties.setProperty("backup.systemtables", ((String)object).substring("-Bsystemtables:".length()));
                continue;
            }
            if (((String)object).startsWith("-B0realmtables:")) {
                properties.setProperty("backup-type", "DB");
                properties.setProperty("backup.realmtables", ((String)object).substring("-B0realmtables:".length()));
                continue;
            }
            if (((String)object).startsWith("-Brealmtables:")) {
                properties.setProperty("backup.realmtables", ((String)object).substring("-Brealmtables:".length()));
                continue;
            }
            if (((String)object).startsWith("-Bprofiling:")) {
                properties.setProperty("backup.profiling", ((String)object).substring("-Bprofiling:".length()));
                continue;
            }
            if (((String)object).startsWith("-Rsystemtables:")) {
                properties.setProperty("restore.systemtables", ((String)object).substring("-Rsystemtables:".length()));
                continue;
            }
            if (((String)object).startsWith("-R0realmtables:")) {
                properties.setProperty("restore-type", "DB");
                properties.setProperty("restore.realmtables", ((String)object).substring("-R0realmtables:".length()));
                continue;
            }
            if (((String)object).startsWith("-Rrealmtables:")) {
                properties.setProperty("restore.realmtables", ((String)object).substring("-Rrealmtables:".length()));
                continue;
            }
            if (((String)object).startsWith("-Rprofiling:")) {
                properties.setProperty("restore.profiling", ((String)object).substring("-Rprofiling:".length()));
                continue;
            }
            DBMaintain.SEDU();
            return;
        }
        DBMaintain dBMaintain = new DBMaintain();
        try {
            dBMaintain.run(properties);
        }
        catch (Exception exception) {
            System.exit(1);
        }
        GlobalDataService.shutdown();
        object = DBManager.getDefaultWorkspace();
        Iterator iterator = object.databases().iterator();
        while (iterator.hasNext()) {
            DatabaseImpl databaseImpl = (DatabaseImpl)iterator.next();
            databaseImpl.close();
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        System.exit(0);
    }

    private static void SEDU() {
        DBMaintain.backup("Usage: java jet.server.tools.DBMaintain [options]");
        DBMaintain.backup("Options:");
        DBMaintain.backup("  -?\t\tprint this help message");
        DBMaintain.backup("  -cleanup\tcheck integrality of server data and cleanup invalid data");
        DBMaintain.backup("  -Bsystemtables:<filename>\r\n\t\tbackup system database to an appointed file");
        DBMaintain.backup("  -Brealmtables:<filename>\r\n\t\tbackup realmtables database to an appointed file");
        DBMaintain.backup("  -B0realmtables:<filename>\r\n\t\tbackup realmtables database without external data");
        DBMaintain.backup("  -Bprofiling:<filename>\r\n\t\tbackup profiling database to an appointed file");
        DBMaintain.backup("  -Rsystemtables:<filename>\r\n\t\trestore system database from an appointed file");
        DBMaintain.backup("  -Rrealmtables:<filename>\r\n\t\trestore realmtables database from an appointed file");
        DBMaintain.backup("  -R0realmtables:<filename>\r\n\t\trestore realmtables database and exclude external data");
        DBMaintain.backup("  -Rprofiling:<filename>\r\n\t\trestore profiling database from an appointed file");
    }

    private static void backup(String string) {
        System.err.println(string);
    }

    private DBMaintain() {
    }

    void run(Properties properties) throws Exception {
        Database database;
        System.getProperties().putAll((Map<?, ?>)properties);
        ServerEnv.checkDBEnv();
        Workspace workspace = DBManager.getSystemWorkspace();
        String string = properties.getProperty("backup.systemtables");
        if (string != null && string.trim().length() > 0 && workspace != null && (database = workspace.databases("systemtables")) != null) {
            try {
                database.backup(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        workspace = DBManager.getDefaultWorkspace();
        string = properties.getProperty("backup.realmtables");
        if (string != null && string.trim().length() > 0 && workspace != null && (database = workspace.databases("realmtables")) != null) {
            try {
                String string2 = properties.getProperty("backup-type");
                if (string2 != null) {
                    database.setProperty("backup-type", string2);
                }
                database.backup(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        if ((string = properties.getProperty("backup.profiling")) != null && string.trim().length() > 0 && workspace != null && (database = workspace.databases("profile")) != null) {
            try {
                database.backup(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }
}

