/*
 * Decompiled with CFR 0.152.
 */
package jet.server.tools;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.ResultVersionRecord;
import jet.server.db.CompletedTable;
import jet.server.db.JRTaskSuccessInfo;
import jet.server.db.ROCompletedTaskRecord;
import jet.server.db.VersionAmountRecord;
import jet.server.db.VersionAmountRecordContainerImpl;
import jet.server.db.VersionRecord;
import jet.server.db.VersionRecordContainer;
import jet.server.jrserver.JRResultVersionRecord;
import jet.server.tools.MigrationToV6;
import jet.server.tools.migration.CompletedTableImpl;

public class MigrationBV52toV6
extends MigrationToV6 {
    public MigrationBV52toV6(String string, String string2) throws Exception {
        super(string, string2);
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        String string2;
        if (stringArray.length == 0 || stringArray[0].equals("?")) {
            System.out.println("Usage: java jet.server.tools.MigrationBV52toV6 v6Reporthome [orgReportHome}");
            System.out.println("newReporthome        report home of JREntServer v6, which orginal data will be migrated to.");
            System.out.println("orgReporthome        report home of orginal JREntServer");
            System.out.println("                     if this parameter is not inputed, use value of \"newReporthome\" as its value ");
            return;
        }
        if (stringArray.length == 1) {
            string2 = stringArray[0];
            string = stringArray[0];
        } else {
            string2 = stringArray[1];
            string = stringArray[0];
        }
        MigrationBV52toV6 migrationBV52toV6 = new MigrationBV52toV6(string2, string);
        migrationBV52toV6.migrateResource();
        migrationBV52toV6.migrateSecurity(false);
        Hashtable hashtable = null;
        Vector vector = null;
        for (int i = 0; i < migrationBV52toV6.realms.size(); ++i) {
            String string3 = (String)migrationBV52toV6.realms.elementAt(i);
            vector = migrationBV52toV6.getResultVersionRecordVector(string3);
            migrationBV52toV6.migrateResultVersions(string3, vector);
            hashtable = migrationBV52toV6.getVersionAmountRecord(string3);
            migrationBV52toV6.migrateVersionLimit(string3, hashtable);
        }
        migrationBV52toV6.migrateCompletedTable();
        migrationBV52toV6.migrateProtections();
        migrationBV52toV6.migrateAlias();
        migrationBV52toV6.close();
        System.exit(0);
    }

    public void migrateCompletedTable() {
        boolean bl = true;
        if (this.realms != null && this.realms.size() != 0) {
            for (int i = 0; i < this.realms.size(); ++i) {
                String string = (String)this.realms.elementAt(i);
                CompletedTable completedTable = this.dataV6.getDataService(string).getCompletedTable();
                Vector vector = new Vector();
                vector = this.getCompletedTableRecordVector(string);
                for (int j = 0; j < vector.size(); ++j) {
                    ROCompletedTaskRecord rOCompletedTaskRecord = (ROCompletedTaskRecord)vector.elementAt(j);
                    long[] lArray = ((JRTaskSuccessInfo)rOCompletedTaskRecord.getSuccessInfo()).getSuccessInfo().getSuccInfo();
                    try {
                        completedTable.addRecord(rOCompletedTaskRecord.getTaskID(), rOCompletedTaskRecord.getCatalogFile(), rOCompletedTaskRecord.getReportFile(), rOCompletedTaskRecord.getParamFile(), rOCompletedTaskRecord.getResults(), rOCompletedTaskRecord.getCompletedTime(), rOCompletedTaskRecord.getSubmitter(), rOCompletedTaskRecord.isSuccessful(), lArray, rOCompletedTaskRecord.getErrorMessage(), rOCompletedTaskRecord.getTaskClass(), APIUtil.parseInt(rOCompletedTaskRecord.getVersionID(), -1), rOCompletedTaskRecord.getCompletedRecordID(), rOCompletedTaskRecord.getLaunchType(), rOCompletedTaskRecord.getEngineStatus(), "");
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        System.out.println("migrate completed table error: " + remoteException);
                    }
                }
            }
        }
        if (bl) {
            System.out.println("migrate completed table successfully!");
        } else {
            System.out.println("migrate completed table failed!");
        }
    }

    public Vector getCompletedTableRecordVector(String string) {
        Vector vector = new Vector();
        CompletedTableImpl completedTableImpl = null;
        try {
            completedTableImpl = new CompletedTableImpl(true, this.orgRealmsPath, string);
            if (ServerEnv.shouldStartRMI()) {
                UnicastRemoteObject.exportObject((Remote)completedTableImpl, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
            }
            completedTableImpl.init(null);
            vector = completedTableImpl.getAllCompletedTaskRecordsVector();
            completedTableImpl.commit();
        }
        catch (RemoteException remoteException) {
            System.out.println("get completed table records error: " + remoteException);
        }
        if (completedTableImpl != null) {
            completedTableImpl.close();
        }
        return vector;
    }

    public Vector getResultVersionRecordVector(String string) {
        Vector vector = new Vector();
        Vector<JRResultVersionRecord> vector2 = new Vector<JRResultVersionRecord>();
        VersionRecordContainer versionRecordContainer = null;
        try {
            versionRecordContainer = new VersionRecordContainer(true, this.orgPropertiesPath, this.orgRealmsPath, string);
            versionRecordContainer.init();
            vector = versionRecordContainer.getVersionRecords();
            for (int i = 0; i < vector.size(); ++i) {
                VersionRecord versionRecord = (VersionRecord)vector.elementAt(i);
                JRResultVersionRecord jRResultVersionRecord = new JRResultVersionRecord(versionRecord.getValues());
                vector2.addElement(jRResultVersionRecord);
            }
            versionRecordContainer.commit();
        }
        catch (Exception exception) {
            System.out.println("get result version record error: " + exception);
        }
        if (versionRecordContainer != null) {
            versionRecordContainer.close();
        }
        return vector2;
    }

    public Hashtable getVersionAmountRecord(String string) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        VersionAmountRecordContainerImpl versionAmountRecordContainerImpl = null;
        try {
            versionAmountRecordContainerImpl = new VersionAmountRecordContainerImpl(this.orgPropertiesPath);
            if (ServerEnv.shouldStartRMI()) {
                UnicastRemoteObject.exportObject((Remote)versionAmountRecordContainerImpl, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
            }
            Vector vector = new Vector();
            vector = versionAmountRecordContainerImpl.getVersionAmountRecords();
            for (int i = 0; i < vector.size(); ++i) {
                VersionAmountRecord versionAmountRecord = (VersionAmountRecord)vector.elementAt(i);
                String string2 = versionAmountRecord.getCatFile();
                String string3 = versionAmountRecord.getReportFile();
                if (string3.indexOf("/") < 0) {
                    string3 = string2.substring(0, string2.lastIndexOf("/") + 1) + string3;
                }
                int n = versionAmountRecord.getMaxAmount();
                hashtable.put(string3, new Integer(n));
            }
            versionAmountRecordContainerImpl.commit();
        }
        catch (Exception exception) {
            System.out.println("get version amount record error: " + exception);
        }
        if (versionAmountRecordContainerImpl != null) {
            versionAmountRecordContainerImpl.close();
        }
        return hashtable;
    }

    public void testGetCompletedTableRecordVector() {
        if (this.realms != null && this.realms.size() != 0) {
            for (int i = 0; i < this.realms.size(); ++i) {
                String string = (String)this.realms.elementAt(i);
                Vector vector = this.getCompletedTableRecordVector(string);
                if (vector != null && vector.size() != 0) {
                    String string2 = ((ROCompletedTaskRecord)vector.elementAt(0)).getTaskID();
                    System.out.println("taskId=" + string2);
                    continue;
                }
                System.out.println("the completed table have no record!");
            }
        }
    }

    public void testGetResultVersionRecordVector() {
        if (this.realms != null && this.realms.size() != 0) {
            for (int i = 0; i < this.realms.size(); ++i) {
                String string = (String)this.realms.elementAt(i);
                Vector vector = this.getResultVersionRecordVector(string);
                if (vector != null && vector.size() != 0) {
                    try {
                        String string2 = ((ResultVersionRecord)vector.elementAt(0)).getResultFile();
                        System.out.println("result=" + string2);
                    }
                    catch (Exception exception) {
                        System.out.println("e=" + exception);
                    }
                    continue;
                }
                System.out.println("the result version table have no record!");
            }
        }
    }
}

