/*
 * Decompiled with CFR 0.152.
 */
package jet.server.tools;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.db.CompletedTable;
import jet.server.db.CompletedTaskRecordImpl;
import jet.server.db.JRTaskSuccessInfo;
import jet.server.db.ResultVersionRecordImpl;
import jet.server.db.VersionLimitRecordImpl;
import jet.server.db.VersionLimitTableImpl;
import jet.server.db.VersionTableImpl;
import jet.server.tools.MigrationToV6;
import jet.server.tools.migration.CompletedTableImpl2;

public class MigrationV52toV6
extends MigrationToV6 {
    public MigrationV52toV6(String string, String string2) throws Exception {
        super(string, string2);
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        String string2;
        if (stringArray.length == 0 || stringArray[0].equals("?")) {
            System.out.println("Usage: java jet.server.tools.MigrationV52toV6 v6Reporthome [orgReportHome}");
            System.out.println("newReporthome        report home of JREntServer v6, which orginal data will be migrated to.");
            System.out.println("orgReporthome        report home of orginal JREntServer");
            System.out.println("                     if this parameter is not inputed, use value of \"newReportHome\" as its value ");
            return;
        }
        if (stringArray.length == 1) {
            string2 = stringArray[0];
            string = stringArray[0];
        } else {
            string2 = stringArray[1];
            string = stringArray[0];
        }
        MigrationV52toV6 migrationV52toV6 = new MigrationV52toV6(string2, string);
        migrationV52toV6.migrateResource();
        migrationV52toV6.migrateSecurity(true);
        Hashtable hashtable = null;
        Vector vector = null;
        for (int i = 0; i < migrationV52toV6.realms.size(); ++i) {
            String string3 = (String)migrationV52toV6.realms.elementAt(i);
            vector = migrationV52toV6.getResultVersionRecordVector(string3);
            migrationV52toV6.migrateResultVersions(string3, vector);
            hashtable = migrationV52toV6.getVersionAmountRecord(string3);
            migrationV52toV6.migrateVersionLimit(string3, hashtable);
        }
        migrationV52toV6.migrateCompletedTable();
        migrationV52toV6.migrateProtections();
        migrationV52toV6.migrateAlias();
        migrationV52toV6.close();
        System.exit(0);
    }

    public void migrateCompletedTable() {
        boolean bl = true;
        if (this.realms != null && this.realms.size() != 0) {
            for (int i = 0; i < this.realms.size(); ++i) {
                String string = (String)this.realms.elementAt(i);
                CompletedTable completedTable = this.dataV6.getDataService(string).getCompletedTable();
                Vector vector = new Vector();
                vector = this.getCompletedTableRecordVector(string);
                for (int j = 0; j < vector.size(); ++j) {
                    CompletedTaskRecordImpl completedTaskRecordImpl = (CompletedTaskRecordImpl)vector.elementAt(j);
                    long[] lArray = ((JRTaskSuccessInfo)completedTaskRecordImpl.getSuccessInfo()).getSuccessInfo().getSuccInfo();
                    try {
                        completedTable.addRecord(completedTaskRecordImpl.getTaskID(), completedTaskRecordImpl.getCatalogFile(), completedTaskRecordImpl.getReportFile(), completedTaskRecordImpl.getParamFile(), completedTaskRecordImpl.getResults(), completedTaskRecordImpl.getCompletedTime(), completedTaskRecordImpl.getSubmitter(), completedTaskRecordImpl.isSuccessful(), lArray, completedTaskRecordImpl.getErrorMessage(), completedTaskRecordImpl.getTaskClass(), APIUtil.parseInt(completedTaskRecordImpl.getVersionID(), -1), completedTaskRecordImpl.getCompletedRecordID(), completedTaskRecordImpl.getLaunchType(), completedTaskRecordImpl.getEngineStatus(), "");
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        System.out.println("migrate completed table error: " + remoteException);
                    }
                }
            }
        }
        if (bl) {
            System.out.println("migrate completed table successfully!");
        } else {
            System.out.println("migrate completed table failed!");
        }
    }

    public Vector getCompletedTableRecordVector(String string) {
        Vector vector = new Vector();
        CompletedTableImpl2 completedTableImpl2 = null;
        try {
            completedTableImpl2 = CompletedTableImpl2.newInstance("jdbc:hsqldb:" + this.orgPropertiesPath + "systable", "sa", "", string);
            if (ServerEnv.shouldStartRMI()) {
                UnicastRemoteObject.exportObject((Remote)completedTableImpl2, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
            }
            vector = completedTableImpl2.getAllCompletedTaskRecordsVector();
            completedTableImpl2.commit();
        }
        catch (RemoteException remoteException) {
            System.out.println("get completed table records' vector error: " + remoteException);
        }
        if (completedTableImpl2 != null) {
            completedTableImpl2.close();
        }
        return vector;
    }

    public Vector getResultVersionRecordVector(String string) {
        Vector vector = new Vector();
        VersionTableImpl versionTableImpl = null;
        try {
            versionTableImpl = VersionTableImpl.newInstance("jdbc:hsqldb:" + this.orgPropertiesPath + "systable", "sa", "", string);
            if (ServerEnv.shouldStartRMI()) {
                UnicastRemoteObject.exportObject((Remote)versionTableImpl, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
            }
            vector = versionTableImpl.getAllRecords();
            versionTableImpl.commit();
        }
        catch (RemoteException remoteException) {
            System.out.println("get result version record vector error:" + remoteException);
        }
        if (versionTableImpl != null) {
            versionTableImpl.close();
        }
        return vector;
    }

    public Hashtable getVersionAmountRecord(String string) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        VersionLimitTableImpl versionLimitTableImpl = null;
        try {
            versionLimitTableImpl = VersionLimitTableImpl.newInstance("jdbc:hsqldb:" + this.orgPropertiesPath + "systable", "sa", "", string);
            if (ServerEnv.shouldStartRMI()) {
                UnicastRemoteObject.exportObject((Remote)versionLimitTableImpl, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
            }
            Vector vector = new Vector();
            vector = versionLimitTableImpl.getAllRecords();
            for (int i = 0; i < vector.size(); ++i) {
                VersionLimitRecordImpl versionLimitRecordImpl = (VersionLimitRecordImpl)vector.elementAt(i);
                String string2 = versionLimitRecordImpl.getCatalogFile();
                String string3 = versionLimitRecordImpl.getReportFile();
                if (string3.indexOf("/") < 0) {
                    string3 = string2.substring(0, string2.lastIndexOf("/") + 1) + string3;
                }
                int n = versionLimitRecordImpl.getMaxAmount();
                hashtable.put(string3, new Integer(n));
            }
            versionLimitTableImpl.commit();
        }
        catch (RemoteException remoteException) {
            System.out.println("get version amount record error: " + remoteException);
        }
        if (versionLimitTableImpl != null) {
            versionLimitTableImpl.close();
        }
        return hashtable;
    }

    public void testGetCompletedTableRecordVector() {
        if (this.realms != null && this.realms.size() != 0) {
            for (int i = 0; i < this.realms.size(); ++i) {
                String string = (String)this.realms.elementAt(i);
                Vector vector = this.getCompletedTableRecordVector(string);
                if (vector != null && vector.size() != 0) {
                    String string2 = ((CompletedTaskRecordImpl)vector.elementAt(0)).getTaskID();
                    System.out.println("taskId=" + string2);
                    continue;
                }
                System.out.println("the completed table have no record!");
            }
        }
    }

    public void testGetResultVersionRecordVector() {
        if (this.realms != null && this.realms.size() != 0) {
            for (int i = 0; i < this.realms.size(); ++i) {
                String string = (String)this.realms.elementAt(i);
                Vector vector = this.getResultVersionRecordVector(string);
                if (vector != null && vector.size() != 0) {
                    String string2 = ((ResultVersionRecordImpl)vector.elementAt(0)).getResultFile();
                    System.out.println("result=" + string2);
                    continue;
                }
                System.out.println("the result version table have no record!");
            }
        }
    }
}

