/*
 * Decompiled with CFR 0.152.
 */
package jet.server.trigger;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import jet.server.ServerEnv;
import jet.server.api.trigger.Trigger;
import jet.server.api.trigger.TriggerManageException;
import jet.server.api.trigger.TriggerManager;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.util.ClusterInitLocker;
import jet.server.log.ServiceLogger;
import jet.server.trigger.ExternTriggerImpl;
import jet.server.trigger.TriggerTableImpl;

public final class TriggerManagerImpl
implements TriggerManager {
    private static TriggerManager SEDU = null;
    private ClusterMap _updateTrigger = null;
    private TriggerTableImpl addTrigger;

    public static synchronized TriggerManager getInstance() {
        if (SEDU == null) {
            SEDU = new TriggerManagerImpl();
        }
        return SEDU;
    }

    private TriggerManagerImpl() {
        ServiceLogger.logEvent(4670015, 4);
        this.addTrigger = TriggerTableImpl.getInstance();
        try {
            this._updateTrigger = MapFactory.getMap(MapAttr.triggersMap);
            if (!ClusterInitLocker.hasInited(this._updateTrigger.getName())) {
                this.close();
                ClusterInitLocker.setInited(this._updateTrigger.getName());
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            System.out.println("Fail to get triggers Map!");
        }
    }

    public ClusterMap getTriggersMap() {
        return this._updateTrigger;
    }

    public void destroy() {
        if (this.addTrigger != null) {
            this.addTrigger.close();
        }
        SEDU = null;
        ServiceLogger.logEvent(4670016, 4);
    }

    @Override
    public synchronized Trigger createTrigger(String string, String string2) throws TriggerManageException {
        if (this.contains(string)) {
            throw new TriggerManageException(670001, new Object[]{string}, null);
        }
        ExternTriggerImpl externTriggerImpl = new ExternTriggerImpl(string, string2);
        if (this.SEDU(externTriggerImpl)) {
            this._updateTrigger.put(externTriggerImpl.getName(), externTriggerImpl);
        }
        return externTriggerImpl;
    }

    @Override
    public synchronized void setEnable(String string, boolean bl) {
        Trigger trigger = this.getTrigger(string);
        if (trigger != null) {
            boolean bl2 = trigger.isEnable();
            ((ExternTriggerImpl)trigger).setEnable(bl);
            if (!this._updateTrigger(trigger)) {
                ((ExternTriggerImpl)trigger).setEnable(bl2);
            } else {
                this._updateTrigger.put(trigger.getName(), (ExternTriggerImpl)trigger);
            }
        }
    }

    @Override
    public Trigger getTrigger(String string) {
        return (Trigger)this._updateTrigger.get(string);
    }

    @Override
    public synchronized void deleteTrigger(String string) throws TriggerManageException {
        Trigger trigger = this.getTrigger(string);
        if (trigger != null) {
            int n = trigger.getReferenced();
            if (n != 0) {
                throw new TriggerManageException(670002, new Object[]{string, new Integer(n)}, null);
            }
            if (this.addTrigger(trigger)) {
                this._updateTrigger.remove(trigger.getName());
            }
        }
    }

    @Override
    public boolean contains(String string) {
        return this._updateTrigger.containsKey(string);
    }

    @Override
    public Iterator iterator() {
        ArrayList arrayList = new ArrayList(this._updateTrigger.values());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Trigger trigger, Trigger trigger2) {
                return trigger.getName().compareTo(trigger2.getName());
            }
        });
        return arrayList.iterator();
    }

    @Override
    public int size() {
        return this._updateTrigger.size();
    }

    @Override
    public void fire(String string, Properties properties) throws TriggerManageException {
        if (!this.contains(string)) {
            throw new TriggerManageException(670003, new Object[]{string}, null);
        }
        Trigger trigger = this.getTrigger(string);
        if (!trigger.isEnable()) {
            throw new TriggerManageException(670004, new Object[]{string}, null);
        }
        ((ExternTriggerImpl)trigger).setPrevFireTime(System.currentTimeMillis());
        this.contains(trigger, properties);
        this._updateTrigger(trigger);
        this._updateTrigger.put(trigger.getName(), (ExternTriggerImpl)trigger);
    }

    private boolean SEDU(Trigger trigger) {
        if (this.addTrigger != null) {
            return this.addTrigger.addTrigger(trigger);
        }
        return true;
    }

    private boolean addTrigger(Trigger trigger) {
        if (this.addTrigger != null) {
            return this.addTrigger.delTrigger(trigger);
        }
        return true;
    }

    public boolean _updateTrigger(Trigger trigger) {
        if (this.addTrigger != null) {
            return this.addTrigger.updateTrigger(trigger);
        }
        return true;
    }

    private void close() {
        try {
            for (Trigger trigger : this.addTrigger.loadTriggers()) {
                this._updateTrigger.put(trigger.getName(), (ExternTriggerImpl)trigger);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    private boolean contains(Trigger trigger, Object object) {
        ServiceLogger.logEvent(6670017, trigger.getName(), 6);
        Properties properties = new Properties();
        properties.setProperty("trigger.name", trigger.getName());
        if (object != null) {
            properties.put("trigger.data", object);
        }
        try {
            ServerEnv.getEventQueue().postEvent("TRIGGER_FIRE", 0, properties, 1);
            return true;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return false;
        }
    }
}

