/*
 * Decompiled with CFR 0.152.
 */
package jet.server.trigger;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.api.trigger.Trigger;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.log.ServiceLogger;
import jet.server.trigger.ExternTriggerImpl;

public final class TriggerTableImpl
extends TableImpl
implements Table {
    public static final int version = 1;
    private static String BIGINT = "TRIGGERS_1";
    private static TriggerTableImpl BIT = null;

    public static synchronized TriggerTableImpl getInstance() {
        return BIT;
    }

    public static synchronized TriggerTableImpl newInstance(Database database) {
        if (BIT == null) {
            try {
                BIT = new TriggerTableImpl(database);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return BIT;
    }

    private TriggerTableImpl(Database database) throws InstantiationException, SQLException {
        super(database, BIGINT);
        super.append(new FieldImpl(this.getName(), "trigger_name", JDBCType.VARCHAR, 80, 9, 0));
        super.append(new FieldImpl(this.getName(), "description", JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), "trigger_type", JDBCType.TINYINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), "trigger_state", JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), "prev_fire_time", JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), "next_fire_time", JDBCType.BIGINT, 0, 0, 0));
        if (!database.tables().contains(this.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    @Override
    public void close() {
        super.close();
        BIT = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadTriggers() {
        ArrayList<ExternTriggerImpl> arrayList = new ArrayList<ExternTriggerImpl>();
        Recordset recordset = null;
        try {
            recordset = super.query(super.fields().toArray(), null, ParameterMetaInfo.EMPTY, true);
            while (recordset.next()) {
                ExternTriggerImpl externTriggerImpl = null;
                String string = recordset.getString("trigger_name");
                String string2 = recordset.getString("description");
                int n = recordset.getInt("trigger_type");
                boolean bl = recordset.getBoolean("trigger_state");
                long l = recordset.getLong("prev_fire_time");
                long l2 = recordset.getLong("next_fire_time");
                switch (n) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        externTriggerImpl = new ExternTriggerImpl(string, string2);
                        externTriggerImpl.setEnable(bl);
                        externTriggerImpl.setPrevFireTime(l);
                        externTriggerImpl.setNextFireTime(l2);
                        arrayList.add(externTriggerImpl);
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable, 3);
            }
        }
        return arrayList;
    }

    public boolean addTrigger(Trigger trigger) {
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(trigger.getName());
        fieldValueArray[1].setValue(trigger.getDescription());
        fieldValueArray[2].setValue(new Integer(((ExternTriggerImpl)trigger).getType()));
        fieldValueArray[3].setValue(new Boolean(trigger.isEnable()));
        fieldValueArray[4].setValue(new Long(trigger.getPrevFireTime()));
        fieldValueArray[5].setValue(new Long(((ExternTriggerImpl)trigger).getNextFireTime()));
        try {
            super.insert(fieldValueArray);
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public boolean updateTrigger(Trigger trigger) {
        FieldValue[] fieldValueArray = new FieldValue[3];
        fieldValueArray[0] = super.fields("trigger_state").createFieldValue();
        fieldValueArray[0].setValue(new Boolean(trigger.isEnable()));
        fieldValueArray[1] = super.fields("prev_fire_time").createFieldValue();
        fieldValueArray[1].setValue(new Long(trigger.getPrevFireTime()));
        fieldValueArray[2] = super.fields("next_fire_time").createFieldValue();
        fieldValueArray[2].setValue(new Long(((ExternTriggerImpl)trigger).getNextFireTime()));
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add("trigger_name", trigger.getName(), 12);
        try {
            super.update(fieldValueArray, "WHERE trigger_name=?", parameterMetaInfo);
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public boolean delTrigger(Trigger trigger) {
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields("TRIGGER_NAME").getName(), trigger.getName(), 12);
        stringBuffer.append(" WHERE ").append(super.fields("TRIGGER_NAME").getName());
        stringBuffer.append("=?");
        try {
            super.delete(stringBuffer.toString(), parameterMetaInfo);
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }
}

