/*
 * Decompiled with CFR 0.152.
 */
package jet.server.ui;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;
import jet.server.util.ParamUtil;
import jet.server.util.ServerUtil;
import jet.server.util.nls.PropertyMessageResourcesFactory;
import jet.server.util.nls.PropertyMessageResourcesFactoryUtils;

public abstract class Combobox {
    protected String name;
    protected String prefix;
    protected String displayName;
    protected String value;
    protected String displayValue;
    protected String nlsValue;
    protected HashMap<String, String[]> hItems = null;
    protected String tipsValue = "";
    protected Locale locale;
    protected String pattern;
    protected String width;
    protected String cssClass;
    protected String displayCssClass;
    protected String cssStyle;
    protected String onchange = "";
    protected char mode;
    protected List<String[]> dropDownList = new LinkedList<String[]>();
    protected List<DropDownRow> savedDropDownList;
    private Map<String, String> I = new HashMap<String, String>();

    public Combobox(String string, String string2) {
        this.name = string;
        this.value = string2;
        this.savedDropDownList = new LinkedList<DropDownRow>();
    }

    protected void write(Writer writer, String string, Object ... objectArray) throws IOException {
        writer.write(String.format(string, objectArray));
    }

    public String getId() {
        return "box_" + Integer.toHexString(this.name.hashCode());
    }

    public void render(Writer writer) throws IOException {
    }

    public String getDisplayValue() {
        if (this.displayValue == null) {
            if (this.value == null || this.value.trim().length() == 0) {
                this.displayValue = "";
            } else {
                this.displayValue = this.getValue();
                for (String[] stringArray : this.dropDownList) {
                    if (!this.value.equals(stringArray[0])) continue;
                    this.displayValue = stringArray[1];
                    break;
                }
            }
        }
        return this.displayValue;
    }

    public String getDisplayValue(String string) {
        if ("\u0007".equals(string)) {
            PropertyMessageResourcesFactory propertyMessageResourcesFactory = PropertyMessageResourcesFactoryUtils.getServerResourceFactory(this.locale.toString());
            if (HttpUtil.isStandaloneServer()) {
                String string2 = HttpUtil.getHttpRptServer().getServerEnv().getHomePath() + "resources" + File.separator + "server" + File.separator + "languages" + File.separator;
                propertyMessageResourcesFactory.setLanguagePath(string2);
            }
            return propertyMessageResourcesFactory.getMessage("2221824");
        }
        String string3 = null;
        if (string == null || string.trim().length() == 0) {
            string3 = "";
        } else {
            string3 = this.getValue();
            boolean bl = false;
            try {
                bl = ParamUtil.parseExpression(string3);
                if (bl) {
                    string3 = ParamUtil.evalExpressionValue(string3, this.pattern, this.locale);
                }
            }
            catch (Throwable throwable) {
                bl = false;
            }
            if (!bl) {
                for (String[] stringArray : this.dropDownList) {
                    if (!string.equals(stringArray[0])) continue;
                    string3 = stringArray[1];
                    break;
                }
            }
        }
        return string3;
    }

    public String getNLSValue() {
        if (null == this.hItems) {
            ServiceLogger.logDebug("Combobox::getNLSValue: hItems is null.");
            return this.getDisplayValue(this.value);
        }
        Object[] objectArray = this.hItems.get(this.value);
        if (null == objectArray) {
            ServiceLogger.logDebug("Combobox::getNLSValue: value" + this.value + ", item=" + Arrays.toString(objectArray), 4);
            return this.getDisplayValue(this.value);
        }
        String string = objectArray[3];
        return null != string ? string : this.getDisplayValue(this.value);
    }

    public String getTipsValue() {
        if (this.tipsValue == null) {
            if (this.value == null || this.value.trim().length() == 0) {
                this.tipsValue = "";
            } else {
                this.tipsValue = this.getValue();
                for (String[] stringArray : this.dropDownList) {
                    if (!this.value.equals(stringArray[0])) continue;
                    this.tipsValue = stringArray[1];
                    break;
                }
            }
        }
        return this.tipsValue;
    }

    public String getTipsValue(String string) {
        if ("\u0007".equals(string)) {
            PropertyMessageResourcesFactory propertyMessageResourcesFactory = PropertyMessageResourcesFactoryUtils.getServerResourceFactory(this.locale.toString());
            if (HttpUtil.isStandaloneServer()) {
                String string2 = HttpUtil.getHttpRptServer().getServerEnv().getHomePath() + "resources" + File.separator + "server" + File.separator + "languages" + File.separator;
                propertyMessageResourcesFactory.setLanguagePath(string2);
            }
            return propertyMessageResourcesFactory.getMessage("2221824");
        }
        String string3 = null;
        if (string == null || string.trim().length() == 0) {
            string3 = "";
        } else {
            string3 = this.getValue();
            for (String[] stringArray : this.dropDownList) {
                if (!string.equals(stringArray[0])) continue;
                string3 = stringArray[1];
                break;
            }
        }
        return string3;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.name != null && this.prefix != null ? this.name.replace(this.prefix, "jrs.param.displayname$") : "jrs.param.displayname$" + (this.name == null ? new Date().toString() : this.name);
        }
        return this.displayName;
    }

    public boolean hasDropDownList() {
        return this.dropDownList != null && this.dropDownList.size() > 0 || this.savedDropDownList != null && this.savedDropDownList.size() > 0;
    }

    public void addDropDownItem(String string, String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = stringArray[i];
        }
        this.dropDownList.add(stringArray2);
    }

    public void setAttribute(String string, String string2) {
        this.I.put(string, string2);
    }

    public String getName() {
        return this.name;
    }

    public List<String[]> getDropDownList() {
        return this.dropDownList;
    }

    public List<String[]> encodeDropDownList() {
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        for (String[] stringArray : this.dropDownList) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = i == 0 ? ServerUtil.encodeUrl(stringArray[i]) : ServerUtil.escapeHTMLWithBlank(stringArray[i]);
            }
            linkedList.add(stringArray2);
        }
        return linkedList;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDropDownList(List<String[]> list) {
        this.dropDownList = list;
    }

    public String encodeValue() {
        return this.value == null ? "" : ServerUtil.encodeUrl(this.value);
    }

    public String encodeDisplayValue() {
        String string = this.getDisplayValue();
        return string == null ? "" : string;
    }

    public String encodeNLSValue() {
        String string = this.getNLSValue();
        return string == null || string.isEmpty() ? this.encodeDisplayValue() : string;
    }

    public void setValueListItems(HashMap<String, String[]> hashMap) {
        this.hItems = hashMap;
    }

    public String encodeTipsValue() {
        String string = this.getTipsValue();
        return string == null ? "" : string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public char getMode() {
        return this.mode;
    }

    public void setMode(char c) {
        this.mode = c;
    }

    public String getWidth() {
        return this.width == null ? "" : this.width;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public String getCssStyle() {
        return this.cssStyle;
    }

    public void setWidth(String string) {
        this.width = string;
    }

    public void addCssClass(String string) {
        this.cssClass = this.cssClass + " " + string;
    }

    public void setCssStyle(String string) {
        this.cssStyle = string;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setDisplayValue(String string) {
        this.displayValue = string;
    }

    public void setNLSValue(String string) {
        this.nlsValue = string;
    }

    public String getOnchange() {
        return this.onchange;
    }

    public void setOnchange(String string) {
        this.onchange = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getDisplayCssClass() {
        if (this.displayCssClass == null) {
            return "";
        }
        return this.displayCssClass.trim();
    }

    public void setDisplayCssClass(String string) {
        this.displayCssClass = string;
    }

    public void setSavedDropDownList(List<DropDownRow> list) {
        this.savedDropDownList = list;
    }

    public List<DropDownRow> getSavedDropDownList() {
        return this.savedDropDownList;
    }

    public int getDropDownColSize() {
        return Math.max(this.I(), this.SEDU());
    }

    private int I() {
        int n = 0;
        if (this.dropDownList != null) {
            for (String[] stringArray : this.dropDownList) {
                n = Math.max(n, stringArray.length - 1);
            }
        }
        return n;
    }

    private int SEDU() {
        int n = 0;
        if (this.savedDropDownList != null) {
            for (DropDownRow dropDownRow : this.savedDropDownList) {
                n = Math.max(n, dropDownRow.cellsSize + 1);
            }
        }
        return n;
    }

    public static final class DropDownCell {
        public String name;
        public String value;
        public String label;
        public String nlsLabel;

        public DropDownCell(String string, String string2, String string3, String string4) {
            this.name = string;
            this.value = ServerUtil.encodeUrl(string2);
            this.label = string3;
            this.nlsLabel = string4;
        }
    }

    public static final class DropDownRow {
        public String name;
        public List<DropDownCell> cells;
        public int cellsSize = 0;

        public DropDownRow(String string, List<DropDownCell> list) {
            this.name = string;
            this.cells = list;
            if (list != null) {
                this.cellsSize = list.size();
            }
        }
    }
}

