/*
 * Decompiled with CFR 0.152.
 */
package jet.server.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.cs.util.APIUtil;
import jet.server.api.DashboardListenerManager;
import jet.server.api.RemoteFileService;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.jrserver.JRDashboardListenerInfo;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.util.Json;
import jet.server.util.WebSecurityUtil;

public class DashboardListenerDelegate {
    protected ServletContext application;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    private String DYNAMICCLASSES = "";

    public DashboardListenerDelegate(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws NoPrivilegeException {
        this.application = servletContext;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
    }

    public String newHashboardListener() {
        try {
            boolean bl = false;
            Properties properties = HttpUtil.getParameters(this.request);
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = this.request.getParameterValues("selectedTargets");
            if (stringArray != null) {
                for (String string : stringArray) {
                    arrayList.add(string);
                }
            }
            String string = properties.getProperty("className");
            String string2 = properties.getProperty("description");
            int n = APIUtil.getBoolean(properties.getProperty("enabled"), false) ? 1 : 0;
            JRDashboardListenerInfo jRDashboardListenerInfo = new JRDashboardListenerInfo(string, arrayList, string2, n != 0, new Date().getTime());
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(this.request);
            DashboardListenerManager dashboardListenerManager = httpRptServer.getDashboardListenerManager();
            bl = dashboardListenerManager.addDashboardListener(jRDashboardListenerInfo);
            return this.DYNAMICCLASSES(bl, this.DYNAMICCLASSES);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            String string = throwable.getMessage();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{\"success\":false");
            stringBuffer.append(",\"customMsg\" :" + Json.toJson(string));
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    public String updateHashboardListener() {
        try {
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = this.request.getParameterValues("selectedTargets");
            if (stringArray != null) {
                for (String string : stringArray) {
                    arrayList.add(string);
                }
            }
            String string = this.request.getParameter("className");
            String string2 = this.request.getParameter("description");
            int n = APIUtil.getBoolean(this.request.getParameter("enabled"), false) ? 1 : 0;
            JRDashboardListenerInfo jRDashboardListenerInfo = new JRDashboardListenerInfo(string, arrayList, string2, n != 0, new Date().getTime());
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(this.request);
            DashboardListenerManager dashboardListenerManager = httpRptServer.getDashboardListenerManager();
            bl = dashboardListenerManager.updateDashboardListener(jRDashboardListenerInfo);
            return this.DYNAMICCLASSES(bl, this.DYNAMICCLASSES);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            String string = throwable.getMessage();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{\"success\":false");
            stringBuffer.append(",\"customMsg\" :" + Json.toJson(string));
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    public String deleteHashboardListeners() {
        try {
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = this.request.getParameterValues("className");
            for (String string : stringArray) {
                arrayList.add(string);
            }
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(this.request);
            DashboardListenerManager dashboardListenerManager = httpRptServer.getDashboardListenerManager();
            bl = dashboardListenerManager.deleteDashboardListeners(arrayList);
            return this.DYNAMICCLASSES(bl, this.DYNAMICCLASSES);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            String string = throwable.getMessage();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{\"success\":false");
            stringBuffer.append(",\"customMsg\" :" + Json.toJson(string));
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    public String updateHashboardListenersEnable() {
        try {
            String[] stringArray;
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : stringArray = this.request.getParameterValues("className")) {
                arrayList.add(string);
            }
            boolean bl2 = APIUtil.getBoolean(this.request.getParameter("isEnabled"), false);
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(this.request);
            DashboardListenerManager dashboardListenerManager = httpRptServer.getDashboardListenerManager();
            bl = dashboardListenerManager.setMultiEnabled(arrayList, bl2);
            return this.DYNAMICCLASSES(bl, this.DYNAMICCLASSES);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            String string = throwable.getMessage();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{\"success\":false");
            stringBuffer.append(",\"customMsg\" :" + Json.toJson(string));
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    public String copyToDynamicClassDir() {
        boolean bl = false;
        try {
            String string = HttpUtil.isRemoteServer() ? HttpUtil.getRemoteFileService(this.request).getRemoteFileSeparator() : File.separator;
            String string2 = HttpUtil.getHttpRptServer().getServerEnv().getHomePath();
            if (!string2.endsWith(string)) {
                string2 = string2 + string;
            }
            string2 = string2 + "dynamicclasses" + string;
            String string3 = HttpUtil.decodeEsc(this.request.getParameter("filePath"));
            String string4 = this.request.getParameter("className");
            String string5 = string4 + ".jar";
            ServiceLogger.trace("DashboardListenerDelegate: copyToDynamicClassDir: [tempFile=%s, dynamicClassDir=%s]", string3, string2);
            if (HttpUtil.isRemoteServer()) {
                RemoteFileService remoteFileService = HttpUtil.getRemoteFileService(this.request);
                if (remoteFileService.exists(string3) && string4 != null) {
                    remoteFileService.copy(string3, string2 + string5);
                    if (remoteFileService.exists(string2 + string5)) {
                        StorageEnv.getStorage().add(Storage.StorageRoot.DYNAMICCLASSES.getRootPath() + "/" + string5, WebSecurityUtil.validateFilePath(string2 + string5));
                    }
                    bl = true;
                }
            } else {
                File file = WebSecurityUtil.validateFilePath(string3);
                File file2 = WebSecurityUtil.validateFilePath(string2, string5);
                if (file.exists() && string4 != null) {
                    SchdTools.copyFile(file, file2);
                    if (file2.exists()) {
                        StorageEnv.getStorage().add(Storage.StorageRoot.DYNAMICCLASSES.getRootPath() + "/" + string5, file2);
                    }
                    bl = true;
                }
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            ServiceLogger.trace("DashboardListenerDelegate: copyToDynamicClassDir: failed! %s", throwable);
            String string = throwable.getMessage();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{\"success\":false");
            stringBuffer.append(",\"customMsg\" :" + Json.toJson(string));
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        return this.DYNAMICCLASSES(bl, this.DYNAMICCLASSES);
    }

    private String DYNAMICCLASSES(boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\"success\":").append(bl);
        stringBuffer.append(",\"customMsg\" :" + Json.toJson(string));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

