/*
 * Decompiled with CFR 0.152.
 */
package jet.server.ui;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import jet.cs.util.APIUtil;
import jet.server.api.ParamInfo;
import jet.server.api.PathInfo;
import jet.server.api.ReportInfo;
import jet.server.api.RptServerException;
import jet.server.api.UserPreferenceManager;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;
import jet.server.ui.ParamsController;
import jet.server.util.ParamUtil;
import jet.server.util.ServerUtil;
import jet.server.util.nls.NlsClientResource;
import jet.server.util.nls.PropertyMessageResourcesFactory;

public class DirectRunController {
    private HttpRptServer SEDU;
    private String append;
    private Properties clone;
    private Map containsKey;
    private NlsClientResource currentTimeMillis = null;
    private PropertyMessageResourcesFactory encodeEsc = null;
    private Properties equals = null;
    long currentTime = System.currentTimeMillis();
    private ParamsController escapeHTML;
    private String escapeHtmlSpecialChars;
    private String get;
    private String getAvailableLanguages;
    private String getBoolean;
    private String getCountry = "";
    private String getDefaultUserPreference;
    private int getHiddenFields;
    private String getHttpRptServer;
    private String getLanguage = null;
    private String getLatestVersionNumber;
    private Properties getLocale = new Properties();
    private ReportInfo getMessage = null;
    private Locale getName;
    private boolean getOriginalThrowable;

    public DirectRunController(HttpServletRequest httpServletRequest) throws Exception {
        try {
            this.clone(httpServletRequest);
            this.containsKey();
            this.encodeEsc();
            this.currentTimeMillis();
            this.currentTime();
            this.append();
            this.SEDU();
            int n = APIUtil.parseInt(this.getDefaultUserPreference) == 8 ? 1 : 0;
            this.escapeHTML = ParamsController.make(this.SEDU, this.getMessage, n, this.getName, this.append, this.clone, this.currentTime, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private void SEDU() {
        this.put("currentCalendar", "");
        this.put("is_direct_run", "true");
        this.put("flag", "dropdown");
        this.getOriginalThrowable = APIUtil.getBoolean((String)this.get("useSection508"));
        if (this.getOriginalThrowable) {
            this.put("jrs.use_section508_output", "true");
            this.put("jrs.use_html_table", "true");
            this.put("jrs.relative_font_size", "true");
            this.put("jrs.is_applet_chart", "false");
            this.put("jrs.format_chart", "0");
        }
    }

    private void append() throws RptServerException {
        String string = (String)this.get("jrs.rpt_country");
        String string2 = (String)this.get("jrs.rpt_language");
        String string3 = (String)this.get("jrs.rpt_variant");
        this.getName = string != null && string3 != null ? new Locale(string2, string, string3) : (string2 != null ? (string != null ? new Locale(string2, string) : ServerUtil.getLocale(string2)) : this.currentTimeMillis.getLocale());
        this.put("jrs.rpt_country", this.getName.getCountry());
        this.put("jrs.rpt_language", this.getName.getLanguage());
        this.put("jrs.rpt_variant", this.getName.getVariant());
    }

    private void clone(HttpServletRequest httpServletRequest) throws NoSuchUserException {
        this.append = HttpUtil.getUser(httpServletRequest);
        this.SEDU = HttpUtil.getHttpRptServer(httpServletRequest);
        if (this.SEDU == null) {
            System.getProperties().put("jreport.context", httpServletRequest.getSession().getServletContext());
            HttpUtil.initEnv(System.getProperties());
            this.SEDU = HttpUtil.getHttpRptServer(httpServletRequest);
        }
        this.currentTimeMillis = new NlsClientResource(httpServletRequest);
        this.encodeEsc = this.currentTimeMillis.getServerResourceFactory();
        this.equals = this.SEDU.getUserPreferenceManager().getUserPreference(this.append);
        this.clone = HttpUtil.getParameters(httpServletRequest);
        this.containsKey = ParamUtil.getSessionParameters(httpServletRequest.getSession(), this.clone);
        ParamUtil.replaceWithSessionParameter(httpServletRequest.getSession(), this.clone);
        try {
            this.currentTime = Long.parseLong((String)this.get("currTime"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getLatestVersionNumber = (String)this.get("jrs.engine_id");
    }

    private void containsKey() throws RptServerException {
        this.escapeHtmlSpecialChars = (String)this.get("jrs.catalog");
        this.getAvailableLanguages = (String)this.get("jrs.cat_version");
        if (DirectRunController.isEmpty(this.getAvailableLanguages) && !DirectRunController.isEmpty(this.escapeHtmlSpecialChars)) {
            this.getAvailableLanguages = this.SEDU.getResourceManager().getPathInfo(this.append, this.escapeHtmlSpecialChars).getLatestVersionNumber() + "";
            this.put("jrs.cat_version", this.getAvailableLanguages);
        }
        this.get = (String)this.get("jrs.report");
        this.getBoolean = (String)this.get("jrs.rpt_version");
        if (DirectRunController.isEmpty(this.getBoolean) && !DirectRunController.isEmpty(this.get)) {
            this.getBoolean = this.SEDU.getResourceManager().getPathInfo(this.append, this.get).getLatestVersionNumber() + "";
            this.put("jrs.rpt_version", this.getBoolean);
        }
        if (this.get != null) {
            this.getCountry = this.get.substring(0, this.get.lastIndexOf("/"));
        } else if (this.escapeHtmlSpecialChars != null) {
            this.getCountry = this.escapeHtmlSpecialChars.substring(0, this.escapeHtmlSpecialChars.lastIndexOf("/"));
        }
    }

    private void currentTime() throws RptServerException {
        this.getDefaultUserPreference = (String)this.get("jrs.result_type");
        if (DirectRunController.isEmpty(this.getDefaultUserPreference)) {
            this.getDefaultUserPreference = this.equals.getProperty("default_view_format");
        }
        if (DirectRunController.isEmpty(this.getDefaultUserPreference)) {
            this.getDefaultUserPreference = String.valueOf(1);
        }
        this.put("jrs.result_type", this.getDefaultUserPreference);
        this.put("jrs.cmd", "jrs.web_vw");
        this.getHiddenFields = APIUtil.parseInt((String)this.get("jrs.page_style"), 1);
        this.getHttpRptServer = (String)this.get("rptsheet");
        if (DirectRunController.isEmpty(this.getHttpRptServer)) {
            this.getHttpRptServer = (String)this.get("dhtmlrptsheet");
            if (!DirectRunController.isEmpty(this.getHttpRptServer)) {
                this.put("rptsheet", this.getHttpRptServer);
            }
        }
        Enumeration<Object> enumeration = this.clone.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("jrs.report_sheet")) continue;
            this.getLanguage = string;
        }
        if (!DirectRunController.isEmpty(this.getLanguage)) {
            this.put(this.getLanguage, "true");
        }
    }

    private void currentTimeMillis() throws RptServerException {
        this.getMessage = this.SEDU.getReportInfo(this.append, this.escapeHtmlSpecialChars, APIUtil.parseInt(this.getAvailableLanguages), this.get, APIUtil.parseInt(this.getBoolean), this.clone);
        if (!this.getMessage.getParamEngineId().equals(this.getLatestVersionNumber)) {
            if (this.getLatestVersionNumber != null) {
                this.getMessage.removeParamEngineById(this.getLatestVersionNumber);
            }
            this.getLatestVersionNumber = this.getMessage.getParamEngineId();
            this.put("jrs.engine_id", this.getLatestVersionNumber);
        }
        try {
            this.getMessage.getAvailableLanguages();
        }
        catch (RptServerException rptServerException) {
            if (rptServerException instanceof RptServerException && !(rptServerException.getOriginalThrowable() instanceof UnknownResource)) {
                throw rptServerException;
            }
            throw new RptServerException(this.escapeHTML("2150311", new Object[]{this.escapeHtmlSpecialChars, this.getAvailableLanguages, this.get, this.getBoolean}));
        }
    }

    private void encodeEsc() {
        String string = (String)this.get("jrs.jdbc_url");
        String string2 = (String)this.get("jrs.db_user");
        String string3 = (String)this.get("jrs.db_pswd");
        String string4 = (String)this.get("jrs.jdbc_driver");
        if (string != null) {
            this.getLocale.put("jrs.jdbc_url", string);
        }
        if (string2 != null) {
            this.getLocale.put("jrs.db_user", string2);
        }
        if (string3 != null) {
            this.getLocale.put("jrs.db_pswd", string3);
        }
        if (string4 != null) {
            this.getLocale.put("jrs.jdbc_driver", string4);
        }
        if (this.getLatestVersionNumber != null) {
            this.getLocale.put("jrs.engine_id", this.getLatestVersionNumber);
        }
        Locale locale = this.currentTimeMillis.getLocale();
        this.getLocale.put("jrs.client_locale", locale);
        if (!this.getLocale.containsKey("jrs.rpt_language")) {
            this.getLocale.put("jrs.rpt_language", locale.getLanguage());
            this.getLocale.put("jrs.rpt_country", locale.getCountry());
            this.getLocale.put("jrs.rpt_variant", locale.getVariant());
        }
    }

    public <T> T get(String string) {
        return (T)this.clone.get(string);
    }

    public void put(String string, Object object) {
        this.clone.put(string, object);
    }

    static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public String getProfileName() {
        return this.equals(this.get);
    }

    private String equals(String string) {
        String string2 = null;
        try {
            if (!DirectRunController.isEmpty(string)) {
                PathInfo pathInfo = this.SEDU.getResourceManager().getPathInfo(this.append, string);
                if (pathInfo != null) {
                    string2 = pathInfo.getProfileName();
                    if (!DirectRunController.isEmpty(string) && DirectRunController.isEmpty(string2)) {
                        string2 = this.equals(pathInfo.getParentPath());
                    }
                }
            } else {
                UserPreferenceManager userPreferenceManager = this.SEDU.getUserDHTMLPreferenceManager();
                Properties properties = userPreferenceManager.getUserPreference(this.append);
                string2 = properties.getProperty("dhtml.currentprofile");
                if (string2 == null || string2.trim().length() == 0) {
                    properties = userPreferenceManager.getDefaultUserPreference();
                    string2 = properties.getProperty("dhtml.currentprofile");
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return string2;
    }

    public Map<String, String> getHiddenFields() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (String string : this.clone.keySet()) {
            if (this.containsKey != null && this.containsKey.containsKey(string) || string.startsWith("jrs.param.exp$") || string.startsWith("_isMultiple_") || string.startsWith("jrs.param.isAll$") || string.equals("useSavedParameter") || string.equals("savedParameterList") || string.equals("change_value")) continue;
            if (string.startsWith("jrs.param$")) {
                if (!this.escapeHTML.isLockedParam(string)) continue;
                hashtable.put("locked_" + string, "true");
                continue;
            }
            Object t = this.get(string);
            if (!(t instanceof String)) continue;
            hashtable.put(string, (String)t);
        }
        hashtable.put("paramPageDisabled", "true");
        return hashtable;
    }

    private String escapeHTML(String string, Object[] objectArray) {
        return this.encodeEsc.getMessage(string, objectArray);
    }

    public String getRunReportPath() {
        StringBuffer stringBuffer = new StringBuffer();
        for (ParamInfo paramInfo : this.escapeHTML.getParamInfos()) {
            Vector vector = paramInfo.getValueOptions();
            if (!this.escapeHTML.isHiddenParam(paramInfo)) continue;
            stringBuffer.append("jrs.param$" + ServerUtil.escapeHTML(paramInfo.getName())).append("=").append(APIUtil.escapeHtmlSpecialChars((String)vector.get(0))).append("&");
        }
        return "runReport.jsp?" + HttpUtil.makeQuery(this.clone) + stringBuffer.toString();
    }

    public String getCancelPath() {
        if (APIUtil.getBoolean(this.equals.getProperty("popup_dhtml_window"), false) && this.getDefaultUserPreference.equals(String.valueOf(8))) {
            return "";
        }
        return "getCatRptsNew.jsp?jrs.cmd=jrs.get_cat_rpts_new&jrs.page_style=" + this.getHiddenFields + "&" + "jrs.path" + "=" + HttpUtil.encodeEsc(this.getCountry);
    }

    public String getResetPath() {
        Hashtable hashtable = (Hashtable)((Hashtable)this.getHiddenFields()).clone();
        hashtable.remove("jrs.engine_id");
        return "getRptParam.jsp?" + HttpUtil.makeQuery(hashtable);
    }

    public int getShownParamSize() {
        return this.escapeHTML.getShownParamSize();
    }

    public ParamsController getParamsController() {
        return this.escapeHTML;
    }
}

