/*
 * Decompiled with CFR 0.152.
 */
package jet.server.ui;

import java.io.File;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jet.exception.ParseFormulaFailedException;
import jet.parameter.UserInput;
import jet.server.api.ParamInfo;
import jet.server.api.http.HttpUtil;
import jet.server.api.paramlist.ParamValue;
import jet.server.api.paramlist.ReportParamList;
import jet.server.log.ServiceLogger;
import jet.server.ui.Checkbox;
import jet.server.ui.Combobox;
import jet.server.ui.DateCombobox;
import jet.server.ui.DateExprCombobox;
import jet.server.ui.MultiCombobox;
import jet.server.ui.MultiDateCombobox;
import jet.server.ui.ParamModel;
import jet.server.ui.ParamsController;
import jet.server.ui.SimpleCombobox;
import jet.server.util.ParamUtil;
import jet.server.util.ServerUtil;
import jet.server.util.StringUtil;
import jet.server.util.nls.PropertyMessageResourcesFactory;
import jet.server.util.nls.PropertyMessageResourcesFactoryUtils;

public class ParamController
extends ParamModel {
    private ParamsController J;
    private ParamInfo SEDU;
    private Combobox add;

    public ParamController(ParamsController paramsController, ParamInfo paramInfo) {
        this.J = paramsController;
        this.SEDU = paramInfo;
        this.J();
    }

    private void J() {
        this.add = this.isMultiple() ? (this.getAutoSavedParamLists() || this.isDateTime() || this.isTime() ? this.currentTime() : this.crdParamNames()) : (this.getAutoSavedParamLists() || this.isDateTime() || this.isTime() ? this.elementAt() : (this.isBoolean() ? this.endsWith() : this.equals()));
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        Vector<String[]> vector = this.SEDU.getValueList();
        for (String[] stringArray : vector) {
            String string = stringArray[0];
            hashMap.put(string, stringArray);
        }
        this.add.setValueListItems(hashMap);
        if (this.J.getIsDisableParamInput()) {
            this.add.setMode('D');
        }
    }

    private String SEDU() {
        String string = this.SEDU.getUserFormat();
        if (ParamsController.isEmpty(string) && (this.getAutoSavedParamLists() || this.isDateTime() || this.isTime())) {
            return this.SEDU.getDefaultDateFormat();
        }
        return string;
    }

    private Locale add() {
        return this.J.reportLocale;
    }

    private List<Combobox.DropDownRow> addDropDownItem() {
        LinkedList<Combobox.DropDownRow> linkedList = new LinkedList<Combobox.DropDownRow>();
        List<ReportParamList> list = this.J.getAutoSavedParamLists();
        if (list != null) {
            String[] stringArray = this.J.getParamNames();
            for (ReportParamList reportParamList : list) {
                LinkedList<Combobox.DropDownCell> linkedList2 = new LinkedList<Combobox.DropDownCell>();
                HashMap hashMap = new HashMap();
                List<ParamValue> list2 = reportParamList.sort(this.SEDU.getName(), stringArray);
                if (list2 != null) {
                    Object object;
                    Object[] objectArray;
                    Object object2;
                    Cloneable cloneable;
                    Serializable serializable;
                    Object object3;
                    String string;
                    for (ParamValue paramValue : list2) {
                        if (paramValue == null) continue;
                        string = paramValue.getName();
                        object3 = this.J.getParamInfo(string);
                        if (!hashMap.containsKey(string)) {
                            hashMap.put(string, new HashMap());
                        }
                        serializable = (HashMap)hashMap.get(string);
                        cloneable = object3.getValueList();
                        object2 = ((Vector)cloneable).iterator();
                        while (object2.hasNext()) {
                            objectArray = (String[])object2.next();
                            object = objectArray[0];
                            if (((HashMap)serializable).containsKey(object)) {
                                ServiceLogger.logDebug("ParamController::makeDropDownRows: value=" + (String)object + ", item" + Arrays.toString(objectArray), 4);
                            }
                            ((HashMap)serializable).put(object, objectArray);
                        }
                    }
                    for (ParamValue paramValue : list2) {
                        if (paramValue == null) continue;
                        string = paramValue.getName();
                        object3 = new StringBuffer();
                        serializable = new StringBuffer();
                        cloneable = (HashMap)hashMap.get(string);
                        object2 = new StringBuffer();
                        objectArray = paramValue.getValue();
                        object = paramValue.getDisplayValue();
                        if (objectArray != null) {
                            int n = objectArray.length;
                            for (int i = 0; i < n; ++i) {
                                Object object4;
                                String string2 = objectArray[i];
                                String string3 = null;
                                Object[] objectArray2 = (String[])((HashMap)cloneable).get(string2);
                                if (null == objectArray2) {
                                    ServiceLogger.logDebug("ParamController::makeDropDownRows: valueStr=" + string2 + ", item" + Arrays.toString(objectArray2), 4);
                                    if (object != null && ((String[])object).length > i) {
                                        string3 = object[i];
                                    }
                                    if (string3 == null || string3.trim().length() == 0) {
                                        string3 = this.contains(this.J.getParamInfo(string), string2);
                                    }
                                    if (n > 1) {
                                        if (i > 0) {
                                            ((StringBuffer)serializable).append(",");
                                        }
                                        ((StringBuffer)serializable).append(string3);
                                    } else {
                                        ((StringBuffer)serializable).append(string3);
                                    }
                                    if (n > 1 && i > 0) {
                                        ((StringBuffer)object2).append(",");
                                    }
                                    ((StringBuffer)object2).append(string3);
                                    continue;
                                }
                                String string4 = objectArray2[1];
                                if (null == string4 || string4.isEmpty()) {
                                    string4 = string2;
                                }
                                if (null == (object4 = objectArray2[3]) || ((String)object4).isEmpty()) {
                                    object4 = string4;
                                }
                                if (n > 1 && i > 0) {
                                    ((StringBuffer)serializable).append(",");
                                }
                                ((StringBuffer)serializable).append(string4);
                                if (n > 1 && i > 0) {
                                    ((StringBuffer)object2).append(",");
                                }
                                ((StringBuffer)object2).append((String)object4);
                            }
                        }
                        linkedList2.add(new Combobox.DropDownCell(string, ((StringBuffer)object3).toString(), ((StringBuffer)serializable).toString(), ((StringBuffer)object2).toString()));
                    }
                }
                Iterator<ParamValue> iterator = new Combobox.DropDownRow(reportParamList.getName(), linkedList2);
                linkedList.add((Combobox.DropDownRow)((Object)iterator));
            }
        }
        return linkedList;
    }

    private void append(Combobox combobox) {
        Object object;
        Object object2;
        combobox.setPrefix(this.J.getParamPrefix());
        if (this.J.isHiddenParam(this.SEDU) || this.J.isLockedParam(this.SEDU) || this.J.isGetValueFromAPI(this.SEDU)) {
            combobox.setMode('H');
        } else if (this.get()) {
            combobox.setMode('R');
        } else if (this.SEDU.isAllowTypeIn()) {
            combobox.setMode('E');
        } else {
            combobox.setMode('C');
        }
        combobox.setPattern(this.SEDU());
        combobox.setLocale(this.add());
        if (this.SEDU.isParameters() || this.SEDU.isReferedBy()) {
            object2 = this.SEDU.getName();
            object = this.J.getOnChangeAction();
            if (object != null) {
                combobox.setOnchange((String)object + "?change_value=" + (String)object2);
            }
        }
        object2 = this.SEDU.getValueOptions();
        object = this.SEDU.getDisplayValues();
        Vector<String[]> vector = this.SEDU.getValueList();
        int n = ((Vector)object2).size();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = string = (String)((Vector)object2).elementAt(i);
            String string3 = string;
            if (!((Vector)object).isEmpty() && ((Vector)object).size() > i) {
                string2 = (String)((Vector)object).elementAt(i);
            }
            if (this.SEDU.needNLSDisplayValue()) {
                string2 = this.J.doMetadataNLS(string2);
            }
            if (!vector.isEmpty() && vector.size() > i) {
                String[] stringArray = vector.elementAt(i);
                string3 = stringArray[3];
                string3 = null == string3 ? string2 : string3;
            }
            combobox.addDropDownItem(string, string2, string3);
        }
        if (this.J.isAutoSaveParameter()) {
            combobox.setSavedDropDownList(this.addDropDownItem());
        }
    }

    private String contains(ParamInfo paramInfo, String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        if (paramInfo.isMultiple() && paramInfo.isAllowAll() && "\u0007".equals(string)) {
            PropertyMessageResourcesFactory propertyMessageResourcesFactory = PropertyMessageResourcesFactoryUtils.getServerResourceFactory(paramInfo.getLocale().toString());
            if (HttpUtil.isStandaloneServer()) {
                String string2 = HttpUtil.getHttpRptServer().getServerEnv().getHomePath() + "resources" + File.separator + "server" + File.separator + "languages" + File.separator;
                propertyMessageResourcesFactory.setLanguagePath(string2);
            }
            return propertyMessageResourcesFactory.getMessage("2221824");
        }
        Vector vector = paramInfo.getValueOptions();
        Vector vector2 = paramInfo.getDisplayValues();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string3;
            String string4 = string3 = (String)vector.elementAt(i);
            if (!vector2.isEmpty() && vector2.size() > i) {
                string4 = (String)vector2.elementAt(i);
            }
            if (!string3.equals(string)) continue;
            return paramInfo.needNLSDisplayValue() ? this.J.doMetadataNLS(string4) : string4;
        }
        try {
            UserInput userInput = ParamUtil.makeUserInput(string)[0];
            if (userInput.isExpression()) {
                return paramInfo.needNLSDisplayValue() ? this.J.doMetadataNLS(userInput.getUserInput()) : userInput.getUserInput();
            }
            return paramInfo.needNLSDisplayValue() ? this.J.doMetadataNLS(string) : string;
        }
        catch (Throwable throwable) {
            return paramInfo.needNLSDisplayValue() ? this.J.doMetadataNLS(string) : string;
        }
    }

    private void containsKey(MultiCombobox multiCombobox) {
        this.append(multiCombobox);
        multiCombobox.setAllowAll(this.SEDU.isAllowAll());
    }

    private MultiCombobox crdParamNames() {
        String string = this.getName();
        List<String> list = this.getValues();
        MultiCombobox multiCombobox = new MultiCombobox(string, list);
        this.containsKey(multiCombobox);
        return multiCombobox;
    }

    private MultiCombobox currentTime() {
        String string = this.getName();
        List<String> list = this.getValues();
        MultiDateCombobox multiDateCombobox = new MultiDateCombobox(string, list);
        this.containsKey(multiDateCombobox);
        if (this.isDateTime()) {
            multiDateCombobox.setDateTime(true);
        }
        if (this.isTime()) {
            multiDateCombobox.setTime(true);
        }
        return multiDateCombobox;
    }

    private DateCombobox doMetadataNLS() {
        String string = this.getName();
        String string2 = this.getValue();
        DateCombobox dateCombobox = new DateCombobox(string, string2);
        this.append(dateCombobox);
        if (this.isDateTime()) {
            dateCombobox.setDateTime(true);
        }
        if (this.isTime()) {
            dateCombobox.setTime(true);
        }
        return dateCombobox;
    }

    private DateExprCombobox elementAt() {
        String string = this.getName();
        String string2 = this.getValue();
        DateExprCombobox dateExprCombobox = new DateExprCombobox(string, string2);
        this.append(dateExprCombobox);
        if (this.isDateTime()) {
            dateExprCombobox.setDateTime(true);
        }
        if (this.isTime()) {
            dateExprCombobox.setTime(true);
        }
        return dateExprCombobox;
    }

    private Checkbox endsWith() {
        String string = this.getName();
        String string2 = this.getValue();
        Checkbox checkbox = new Checkbox(string, string2);
        this.append(checkbox);
        checkbox.setDisplayValue(this.getPromptText());
        return checkbox;
    }

    private SimpleCombobox equals() {
        String string = this.getName();
        String string2 = this.getValue();
        SimpleCombobox simpleCombobox = new SimpleCombobox(string, string2);
        this.append(simpleCombobox);
        return simpleCombobox;
    }

    public String getName() {
        return this.J.getParamPrefix() + this.SEDU.getName();
    }

    private String equalsIgnoreCase(String string, String string2, Locale locale, String string3, Locale locale2) {
        if (string.endsWith("\u0007") && this.isMultiple()) {
            return string;
        }
        String string4 = string.trim();
        boolean bl = false;
        try {
            bl = ParamUtil.parseExpression(string);
        }
        catch (ParseFormulaFailedException parseFormulaFailedException) {
            bl = false;
        }
        if (!bl) {
            try {
                if (this.getAutoSavedParamLists() || this.isDateTime() || this.isTime()) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, locale);
                    DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                    dateFormatSymbols.setZoneStrings(new String[0][0]);
                    if (!locale.getCountry().equals("JP") && !locale.getVariant().equals("JP")) {
                        simpleDateFormat.setDateFormatSymbols(dateFormatSymbols);
                    }
                    simpleDateFormat.setTimeZone(TimeZone.getDefault());
                    Date date = simpleDateFormat.parse(string);
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string3, locale2);
                    DateFormatSymbols dateFormatSymbols2 = simpleDateFormat2.getDateFormatSymbols();
                    dateFormatSymbols2.setZoneStrings(new String[0][0]);
                    if (!locale2.getCountry().equals("JP") && !locale2.getVariant().equals("JP")) {
                        simpleDateFormat2.setDateFormatSymbols(dateFormatSymbols2);
                    }
                    simpleDateFormat2.setTimeZone(TimeZone.getDefault());
                    string4 = simpleDateFormat2.format(date);
                } else if (this.getCountry()) {
                    Number number = string2 != null && string2.trim().length() > 0 ? (Number)new DecimalFormat(string2, new DecimalFormatSymbols(locale)).parse(string) : (Number)NumberFormat.getInstance(locale).parse(string);
                    string4 = string3 != null && string3.trim().length() > 0 ? new DecimalFormat(string3, new DecimalFormatSymbols(locale2)).format(number) : NumberFormat.getInstance(locale2).format(number);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object format(Object object) {
        if (object != null && this.J.oldLocale != null && this.J.oldLocale.trim().length() > 0 && (this.getAutoSavedParamLists() || this.isDateTime() || this.isTime() || this.getCountry())) {
            Locale locale = null;
            try {
                locale = this.SEDU.getLocale();
                String string = this.SEDU.getUserFormat();
                if (ParamsController.isEmpty(string) && (this.getAutoSavedParamLists() || this.isDateTime() || this.isTime())) {
                    string = this.SEDU.getDefaultDateFormat();
                }
                Locale locale2 = ServerUtil.getLocale(this.J.oldLocale);
                this.SEDU.setLocale(locale2);
                String string2 = this.SEDU.getUserFormat();
                if (ParamsController.isEmpty(string2) && (this.getAutoSavedParamLists() || this.isDateTime() || this.isTime())) {
                    string2 = this.SEDU.getDefaultDateFormat();
                }
                if (object instanceof String) {
                    object = this.equalsIgnoreCase((String)object, string2, locale2, string, locale);
                } else if (object instanceof String[]) {
                    String[] stringArray = object;
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = this.equalsIgnoreCase(stringArray[i], string2, locale2, string, locale);
                    }
                    object = stringArray;
                } else if (object instanceof List) {
                    List list = (List)object;
                    String[] stringArray = new String[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        stringArray[i] = this.equalsIgnoreCase((String)list.get(i), string2, locale2, string, locale);
                    }
                    object = stringArray;
                } else {
                    object = this.equalsIgnoreCase(object.toString(), string2, locale2, string, locale);
                }
            }
            finally {
                if (locale != null) {
                    this.SEDU.setLocale(locale);
                }
            }
        }
        return object;
    }

    public List<String> getValues() {
        ArrayList<String> arrayList;
        String[] stringArray = null;
        Object object = this.J.get(this.getName());
        object = this.format(object);
        ServiceLogger.trace("ParamsController:ParamController:getValues: param=%s, currentValue=%s", ParamUtil.toString(this.SEDU), StringUtil.toString(object));
        if (object instanceof String[]) {
            stringArray = (String[])object;
        } else if (object instanceof List) {
            arrayList = (ArrayList<String>)object;
            stringArray = new String[arrayList.size()];
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                stringArray[i] = (String)arrayList.get(i);
            }
        } else if (object instanceof String) {
            stringArray = new String[]{(String)object};
        } else if (object != null) {
            stringArray = new String[]{object.toString()};
        }
        if (stringArray == null && !this.SEDU.isAllowAll()) {
            stringArray = new String[]{this.SEDU.getDefaultValue()};
        }
        arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (String string : stringArray) {
                arrayList.add(string);
            }
            ServiceLogger.trace("ParamsController:ParamController:getValue: param=%s, defaultValue=%s", ParamUtil.toString(this.SEDU), StringUtil.toString(arrayList));
            return arrayList;
        }
        ServiceLogger.trace("ParamsController:ParamController:getValue: param=%s, defaultValue=<>", ParamUtil.toString(this.SEDU));
        return null;
    }

    public String getValue() {
        String string = null;
        Object object = this.J.get(this.getName());
        object = this.format(object);
        ServiceLogger.trace("ParamsController:ParamController:getValue: param=%s, currentValue=%s", ParamUtil.toString(this.SEDU), StringUtil.toString(object));
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
        } else if (object instanceof List) {
            List list = (List)object;
            if (list.size() > 0) {
                string = (String)list.get(0);
            }
        } else if (object != null) {
            string = object.toString();
        }
        if (string == null) {
            string = this.SEDU.isDynamicDateParameter() ? this.SEDU.getDynamicDisplayValue(this.J.currentTime) : this.SEDU.getDefaultValue();
        }
        ServiceLogger.trace("ParamsController:ParamController:getValue: param=%s, defaultValue=%s", ParamUtil.toString(this.SEDU), StringUtil.toString(string));
        return string;
    }

    private boolean get() {
        return this.J.crdParamNames != null && this.J.crdParamNames.contains(this.SEDU.getName());
    }

    public String getPromptText() {
        Object object;
        String string = null;
        String string2 = this.SEDU.getUserFormat();
        if (string2 != null && string2.length() > 0) {
            if (this.getAutoSavedParamLists() || this.isDateTime() || this.isTime()) {
                object = new DateFormatSymbols(this.J.reportLocale);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, (DateFormatSymbols)object);
                string = " (" + simpleDateFormat.toLocalizedPattern() + ")";
            } else if (this.getCountry()) {
                object = new DecimalFormatSymbols(this.J.reportLocale);
                DecimalFormat decimalFormat = new DecimalFormat(string2, (DecimalFormatSymbols)object);
                string = " (" + decimalFormat.toLocalizedPattern() + ")";
            } else {
                string = " (" + string2 + ")";
            }
        }
        if ((object = this.J.getPromptText(this.SEDU)) == null) {
            object = "";
        }
        object = string != null ? (String)object + string : object;
        return object;
    }

    private boolean getAutoSavedParamLists() {
        return this.SEDU.getType().equalsIgnoreCase("Date");
    }

    private boolean getCountry() {
        return this.SEDU.getType().equals("Integer") || this.SEDU.getType().equals("Number") || this.SEDU.getType().equals("Currency");
    }

    private boolean isDateTime() {
        return this.SEDU.getType().equalsIgnoreCase("DateTime");
    }

    private boolean isTime() {
        return this.SEDU.getType().equalsIgnoreCase("Time");
    }

    public boolean isBoolean() {
        return this.SEDU.getType().equalsIgnoreCase("Boolean") && !this.SEDU.isColumn() && !this.SEDU.isCascading();
    }

    public boolean isMultiple() {
        return this.SEDU.isMultiple();
    }

    public Combobox getUiComponent() {
        return this.add;
    }

    public boolean isSimpleCombobox() {
        return this.add instanceof SimpleCombobox;
    }

    public boolean isDateCombobox() {
        return this.add instanceof DateCombobox;
    }

    public boolean isDateExprCombobox() {
        return this.add instanceof DateExprCombobox;
    }

    public boolean isMultiCombobox() {
        return this.add instanceof MultiCombobox;
    }

    public boolean isMultiDateCombobox() {
        return this.add instanceof MultiDateCombobox;
    }

    public boolean isCheckbox() {
        return this.add instanceof Checkbox;
    }
}

