/*
 * Decompiled with CFR 0.152.
 */
package jet.server.ui;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.cs.util.APIUtil;
import jet.server.api.ParamInfo;
import jet.server.api.ParameterRecorder;
import jet.server.api.ReportInfo;
import jet.server.api.ReportSheetInfo;
import jet.server.api.RptServerException;
import jet.server.api.crd.CRDInfo;
import jet.server.api.crd.CRDInfoKey;
import jet.server.api.crd.CRDManageException;
import jet.server.api.crd.CRDManager;
import jet.server.api.http.HttpRptServer;
import jet.server.api.paramlist.ReportParamList;
import jet.server.intf.jrs.ExHttpRptServer;
import jet.server.jrserver.JRParamInfo;
import jet.server.log.ServiceLogger;
import jet.server.ui.ParamController;
import jet.server.ui.ParamModel;
import jet.server.util.ParamUtil;
import jet.server.util.ServerUtil;
import jet.server.util.StringUtil;

public class ParamsController {
    public static final int MODE_DIRECT = 0;
    public static final int MODE_ADVANCED = 1;
    public static final int MODE_SCHEDULE = 2;
    public static final int MODE_SCHEDULE_BURSTING = 3;
    public static final int MODE_SCHEDULE_CRD = 4;
    public static final int MODE_PARAM_SETTING = 5;
    ExHttpRptServer httpRptServer;
    private Properties SEDU;
    Properties properties;
    String user;
    List<ParamInfo> paramInfos;
    String[] paramNames;
    Map<String, ParamInfo> paramInfoMap;
    List<String> crdParamNames;
    private int add = 0;
    Locale reportLocale;
    long currentTime;
    private String append = "";
    private Boolean booleanValue;
    private Boolean byteValue;
    private List<ReportParamList> contains;
    int mode = 0;
    boolean dontShowParamPage;
    boolean existUserDefinedDefault;
    private boolean doMetadataNLS = false;
    List<ParamController> paramControllers = null;
    private String elementAt = null;
    String oldLocale;

    public static ParamsController make(HttpRptServer httpRptServer, ReportInfo reportInfo, int n, Locale locale, String string, Properties properties, long l, int n2) throws Exception {
        return new ParamsController(httpRptServer, reportInfo, n, locale, string, properties, l, n2);
    }

    public static ParamsController make(HttpRptServer httpRptServer, List<ParamInfo> list, Locale locale, String string, Properties properties, long l, int n, String string2) throws Exception {
        return new ParamsController(httpRptServer, list, locale, string, properties, l, n, string2);
    }

    public static ParamsController make(HttpRptServer httpRptServer, List<ParamInfo> list, Locale locale, String string, Properties properties, long l, int n) throws Exception {
        return new ParamsController(httpRptServer, list, locale, string, properties, l, n, "");
    }

    private ParamsController(HttpRptServer httpRptServer, ReportInfo reportInfo, int n, Locale locale, String string, Properties properties, long l, int n2) throws Exception {
        Object object;
        ServiceLogger.trace("ParamsController: new... (reportInfo=%s, reportStatus=%s, reportLocale=%s, user=%s, currentTime=%s, mode=%s, props=%s)", reportInfo, n, locale, string, l, n2, properties);
        this.httpRptServer = (ExHttpRptServer)httpRptServer;
        this.properties = properties;
        this.reportLocale = locale;
        this.user = string;
        this.currentTime = l;
        this.mode = n2;
        this.oldLocale = properties.getProperty("old_locale");
        if (this.mode == 0) {
            String string2;
            String string3 = (String)properties.get("paramPageDisabled");
            if (string3 != null) {
                if ("true".equals(string3 = string3.trim())) {
                    this.booleanValue = true;
                } else if ("false".equals(string3)) {
                    this.booleanValue = false;
                }
            }
            if (!(this.booleanValue != null && this.booleanValue.booleanValue() || (string2 = (String)properties.get("jrs.param_page")) == null)) {
                if ("true".equals(string2 = string2.trim())) {
                    this.byteValue = true;
                } else if ("false".equals(string2)) {
                    this.byteValue = false;
                }
            }
        }
        this.SEDU = this.httpRptServer.getUserPreferenceManager().getUserPreference(string);
        if (5 == n2) {
            boolean bl = APIUtil.getBoolean(this.SEDU.getProperty("profile_enable_setting_default_parameter_values_4_jreport_viewer"));
            boolean bl2 = APIUtil.getBoolean(this.SEDU.getProperty("profile_enable_setting_default_parameter_values_4_jreport_studio"));
            String string4 = properties.getProperty("jrs.report");
            object = this.httpRptServer.getResourceManager().getPathInfo(string, string4);
            boolean bl3 = object.isStudioReport();
            boolean bl4 = object.isReport() && !object.isStudioReport() && !object.isJDashboard();
            this.doMetadataNLS = bl4 && !bl || bl3 && !bl2;
        }
        ParameterRecorder parameterRecorder = this.httpRptServer.getParameterRecorder();
        String string5 = properties.getProperty("jrs.report");
        this.dontShowParamPage = parameterRecorder.isDontShowParamPage(string, string5);
        boolean bl = this.existUserDefinedDefault = parameterRecorder.getDefaultReportParamList(string, string5) != null;
        if (this.byteValue == null && n2 != 4) {
            boolean bl5 = false;
            if (n2 == 2) {
                object = (String)this.properties.get("jrs.task_id");
                boolean bl6 = bl5 = object != null && ((String)object).trim().length() > 0;
            }
            if (!bl5) {
                this.SEDU();
            }
        }
        if (n2 != 4 && n2 != 5) {
            this.append(reportInfo);
        }
        this.add(reportInfo, n);
        this.booleanValue();
        ServiceLogger.trace("ParamsController: new success. (reportStatus=%s, reportLocale=%s, user=%s, currentTime=%s, mode=%s, paramPageDisabled=%s, paramPage=%s, dontShowParamPage=%s, existUserDefinedDefault=%s)", n, locale, string, l, n2, this.booleanValue, this.byteValue, this.dontShowParamPage, this.existUserDefinedDefault);
    }

    private ParamsController(HttpRptServer httpRptServer, List<ParamInfo> list, Locale locale, String string, Properties properties, long l, int n, String string2) throws Exception {
        String string3;
        Object object;
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("ParamsController: new... (reportLocale=%s, user=%s, currentTime=%s, mode=%s, paramPrefix=%s, props=%s, paramInfos=%s)", locale, string, l, n, string2, properties, ParamUtil.toString(list));
        }
        this.httpRptServer = (ExHttpRptServer)httpRptServer;
        this.properties = properties;
        this.reportLocale = locale;
        this.user = string;
        this.currentTime = l;
        this.mode = n;
        this.append = string2;
        this.paramInfos = list;
        this.oldLocale = properties.getProperty("old_locale");
        if (this.mode == 0) {
            object = (String)properties.get("paramPageDisabled");
            if (object != null) {
                if ("true".equals(object = ((String)object).trim())) {
                    this.booleanValue = true;
                } else if ("false".equals(object)) {
                    this.booleanValue = false;
                }
            }
            if (!(this.booleanValue != null && this.booleanValue.booleanValue() || (string3 = (String)properties.get("jrs.param_page")) == null)) {
                if ("true".equals(string3 = string3.trim())) {
                    this.byteValue = true;
                } else if ("false".equals(string3)) {
                    this.byteValue = false;
                }
            }
        }
        if (this.mode == 0 && this.booleanValue != null && !this.booleanValue.booleanValue() && (object = (String)properties.get("jrs.param_page")) != null) {
            if ("true".equals(object = ((String)object).trim())) {
                this.byteValue = true;
            } else if ("false".equals(object)) {
                this.byteValue = false;
            }
        }
        this.SEDU = this.httpRptServer.getUserPreferenceManager().getUserPreference(string);
        object = this.httpRptServer.getParameterRecorder();
        string3 = properties.getProperty("jrs.report");
        this.dontShowParamPage = object.isDontShowParamPage(string, string3);
        this.existUserDefinedDefault = object.getDefaultReportParamList(string, string3) != null;
        for (ParamInfo paramInfo : list) {
            paramInfo.setLocale(locale);
            if (this.isHiddenParam(paramInfo)) continue;
            ++this.add;
        }
        if (this.byteValue == null && n != 4) {
            this.SEDU();
        }
        this.booleanValue();
        ServiceLogger.trace("ParamsController: new success. (reportLocale=%s, user=%s, currentTime=%s, mode=%s, paramPageDisabled=%s, paramPage=%s, shownParamSize=%s, dontShowParamPage=%s, existUserDefinedDefault=%s)", locale, string, l, n, this.booleanValue, this.byteValue, this.add, this.dontShowParamPage, this.existUserDefinedDefault);
    }

    private void SEDU() {
        Object[] objectArray;
        Object object = this.properties.get("jrs.saved_param_list_type");
        int n = 2;
        String string = (String)this.properties.get("change_value");
        if (object != null && object.toString().trim().length() > 0) {
            try {
                n = Byte.parseByte(object.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object == null && (string == null || string.trim().length() == 0)) {
            this.properties.put("jrs.saved_param_list_type", (Object)2);
        }
        String string2 = (String)this.properties.get("jrs.rpt_language");
        String string3 = (String)this.properties.get("jrs.rpt_country");
        if (!(this.reportLocale == null || string2 != null && string2.trim().length() != 0 || string3 != null && string3.trim().length() != 0)) {
            this.properties.put("jrs.rpt_language", this.reportLocale.toString());
        }
        if (!((Boolean)(objectArray = ParamUtil.resetParamValues(this.user, this.append, this.properties))[1]).booleanValue() && n == 2 && (Byte)objectArray[0] == 2) {
            this.properties.put("jrs.saved_param_list_type", (Object)-1);
            ParamUtil.resetParamValues(this.user, this.append, this.properties);
        }
        this.properties.remove("jrs.saved_param_list_type");
        this.properties.remove("jrs.saved_param_list_name");
    }

    public String getParamPrefix() {
        if (this.mode == 3) {
            return "jrs.recipient_param$";
        }
        return "jrs.param$" + (this.append == null ? "" : this.append);
    }

    public List<? extends ParamModel> getParamModels() {
        return this.getParamControllers();
    }

    public List<ParamController> getParamControllers() {
        if (this.paramControllers == null) {
            this.paramControllers = new LinkedList<ParamController>();
            for (ParamInfo paramInfo : this.paramInfos) {
                this.paramControllers.add(new ParamController(this, paramInfo));
            }
        }
        return this.paramControllers;
    }

    /*
     * WARNING - void declaration
     */
    private void add(ReportInfo reportInfo, int n) {
        ServiceLogger.trace("ParamsController: initParamInfos... (reportInfo=%s, reportStatus=%s)", reportInfo, n);
        try {
            void var4_8;
            boolean bl = this.get("changeres") != null;
            Vector<String> vector = ServerUtil.parseSheetNames(this.properties);
            if (vector.size() == 0 && !bl) {
                boolean bl2 = "jrs.get_new_schd_page".equals(this.get("jrs.cmd"));
                Vector vector2 = reportInfo.getReportSheetInfos(n);
                Vector<String> vector3 = new Vector<String>();
                Vector<String> vector4 = new Vector<String>();
                for (ReportSheetInfo reportSheetInfo : vector2) {
                    if (reportSheetInfo.isBurstingReport()) {
                        vector4.add(reportSheetInfo.getName());
                        continue;
                    }
                    vector3.add(reportSheetInfo.getName());
                }
                if (bl2 && vector3.isEmpty()) {
                    if (!vector4.isEmpty()) {
                        vector.add((String)vector4.get(0));
                    }
                } else {
                    Vector<String> vector5 = vector3;
                }
            }
            this.paramInfos = reportInfo.getParamInfos((List<String>)var4_8, this.properties);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        if (this.paramInfos != null) {
            for (ParamInfo paramInfo : this.paramInfos) {
                paramInfo.setLocale(this.reportLocale);
                if (this.isHiddenParam(paramInfo)) continue;
                ++this.add;
            }
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("ParamsController: initParamInfos end. (reportInfo=%s, shownParamSize=%s, paramInfos=%s)", reportInfo, this.add, ParamUtil.toString(this.paramInfos));
        }
    }

    boolean isLockedParam(String string) {
        if (string.startsWith(this.getParamPrefix())) {
            string = string.substring(this.getParamPrefix().length());
        }
        for (ParamInfo paramInfo : this.paramInfos) {
            if (!string.equalsIgnoreCase(paramInfo.getName())) continue;
            return this.isLockedParam(paramInfo);
        }
        return false;
    }

    boolean isLockedParam(ParamInfo paramInfo) {
        boolean bl = false;
        if (this.byteValue != null) {
            Object t = this.get(this.getParamPrefix() + paramInfo.getName());
            bl = this.byteValue == false || this.byteValue != false && t != null;
        } else {
            bl = this.get("locked_" + this.getParamPrefix() + paramInfo.getName()) != null;
        }
        return bl;
    }

    boolean isGetValueFromAPI(ParamInfo paramInfo) {
        return paramInfo.isGetValueFromAPI();
    }

    boolean isHiddenParam(ParamInfo paramInfo) {
        return paramInfo.isHideParameterWhenSingleValueReturn() && paramInfo.isColumn() && !paramInfo.isReferedBy() && !paramInfo.isReferOther() && paramInfo.getValueOptions().size() == 1;
    }

    static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private void append(ReportInfo reportInfo) throws RptServerException {
        ServiceLogger.trace("ParamsController: initCrdParams... (reportInfo=%s)", reportInfo);
        this.crdParamNames = new LinkedList<String>();
        Vector<CRDInfoKey> vector = reportInfo.getQueryInfos();
        CRDManager cRDManager = this.httpRptServer.getCRDManager();
        String string = (String)this.get("jrs.catalog");
        int n = APIUtil.parseInt((String)this.get("jrs.cat_version"), 0);
        if (n <= 0 || n == this.httpRptServer.getResourceManager().getPathInfo(this.user, string).getLatestVersionNumber()) {
            for (int i = 0; i < vector.size(); ++i) {
                CRDInfoKey cRDInfoKey = vector.elementAt(i);
                if (cRDInfoKey.getQueryType() == 6) continue;
                try {
                    List<ParamInfo> list = cRDManager.getParamInfos(this.user, cRDInfoKey);
                    if (list == null) continue;
                    for (int j = 0; j < list.size(); ++j) {
                        ParamInfo paramInfo = list.get(j);
                        String string2 = paramInfo.getName();
                        if (this.crdParamNames.contains(string2)) continue;
                        this.crdParamNames.add(string2);
                        CRDInfo cRDInfo = cRDManager.getCRD(this.user, cRDInfoKey);
                        Map<String, String[]> map = cRDInfo.getParamValues();
                        String[] stringArray = map.get(string2);
                        if (stringArray == null || stringArray.length <= 0) continue;
                        ServiceLogger.trace("ParamsController:initCrdParams: replace parameter value with CRD![paramName=%s, paramValues=%s]", string2, StringUtil.toString(stringArray));
                        if (this.oldLocale == null || this.oldLocale.trim().length() == 0) {
                            this.oldLocale = Locale.getDefault().toString();
                        }
                        if (paramInfo.isMultiple()) {
                            this.put("jrs.param$" + string2, stringArray);
                            continue;
                        }
                        this.put("jrs.param$" + string2, stringArray[0]);
                    }
                    continue;
                }
                catch (CRDManageException cRDManageException) {
                    ServiceLogger.logError((Throwable)((Object)cRDManageException), 3);
                }
            }
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("ParamsController: initCrdParams end. (crdParamNames=%s)", StringUtil.toString(this.crdParamNames));
        }
    }

    private void booleanValue() {
        String string = (String)this.get("change_value");
        if (string != null && string.trim().length() > 0) {
            Vector vector;
            ParamInfo paramInfo = null;
            if (this.paramInfos != null && this.paramInfos.size() > 0) {
                for (int i = this.paramInfos.size() - 1; i >= 0; --i) {
                    ParamInfo paramInfo2 = this.paramInfos.get(i);
                    if (!string.equals(paramInfo2.getName())) continue;
                    paramInfo = paramInfo2;
                    break;
                }
            }
            if (paramInfo != null && (vector = paramInfo.getReferedBy()) != null && vector.size() > 0) {
                for (int i = vector.size() - 1; i >= 0; --i) {
                    String string2 = (String)vector.get(i);
                    ServiceLogger.trace("ParamsController:removeNextParamValues: remove parameter value! [changedParamName=%s, paramName=%s]", string, string2);
                    this.properties.remove(this.getParamPrefix() + string2);
                }
            }
        }
    }

    <T> T get(String string) {
        return (T)this.properties.get(string);
    }

    void put(String string, Object object) {
        this.properties.put(string, object);
    }

    public String doMetadataNLS(String string) {
        String string2 = string;
        if (null != this.reportLocale) {
            try {
                String string3 = (String)this.properties.get("jrs.report");
                int n = APIUtil.parseInt((String)this.properties.get("jrs.rpt_version"), -1);
                if (-1 == n) {
                    n = this.httpRptServer.getResourceManager().getLatestVersionNumber(string3);
                }
                String string4 = (String)this.properties.get("jrs.catalog");
                int n2 = APIUtil.parseInt((String)this.properties.get("jrs.cat_version"), -1);
                if (-1 == n2) {
                    n = this.httpRptServer.getResourceManager().getLatestVersionNumber(string3);
                }
                string2 = this.httpRptServer.getNLSText(this.user, string3, n, string4, n, this.reportLocale, 9, string);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return string2;
    }

    public String doMetadataNLS(String string, Locale locale) {
        String string2 = string;
        if (null != locale) {
            try {
                String string3 = (String)this.properties.get("jrs.report");
                int n = APIUtil.parseInt((String)this.properties.get("jrs.rpt_version"), -1);
                if (-1 == n) {
                    n = this.httpRptServer.getResourceManager().getLatestVersionNumber(string3);
                }
                String string4 = (String)this.properties.get("jrs.catalog");
                int n2 = APIUtil.parseInt((String)this.properties.get("jrs.cat_version"), -1);
                if (-1 == n2) {
                    n = this.httpRptServer.getResourceManager().getLatestVersionNumber(string3);
                }
                string2 = this.httpRptServer.getNLSText(this.user, string3, n, string4, n, locale, 9, string);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return string2;
    }

    public String getPromptText(ParamInfo paramInfo) {
        String string = null;
        if (!paramInfo.isCascading()) {
            string = paramInfo.getPrompt();
            if (string == null || string.trim().length() == 0) {
                string = paramInfo.getName();
                string = this.doMetadataNLS(string, ((JRParamInfo)paramInfo).getDisplayLocale());
            }
        } else {
            boolean bl = false;
            for (int i = 0; i < this.paramInfos.size(); ++i) {
                Object object;
                String string2;
                int n;
                Object object2 = this.paramInfos.get(i);
                if (object2 != paramInfo) continue;
                for (n = i; n > 0; --n) {
                    string2 = object2.getPreviousLevel();
                    object = this.paramInfos.get(n - 1);
                    if (string2 == null || string2.length() == 0 || !object.getName().equals(string2)) break;
                    object2 = object;
                }
                do {
                    string2 = object2.getPrompt();
                    boolean bl2 = bl = bl || string2 == null || string2.length() == 0;
                    if (!object2.isSetAsParameter()) continue;
                    string = string == null ? object2.getName() : string + "/" + object2.getName();
                } while ((object = object2.getNextLevel()) != null && ((String)object).length() > 0 && ++n < this.paramInfos.size() && (object2 = this.paramInfos.get(n)).getName().equals(object));
                break;
            }
            if (bl) {
                String string3 = paramInfo.getPreviousLevel();
                if (string3 != null && string3.length() > 0) {
                    string = null;
                }
            } else {
                string = paramInfo.getPrompt();
            }
        }
        return string;
    }

    public List<ParamInfo> getParamInfos() {
        return this.paramInfos;
    }

    public String[] getParamNames() {
        if (this.paramNames == null && this.paramInfos != null) {
            this.paramNames = new String[this.paramInfos.size()];
            int n = 0;
            for (ParamInfo paramInfo : this.paramInfos) {
                this.paramNames[n] = paramInfo.getName();
                ++n;
            }
        }
        return this.paramNames;
    }

    public ParamInfo getParamInfo(String string) {
        if (this.paramInfoMap == null) {
            this.paramInfoMap = new Hashtable<String, ParamInfo>();
            if (this.paramInfos != null) {
                for (ParamInfo paramInfo : this.paramInfos) {
                    this.paramInfoMap.put(paramInfo.getName(), paramInfo);
                }
            }
        }
        return this.paramInfoMap.get(string);
    }

    public int getShownParamSize() {
        return this.add;
    }

    public int getParamSize() {
        if (this.paramInfos == null) {
            return 0;
        }
        return this.paramInfos.size();
    }

    public Locale getReportLocale() {
        return this.reportLocale;
    }

    public boolean isEnableSaveParameter() {
        return APIUtil.getBoolean(this.SEDU.getProperty("jrs.enable_save_used_parameter_values"));
    }

    public boolean isAutoSaveParameter() {
        if (this.mode == 4) {
            return false;
        }
        if (this.isEnableSaveParameter()) {
            return APIUtil.getBoolean(this.SEDU.getProperty("jrs.isAuto_save_used_parameter_values"));
        }
        return false;
    }

    public boolean isManualSaveParameter() {
        if (this.mode == 4) {
            return false;
        }
        if (this.isEnableSaveParameter()) {
            return !APIUtil.getBoolean(this.SEDU.getProperty("jrs.isAuto_save_used_parameter_values"));
        }
        return false;
    }

    public boolean isUseSavedParameter() {
        return APIUtil.getBoolean((String)this.get("useSavedParameter"), false);
    }

    public List<ReportParamList> getAutoSavedParamLists() {
        if (this.contains == null) {
            this.contains = ParamUtil.getAutoReportParamLists(this.user, this.properties);
        }
        return this.contains;
    }

    public boolean isDontShowParamPage() {
        return this.dontShowParamPage;
    }

    public boolean isExistUserDefinedDefault() {
        return this.existUserDefinedDefault;
    }

    public int getMode() {
        return this.mode;
    }

    public String getOnChangeAction() {
        if (this.elementAt != null && this.elementAt.trim().length() > 0) {
            return this.elementAt;
        }
        switch (this.mode) {
            case 0: {
                return "getRptParam.jsp";
            }
            case 1: {
                return "getRptDescPage.jsp";
            }
            case 2: {
                return "schedulePage.jsp";
            }
            case 3: {
                return "schedulePage.jsp";
            }
            case 4: {
                return "scheduleCRDPage.jsp";
            }
            case 5: {
                return "setRptParam.jsp";
            }
        }
        return null;
    }

    public List<ReportParamList> getManualReportParamLists() {
        return ParamUtil.getManualReportParamLists(this.user, this.properties);
    }

    public boolean getIsDisableParamInput() {
        return this.doMetadataNLS;
    }

    public void setOnChangeAction(String string) {
        this.elementAt = string;
    }
}

