/*
 * Decompiled with CFR 0.152.
 */
package jet.server.ui;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.cs.util.APIUtil;
import jet.server.api.BurstingSchemaInfo;
import jet.server.api.ParamInfo;
import jet.server.api.PathInfo;
import jet.server.api.ReportInfo;
import jet.server.api.ReportSheetInfo;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserPreferenceManager;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoRemoteServerException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.api.http.TooManyTimesException;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;
import jet.server.util.WebSecurityUtil;
import jet.server.util.nls.NlsClientResource;
import jet.server.util.nls.PropertyMessageResourcesFactory;

public class ReportPageDelegate {
    protected ServletContext application;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected HttpRptServer httpRptServer = null;
    protected NlsClientResource nlsClientResource = null;
    protected PropertyMessageResourcesFactory serverResource = null;
    protected ReportInfo rptInfo = null;
    protected BurstingSchemaInfo schemaInfo = null;
    protected Vector vAllBurstParams = null;
    protected Properties burstProp = null;
    protected String defaultParamWidth = "20em";

    public ReportPageDelegate(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws NoPrivilegeException {
        this.application = servletContext;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.httpRptServer = HttpUtil.getHttpRptServer(httpServletRequest);
        if (this.httpRptServer == null) {
            System.getProperties().put("jreport.context", servletContext);
            HttpUtil.initEnv(System.getProperties());
            this.httpRptServer = HttpUtil.getHttpRptServer(httpServletRequest);
        }
        this.nlsClientResource = new NlsClientResource(httpServletRequest);
        this.serverResource = this.nlsClientResource.getServerResourceFactory();
        this.SEDU();
    }

    private void SEDU() throws NoPrivilegeException {
        String string = null;
        System.getProperties().put("jreport.context", this.application);
        String string2 = HttpUtil.decodeEsc(this.request.getParameter("jrs.path"));
        try {
            if (!HttpUtil.checkLogin(this.request, this.response)) {
                return;
            }
        }
        catch (TooManyUsersException tooManyUsersException) {
            string = HttpUtil.filterXSS(tooManyUsersException.getMessage());
        }
        catch (TooManyTimesException tooManyTimesException) {
            string = HttpUtil.filterXSS(this.getNLSMessage("2150001"));
        }
        catch (NoRemoteServerException noRemoteServerException) {
            string = HttpUtil.filterXSS(noRemoteServerException.getMessage());
            ServiceLogger.logError((Throwable)((Object)noRemoteServerException));
        }
        catch (Throwable throwable) {
            string = HttpUtil.filterXSS(throwable.getMessage());
            ServiceLogger.logError(throwable);
        }
        String string3 = this.application.getInitParameter("autoDetectServletPath");
        if (string3 == null || string3.equals("true")) {
            HttpUtil.updateServletPaths(this.application, this.request);
        }
        if (!HttpUtil.checkPermission(this.request)) {
            String string4;
            Object object;
            String string5 = this.request.getParameter("jrs.cmd");
            String string6 = "";
            if (string5 != null) {
                if (string5.equals("jrs.get_rpt_desc_page") || string5.equals("jrs.try_vw")) {
                    string6 = "execute ";
                } else if (string5.equals("jrs.get_new_schd_page")) {
                    string6 = "schedule ";
                } else if (string5.equals("jrs.import_resource") || string5.equals("jrs.save_node_prop")) {
                    string6 = "write ";
                } else if (string5.equals("jrs.get_node_prop")) {
                    string6 = "read ";
                }
            }
            if (string2 != null) {
                object = null;
                if (string6.length() > 0) {
                    object = new Object[]{string6, string2};
                    string4 = "2150280";
                } else {
                    object = new Object[]{string2};
                    string4 = "2221737";
                }
                string = this.getNLSMessage(string4, (Object[])object);
            } else {
                string = HttpUtil.filterXSS(this.getNLSMessage("2150281", new Object[]{string6}));
            }
            if (ServiceLogger.isLoggable(0, 5)) {
                object = null;
                string4 = this.request.getSession(false);
                if (string4 != null) {
                    object = string4.getId();
                }
                ServiceLogger.logAccessFailEvent(HttpUtil.getHttpRptServer(this.request).getResourceManager().getRealm(), HttpUtil.getUser(this.request), (String)object, "403 Access denied", 5);
            }
        }
        if (string != null && string.trim().length() > 0) {
            throw new NoPrivilegeException(string);
        }
    }

    private Hashtable add(Vector vector) {
        Hashtable hashtable = new Hashtable();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Vector<String> vector2 = new Vector<String>();
            String string = (String)vector.elementAt(i);
            String string2 = string.substring(0, 2);
            if (!hashtable.containsKey(string2)) {
                if (string.length() == 2) {
                    vector2.add("");
                } else {
                    vector2.add(string.substring(3, 5));
                }
            }
            for (int j = i + 1; j < n; ++j) {
                String string3 = (String)vector.elementAt(j);
                if (hashtable.containsKey(string3.substring(0, 2)) || !string2.equals(string3.substring(0, 2))) continue;
                vector2.add(string3.substring(3, 5));
            }
            if (hashtable.containsKey(string2)) continue;
            hashtable.put(string2, vector2);
        }
        return hashtable;
    }

    public String getNLSMessage(String string) {
        return this.serverResource.getMessage(string);
    }

    public String getNLSMessage(String string, Object object) {
        return this.serverResource.getMessage(string, new Object[]{object});
    }

    public String getNLSMessage(String string, Object[] objectArray) {
        return this.serverResource.getMessage(string, objectArray);
    }

    protected Hashtable[] getUserProp(Vector vector, Vector vector2, Vector vector3, Properties properties) {
        String string;
        String string2;
        String string3;
        int n;
        boolean bl = APIUtil.getBoolean((String)properties.get("is_schedule"), false);
        Hashtable[] hashtableArray = null;
        hashtableArray = new Hashtable[]{new Hashtable(), new Hashtable(), new Hashtable()};
        if (vector != null) {
            for (n = 0; n < vector.size(); ++n) {
                string3 = (String)vector.elementAt(n);
                string2 = "";
                string = "";
                if (APIUtil.getBoolean((String)properties.get("jrs.user_permission$" + string3 + "." + "visible"))) {
                    if (!bl) {
                        properties.remove("jrs.user_permission$" + string3 + "." + "visible");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.user_permission$" + string3 + "." + "read"))) {
                    if (!bl) {
                        properties.remove("jrs.user_permission$" + string3 + "." + "read");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.user_permission$" + string3 + "." + "write"))) {
                    if (!bl) {
                        properties.remove("jrs.user_permission$" + string3 + "." + "write");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.user_permission$" + string3 + "." + "execute"))) {
                    if (!bl) {
                        properties.remove("jrs.user_permission$" + string3 + "." + "execute");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.user_permission$" + string3 + "." + "schedule"))) {
                    if (!bl) {
                        properties.remove("jrs.user_permission$" + string3 + "." + "schedule");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.user_permission$" + string3 + "." + "delete"))) {
                    if (!bl) {
                        properties.remove("jrs.user_permission$" + string3 + "." + "delete");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.user_permission$" + string3 + "." + "grant"))) {
                    if (!bl) {
                        properties.remove("jrs.user_permission$" + string3 + "." + "grant");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                hashtableArray[0].put(string3, string);
            }
        }
        if (vector2 != null) {
            for (n = 0; n < vector2.size(); ++n) {
                string3 = (String)vector2.elementAt(n);
                string2 = "";
                string = "";
                if (APIUtil.getBoolean((String)properties.get("jrs.role_permission$" + string3 + "." + "visible"))) {
                    if (!bl) {
                        properties.remove("jrs.role_permission$" + string3 + "." + "visible");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.role_permission$" + string3 + "." + "read"))) {
                    if (!bl) {
                        properties.remove("jrs.role_permission$" + string3 + "." + "read");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.role_permission$" + string3 + "." + "write"))) {
                    if (!bl) {
                        properties.remove("jrs.role_permission$" + string3 + "." + "write");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.role_permission$" + string3 + "." + "execute"))) {
                    if (!bl) {
                        properties.remove("jrs.role_permission$" + string3 + "." + "execute");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.role_permission$" + string3 + "." + "schedule"))) {
                    if (!bl) {
                        properties.remove("jrs.role_permission$" + string3 + "." + "schedule");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.role_permission$" + string3 + "." + "delete"))) {
                    if (!bl) {
                        properties.remove("jrs.role_permission$" + string3 + "." + "delete");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.role_permission$" + string3 + "." + "grant"))) {
                    if (!bl) {
                        properties.remove("jrs.role_permission$" + string3 + "." + "grant");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                hashtableArray[1].put(string3, string);
            }
        }
        if (vector3 != null) {
            for (n = 0; n < vector3.size(); ++n) {
                string3 = (String)vector3.elementAt(n);
                string2 = "";
                string = "";
                if (APIUtil.getBoolean((String)properties.get("jrs.group_permission$" + string3 + "." + "visible"))) {
                    if (!bl) {
                        properties.remove("jrs.group_permission$" + string3 + "." + "visible");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.group_permission$" + string3 + "." + "read"))) {
                    if (!bl) {
                        properties.remove("jrs.group_permission$" + string3 + "." + "read");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.group_permission$" + string3 + "." + "write"))) {
                    if (!bl) {
                        properties.remove("jrs.group_permission$" + string3 + "." + "write");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.group_permission$" + string3 + "." + "execute"))) {
                    if (!bl) {
                        properties.remove("jrs.group_permission$" + string3 + "." + "execute");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.group_permission$" + string3 + "." + "schedule"))) {
                    if (!bl) {
                        properties.remove("jrs.group_permission$" + string3 + "." + "schedule");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.group_permission$" + string3 + "." + "delete"))) {
                    if (!bl) {
                        properties.remove("jrs.group_permission$" + string3 + "." + "delete");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                if (APIUtil.getBoolean((String)properties.get("jrs.group_permission$" + string3 + "." + "grant"))) {
                    if (!bl) {
                        properties.remove("jrs.group_permission$" + string3 + "." + "grant");
                    }
                    string = string + "1";
                } else {
                    string = string + "0";
                }
                hashtableArray[2].put(string3, string);
            }
        }
        return hashtableArray;
    }

    protected Vector getSavePrincipals(String string, Properties properties) {
        Vector<String> vector = new Vector<String>();
        String string2 = HttpUtil.decodeEsc((String)properties.get("curr" + string));
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                string2 = string2.substring(2);
                vector.addElement(string2);
            }
        }
        return vector;
    }

    protected Hashtable[] getNodeCurrentPermissions(Hashtable[] hashtableArray, Hashtable[] hashtableArray2, Set[] setArray) {
        String string;
        String string2;
        Object object2;
        Set set;
        if (hashtableArray2 == null) {
            hashtableArray2 = new Hashtable[]{new Hashtable(), new Hashtable(), new Hashtable()};
        }
        if (hashtableArray2[0] == null) {
            hashtableArray2[0] = new Hashtable();
        }
        if (hashtableArray2[1] == null) {
            hashtableArray2[1] = new Hashtable();
        }
        if (hashtableArray2[2] == null) {
            hashtableArray2[2] = new Hashtable();
        }
        if (hashtableArray2[0] != null) {
            set = setArray[0];
            for (Object object2 : set) {
                if (!hashtableArray2[0].containsKey(object2)) continue;
                hashtableArray2[0].remove(object2);
            }
            if (hashtableArray[0] != null) {
                object2 = hashtableArray[0].keys();
                while (object2.hasMoreElements()) {
                    string2 = (String)object2.nextElement();
                    string = (String)hashtableArray[0].get(string2);
                    hashtableArray2[0].put(string2, string);
                }
            }
        }
        if (hashtableArray2[1] != null) {
            set = setArray[1];
            for (Object object2 : set) {
                if (!hashtableArray2[1].containsKey(object2)) continue;
                hashtableArray2[1].remove(object2);
            }
            if (hashtableArray[1] != null) {
                object2 = hashtableArray[1].keys();
                while (object2.hasMoreElements()) {
                    string2 = (String)object2.nextElement();
                    string = (String)hashtableArray[1].get(string2);
                    hashtableArray2[1].put(string2, string);
                }
            }
        }
        if (hashtableArray2[2] != null) {
            set = setArray[2];
            for (Object object2 : set) {
                if (!hashtableArray2[2].containsKey(object2)) continue;
                hashtableArray2[2].remove(object2);
            }
            if (hashtableArray[2] != null) {
                object2 = hashtableArray[2].keys();
                while (object2.hasMoreElements()) {
                    string2 = (String)object2.nextElement();
                    string = (String)hashtableArray[2].get(string2);
                    hashtableArray2[2].put(string2, string);
                }
            }
        }
        return hashtableArray2;
    }

    protected void checkParamValues(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("jrs.param$")) continue;
            if ("Gen".equalsIgnoreCase(properties.getProperty("Radio_" + string))) {
                properties.remove(string);
                properties.put(string, "jrs.param_gen$" + properties.getProperty("Gen_" + string));
            }
            properties.remove("Gen_" + string);
            properties.remove("Radio_" + string);
        }
    }

    protected boolean isParameterReady(Properties properties, Vector vector) {
        Object object;
        int n;
        Object object2;
        Object object3;
        if (properties.containsKey("jrs.param_values")) {
            object3 = (String)properties.get("jrs.param_values");
            properties.remove("jrs.param_values");
            if (object3 != null && ((String)object3).length() > 0) {
                object2 = ((String)object3).split(",");
                for (n = 0; n < ((String[])object2).length; ++n) {
                    object = "jrs.param$" + object2[n].substring(0, object2[n].indexOf("="));
                    String string = object2[n].substring(object2[n].indexOf("=") + 1);
                    properties.put(object, string);
                }
            }
        }
        object3 = properties.keySet();
        object2 = null;
        object = null;
        if (object3.contains("flag")) {
            return true;
        }
        boolean bl = true;
        for (n = 0; n < vector.size(); ++n) {
            object = (ParamInfo)vector.elementAt(n);
            object2 = "jrs.param$" + ServerUtil.escapeHTML(object.getName());
            if (object3.contains(object2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean validateParamGenClass(String string) {
        boolean bl = false;
        if (string != null && string.trim().length() > 0) {
            Class[] classArray = null;
            try {
                classArray = new Class[]{Class.forName("jet.server.api.custom.schedule.ParameterGenerator"), Class.forName("jet.server.api.custom.schedule.ExtParameterGenerator")};
            }
            catch (ClassNotFoundException classNotFoundException) {
                ServiceLogger.logError(classNotFoundException);
            }
            if (WebSecurityUtil.validateReflectClass(string, null, classArray) != null) {
                bl = true;
            }
        }
        return bl;
    }

    protected Vector getInvalidParamGen(Properties properties) {
        Vector<String> vector = new Vector<String>();
        String string = "";
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith("jrs.param$") || (string = properties.getProperty(string3)) == null || !string.startsWith("jrs.param_gen$") || ReportPageDelegate.validateParamGenClass(string2 = string.substring(string.indexOf("$") + 1))) continue;
            vector.addElement(string2);
        }
        return vector;
    }

    protected String getBooleanDefaultValue(ParamInfo paramInfo, String string) {
        if (string == null || string.trim().length() == 0) {
            string = "false";
        } else {
            boolean bl = false;
            String[] stringArray = paramInfo.getBooleanLiteral()[1];
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                bl = true;
                break;
            }
            string = bl ? "false" : "true";
        }
        if (string.equals("true")) {
            return this.getBooleanOptions(paramInfo)[0];
        }
        return this.getBooleanOptions(paramInfo)[1];
    }

    protected String[] getBooleanOptions(ParamInfo paramInfo) {
        String[] stringArray = new String[]{paramInfo.getBooleanLiteral()[0][0], paramInfo.getBooleanLiteral()[1][0]};
        return stringArray;
    }

    protected void removeReferedParamValues(String string, Vector vector, Map map) {
        if (string != null) {
            Vector vector2;
            ParamInfo paramInfo = null;
            if (vector != null && vector.size() > 0) {
                for (int i = vector.size() - 1; i >= 0; --i) {
                    ParamInfo paramInfo2 = (ParamInfo)vector.get(i);
                    if (!string.equals(paramInfo2.getName())) continue;
                    paramInfo = paramInfo2;
                    break;
                }
            }
            if (paramInfo != null && (vector2 = paramInfo.getReferedBy()) != null && vector2.size() > 0) {
                for (int i = vector2.size() - 1; i >= 0; --i) {
                    String string2 = (String)vector2.get(i);
                    Object v = map.remove("jrs.param$" + string2);
                }
            }
        }
    }

    protected String getProfileName(HttpRptServer httpRptServer, String string, String string2) {
        String string3 = null;
        try {
            if (string2 != null && string2.trim().length() > 0) {
                PathInfo pathInfo = httpRptServer.getResourceManager().getPathInfo(string, string2);
                if (pathInfo != null) {
                    string3 = pathInfo.getProfileName();
                    if (string2 != null && string2.trim().length() > 0 && (string3 == null || string3.trim().length() == 0)) {
                        string3 = this.getProfileName(httpRptServer, string, pathInfo.getParentPath());
                    }
                }
            } else {
                UserPreferenceManager userPreferenceManager = httpRptServer.getUserDHTMLPreferenceManager();
                Properties properties = userPreferenceManager.getUserPreference(string);
                string3 = properties.getProperty("dhtml.currentprofile");
                if (string3 == null || string3.trim().length() == 0) {
                    properties = userPreferenceManager.getDefaultUserPreference();
                    string3 = properties.getProperty("dhtml.currentprofile");
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return string3;
    }

    protected Vector getAllParamInfos(Hashtable hashtable, ReportInfo reportInfo, String string, int n) {
        Vector vector = null;
        try {
            boolean bl = hashtable.get("changeres") != null;
            Vector<String> vector2 = ServerUtil.parseSheetNames(hashtable);
            if (vector2.size() == 0 && !bl) {
                boolean bl2 = "jrs.get_new_schd_page".equals(hashtable.get("jrs.cmd"));
                Vector vector3 = reportInfo.getReportSheetInfos(n);
                Vector<String> vector4 = new Vector<String>();
                Vector<String> vector5 = new Vector<String>();
                for (ReportSheetInfo reportSheetInfo : vector3) {
                    if (reportSheetInfo.isBurstingReport()) {
                        vector5.add(reportSheetInfo.getName());
                        continue;
                    }
                    vector4.add(reportSheetInfo.getName());
                }
                if (bl2 && vector4.isEmpty()) {
                    if (!vector5.isEmpty()) {
                        vector2.add((String)vector5.get(0));
                    }
                } else {
                    vector2 = vector4;
                }
                ServiceLogger.logDebug(6600273, new Object[]{string, n, vector2}, 6);
            }
            vector = (Vector)reportInfo.getParamInfos(vector2, hashtable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return vector;
    }

    protected Vector sort(Properties properties, Vector vector) {
        if (properties == null) {
            return null;
        }
        String[] stringArray = null;
        stringArray = vector == null || vector.isEmpty() ? properties.keySet().toArray(new String[properties.size()]) : vector.toArray(new String[vector.size()]);
        Vector<Object> vector2 = new Vector<Object>();
        properties = (Properties)properties.clone();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            ParamInfo paramInfo = (ParamInfo)properties.get(string);
            if (paramInfo == null) continue;
            if (!paramInfo.isCascading()) {
                vector2.add(paramInfo);
                properties.remove(paramInfo.getName());
                continue;
            }
            while (paramInfo.getPreviousLevel() != null && properties.get(paramInfo.getPreviousLevel()) != null) {
                paramInfo = (ParamInfo)properties.get(paramInfo.getPreviousLevel());
            }
            while (paramInfo != null) {
                vector2.add(paramInfo);
                properties.remove(paramInfo.getName());
                paramInfo = paramInfo.getNextLevel() == null ? null : (ParamInfo)properties.get(paramInfo.getNextLevel());
            }
        }
        if (properties.size() > 0) {
            vector2.addAll(properties.values());
        }
        return vector2;
    }

    protected String getParamSelectWidth(Vector vector, Vector vector2) {
        Object[] objectArray = vector == null ? new Object[]{} : vector.toArray();
        Object[] objectArray2 = vector2 == null ? new Object[]{} : vector2.toArray();
        return this.getParamSelectWidth(objectArray, objectArray2);
    }

    protected String getParamSelectWidth(Object[] objectArray, Object[] objectArray2) {
        int n = 0;
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            string = objectArray2 != null && objectArray2.length > i ? (String)objectArray2[i] : string;
            n = string != null ? Math.max(n, string.length()) : n;
        }
        if (n * 5 / 9 < 20) {
            return this.defaultParamWidth;
        }
        return "auto";
    }

    protected Vector getAllBurstParamInfos(Hashtable hashtable, ReportInfo reportInfo, BurstingSchemaInfo burstingSchemaInfo, String string, int n) {
        if (string != null && string.equalsIgnoreCase("null")) {
            string = null;
        }
        this.schemaInfo = burstingSchemaInfo;
        this.rptInfo = reportInfo;
        Vector vector = new Vector();
        if (this.vAllBurstParams != null && !this.vAllBurstParams.isEmpty()) {
            this.vAllBurstParams.removeAllElements();
        }
        if (this.burstProp != null && this.burstProp.size() > 0) {
            this.burstProp.clear();
        }
        try {
            vector = this.getAllBurstParamVector(this.schemaInfo.getParamInfosForRecipient(), hashtable, n);
            this.getNewBurstParamVector(this.vAllBurstParams, hashtable, n);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return this.sort(this.burstProp, vector);
    }

    protected Vector getAllBurstParamVector(Vector vector, Hashtable hashtable, int n) {
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        if (this.vAllBurstParams == null) {
            this.vAllBurstParams = new Vector();
        }
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            ParamInfo paramInfo = (ParamInfo)vector.elementAt(i);
            vector2.add(paramInfo.getName());
            this.vAllBurstParams.addElement(paramInfo);
            if (!paramInfo.isParameters()) continue;
            String string = null;
            if (hashtable != null) {
                string = (String)hashtable.get("jrs.recipient_param$" + paramInfo.getName());
            }
            Vector vector3 = paramInfo.getValueOptions(Locale.getDefault());
            if (hashtable.get("burstflag") != null && !hashtable.get("burstflag").toString().equals("bursttextobj")) {
                boolean bl = false;
                for (int j = 0; j < vector3.size(); ++j) {
                    String string2 = (String)vector3.get(j);
                    if (!string2.equalsIgnoreCase(string)) continue;
                    bl = true;
                }
                if (!bl) {
                    string = null;
                }
            }
            try {
                this.getAllBurstParamVector(this.schemaInfo.getParamInfosByValueForRecipient(paramInfo.getName(), string, this.rptInfo.getParamEngineId(n)), hashtable, n);
                continue;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector2;
    }

    protected void getNewBurstParamVector(Vector vector, Hashtable hashtable, int n) {
        Object object;
        if (vector == null || vector.isEmpty()) {
            return;
        }
        if (this.burstProp == null) {
            this.burstProp = new Properties();
        }
        Object object2 = null;
        String string = (String)hashtable.get("change_value");
        for (int i = 0; i < vector.size(); ++i) {
            object = (ParamInfo)vector.elementAt(i);
            this.burstProp.put(object.getName(), object);
            if (!object.getName().equals(string)) continue;
            object2 = object;
        }
        if (string != null && string.length() > 0 && object2.isReferedBy()) {
            String string2 = null;
            if (hashtable != null) {
                string2 = (String)hashtable.get("jrs.recipient_param$" + object2.getName());
            }
            object = object2.getValueOptions(Locale.getDefault());
            if (object2.isColumn()) {
                if (!((Vector)object).contains(string2)) {
                    string2 = null;
                }
            } else if (hashtable.get("flag") != null && !hashtable.get("flag").toString().equals("textobj")) {
                boolean bl = false;
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    String string3 = (String)((Vector)object).get(i);
                    if (!string3.equalsIgnoreCase(string2)) continue;
                    bl = true;
                }
                if (!bl) {
                    string2 = null;
                }
            }
            try {
                this.getChangeBurstParam(this.schemaInfo.getParamInfosByValueForRecipient(object2.getName(), string2, this.rptInfo.getParamEngineId(n)));
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    protected void getChangeBurstParam(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        if (this.burstProp == null) {
            this.burstProp = new Properties();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ParamInfo paramInfo = (ParamInfo)vector.elementAt(i);
            this.burstProp.put(paramInfo.getName(), paramInfo);
        }
    }

    protected String getPromptText(Vector vector, ParamInfo paramInfo) {
        String string = null;
        if (!paramInfo.isCascading()) {
            string = paramInfo.getPrompt();
            if (string == null || string.trim().length() == 0) {
                string = paramInfo.getName();
            }
        } else {
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                Object object;
                String string2;
                int n;
                Object object2 = (ParamInfo)vector.get(i);
                if (object2 != paramInfo) continue;
                for (n = i; n > 0; --n) {
                    string2 = object2.getPreviousLevel();
                    object = (ParamInfo)vector.get(n - 1);
                    if (string2 == null || string2.length() == 0 || !object.getName().equals(string2)) break;
                    object2 = object;
                }
                do {
                    string2 = object2.getPrompt();
                    boolean bl2 = bl = bl || string2 == null || string2.length() == 0;
                    if (!object2.isSetAsParameter()) continue;
                    string = string == null ? object2.getName() : string + "/" + object2.getName();
                } while ((object = object2.getNextLevel()) != null && ((String)object).length() > 0 && ++n < vector.size() && (object2 = (ParamInfo)vector.get(n)).getName().equals(object));
                break;
            }
            if (bl) {
                String string3 = paramInfo.getPreviousLevel();
                if (string3 != null && string3.length() > 0) {
                    string = null;
                }
            } else {
                string = paramInfo.getPrompt();
            }
        }
        return string;
    }
}

