/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman;

import guitools.toolkit.JDebug;
import java.io.IOException;
import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;
import jet.cs.EncodeExProperties;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.log.ServiceLogger;
import jet.server.userman.PermissionImpl;
import jet.server.userman.Permissions;
import jet.server.userman.Realm;

public class AclEntryImpl
implements AclEntry {
    protected boolean bNegative = false;
    protected String user = null;
    protected Vector vPermission = new Vector();
    protected String realmName;

    public AclEntryImpl() {
    }

    public AclEntryImpl(String string) {
        this.user = string;
    }

    public synchronized void setRealmName(String string) {
        this.realmName = string;
    }

    public synchronized boolean setPrincipal(Principal principal) {
        if (this.user != null) {
            return false;
        }
        this.user = principal.getName();
        return true;
    }

    public synchronized Principal getPrincipal() {
        Object object = null;
        Realm realm = null;
        try {
            realm = Realm.get(this.realmName);
            object = realm.getUser(this.user);
            return object;
        }
        catch (NoSuchUserException noSuchUserException) {
            try {
                object = realm.getGroup(this.user);
                return object;
            }
            catch (NoSuchGroupException noSuchGroupException) {
                ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return null;
    }

    public synchronized String getNotExistInRealmPrincipalName() {
        if (this.getPrincipal() == null && this.user != null) {
            return this.user;
        }
        return null;
    }

    public synchronized void setNegativePermissions() {
        this.bNegative = true;
    }

    public synchronized boolean isNegative() {
        return this.bNegative;
    }

    public synchronized boolean addPermission(Permission permission) {
        for (int i = 0; i < this.vPermission.size(); ++i) {
            Permission permission2 = (Permission)this.vPermission.elementAt(i);
            if (!permission2.equals(permission)) continue;
            return false;
        }
        this.vPermission.addElement(permission);
        return true;
    }

    public synchronized boolean removePermission(Permission permission) {
        for (int i = 0; i < this.vPermission.size(); ++i) {
            Permission permission2 = (Permission)this.vPermission.elementAt(i);
            if (!permission2.equals(permission)) continue;
            this.vPermission.removeElement(permission2);
            return true;
        }
        return false;
    }

    public synchronized boolean checkPermission(Permission permission) {
        for (int i = 0; i < this.vPermission.size(); ++i) {
            Permission permission2 = (Permission)this.vPermission.elementAt(i);
            if (!permission2.equals(permission)) continue;
            return true;
        }
        return false;
    }

    public synchronized Enumeration permissions() {
        return ((Vector)this.vPermission.clone()).elements();
    }

    public synchronized Object clone() {
        AclEntryImpl aclEntryImpl = new AclEntryImpl(this.user);
        if (this.bNegative) {
            aclEntryImpl.setNegativePermissions();
        }
        for (int i = 0; i < this.vPermission.size(); ++i) {
            Permission permission = (Permission)this.vPermission.elementAt(i);
            aclEntryImpl.addPermission(permission);
        }
        return aclEntryImpl;
    }

    public String toString() {
        return "AclEntryImpl:" + this.hashCode() + " " + this.user + "," + this.bNegative;
    }

    public void dump() {
        String string = "" + this;
        string = string + "\n  user:" + this.user;
        string = string + "\n  permissions:" + this.vPermission;
        JDebug.INFO((String)string);
    }

    public synchronized void save(EncodeExProperties encodeExProperties, String string) throws IOException {
        encodeExProperties.setProperty(string + "negative", this.bNegative);
        encodeExProperties.setProperty(string + "user", this.user);
        encodeExProperties.setProperty(string + "permission.count", this.vPermission.size());
        for (int i = 0; i < this.vPermission.size(); ++i) {
            encodeExProperties.setProperty(string + "permission." + i, ((PermissionImpl)this.vPermission.elementAt(i)).getName());
        }
    }

    public synchronized void load(EncodeExProperties encodeExProperties, String string) throws IOException {
        this.bNegative = encodeExProperties.getProperty(string + "negative", false);
        this.user = encodeExProperties.getProperty(string + "user", "");
        int n = encodeExProperties.getProperty(string + "permission.count", 0);
        for (int i = 0; i < n; ++i) {
            PermissionImpl permissionImpl;
            String string2 = encodeExProperties.getProperty(string + "permission." + i, "");
            if (string2.length() <= 0 || (permissionImpl = Permissions.getPermission(string2)) == null) continue;
            this.vPermission.addElement(permissionImpl);
        }
    }
}

