/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman;

import guitools.toolkit.JDebug;
import java.io.File;
import java.security.Principal;
import java.security.acl.Group;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jet.cs.EncodeExProperties;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.db.Connector;
import jet.server.db.DataTable;
import jet.server.db.core.ConnectorManager;
import jet.server.db.factory.HSQLDataTableFactory;
import jet.server.db.security.RoleTableImpl;
import jet.server.db.security.UserProfileTableImpl;
import jet.server.db.security.UserTableImpl;
import jet.server.jrc.security.SharedPasswordRealm2;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.userman.AuditInfo;
import jet.server.userman.PasswordInfo;
import jet.server.userman.Realm;
import jet.server.userman.SharedPasswordRealm;
import jet.server.userman.User;
import jet.server.userman.UserImpl;
import jet.server.util.ServerUtil;

public class OldDataLoader {
    public String oldDataURL = "";
    public String newDataURL = "";
    public String newDataBaseURL = "";
    public Vector newRealmName = new Vector();

    public OldDataLoader(String string, String string2) {
        this.oldDataURL = string.endsWith(File.separator) ? string + "realm" : string + File.separator + "realm";
        if (string2.endsWith(File.separator)) {
            this.newDataURL = string2 + "realm";
            this.newDataBaseURL = string2 + "properties";
        } else {
            this.newDataURL = string2 + File.separator + "realm";
            this.newDataBaseURL = string2 + File.separator + "properties";
        }
    }

    private void I() {
        File file;
        String[] stringArray;
        JDebug.INFO((String)"Loading security data files...");
        Realm.clearAll();
        if (!this.oldDataURL.endsWith(File.separator)) {
            this.oldDataURL = this.oldDataURL + File.separator;
        }
        if ((stringArray = (file = new File(this.oldDataURL)).list()) != null && stringArray.length > 0) {
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!new File(this.oldDataURL + stringArray[i]).isDirectory()) continue;
                    SharedPasswordRealm sharedPasswordRealm = new SharedPasswordRealm("");
                    sharedPasswordRealm.loadOld(this.oldDataURL, this.oldDataURL + stringArray[i] + File.separator + "realm.properties");
                    Realm.add(sharedPasswordRealm);
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JDebug.INFO((String)"Loading property files failed!  Using default...");
    }

    private void INFO() {
        File file;
        String[] stringArray;
        JDebug.INFO((String)"Loading security data files...");
        if (!this.newDataURL.endsWith(File.separator)) {
            this.newDataURL = this.newDataURL + File.separator;
        }
        if ((stringArray = (file = new File(this.newDataURL)).list()) != null && stringArray.length > 0) {
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!new File(this.newDataURL + stringArray[i]).isDirectory()) continue;
                    String string = this.newDataURL + stringArray[i] + File.separator + "realm.properties";
                    EncodeExProperties encodeExProperties = new EncodeExProperties();
                    encodeExProperties.load(new File(string));
                    String string2 = encodeExProperties.getProperty("name", "");
                    if (this.newRealmName.contains(string2)) continue;
                    this.newRealmName.add(string2);
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Enumeration J() {
        return Realm.getRealmNames();
    }

    private Enumeration getAllGroups(Realm realm) throws BadRealmException {
        return realm.getGroups();
    }

    private Enumeration SEDU(Group group) {
        Enumeration enumeration = group.members();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            Principal principal = (Principal)enumeration.nextElement();
            String string = principal.getName();
            if (!(principal instanceof User)) continue;
            vector.addElement(string);
        }
        Enumeration enumeration2 = vector.elements();
        return enumeration2;
    }

    private DataTable Z(String string) {
        Properties properties = new Properties();
        properties.put("driver", "org.hsqldb.jdbcDriver");
        properties.put("url", "jdbc:hsqldb:" + this.newDataBaseURL + File.separator + "systable." + string);
        properties.put("user", "sa");
        properties.put("password", "");
        Connector connector = ConnectorManager.newInstance().getConnector(properties);
        DataTable dataTable = new HSQLDataTableFactory().createDataTable(connector);
        return dataTable;
    }

    public void loadSecurityData() throws SQLException, ClassNotFoundException, NoSuchRealmException, NoSuchGroupException, NoSuchUserException, BadRealmException {
        this.I();
        this.INFO();
        RoleTableImpl roleTableImpl = null;
        UserTableImpl userTableImpl = null;
        UserProfileTableImpl userProfileTableImpl = null;
        Enumeration enumeration = this.J();
        while (enumeration.hasMoreElements()) {
            Object object;
            DataTable dataTable;
            Object object2;
            String string = (String)enumeration.nextElement();
            Realm realm = Realm.get(string);
            int n = realm.getScheme();
            if (this.newRealmName.contains(string)) {
                object2 = this.Z(string);
                roleTableImpl = RoleTableImpl.newInstance((DataTable)object2);
                dataTable = this.Z(string);
                userTableImpl = UserTableImpl.newInstance(dataTable);
                object = this.Z(string);
                userProfileTableImpl = UserProfileTableImpl.newInstance((DataTable)object);
            } else {
                this.add(string, n);
                System.out.println("Adding realm " + string + " to new system!");
                object2 = this.Z(string);
                roleTableImpl = RoleTableImpl.newInstance((DataTable)object2);
                dataTable = this.Z(string);
                userTableImpl = UserTableImpl.newInstance(dataTable);
                object = this.Z(string);
                userProfileTableImpl = UserProfileTableImpl.newInstance((DataTable)object);
            }
            object2 = this.getAllGroups(realm);
            while (object2.hasMoreElements()) {
                dataTable = (Group)object2.nextElement();
                object = dataTable.getName();
                boolean bl = false;
                if (((String)object).equals("administrators") || ((String)object).equals("everyone")) {
                    bl = true;
                }
                if (roleTableImpl.getRole((String)object) == null) {
                    System.out.println("Adding group:" + (String)object + " to new system!");
                    roleTableImpl.addRecord((String)object, "RoleRoot", bl, "OldSecurityLoad");
                }
                Enumeration enumeration2 = this.SEDU((Group)dataTable);
                while (enumeration2.hasMoreElements()) {
                    String string2 = (String)enumeration2.nextElement();
                    SharedPasswordRealm sharedPasswordRealm = (SharedPasswordRealm)Realm.get(string);
                    UserImpl userImpl = (UserImpl)sharedPasswordRealm.getUser(string2);
                    PasswordInfo passwordInfo = userImpl.passwordInfo;
                    AuditInfo auditInfo = userImpl.auditInfo;
                    boolean bl2 = false;
                    if (string2.equals("admin") || string2.equals("guest")) {
                        bl2 = true;
                    }
                    if (userTableImpl.getUserRecordbyUN(string2) == null) {
                        System.out.println("Adding user:" + string2 + " to new system!");
                        userTableImpl.addRecord(string2, userImpl.getFullname(), userImpl.getDescription(), userImpl.getEmail(), new Date(System.currentTimeMillis()), ServerUtil.encode((String)userImpl.getAuthInfo()), bl2, passwordInfo.bPermitBlank, passwordInfo.iMinLength, new Date(passwordInfo.timeLastModify), passwordInfo.bNeverExpire, passwordInfo.iExpireTime, userImpl.bDisabled, auditInfo.bAccessSuccess, auditInfo.bAccessFail, auditInfo.bManageSuccess, auditInfo.bManageFail, auditInfo.bNoAudit, 0, 0);
                    }
                    if (userProfileTableImpl.getRecord(string2, (String)object) != null) continue;
                    userProfileTableImpl.addRecord(string2, (String)object);
                }
            }
        }
        roleTableImpl.close();
        userTableImpl.close();
        userProfileTableImpl.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String add(String string, int n) throws BadRealmException {
        if (string == null || string.trim().equals("")) {
            return "realm name is blank";
        }
        if (!this.newDataURL.endsWith(File.separator)) {
            this.newDataURL = this.newDataURL + File.separator;
        }
        if (!UserDataToolkit.isValidName(string)) {
            return "Invalid realm name. Valid name can contains only \"_0-9a-zA-Z\"";
        }
        Class<Realm> clazz = Realm.class;
        synchronized (Realm.class) {
            try {
                jet.server.jrc.security.Realm.get(string);
            }
            catch (NoSuchRealmException noSuchRealmException) {
                SharedPasswordRealm2 sharedPasswordRealm2 = new SharedPasswordRealm2(this.newDataURL, string);
                sharedPasswordRealm2.setScheme(n);
                jet.server.jrc.security.Realm.add(sharedPasswordRealm2);
                sharedPasswordRealm2.oldSave(this.newDataURL);
            }
            return null;
        }
    }

    private static void addElement() {
        System.out.println("java OldDataLoader oldJRHome newJRHome");
        System.out.println("For Example:");
        System.out.println("java OldDataLoader C:" + File.separator + "OldJREntServer C:" + File.separator + "NewJREntServer");
    }
}

