/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman;

import guitools.toolkit.JDebug;
import java.io.File;
import java.io.IOException;
import java.security.acl.Group;
import java.util.Vector;
import jet.cs.EncodeExProperties;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.log.ServiceLogger;
import jet.server.userman.AuditInfo;
import jet.server.userman.PasswordInfo;
import jet.server.userman.Realm;
import jet.server.userman.User;

public class UserImpl
implements User {
    private String INFO = "";
    private String SEDU = "";
    private String addElement = "";
    private String append = "";
    boolean bDisabled = false;
    long timeCreation;
    public PasswordInfo passwordInfo = new PasswordInfo();
    public AuditInfo auditInfo = new AuditInfo();
    private Vector contains = new Vector();
    private String currentTimeMillis;
    private String elementAt = "";
    private boolean exists = false;
    private boolean get = false;

    public UserImpl() {
        this("", "");
    }

    public UserImpl(String string) {
        this(string, "");
    }

    public UserImpl(String string, String string2) {
        this.timeCreation = System.currentTimeMillis();
        this.INFO = string;
        try {
            this.setAuthInfo(string2);
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError((Throwable)((Object)badRealmException), 3);
        }
        if (!this.contains.contains("everyone")) {
            this.contains.addElement("everyone");
        }
    }

    public boolean getLdapFlag() {
        return this.get;
    }

    public void setLdapFlag(boolean bl) {
        this.get = bl;
    }

    public synchronized String getFullname() {
        return this.SEDU == null ? "" : this.SEDU;
    }

    public synchronized void setFullname(String string) {
        this.SEDU = string;
    }

    public synchronized String getDescription() {
        return this.addElement == null ? "" : this.addElement;
    }

    public synchronized void setDescription(String string) {
        this.addElement = string;
    }

    public synchronized String getEmail() {
        return this.append == null ? "" : this.append;
    }

    public synchronized void setEmail(String string) {
        this.append = string;
    }

    public boolean isAdministrator() {
        return this.exists;
    }

    public void setAdministrator() {
        this.exists = true;
    }

    public synchronized String getHomePath() {
        return this.elementAt;
    }

    public synchronized void setHomePath(String string) {
        this.elementAt = string;
    }

    public synchronized void insertIntoGroup(Group group) {
        if (this.contains.contains(group.getName())) {
            return;
        }
        this.contains.addElement(group.getName());
    }

    public synchronized void removeFromGroup(Group group) {
        if (!this.contains.contains(group.getName())) {
            return;
        }
        this.contains.removeElement(group.getName());
    }

    public synchronized Vector getParentGroups() {
        return this.contains;
    }

    public synchronized void setName(String string) {
        this.INFO = string;
    }

    @Override
    public synchronized String getName() {
        return this.INFO;
    }

    public synchronized void setRealm(Realm realm) {
        this.currentTimeMillis = realm.getName();
    }

    public synchronized void setRealmName(String string) {
        this.currentTimeMillis = string;
    }

    @Override
    public synchronized Realm getRealm() {
        try {
            return Realm.get(this.currentTimeMillis);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized String getRealmName() {
        return this.currentTimeMillis;
    }

    @Override
    public synchronized Object getAuthInfo() throws NoSuchUserException {
        return this.passwordInfo.getName();
    }

    @Override
    public synchronized void setAuthInfo(Object object) throws BadRealmException {
        this.passwordInfo.setName((String)object);
    }

    @Override
    public synchronized Object getAttribute(String string) {
        return null;
    }

    @Override
    public synchronized Object[] getAttributes(String[] stringArray) {
        return null;
    }

    @Override
    public synchronized void setAttributes(String[] stringArray, Object[] objectArray) {
    }

    public void setDisabled(boolean bl) {
        this.bDisabled = bl;
    }

    public boolean isDisabled() {
        return this.bDisabled;
    }

    @Override
    public String toString() {
        return "UserImpl@" + this.hashCode() + " " + this.INFO;
    }

    public void dump() {
        String string = this + "\n  Realm:" + this.currentTimeMillis + "\n  Groups:" + this.contains;
        JDebug.INFO((String)string);
    }

    public synchronized boolean load(String string) {
        this.elementAt = string;
        File file = new File(string + File.separator + "account.properties");
        if (!file.exists()) {
            return false;
        }
        try {
            EncodeExProperties encodeExProperties = new EncodeExProperties();
            encodeExProperties.load(file);
            this.INFO = encodeExProperties.getProperty("name", "");
            this.SEDU = encodeExProperties.getProperty("fullname", "");
            this.addElement = encodeExProperties.getProperty("description", "");
            this.append = encodeExProperties.getProperty("email", "");
            this.exists = encodeExProperties.getProperty("administrator", false);
            this.bDisabled = encodeExProperties.getProperty("disabled", false);
            this.timeCreation = encodeExProperties.getProperty("creation", 0L);
            int n = encodeExProperties.getProperty("group.count", 0);
            for (int i = 0; i < n; ++i) {
                String string2 = encodeExProperties.getProperty("group." + i, "");
                if (string2.length() <= 0) continue;
                this.contains.addElement(string2);
            }
            this.passwordInfo.load(encodeExProperties, "password.");
            this.auditInfo.load(encodeExProperties, "");
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public synchronized EncodeExProperties getProperties() throws IOException {
        EncodeExProperties encodeExProperties = new EncodeExProperties();
        encodeExProperties.setProperty("name", this.getName());
        encodeExProperties.setProperty("fullname", this.getFullname());
        encodeExProperties.setProperty("description", this.getDescription());
        encodeExProperties.setProperty("email", this.getEmail());
        encodeExProperties.setProperty("administrator", this.isAdministrator());
        encodeExProperties.setProperty("disabled", this.bDisabled);
        encodeExProperties.setProperty("creation", this.timeCreation);
        encodeExProperties.setProperty("group.count", this.contains.size());
        for (int i = 0; i < this.contains.size(); ++i) {
            encodeExProperties.setProperty("group." + i, (String)this.contains.elementAt(i));
        }
        this.passwordInfo.write(encodeExProperties, "password.");
        this.auditInfo.write(encodeExProperties, "");
        return encodeExProperties;
    }

    public synchronized void save() {
        try {
            EncodeExProperties encodeExProperties = this.getProperties();
            File file = new File(this.elementAt);
            if (!file.exists()) {
                file.mkdirs();
            }
            encodeExProperties.save(this.elementAt + File.separator + "account.properties", "");
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }
}

