/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import jet.server.api.admin.cfg.ConfigurationLDAPServer;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.ldap.LDAPConnectionImpl;
import jet.server.jrc.security.ldap.LDAPData;
import jet.server.jrc.security.ldap.LDAPEnvironments;
import jet.server.jrc.security.ldap.intf.LDAPGroup;
import jet.server.jrc.security.ldap.intf.LDAPManager;
import jet.server.jrc.security.ldap.intf.LDAPUser;
import jet.server.jrc.security.ldap.intf.RoleMap;
import jet.server.log.ServiceLogger;

public final class LDAPSetting {
    public String settingName;
    public boolean enableNoneImportLDAPSupport;
    public boolean enableLDAPSupport;
    public String LDAPVersionNum;
    public boolean autoImportedLDAPUser;
    public String LDAPURL;
    public String LDAPServerPort;
    public String LDAPRootEntry;
    public boolean isUsingSSL;
    public String importLDAPGroupType;
    public String LDAPDN;
    public String LDAPPW;
    public boolean isRememberPW;
    public String encryptionType;
    public String userSchemaName;
    public String userSchemaCommon;
    public boolean userSchemaEnableSAN;
    public String userSchemaSAN;
    public String userSchemaPW;
    public String userSchemaDN;
    public String userSchemaFilter;
    public String groupSchemaCommon;
    public boolean groupSchemaEnableSAN;
    public String groupSchemaSAN;
    public String groupSchemaType;
    public String groupSchemaDN;
    public String groupSchemaFilter;
    public String groupSchemaAdmin;

    public void updateSetting(ConfigurationLDAPServer configurationLDAPServer, String string) {
        this.enableNoneImportLDAPSupport = configurationLDAPServer.isEnableNoneImportedLDAPSupport();
        this.enableLDAPSupport = configurationLDAPServer.isLdapEnable();
        this.LDAPVersionNum = configurationLDAPServer.getLDAPVersion();
        this.autoImportedLDAPUser = configurationLDAPServer.isImportUserUponAuthentication();
        this.settingName = string;
        this.LDAPURL = configurationLDAPServer.getLDAPURL();
        this.LDAPServerPort = configurationLDAPServer.getLADPServerPort() >= 0 && configurationLDAPServer.getLADPServerPort() <= 65535 ? String.valueOf(configurationLDAPServer.getLADPServerPort()) : "";
        this.LDAPRootEntry = configurationLDAPServer.getRoot();
        this.isUsingSSL = configurationLDAPServer.isEncryptionInLayer();
        this.importLDAPGroupType = configurationLDAPServer.getImportGroupType();
        this.LDAPDN = configurationLDAPServer.getDirectoryManagerDN();
        this.LDAPPW = configurationLDAPServer.getPassword();
        this.isRememberPW = false;
        this.userSchemaName = configurationLDAPServer.getUserAttributeName();
        this.userSchemaCommon = configurationLDAPServer.getUserCommonName();
        this.userSchemaEnableSAN = configurationLDAPServer.isUserEnableSAN();
        this.userSchemaSAN = configurationLDAPServer.getUserSAN();
        this.userSchemaDN = configurationLDAPServer.getUserDistinguishName();
        this.userSchemaFilter = configurationLDAPServer.getUserFilter();
        this.userSchemaPW = configurationLDAPServer.getUserPassword();
        this.groupSchemaCommon = configurationLDAPServer.getGroupCommonName();
        this.groupSchemaEnableSAN = configurationLDAPServer.isGroupEnableSAN();
        this.groupSchemaSAN = configurationLDAPServer.getGroupSAN();
        this.groupSchemaDN = configurationLDAPServer.getGroupDistinguishName();
        this.groupSchemaFilter = configurationLDAPServer.getGroupFilter();
        this.groupSchemaType = configurationLDAPServer.getGroupMemberType();
        this.groupSchemaAdmin = configurationLDAPServer.getAdminGroup();
    }

    public String saveLDAPSettings(ConfigurationLDAPServer configurationLDAPServer) {
        StringBuffer stringBuffer = new StringBuffer();
        configurationLDAPServer.getProperties();
        stringBuffer.append(String.valueOf(configurationLDAPServer.isEnableNoneImportedLDAPSupport())).append(String.valueOf(configurationLDAPServer.isLdapEnable())).append(configurationLDAPServer.getLDAPVersion()).append(String.valueOf(configurationLDAPServer.isImportUserUponAuthentication())).append(configurationLDAPServer.getLDAPURL()).append(String.valueOf(configurationLDAPServer.getLADPServerPort())).append(configurationLDAPServer.getDirectoryManagerDN()).append(configurationLDAPServer.getPassword()).append(configurationLDAPServer.getRoot()).append(String.valueOf(configurationLDAPServer.isEncryptionInLayer())).append(configurationLDAPServer.getImportGroupType()).append(configurationLDAPServer.getUserAttributeName()).append(configurationLDAPServer.getUserCommonName()).append(configurationLDAPServer.isUserEnableSAN()).append(configurationLDAPServer.getUserSAN()).append(configurationLDAPServer.getUserPassword()).append(configurationLDAPServer.getUserDistinguishName()).append(configurationLDAPServer.getUserFilter()).append(configurationLDAPServer.getGroupCommonName()).append(configurationLDAPServer.isGroupEnableSAN()).append(configurationLDAPServer.getGroupSAN()).append(configurationLDAPServer.getGroupMemberType()).append(configurationLDAPServer.getGroupDistinguishName()).append(configurationLDAPServer.getGroupFilter()).append(configurationLDAPServer.getAdminGroup());
        int n = stringBuffer.toString().hashCode();
        if (n == this.storeCharacteristic() && n == this.hashCode()) {
            return "LDAP_M_00001";
        }
        boolean bl = this.enableNoneImportLDAPSupport;
        if (bl) {
            String string = this.groupSchemaAdmin;
            if (string == null || string.length() == 0) {
                return "LDAP_M_00007";
            }
            String string2 = this.LDAPDN(string);
            String string3 = this.LDAPRootEntry();
            if (string2 != null && string3 != null) {
                return string2;
            }
        }
        configurationLDAPServer.setEnableLDAPProviders(this.enableNoneImportLDAPSupport);
        configurationLDAPServer.setLdapEnable(this.enableLDAPSupport);
        configurationLDAPServer.setLDAPVersion(this.LDAPVersionNum);
        configurationLDAPServer.setImportUserUponAuthentication(this.autoImportedLDAPUser);
        configurationLDAPServer.setLDAPURL(this.LDAPURL);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(this.LDAPServerPort);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        configurationLDAPServer.setLADPServerPort(n2);
        configurationLDAPServer.setRoot(this.LDAPRootEntry);
        configurationLDAPServer.setEncryptionInLayer(this.isUsingSSL);
        configurationLDAPServer.setImportGroupType(this.importLDAPGroupType);
        configurationLDAPServer.setDirectoryManagerDN(this.LDAPDN);
        configurationLDAPServer.setPassword(this.LDAPPW);
        configurationLDAPServer.setUserAttributeName(this.userSchemaName);
        configurationLDAPServer.setUserCommonName(this.userSchemaCommon);
        configurationLDAPServer.setUserEnableSAN(this.userSchemaEnableSAN);
        configurationLDAPServer.setUserSAN(this.userSchemaSAN);
        configurationLDAPServer.setUserPassword(this.userSchemaPW);
        configurationLDAPServer.setUserDistinguishName(this.userSchemaDN);
        configurationLDAPServer.setUserFilter(this.userSchemaFilter);
        configurationLDAPServer.setGroupCommonName(this.groupSchemaCommon);
        configurationLDAPServer.setGroupEnableSAN(this.groupSchemaEnableSAN);
        configurationLDAPServer.setGroupSAN(this.groupSchemaSAN);
        configurationLDAPServer.setGroupMemberType(this.groupSchemaType);
        configurationLDAPServer.setGroupDistinguishName(this.groupSchemaDN);
        configurationLDAPServer.setAdminGroup(this.groupSchemaAdmin);
        configurationLDAPServer.setGroupFilter(this.groupSchemaFilter);
        try {
            configurationLDAPServer.saveProperties();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return "LDAP_M_00002";
        }
        return "LDAP_M_00003";
    }

    private String LDAPDN(String string) {
        LDAPEnvironments lDAPEnvironments = new LDAPEnvironments(this.toProperties());
        LDAPConnectionImpl lDAPConnectionImpl = new LDAPConnectionImpl(lDAPEnvironments);
        lDAPConnectionImpl.connect();
        Hashtable hashtable = new Hashtable();
        try {
            hashtable = lDAPConnectionImpl.getAllLDAPGroups();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException, 3);
            return "LDAP_M_00004";
        }
        LDAPGroup lDAPGroup = (LDAPGroup)hashtable.get(string);
        if (lDAPGroup == null) {
            return "LDAP_M_00008";
        }
        Vector vector = new Vector();
        if ((vector = this.LDAPPW(hashtable, string, vector)).size() == 0) {
            return "LDAP_M_00009";
        }
        return null;
    }

    private Vector LDAPPW(Hashtable hashtable, String string, Vector vector) {
        LDAPGroup lDAPGroup = (LDAPGroup)hashtable.get(string);
        if (lDAPGroup == null) {
            return vector;
        }
        int n = 0;
        Vector vector2 = lDAPGroup.getUserNames();
        if (n < vector2.size()) {
            String string2 = (String)vector2.elementAt(n);
            vector.add(string2);
            return vector;
        }
        Vector vector3 = lDAPGroup.getSubGroupNames();
        for (int i = 0; i < vector3.size(); ++i) {
            String string3 = (String)vector3.elementAt(i);
            this.LDAPPW(hashtable, string3, vector);
        }
        return vector;
    }

    private String LDAPRootEntry() {
        Object object;
        LDAPManager lDAPManager = UserDataToolkit.getLdapManager();
        Vector vector = lDAPManager.getRoleMaps();
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (RoleMap)enumeration.nextElement();
            String string = object.getRoleName();
            if (!string.equals("administrators")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return "LDAP_M_00005";
        }
        bl = false;
        object = new Vector();
        try {
            object = lDAPManager.getAllLDAPUsers();
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
        }
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            LDAPUser lDAPUser = (LDAPUser)((Vector)object).elementAt(i);
            String string = lDAPUser.getName();
            Vector vector2 = lDAPManager.getRoleNamsByFilter(string);
            if (!vector2.contains("administrators")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return "LDAP_M_00006";
        }
        return null;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.put("Current Settings", this.settingName);
        properties.put("enableNoneImportedLDAPSupport", String.valueOf(this.enableNoneImportLDAPSupport));
        properties.put("enableLDAPSupport", String.valueOf(this.enableLDAPSupport));
        properties.put("ldapVersion", this.LDAPVersionNum);
        properties.put("enableAutoImportLDAPUser", String.valueOf(this.autoImportedLDAPUser));
        properties.put("ldaprealm.remember_password", String.valueOf(this.isRememberPW));
        properties.put("url", this.LDAPURL);
        properties.put("serverPort", this.LDAPServerPort);
        properties.put("rootEntry", this.LDAPRootEntry);
        properties.put("isUsingSSL", String.valueOf(this.isUsingSSL));
        properties.put("importGroupType", this.importLDAPGroupType);
        properties.put("directoryManagerDN", this.LDAPDN);
        properties.put("password", this.LDAPPW);
        properties.put("userAN", this.userSchemaName);
        properties.put("userCN", this.userSchemaCommon);
        properties.put("userEnableSAN", String.valueOf(this.userSchemaEnableSAN));
        properties.put("userSAN", this.userSchemaSAN);
        properties.put("userPassword", this.userSchemaPW);
        properties.put("userDN", this.userSchemaDN);
        properties.put("userFilter", this.userSchemaFilter);
        properties.put("groupCN", this.groupSchemaCommon);
        properties.put("groupEnableSAN", String.valueOf(this.groupSchemaEnableSAN));
        properties.put("groupSAN", this.groupSchemaSAN);
        properties.put("groupMemberType", this.groupSchemaType);
        properties.put("groupDN", this.groupSchemaDN);
        properties.put("groupFilter", this.groupSchemaFilter);
        properties.put("groupAdminGroup", this.groupSchemaAdmin);
        return properties;
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.enableNoneImportLDAPSupport)).append(String.valueOf(this.enableLDAPSupport)).append(this.LDAPVersionNum).append(String.valueOf(this.autoImportedLDAPUser)).append(this.LDAPURL).append(String.valueOf(this.LDAPServerPort)).append(this.LDAPDN).append(this.LDAPPW).append(this.LDAPRootEntry).append(String.valueOf(this.isUsingSSL)).append(this.importLDAPGroupType).append(this.userSchemaName).append(this.userSchemaCommon).append(String.valueOf(this.userSchemaEnableSAN)).append(this.userSchemaSAN).append(this.userSchemaPW).append(this.userSchemaDN).append(this.userSchemaFilter).append(this.groupSchemaCommon).append(String.valueOf(this.groupSchemaEnableSAN)).append(this.groupSchemaSAN).append(this.groupSchemaType).append(this.groupSchemaDN).append(this.groupSchemaFilter).append(this.groupSchemaAdmin);
        String string = stringBuffer.toString();
        return string.hashCode();
    }

    public int storeCharacteristic() {
        Hashtable hashtable = LDAPData.getLDAPProperties();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(hashtable.get("enableNoneImportedLDAPSupport")).append(hashtable.get("enableLDAPSupport")).append(hashtable.get("ldapVersion")).append(hashtable.get("enableAutoImportLDAPUser")).append(hashtable.get("url")).append(hashtable.get("serverPort")).append(hashtable.get("directoryManagerDN")).append(hashtable.get("password")).append(hashtable.get("rootEntry")).append(hashtable.get("isUsingSSL")).append(hashtable.get("importGroupType")).append(hashtable.get("userAN")).append(hashtable.get("userCN")).append(hashtable.get("userEnableSAN")).append(hashtable.get("userSAN")).append(hashtable.get("userPassword")).append(hashtable.get("userDN")).append(hashtable.get("userFilter")).append(hashtable.get("groupCN")).append(hashtable.get("groupEnableSAN")).append(hashtable.get("groupSAN")).append(hashtable.get("groupMemberType")).append(hashtable.get("groupDN")).append(hashtable.get("groupFilter")).append(hashtable.get("groupAdminGroup"));
        String string = stringBuffer.toString();
        return string.hashCode();
    }
}

