/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman.ldap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import jet.server.jrc.security.RoleImpl;
import jet.server.jrc.security.UserImpl;
import jet.server.log.ServiceLogger;
import jet.server.userman.GroupImpl;
import jet.server.userman.ldap.LdapEnvironments;
import jet.server.userman.ldap.LdapGroup;
import jet.server.userman.ldap.LdapToolkit;
import jet.server.userman.ldap.LdapUser;

public class LdapConnection {
    private static LdapContext SEDU = null;
    private static LdapEnvironments Z = null;

    public LdapConnection() {
    }

    public LdapConnection(LdapEnvironments ldapEnvironments) {
        try {
            Z = ldapEnvironments;
            SEDU = new InitialLdapContext(ldapEnvironments, null);
        }
        catch (NamingException namingException) {
            SEDU = null;
        }
    }

    public static boolean reconnect(String string) {
        try {
            Z.replaceEnvironments("java.naming.provider.url", string);
            SEDU = new InitialLdapContext(Z, null);
        }
        catch (NamingException namingException) {
            return false;
        }
        return true;
    }

    public static boolean reconnect(LdapEnvironments ldapEnvironments) {
        try {
            SEDU = new InitialLdapContext(ldapEnvironments, null);
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return false;
        }
        return true;
    }

    public static LdapContext getLdapContext() {
        return SEDU;
    }

    public Enumeration getGroupNames() {
        Vector<String> vector = new Vector<String>();
        Vector[] vectorArray = this.getGroups();
        if (vectorArray == null) {
            return null;
        }
        for (int i = 0; i < vectorArray[0].size(); ++i) {
            vector.add(((GroupImpl)vectorArray[0].get(i)).getName());
        }
        return vector.elements();
    }

    public Enumeration getUserNames() {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this.getUsers();
        if (vector2 == null) {
            return null;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            vector.addElement(((UserImpl)vector2.get(i)).getName());
        }
        return vector.elements();
    }

    public Vector getUsers() {
        if (SEDU == null) {
            return new Vector();
        }
        LdapUser ldapUser = new LdapUser();
        try {
            Vector<UserImpl> vector = new Vector<UserImpl>();
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            String string = "";
            string = LdapUser.userFilter.equalsIgnoreCase("") ? "(&(" + LdapUser.userCN + "=*))" : LdapUser.userFilter;
            NamingEnumeration<SearchResult> namingEnumeration = SEDU.search(LdapUser.userDN, string, searchControls);
            while (namingEnumeration.hasMore()) {
                UserImpl userImpl = new UserImpl();
                SearchResult searchResult = namingEnumeration.next();
                ldapUser.setAttributes(searchResult.getAttributes());
                try {
                    userImpl.setName(ldapUser.getName());
                }
                catch (NullPointerException nullPointerException) {
                    return null;
                }
                userImpl.setFullName(ldapUser.getFullname());
                try {
                    LdapToolkit.bCanGetPw = ldapUser.getPassword() != null;
                    userImpl.setPassword(ldapUser.getPassword());
                }
                catch (NullPointerException nullPointerException) {
                    ServiceLogger.logError(nullPointerException, 3);
                }
                try {
                    userImpl.setEmail(ldapUser.getEmail());
                }
                catch (NullPointerException nullPointerException) {
                    ServiceLogger.logError(nullPointerException, 3);
                }
                userImpl.setAccessEventSuc(true);
                userImpl.setAccessEventFail(true);
                userImpl.setManagementEventSuc(true);
                userImpl.setManagementEventFail(true);
                userImpl.setNoAudit(true);
                vector.addElement(userImpl);
            }
            return vector;
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return null;
        }
    }

    public Vector[] getGroups() {
        Vector[] vectorArray = null;
        Vector[] vectorArray2 = new Vector[]{new Vector(), new Vector()};
        if (SEDU == null) {
            return vectorArray2;
        }
        try {
            SearchControls searchControls = new SearchControls();
            LdapGroup ldapGroup = new LdapGroup();
            searchControls.setSearchScope(2);
            String string = "";
            string = LdapGroup.groupFilter.equalsIgnoreCase("") ? "(&(" + LdapGroup.groupCN + "=*))" : LdapGroup.groupFilter;
            NamingEnumeration<SearchResult> namingEnumeration = SEDU.search(LdapGroup.groupDN, string, searchControls);
            while (namingEnumeration.hasMore()) {
                Vector[] vectorArray3 = new Vector[]{new Vector(), new Vector()};
                try {
                    RoleImpl roleImpl = new RoleImpl();
                    SearchResult searchResult = namingEnumeration.next();
                    ldapGroup.setAttributes(searchResult.getAttributes());
                    try {
                        roleImpl.setName(ldapGroup.getName());
                    }
                    catch (NullPointerException nullPointerException) {
                        return null;
                    }
                    roleImpl.setDescription(ldapGroup.getDescription());
                    if (ldapGroup.hasMembers()) {
                        Object object;
                        Object object2;
                        vectorArray = ldapGroup.getMembers();
                        Enumeration enumeration = vectorArray[0].elements();
                        while (enumeration.hasMoreElements()) {
                            object2 = (String)enumeration.nextElement();
                            object = this.getUser((String)object2);
                            vectorArray3[0].add(object);
                        }
                        object2 = vectorArray[1].elements();
                        while (object2.hasMoreElements()) {
                            object = (String)object2.nextElement();
                            RoleImpl roleImpl2 = new RoleImpl((String)object);
                            vectorArray3[1].add(roleImpl2);
                        }
                    }
                    vectorArray2[0].add(roleImpl);
                    vectorArray2[1].add(vectorArray3);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            }
            return vectorArray2;
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException);
            return null;
        }
    }

    public UserImpl getUser(String string) {
        if (SEDU == null) {
            return null;
        }
        LdapUser ldapUser = new LdapUser();
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            String string2 = "";
            string2 = "(&(" + LdapUser.userID + "=" + string + "))";
            NamingEnumeration<SearchResult> namingEnumeration = SEDU.search(LdapUser.userDN, string2, searchControls);
            UserImpl userImpl = new UserImpl();
            SearchResult searchResult = namingEnumeration.next();
            ldapUser.setAttributes(searchResult.getAttributes());
            userImpl.setName(ldapUser.getName());
            userImpl.setFullName(ldapUser.getFullname());
            userImpl.setEmail(ldapUser.getEmail());
            return userImpl;
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException, 3);
        }
        catch (NullPointerException nullPointerException) {
            ServiceLogger.logError(nullPointerException);
        }
        return null;
    }

    public static boolean isValidLdapUser(String string, String string2) {
        Object object;
        Object object2;
        NamingEnumeration<SearchResult> namingEnumeration;
        String string3;
        Object object3;
        Serializable serializable;
        String string4 = "";
        String string5 = null;
        boolean bl = false;
        try {
            serializable = new SearchControls();
            ((SearchControls)serializable).setSearchScope(2);
            object3 = new LdapUser();
            string3 = "(&(" + LdapUser.userID + "=" + string + "))";
            if (SEDU == null) {
                return false;
            }
            namingEnumeration = SEDU.search(LdapUser.userDN, string3, (SearchControls)serializable);
            if (!namingEnumeration.hasMore()) {
                return false;
            }
            object2 = (SearchResult)namingEnumeration.next();
            string4 = ((NameClassPair)object2).getName();
            object = new LdapUser();
            ((LdapUser)object).setAttributes(((SearchResult)object2).getAttributes());
            try {
                string5 = ((LdapUser)object).getPassword();
                if (string5 == null) {
                    bl = false;
                }
                if (string2.equalsIgnoreCase("")) {
                    if (!LdapEnvironments.getProperty("ldaprealm.authentication").equalsIgnoreCase("none")) {
                        return string5.equals("") && string2.equals("");
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                ServiceLogger.logError(nullPointerException, 3);
            }
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException, 3);
        }
        catch (NullPointerException nullPointerException) {
            ServiceLogger.logError(nullPointerException);
        }
        try {
            serializable = new Hashtable();
            object3 = null;
            string3 = "";
            namingEnumeration = "";
            serializable = (Hashtable)Z.clone();
            object2 = LdapEnvironments.getProperty("ldaprealm.scheme.user.distinguish_name");
            namingEnumeration = !((String)object2).equals("") ? string4 + "," + LdapEnvironments.getProperty("ldaprealm.scheme.user.distinguish_name") : string4;
            object = LdapEnvironments.getProperty("ldaprealm.root");
            if (object != null && ((String)object).length() != 0) {
                namingEnumeration = (String)((Object)namingEnumeration) + "," + (String)object;
            }
            ((Hashtable)serializable).put("java.naming.security.principal", namingEnumeration);
            ((Hashtable)serializable).put("java.naming.security.credentials", string2);
            ((Hashtable)serializable).put("java.naming.ldap.version", "2");
            string3 = string3 + LdapEnvironments.getProperty("ldaprealm.url") + ":" + LdapEnvironments.getProperty("ldaprealm.port");
            ((Hashtable)serializable).put("java.naming.provider.url", string3);
            object3 = new InitialLdapContext((Hashtable<?, ?>)serializable, null);
            LdapEnvironments ldapEnvironments = new LdapEnvironments();
            LdapConnection ldapConnection = new LdapConnection(ldapEnvironments);
            UserImpl userImpl = ldapConnection.getUser(string);
            if (userImpl == null) {
                return false;
            }
            bl = true;
        }
        catch (NamingException namingException) {
            ServiceLogger.logDebug(0x46A646, 4);
            return false;
        }
        return bl;
    }

    public static boolean isExistLdapUser(String string) {
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            LdapUser ldapUser = new LdapUser();
            String string2 = "(&(" + LdapUser.userID + "=" + string + "))";
            if (SEDU == null) {
                return false;
            }
            NamingEnumeration<SearchResult> namingEnumeration = SEDU.search(LdapUser.userDN, string2, searchControls);
            return namingEnumeration.hasMore();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    public static void printAttrs(Attributes attributes) {
        if (attributes == null) {
            System.out.println("No attributes");
        } else {
            try {
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
                while (namingEnumeration.hasMore()) {
                    Attribute attribute = namingEnumeration.next();
                    System.out.println("attribute: " + attribute.getID());
                    NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                    while (namingEnumeration2.hasMore()) {
                        System.out.println("value: " + namingEnumeration2.next());
                    }
                }
            }
            catch (NamingException namingException) {
                ServiceLogger.logError(namingException, 3);
            }
        }
    }

    public static void showInfo() {
        System.out.println("Dir Context:");
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            String string = "(|(ou=groups)|(ou=TestOU))";
            NamingEnumeration<SearchResult> namingEnumeration = SEDU.search("", string, searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
            }
        }
        catch (NamingException namingException) {
            ServiceLogger.logError(namingException, 3);
        }
    }
}

