/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import jet.cs.ExProperties;
import jet.server.ServerEnv;

public class LdapEnvironments
extends Hashtable {
    public static final String ENV_ENABLE_SUPPORT = "ldaprealm.enable_ldap_support";
    public static final String ENV_URL = "ldaprealm.url";
    public static final String ENV_SSL = "ldaprealm.ssl";
    public static final String ENV_PRINCIPAL = "ldaprealm.principal";
    public static final String ENV_CREDENTIAL = "ldaprealm.credential";
    public static final String ENV_AUTHEN = "ldaprealm.authentication";
    public static final String ENV_PORT = "ldaprealm.port";
    public static final String ENV_ROOT = "ldaprealm.root";
    public static final String ENV_RUNMODE = "ldaprealm.running_mode";
    public static final String OPT_GET_MODE = "Get all users and groups when RunTime";
    public static final String OPT_CHECK_MODE = "Check user from Ldap Server when user login";
    public static final String OPT_IMPORT_ASK = "Ask before overwrite";
    public static final String OPT_IMPORT_OVERWRITE = "Overwrite all existing users or groups";
    public static final String OPT_USER_SETTING = "Current Settings";
    public static final String OPT_NDS_SETTING = "Novell Directory Server";
    public static final String OPT_IPLANET_SETTING = "iPlanet Directory Server";
    public static final String OPT_MS_SITE_SETTING = "Microsoft Site Server";
    public static final String OPT_OPENLDAP_SETTING = "OpenLDAP Directory Server";
    public static final String OPT_WIN2000AD_SETTING = "Win2000 Active Directory";
    public static final String OPT_LOTUSDOMINO_SETTING = "Lotus Domino on NT";
    public static final String ENV_USER_SCHEME_USERID = "ldaprealm.scheme.user.user_id";
    public static final String ENV_USER_SCHEME_COMMONNAME = "ldaprealm.scheme.user.common_name";
    public static final String ENV_USER_SCHEME_PASSWROD = "ldaprealm.scheme.user.password";
    public static final String ENV_USER_SCHEME_DN = "ldaprealm.scheme.user.distinguish_name";
    public static final String ENV_USER_SCHEME_FILTER = "ldaprealm.scheme.user.search_filter";
    public static final String ENV_GROUP_SCHEME_COMMONNAME = "ldaprealm.scheme.group.common_name";
    public static final String ENV_GROUP_SCHEME_MEMBERTYPE = "ldaprealm.scheme.group.member_type";
    public static final String ENV_GROUP_SCHEME_DN = "ldaprealm.scheme.group.distinguish_name";
    public static final String ENV_GROUP_SCHEME_FILTER = "ldaprealm.scheme.group.search_filter";
    public static final String ENV_GROUP_SCHEME_ADMINGROUP = "ldaprealm.scheme.group.admin_group";
    private static ExProperties SEDU = new ExProperties();
    private static String append = "";
    private static ServerEnv buildEnvironments = new ServerEnv();

    public LdapEnvironments() {
        this.SEDU();
        this.loadProperties();
    }

    public LdapEnvironments(ExProperties exProperties) {
        this.SEDU();
        SEDU.clear();
        SEDU = (ExProperties)exProperties.clone();
        this.buildEnvironments();
    }

    private void SEDU() {
        this.clear();
        this.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.put("java.naming.ldap.version", "2");
        this.put("java.naming.referral", "follow");
    }

    private String append(String string) {
        if (string.equals(ENV_URL)) {
            return "java.naming.provider.url";
        }
        if (string.equals(ENV_PRINCIPAL)) {
            return "java.naming.security.principal";
        }
        if (string.equals(ENV_CREDENTIAL)) {
            return "java.naming.security.credentials";
        }
        if (string.equals(ENV_AUTHEN)) {
            return "java.naming.security.authentication";
        }
        if (string.equals(ENV_SSL)) {
            return "java.naming.security.protocol";
        }
        return null;
    }

    private String buildEnvironments(String string) {
        if (string.equals("java.naming.provider.url")) {
            return ENV_URL;
        }
        if (string.equals("java.naming.security.principal")) {
            return ENV_PRINCIPAL;
        }
        if (string.equals("java.naming.security.credentials")) {
            return ENV_CREDENTIAL;
        }
        if (string.equals("java.naming.security.authentication")) {
            return ENV_AUTHEN;
        }
        if (string.equals("java.naming.security.protocol")) {
            return ENV_SSL;
        }
        return null;
    }

    public void refresh() {
        this.loadProperties();
        this.buildEnvironments();
    }

    public void refresh(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        SEDU.clear();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            SEDU.put(string, hashtable.get(string));
        }
        this.buildEnvironments();
    }

    public void buildEnvironments() {
        String string = "";
        String string2 = "";
        String string3 = "";
        this.SEDU();
        Enumeration<Object> enumeration = SEDU.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = this.append(string);
            string3 = SEDU.getProperty(string);
            if (string.equals(ENV_SSL) && string3.equals("true")) {
                string3 = "ssl";
            } else if (string.equals(ENV_SSL) && string3.equals("false")) {
                string2 = null;
            }
            if (string.equals(ENV_URL)) {
                String string4 = SEDU.getProperty(ENV_ROOT);
                if (string4 == null) {
                    string4 = "";
                }
                string3 = string3 + ":" + SEDU.getProperty(ENV_PORT) + "/" + string4;
            }
            if (string2 == null) continue;
            this.put(string2, string3);
        }
    }

    public void buildProperties() {
        String string;
        int n;
        String string2;
        String string3;
        int n2;
        String string4;
        ExProperties exProperties = new ExProperties();
        exProperties.setProperty(ENV_ENABLE_SUPPORT, SEDU.containsKey(ENV_ENABLE_SUPPORT) ? SEDU.getProperty(ENV_ENABLE_SUPPORT) : "false");
        exProperties.setProperty(ENV_URL, SEDU.containsKey(ENV_URL) ? SEDU.getProperty(ENV_URL) : "");
        exProperties.setProperty(ENV_SSL, SEDU.containsKey(ENV_SSL) ? SEDU.getProperty(ENV_SSL) : "false");
        exProperties.setProperty(ENV_PRINCIPAL, SEDU.containsKey(ENV_PRINCIPAL) ? SEDU.getProperty(ENV_PRINCIPAL) : "");
        exProperties.setProperty(ENV_CREDENTIAL, SEDU.containsKey(ENV_CREDENTIAL) ? SEDU.getProperty(ENV_CREDENTIAL) : "");
        exProperties.setProperty(ENV_AUTHEN, SEDU.containsKey(ENV_AUTHEN) ? SEDU.getProperty(ENV_AUTHEN) : "none");
        exProperties.setProperty(ENV_PORT, SEDU.containsKey(ENV_PORT) ? SEDU.getProperty(ENV_PORT) : "389");
        String string5 = SEDU.containsKey(ENV_ROOT) ? SEDU.getProperty(ENV_ROOT) : "";
        exProperties.setProperty(ENV_ROOT, string5);
        exProperties.setProperty(ENV_RUNMODE, SEDU.containsKey(ENV_RUNMODE) ? SEDU.getProperty(ENV_RUNMODE) : OPT_GET_MODE);
        exProperties.setProperty(ENV_USER_SCHEME_USERID, SEDU.containsKey(ENV_USER_SCHEME_USERID) ? SEDU.getProperty(ENV_USER_SCHEME_USERID) : "uid");
        exProperties.setProperty(ENV_USER_SCHEME_COMMONNAME, SEDU.containsKey(ENV_USER_SCHEME_COMMONNAME) ? SEDU.getProperty(ENV_USER_SCHEME_COMMONNAME) : "cn");
        exProperties.setProperty(ENV_USER_SCHEME_PASSWROD, SEDU.containsKey(ENV_USER_SCHEME_PASSWROD) ? SEDU.getProperty(ENV_USER_SCHEME_PASSWROD) : "userPassword");
        String string6 = string4 = SEDU.containsKey(ENV_USER_SCHEME_DN) ? SEDU.getProperty(ENV_USER_SCHEME_DN) : "ou=people";
        if (string4 != null && string4.trim().length() > 0 && (n2 = string4.indexOf("dc")) != -1 && (string3 = string4.substring(n2)).equalsIgnoreCase(string5)) {
            string4 = string4.substring(0, n2 - 1);
        }
        exProperties.setProperty(ENV_USER_SCHEME_DN, string4);
        exProperties.setProperty(ENV_USER_SCHEME_FILTER, SEDU.containsKey(ENV_USER_SCHEME_FILTER) ? SEDU.getProperty(ENV_USER_SCHEME_FILTER) : "");
        exProperties.setProperty(ENV_GROUP_SCHEME_COMMONNAME, SEDU.containsKey(ENV_GROUP_SCHEME_COMMONNAME) ? SEDU.getProperty(ENV_GROUP_SCHEME_COMMONNAME) : "cn");
        exProperties.setProperty(ENV_GROUP_SCHEME_MEMBERTYPE, SEDU.containsKey(ENV_GROUP_SCHEME_MEMBERTYPE) ? SEDU.getProperty(ENV_GROUP_SCHEME_MEMBERTYPE) : "uniqueMember");
        String string7 = string2 = SEDU.containsKey(ENV_GROUP_SCHEME_DN) ? SEDU.getProperty(ENV_GROUP_SCHEME_DN) : "ou=groups";
        if (string2 != null && string2.trim().length() > 0 && (n = string2.indexOf("dc")) != -1 && (string = string2.substring(n)).equalsIgnoreCase(string5)) {
            string2 = string2.substring(0, n - 1);
        }
        exProperties.setProperty(ENV_GROUP_SCHEME_DN, string2);
        exProperties.setProperty(ENV_GROUP_SCHEME_FILTER, SEDU.containsKey(ENV_GROUP_SCHEME_FILTER) ? SEDU.getProperty(ENV_GROUP_SCHEME_FILTER) : "");
        exProperties.setProperty(ENV_GROUP_SCHEME_ADMINGROUP, SEDU.containsKey(ENV_GROUP_SCHEME_ADMINGROUP) ? SEDU.getProperty(ENV_GROUP_SCHEME_ADMINGROUP) : "");
        SEDU = exProperties;
    }

    public void setComments(String string) {
        append = string;
    }

    public String getComments() {
        return append;
    }

    public void setProperty(String string, String string2) {
        SEDU.put(string, string2);
    }

    public static String getProperty(String string) {
        if (SEDU.get(string) != null) {
            return (String)SEDU.get(string);
        }
        return "";
    }

    public void replaceProperty(String string, String string2) {
        SEDU.remove(string);
        SEDU.put(string, string2);
    }

    public void replaceEnvironments(String string, String string2) {
        if (this.contains(string)) {
            this.remove(string);
            this.put(string, string2);
        }
    }

    public void loadProperties() {
        String string;
        SEDU.clear();
        SEDU = buildEnvironments.getLdapConfig();
        String string2 = (String)SEDU.get(ENV_ROOT);
        String string3 = (String)SEDU.get(ENV_USER_SCHEME_DN);
        if (string3 != null && string3.trim().length() > 0) {
            String string4;
            int n = string3.indexOf("dc");
            if (n != -1 && (string4 = string3.substring(n)).equalsIgnoreCase(string2)) {
                string3 = string3.substring(0, n - 1);
            }
            SEDU.remove(ENV_USER_SCHEME_DN);
            SEDU.put(ENV_USER_SCHEME_DN, string3);
        }
        if ((string = (String)SEDU.get(ENV_GROUP_SCHEME_DN)) != null && string.trim().length() > 0) {
            String string5;
            int n = string.indexOf("dc");
            if (n != -1 && (string5 = string.substring(n)).equalsIgnoreCase(string2)) {
                string = string.substring(0, n - 1);
            }
            SEDU.remove(ENV_GROUP_SCHEME_DN);
            SEDU.put(ENV_GROUP_SCHEME_DN, string);
        }
        this.buildEnvironments();
    }

    public void saveProperties() {
        ServerEnv.saveLdapConfiguration(SEDU);
    }

    public void showInfo() {
        String string = "";
        String string2 = "";
        System.out.println("Environments list:");
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.equals("com.sun.jndi.ldap.trace.ber")) continue;
            string2 = (String)this.get(string);
            System.out.println(string + "  |  " + string2);
        }
    }
}

