/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.cs.util.APIEnums;
import jet.dataengine.api.query.DatabaseMetadataInfo;
import jet.server.api.CatConnectionInfo;
import jet.server.api.dynamiccon.DynamicConnection;
import jet.server.jrserver.dynamiccon.AdapterCatDynamicConnection;
import jet.server.log.ServiceLogger;
import jet.server.util.RefResource;
import jet.server.util.StringUtil;
import jet.server.util.StringUtils;
import jet.universe.JetUUniverse;

public class DatabaseMetadataInfoMaker {
    public static boolean existedDatabaseConnectionInfo(Map map, boolean bl) {
        if (StringUtils.hasText((String)map.get("jrs.jndi_datasource"))) {
            return true;
        }
        if (bl) {
            if (StringUtils.hasText((String)map.get("jrs._ds_driver"))) {
                return true;
            }
            if (StringUtils.hasText((String)map.get("jrs._ds_url"))) {
                return true;
            }
            if (StringUtils.hasText((String)map.get("jrs.ds_user"))) {
                return true;
            }
            if (StringUtils.hasText((String)map.get("jrs.ds_pswd"))) {
                return true;
            }
        } else {
            if (StringUtils.hasText((String)map.get("jrs.jdbc_driver"))) {
                return true;
            }
            if (StringUtils.hasText((String)map.get("jrs.jdbc_url"))) {
                return true;
            }
            if (StringUtils.hasText((String)map.get("jrs.db_user"))) {
                return true;
            }
            if (StringUtils.hasText((String)map.get("jrs.db_pswd"))) {
                return true;
            }
        }
        if (StringUtils.hasText((String)map.get("jrs.db_date_format"))) {
            return true;
        }
        if (StringUtils.hasText((String)map.get("jrs.db_datetime_format"))) {
            return true;
        }
        if (StringUtils.hasText((String)map.get("jrs.db_extra_characters"))) {
            return true;
        }
        if (StringUtils.hasText((String)map.get("jrs.db_quote_character"))) {
            return true;
        }
        if (StringUtils.hasText((String)map.get("jrs.db_transaction_readonly"))) {
            return true;
        }
        if (StringUtils.hasText((String)map.get("jrs.db_refresh_support_info"))) {
            return true;
        }
        if (StringUtils.hasText((String)map.get("jrs.db_transaction_mode"))) {
            return true;
        }
        if (StringUtils.hasText((String)map.get("jrs.db_char_to_be_replaced"))) {
            return true;
        }
        if (StringUtils.hasText((String)map.get("jrs.db_char_replaced_by"))) {
            return true;
        }
        return StringUtils.hasText((String)map.get("jrs.db_time_format"));
    }

    private static String DEFAULT(String string) {
        if (string == null) {
            return string;
        }
        string = string.replaceAll("jrs\\.db_user:[^,\\W]*", "jrs.db_user:*****");
        string = string.replaceAll("jrs\\.db_pswd:[^,\\W]*", "");
        string = string.replaceAll("jrs\\.new_db_pswd:[^&\\W]*", "");
        string = string.replaceAll("jrs\\.ds_user:[^,\\W]*", "jrs.ds_user:*****");
        string = string.replaceAll("jrs\\.ds_pswd:[^,\\W]*", "");
        string = string.replaceAll("jrs\\.new_ds_pswd:[^,\\W]*", "");
        string = string.replaceAll("jrs\\.auth_pwd:[^,\\W]*", "jrs.auth_pwd:******");
        string = string.replaceAll("jrs\\.authorization=[^,\\W]*", "jrs.auth_authorization:******");
        return string;
    }

    public static DatabaseMetadataInfo make(Map map) {
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("DatabaseMetadataInfoMaker:make: props=%s", DatabaseMetadataInfoMaker.DEFAULT(StringUtil.toString(map)));
        }
        DatabaseMetadataInfo databaseMetadataInfo = new DatabaseMetadataInfo();
        databaseMetadataInfo.setDateFormat((String)map.get("jrs.db_date_format"));
        databaseMetadataInfo.setDatetimeFormat((String)map.get("jrs.db_datetime_format"));
        databaseMetadataInfo.setExtraCharacters((String)map.get("jrs.db_extra_characters"));
        databaseMetadataInfo.setQuoteCharacters((String)map.get("jrs.db_quote_character"));
        String string = (String)map.get("jrs.db_transaction_readonly");
        if ("default".equalsIgnoreCase(string)) {
            databaseMetadataInfo.setReadWriteMode(1);
        } else if ("Read only".equalsIgnoreCase(string)) {
            databaseMetadataInfo.setReadWriteMode(2);
        } else if ("Read&Write".equalsIgnoreCase(string)) {
            databaseMetadataInfo.setReadWriteMode(0);
        }
        string = (String)map.get("jrs.db_refresh_support_info");
        try {
            databaseMetadataInfo.setRefreshSupportInfo(Boolean.valueOf(string).booleanValue());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        databaseMetadataInfo.setTimeFormat((String)map.get("jrs.db_time_format"));
        string = (String)map.get("jrs.db_transaction_mode");
        if ("default".equalsIgnoreCase(string)) {
            databaseMetadataInfo.setTransactionIsolation(0);
        } else if ("None".equalsIgnoreCase(string)) {
            databaseMetadataInfo.setTransactionIsolation(1);
        } else if ("Read Uncommitted".equalsIgnoreCase(string)) {
            databaseMetadataInfo.setTransactionIsolation(2);
        } else if ("Read Committed".equalsIgnoreCase(string)) {
            databaseMetadataInfo.setTransactionIsolation(3);
        } else if ("Repeatable Read".equalsIgnoreCase(string)) {
            databaseMetadataInfo.setTransactionIsolation(4);
        } else if ("Serializable".equalsIgnoreCase(string)) {
            databaseMetadataInfo.setTransactionIsolation(5);
        }
        databaseMetadataInfo.setEscapeReplaced((String)map.get("jrs.db_char_to_be_replaced"));
        databaseMetadataInfo.setReplacedBy((String)map.get("jrs.db_char_replaced_by"));
        string = (String)map.get("jrs.db_name_pattern");
        if (("" + (Object)((Object)APIEnums.ConnectionNamePattern.UNQUALIFIED)).equals(string)) {
            databaseMetadataInfo.setNamePattern(0);
        } else if (("" + (Object)((Object)APIEnums.ConnectionNamePattern.QUALIFIED_2PART)).equals(string)) {
            databaseMetadataInfo.setNamePattern(1);
        } else if (("" + (Object)((Object)APIEnums.ConnectionNamePattern.QUALIFIED_3PART)).equals(string)) {
            databaseMetadataInfo.setNamePattern(2);
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("DatabaseMetadataInfoMaker:make: ret = %s", databaseMetadataInfo);
        }
        return databaseMetadataInfo;
    }

    public static Properties toProperties(DatabaseMetadataInfo databaseMetadataInfo) {
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("DatabaseMetadataInfoMaker:toProperties: info = %s", databaseMetadataInfo);
        }
        Properties properties = new Properties();
        String string = databaseMetadataInfo.getDateFormat();
        if (string != null && string.trim().length() > 0) {
            properties.put("jrs.db_date_format", string);
        }
        if ((string = databaseMetadataInfo.getDatetimeFormat()) != null && string.trim().length() > 0) {
            properties.put("jrs.db_datetime_format", string);
        }
        if ((string = databaseMetadataInfo.getExtraCharacters()) != null && string.trim().length() > 0) {
            properties.put("jrs.db_extra_characters", string);
        }
        if ((string = databaseMetadataInfo.getQuoteCharacters()) != null && string.trim().length() > 0) {
            properties.put("jrs.db_quote_character", string);
        }
        switch (databaseMetadataInfo.getReadWriteMode()) {
            case 1: {
                properties.put("jrs.db_transaction_readonly", "default");
                break;
            }
            case 2: {
                properties.put("jrs.db_transaction_readonly", "Read only");
                break;
            }
            case 0: {
                properties.put("jrs.db_transaction_readonly", "Read&Write");
            }
        }
        string = "" + databaseMetadataInfo.isRefreshSupportInfo();
        properties.put("jrs.db_refresh_support_info", string);
        string = databaseMetadataInfo.getTimeFormat();
        if (string != null && string.trim().length() > 0) {
            properties.put("jrs.db_time_format", string);
        }
        switch (databaseMetadataInfo.getTransactionIsolation()) {
            case 0: {
                properties.put("jrs.db_transaction_mode", "default");
                break;
            }
            case 1: {
                properties.put("jrs.db_transaction_mode", "None");
                break;
            }
            case 2: {
                properties.put("jrs.db_transaction_mode", "Read Uncommitted");
                break;
            }
            case 3: {
                properties.put("jrs.db_transaction_mode", "Read Committed");
                break;
            }
            case 4: {
                properties.put("jrs.db_transaction_mode", "Repeatable Read");
                break;
            }
            case 5: {
                properties.put("jrs.db_transaction_mode", "Serializable");
            }
        }
        string = databaseMetadataInfo.getEscapeReplaced();
        if (string != null && string.trim().length() > 0) {
            properties.put("jrs.db_char_to_be_replaced", string);
        }
        if ((string = databaseMetadataInfo.getReplacedBy()) != null && string.trim().length() > 0) {
            properties.put("jrs.db_char_replaced_by", string);
        }
        switch (databaseMetadataInfo.getNamePattern()) {
            case 0: {
                properties.put("jrs.db_name_pattern", "" + (Object)((Object)APIEnums.ConnectionNamePattern.UNQUALIFIED));
                break;
            }
            case 1: {
                properties.put("jrs.db_name_pattern", "" + (Object)((Object)APIEnums.ConnectionNamePattern.QUALIFIED_2PART));
                break;
            }
            case 2: {
                properties.put("jrs.db_name_pattern", "" + (Object)((Object)APIEnums.ConnectionNamePattern.QUALIFIED_3PART));
            }
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.trace("DatabaseMetadataInfoMaker:toProperties: map=%s", StringUtil.toString(properties));
        }
        return properties;
    }

    public static DatabaseMetadataInfo convert(DynamicConnection dynamicConnection) {
        if (dynamicConnection == null) {
            return null;
        }
        DatabaseMetadataInfo databaseMetadataInfo = new DatabaseMetadataInfo();
        databaseMetadataInfo.setDateFormat(dynamicConnection.getDateFormat());
        databaseMetadataInfo.setDatetimeFormat(dynamicConnection.getTimestampFormat());
        databaseMetadataInfo.setExtraCharacters(dynamicConnection.getExtraCharacters());
        if (dynamicConnection.getNamePattern() == APIEnums.ConnectionNamePattern.UNQUALIFIED) {
            databaseMetadataInfo.setNamePattern(0);
        } else if (dynamicConnection.getNamePattern() == APIEnums.ConnectionNamePattern.QUALIFIED_2PART) {
            databaseMetadataInfo.setNamePattern(1);
        } else if (dynamicConnection.getNamePattern() == APIEnums.ConnectionNamePattern.QUALIFIED_3PART) {
            databaseMetadataInfo.setNamePattern(2);
        }
        databaseMetadataInfo.setQuoteCharacters(dynamicConnection.getQuoteCharacter());
        if (dynamicConnection.getReadOnly() == APIEnums.ConnectionReadOnly.DEFAULT) {
            databaseMetadataInfo.setReadWriteMode(1);
        } else if (dynamicConnection.getReadOnly() == APIEnums.ConnectionReadOnly.READONLY) {
            databaseMetadataInfo.setReadWriteMode(2);
        } else if (dynamicConnection.getReadOnly() == APIEnums.ConnectionReadOnly.READWRITE) {
            databaseMetadataInfo.setReadWriteMode(0);
        }
        databaseMetadataInfo.setTimeFormat(dynamicConnection.getTimeFormat());
        if (dynamicConnection.getTransactionIsolation() == APIEnums.ConnectionTransactionIsolation.DEFAULT) {
            databaseMetadataInfo.setTransactionIsolation(0);
        } else if (dynamicConnection.getTransactionIsolation() == APIEnums.ConnectionTransactionIsolation.NONE) {
            databaseMetadataInfo.setTransactionIsolation(1);
        } else if (dynamicConnection.getTransactionIsolation() == APIEnums.ConnectionTransactionIsolation.READ_UNCOMMITTED) {
            databaseMetadataInfo.setTransactionIsolation(2);
        } else if (dynamicConnection.getTransactionIsolation() == APIEnums.ConnectionTransactionIsolation.READ_COMMITTED) {
            databaseMetadataInfo.setTransactionIsolation(3);
        } else if (dynamicConnection.getTransactionIsolation() == APIEnums.ConnectionTransactionIsolation.REPEATABLE_READ) {
            databaseMetadataInfo.setTransactionIsolation(4);
        } else if (dynamicConnection.getTransactionIsolation() == APIEnums.ConnectionTransactionIsolation.SERIALIZABLE) {
            databaseMetadataInfo.setTransactionIsolation(5);
        }
        return databaseMetadataInfo;
    }

    public static Map<String, DynamicConnection> getOriginalCatConnections(JetUUniverse jetUUniverse) {
        HashMap<String, DynamicConnection> hashMap = new HashMap<String, DynamicConnection>();
        try {
            Vector<CatConnectionInfo> vector = RefResource.getCatConnectionInfo(jetUUniverse);
            if (vector != null) {
                for (CatConnectionInfo catConnectionInfo : vector) {
                    if (!"JDBC Connection".equals(catConnectionInfo.getType())) continue;
                    hashMap.put(catConnectionInfo.getDatasourceName(), new AdapterCatDynamicConnection(catConnectionInfo));
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return hashMap;
    }

    public static DynamicConnection getOriginalCatConnection(CatConnectionInfo catConnectionInfo) {
        return new AdapterCatDynamicConnection(catConnectionInfo);
    }
}

