/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class IOUtil {
    public static long getFileLength(File file) {
        if (!file.exists()) {
            return 0L;
        }
        if (file.isDirectory()) {
            long l = 0L;
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    l += IOUtil.getFileLength(file2);
                }
            }
            return l;
        }
        return file.length();
    }

    public static void deleteFile(File file) {
        File[] fileArray;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                IOUtil.deleteFile(file2);
            }
        }
        file.delete();
    }

    public static boolean isParents(File file, File file2) {
        for (File file3 = file2.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
            if (!file3.equals(file)) continue;
            return true;
        }
        return false;
    }

    public static void copy(File file, File file2, boolean bl) throws IOException {
        if (!file.exists() || file.equals(file2)) {
            return;
        }
        if (bl && IOUtil.isParents(file, file2)) {
            throw new IOException();
        }
        if (file.isFile()) {
            file2.getParentFile().mkdirs();
            IOUtil.copy(file, file2);
        } else if (file.isDirectory()) {
            file2.mkdirs();
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file3 : fileArray) {
                    if (file3.isFile()) {
                        IOUtil.copy(file3, new File(file2, file3.getName()));
                        continue;
                    }
                    if (!bl || !file3.isDirectory()) continue;
                    IOUtil.copy(file3, new File(file2, file3.getName()), bl);
                }
            }
        }
    }

    public static void copy(File file, File file2) throws IOException {
        IOUtil.copy((InputStream)new FileInputStream(file), (OutputStream)new FileOutputStream(file2));
    }

    public static void copy(File file, OutputStream outputStream) throws IOException {
        IOUtil.copy((InputStream)new FileInputStream(file), outputStream);
    }

    public static void copy(InputStream inputStream, File file) throws IOException {
        IOUtil.copy(inputStream, (OutputStream)new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            IOUtil.transfer(inputStream, outputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            finally {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(File file, OutputStream outputStream) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            IOUtil.transfer(fileInputStream, outputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
        while (readableByteChannel.read(byteBuffer) != -1) {
            byteBuffer.flip();
            while (byteBuffer.hasRemaining()) {
                writableByteChannel.write(byteBuffer);
            }
            byteBuffer.clear();
        }
    }
}

