/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

public class ResourceLock {
    private static HashMap SEDU = new HashMap();
    private static byte[] append = "JREPORT".getBytes();
    private static long cancel = 3000L;
    private String close = null;
    private Object containsKey = new Object();
    private Object currentTimeMillis = new Object();
    private String deleteOnExit = null;
    private File err;
    private RandomAccessFile exists = null;
    private Timer get = null;
    private TimerTask getBytes = null;
    private boolean getLockedPath = false;

    public static synchronized ResourceLock newResourceLock(String string) {
        if (string == null) {
            throw new IllegalArgumentException("path can not be null");
        }
        ResourceLock resourceLock = null;
        if (SEDU.containsKey(string)) {
            resourceLock = (ResourceLock)SEDU.get(string);
        } else {
            resourceLock = new ResourceLock(string);
            SEDU.put(string, resourceLock);
        }
        return resourceLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        Object object = this.containsKey;
        synchronized (object) {
            return this.getLockedPath;
        }
    }

    public void lock() {
        if (this.isLocked()) {
            return;
        }
        while (!this.tryLock()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println(interruptedException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() {
        File file = this.SEDU();
        Object object = this.containsKey;
        synchronized (object) {
            if (!file.exists()) {
                this.append(file);
            } else {
                try {
                    this.exists = new RandomAccessFile(file, "r");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                long l = 0L;
                if (this.exists != null) {
                    l = this.cancel(this.exists);
                    for (int i = 0; i < 2; ++i) {
                        try {
                            Thread.sleep(cancel);
                        }
                        catch (InterruptedException interruptedException) {
                            System.err.println(interruptedException.getMessage());
                        }
                        long l2 = this.cancel(this.exists);
                        if (l2 == l) continue;
                        try {
                            this.exists.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        return false;
                    }
                    try {
                        this.exists.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    this.append(file);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (!this.isLocked()) {
            return;
        }
        Object object = this.containsKey;
        synchronized (object) {
            if (this.get != null) {
                this.getBytes.cancel();
                this.getBytes = null;
                this.get.cancel();
                this.get = null;
            }
            if (this.exists != null) {
                Object object2 = this.currentTimeMillis;
                synchronized (object2) {
                    try {
                        this.exists.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    finally {
                        this.exists = null;
                    }
                }
            }
            this.getLockedPath = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destory() {
        this.release();
        HashMap hashMap = SEDU;
        synchronized (hashMap) {
            SEDU.remove(this.getLockedPath());
            if (this.SEDU().exists()) {
                try {
                    this.SEDU().deleteOnExit();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public String getLockedPath() {
        return this.close;
    }

    private ResourceLock(String string) {
        this.close = string;
        int n = string.hashCode();
        this.deleteOnExit = Integer.toHexString(n) + ".lck";
        this.err = new File(System.getProperty("java.io.tmpdir"), this.deleteOnExit);
    }

    private File SEDU() {
        return this.err;
    }

    private void append(File file) {
        try {
            this.exists = new RandomAccessFile(file, "rw");
            this.exists.write(append, 0, append.length);
            this.exists.writeLong(0L);
            if (this.get != null) {
                this.get.cancel();
            }
            this.get = new Timer();
            this.getBytes = new HeartBeatWriter(this.exists);
            this.get.scheduleAtFixedRate(this.getBytes, 1000L, cancel);
            this.exists.writeLong(System.currentTimeMillis());
            this.getLockedPath = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private long cancel(RandomAccessFile randomAccessFile) {
        long l = 0L;
        try {
            randomAccessFile.seek(append.length);
            l = randomAccessFile.readLong();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return l;
    }

    private class HeartBeatWriter
    extends TimerTask {
        private RandomAccessFile SEDU = null;

        public HeartBeatWriter(RandomAccessFile randomAccessFile) {
            this.SEDU = randomAccessFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ResourceLock.this.currentTimeMillis;
            synchronized (object) {
                try {
                    this.SEDU.seek(append.length);
                    this.SEDU.writeLong(System.currentTimeMillis());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

