/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import com.jinfonet.resstore.ResourceLoadException;
import com.jinfonet.resstore.ResourceNotFoundException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.connect.DbValue;
import jet.cs.Base64Ex;
import jet.cs.CSUtil;
import jet.cs.jacl.SecurityData;
import jet.exception.InvalidParameterException;
import jet.exception.ParseFormulaFailedException;
import jet.export.ExportAuxInfo;
import jet.export.mail.mail;
import jet.formula.formulaExecutor.ExecFormulaFailedException;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.server.api.RptServerException;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;
import jet.server.resstore.impl.JRServerResourceStore;
import jet.server.resstore.impl.JRServerResourceStoreFactory;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.util.ParamUtil;
import jet.server.util.StringUtil;
import jet.server.util.StringUtils;
import jet.server.util.ZipArchive;
import jet.universe.JetUDatabase;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.exception.FMLFileException;
import jet.universe.exception.UniverseFileException;
import server.servlet.http.HttpDate;

public final class ServerUtil {
    public static void sendNormalMail(String string, String string2, String string3, String string4, String string5, Vector vector) throws Exception {
        JRServerResourceStore jRServerResourceStore = JRServerResourceStoreFactory.getInstance().getResourceStore(null);
        mail mail2 = new mail(null, null, CSUtil.getUrlEncoding(), new ExportAuxInfo(jRServerResourceStore.getDiskStore()));
        mail2.send(string, string2, string3, string4, string5, false, -1, vector);
    }

    public static String decode(String string) {
        byte[] byArray;
        String string2 = System.getProperty("file.encoding");
        try {
            byArray = Base64Ex.decode(string.getBytes(string2));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return string;
        }
        String string3 = new String(byArray);
        return string3;
    }

    public static String encode(String string) {
        byte[] byArray = new byte[]{};
        String string2 = System.getProperty("file.encoding");
        try {
            byArray = Base64Ex.encode(string.getBytes(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ServiceLogger.logError(unsupportedEncodingException);
            return string;
        }
        String string3 = new String(byArray);
        return string3;
    }

    public static boolean isFileNotModified(File file, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            if (file.exists()) {
                String string = httpServletRequest.getHeader("If-Modified-Since");
                if (string != null) {
                    HttpDate httpDate = new HttpDate();
                    httpDate.parse(string);
                    if (file.lastModified() / 1000L * 1000L <= httpDate.getTime()) {
                        httpServletResponse.setStatus(304);
                        return true;
                    }
                }
                httpServletResponse.setHeader("Last-Modified", new HttpDate(file.lastModified()).toString());
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        return false;
    }

    private static String C(HttpServletRequest httpServletRequest, String string, String string2) {
        ServletContext servletContext = httpServletRequest.getSession(true).getServletContext();
        Set set = servletContext.getResourcePaths(string2);
        String string3 = null;
        if (set != null) {
            for (String string4 : set) {
                if (string4.startsWith("/WEB-INF") || string4.startsWith("META-INF")) continue;
                if (string4.endsWith(string)) {
                    return string4;
                }
                if (!string4.endsWith("/") || (string3 = ServerUtil.C(httpServletRequest, string, string4)) == null) continue;
                return string3;
            }
        }
        return null;
    }

    public static String getUpperPath(HttpServletRequest httpServletRequest, String string) {
        String string2 = ServerUtil.C(httpServletRequest, string, "/");
        if (string2 == null) {
            return "";
        }
        int n = string2.indexOf(string);
        return string2.substring(0, n);
    }

    public static int getBrowserType(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("User-Agent");
        if (string.lastIndexOf("MSIE") != -1) {
            return 0;
        }
        if (string.lastIndexOf("Netscape") != -1) {
            return 1;
        }
        if (string.lastIndexOf("Firefox") != -1) {
            return 2;
        }
        if (string.lastIndexOf("Mozilla") != -1) {
            return 3;
        }
        return -1;
    }

    public static int getBrowserTypeByUserAgent(HttpServletRequest httpServletRequest) {
        if (null == httpServletRequest) {
            return -1;
        }
        String string = httpServletRequest.getHeader("User-Agent");
        if (null == string || 0 == string.length()) {
            return -1;
        }
        string = string.toLowerCase();
        int n = -1;
        if (string.contains("msie") || string.contains("mozilla") && string.contains("trident") && string.contains("rv")) {
            n = 0;
        } else if (string.contains("firefox")) {
            n = 1;
        } else if (string.contains("chrome")) {
            n = 2;
        } else if (string.contains("safari")) {
            n = 3;
        } else if (string.contains("opera") || string.contains("opr")) {
            n = 4;
        } else if (string.contains("netscape") || string.contains("navigator")) {
            n = 5;
        } else if (string.contains("mozilla")) {
            n = 6;
        }
        return n;
    }

    public static PrintWriter getResponseWriter(HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter;
        try {
            printWriter = httpServletResponse.getWriter();
        }
        catch (IllegalStateException illegalStateException) {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            printWriter = new PrintWriter((OutputStream)servletOutputStream);
        }
        return printWriter;
    }

    public static String getZipFilePath(String string) {
        String string2 = ServerUtil.reflectClasspath(null, string);
        if (string2 != null) {
            return string2.substring(string2.indexOf(":") + 1);
        }
        return null;
    }

    private static int[] SEDU(int[] nArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            int n5 = nArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && nArray[n3] < n5) {
                    ++n3;
                }
                while (n4 > n && nArray[n4] > n5) {
                    --n4;
                }
                if (n3 > n4) continue;
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
                ++n3;
                --n4;
            }
            if (n < n4) {
                ServerUtil.SEDU(nArray, n, n4);
            }
            if (n3 < n2) {
                ServerUtil.SEDU(nArray, n3, n2);
            }
        }
        return nArray;
    }

    private static String[] Save(String[] stringArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            String string = stringArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (stringArray[n3].compareTo(string) < 0 && n3 < n2) {
                    ++n3;
                }
                while (stringArray[n4].compareTo(string) > 0 && n4 > n) {
                    --n4;
                }
                if (n3 > n4) continue;
                String string2 = stringArray[n3];
                stringArray[n3] = stringArray[n4];
                stringArray[n4] = string2;
                ++n3;
                --n4;
            }
            if (n < n4) {
                ServerUtil.Save(stringArray, n, n4);
            }
            if (n3 < n2) {
                ServerUtil.Save(stringArray, n3, n2);
            }
        }
        return stringArray;
    }

    public static String[] sortStringAarry(String[] stringArray) {
        return ServerUtil.Save(stringArray, 0, stringArray.length - 1);
    }

    public static int[] sortIntegerArray(int[] nArray) {
        return ServerUtil.SEDU(nArray, 0, nArray.length - 1);
    }

    public static String reflectClasspath(ClassLoader classLoader, String string) {
        return ServerUtil.reflectClasspath(classLoader, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reflectClasspath(ClassLoader classLoader, String string, String string2) {
        String string3;
        block30: {
            ClassLoader classLoader2 = null;
            class Probe {
                Probe() {
                }
            }
            classLoader2 = classLoader == null ? new Probe().getClass().getClassLoader() : classLoader;
            string3 = null;
            try {
                Enumeration<URL> enumeration = classLoader2.getResources(string);
                if (!enumeration.hasMoreElements()) {
                    InputStream inputStream;
                    URL uRL = classLoader2.getResource(string);
                    ServiceLogger.logDebug("0000, resource: " + string + ", url: " + uRL);
                    if (uRL != null) {
                        String string4 = StringUtil.URLDecode(uRL.getFile());
                        if ((string4 = string4.substring(0, string4.indexOf(33))).startsWith("file:")) {
                            string4 = string4.substring("file:".length());
                        }
                        if (string4.length() >= 3 && string4.charAt(0) == '/' && string4.charAt(2) == ':') {
                            string4 = string4.substring(1);
                        }
                        string3 = "jar:" + string4;
                    } else if (string2 != null && (inputStream = classLoader2.getResourceAsStream(string2)) != null) {
                        int n;
                        String string5 = System.getProperty("java.io.tmpdir");
                        SecureRandom secureRandom = new SecureRandom();
                        String string6 = "tmp" + Integer.toHexString(secureRandom.nextInt());
                        File file = new File(string5, string6);
                        file.mkdir();
                        FileOutputStream fileOutputStream = new FileOutputStream(new File(file, "jrenv.jar"));
                        byte[] byArray = new byte[512000];
                        while ((n = inputStream.read(byArray)) != -1) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                        fileOutputStream.flush();
                        fileOutputStream.close();
                        String string7 = file.getAbsolutePath() + File.separator + "jrenv.jar";
                        ServiceLogger.logDebug("22222, path: " + string7);
                        string3 = "jar:" + string7;
                    }
                    break block30;
                }
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    if (uRL instanceof URL) {
                        URL uRL2 = uRL;
                        String string8 = StringUtil.URLDecode(uRL2.getPath());
                        String string9 = uRL2.getProtocol();
                        if (string9.equalsIgnoreCase("jar") || string9.equalsIgnoreCase("wsjar") || string9.equalsIgnoreCase("zip") || string9.equalsIgnoreCase("war") || string9.equalsIgnoreCase("ear") || string9.equalsIgnoreCase("vfszip") || string9.equalsIgnoreCase("vfs") || string9.equalsIgnoreCase("code-source")) {
                            String string10;
                            if (string8.startsWith("file:")) {
                                string8 = string8.charAt(7) == ':' ? string8.substring(6) : string8.substring(5);
                            }
                            if (!string9.equalsIgnoreCase("vfszip") && !string9.equalsIgnoreCase("vfs")) {
                                string8 = string8.substring(0, string8.indexOf(33));
                            } else {
                                string10 = string;
                                if (!string10.startsWith("/")) {
                                    string10 = "/" + string10;
                                }
                                string8 = string8.substring(0, string8.indexOf(string10));
                            }
                            if (string8.length() >= 3 && string8.charAt(0) == '/' && string8.charAt(2) == ':') {
                                string8 = string8.substring(1);
                            }
                            if ((string9.equalsIgnoreCase("vfszip") || string9.equalsIgnoreCase("vfs")) && !new File(string8).exists()) {
                                string10 = string8.toUpperCase();
                                int n = string10.indexOf(".WAR");
                                int n2 = string10.indexOf(".EAR");
                                int n3 = n;
                                n3 = n != -1 ? n : n2;
                                if (n3 != -1) {
                                    String string11 = string8.substring(0, n3 + 4);
                                    File file = new File(string11);
                                    ServiceLogger.logDebug("1111, path: " + string8 + ", warPath: " + string11);
                                    if (file.exists()) {
                                        String string12 = System.getProperty("java.io.tmpdir");
                                        SecureRandom secureRandom = new SecureRandom();
                                        String string13 = "tmp" + Integer.toHexString(secureRandom.nextInt());
                                        File file2 = new File(string12, string13);
                                        file2.mkdir();
                                        String string14 = file2.getAbsolutePath();
                                        ZipArchive zipArchive = new ZipArchive();
                                        try {
                                            zipArchive.open(string11, "r");
                                            zipArchive.expand(string8.substring(n3 + 5), string14, false);
                                        }
                                        catch (Exception exception) {
                                        }
                                        finally {
                                            zipArchive.close();
                                        }
                                        string8 = string14 + string8.substring(string8.lastIndexOf("/"));
                                    }
                                }
                            }
                            string8 = string8.replace('/', File.separatorChar);
                            string3 = "jar:" + string8;
                        } else if (string9.equalsIgnoreCase("jndi")) {
                            string8 = string8.substring(0, string8.lastIndexOf(string) - 1);
                            string8 = string8.replace('/', File.separatorChar);
                            string3 = "jar:" + string8;
                        } else {
                            if ((string8 = string8.substring(0, string8.length() - string.length())).startsWith("file:")) {
                                string8 = string8.substring("file:".length());
                            }
                            if (string8.length() >= 3 && string8.charAt(0) == '/' && string8.charAt(2) == ':') {
                                string8 = string8.substring(1);
                            }
                            string3 = "file:" + string8;
                        }
                    }
                    if (string3 == null) continue;
                    break;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return string3;
    }

    public static boolean isLocalAddress(String string) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        if (inetAddress == null) {
            return false;
        }
        if (inetAddress.isLoopbackAddress()) {
            return true;
        }
        for (InetAddress inetAddress2 : ServerUtil.getAllLocalAddresses()) {
            if (!inetAddress.equals(inetAddress2)) continue;
            return true;
        }
        return false;
    }

    public static InetAddress getLocalAddress() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (!inetAddress.isLoopbackAddress()) {
            return inetAddress;
        }
        for (InetAddress inetAddress2 : ServerUtil.getAllLocalAddresses()) {
            if (inetAddress2.isLoopbackAddress()) continue;
            return inetAddress2;
        }
        return InetAddress.getLocalHost();
    }

    public static List<InetAddress> getAllLocalAddresses() throws UnknownHostException {
        return ServerUtil.getAllLocalAddresses(true, false);
    }

    public static List<InetAddress> getAllLocalAddresses(boolean bl, boolean bl2) throws UnknownHostException {
        Object object;
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        try {
            object = NetworkInterface.getNetworkInterfaces();
            while (object.hasMoreElements()) {
                NetworkInterface networkInterface = object.nextElement();
                Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress = enumeration.nextElement();
                    if (!bl && inetAddress instanceof Inet4Address || !bl2 && inetAddress instanceof Inet6Address || arrayList.contains(inetAddress)) continue;
                    arrayList.add(inetAddress);
                }
            }
        }
        catch (SocketException socketException) {
            InetAddress[] inetAddressArray;
            ServiceLogger.logError(socketException);
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostName();
            if (string == null) {
                string = inetAddress.getHostAddress();
            }
            if ((inetAddressArray = InetAddress.getAllByName(string)) == null || inetAddressArray.length == 0) {
                throw new UnknownHostException(socketException.getMessage());
            }
            for (InetAddress inetAddress2 : inetAddressArray) {
                arrayList.add(inetAddress2);
            }
        }
        object = InetAddress.getByName("127.0.0.1");
        if (bl && !arrayList.contains(object)) {
            arrayList.add((InetAddress)object);
        }
        return arrayList;
    }

    public static String escapeHTML(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String encodeUrl(String string) {
        return ServerUtil.escapeHTML(string);
    }

    public static String escapeHTMLWithBlank(String string) {
        if (string == null) {
            return "";
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == ' ') {
                stringBuffer.append("&nbsp;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static boolean isValidFileName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || c == '_' || c == '-' || c == '.' || c == '(' || c == ')' || c == '[' || c == ']' || c == '$') continue;
            return false;
        }
        return true;
    }

    public static List getSizeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 7; i < 73; ++i) {
            arrayList.add(String.valueOf(i));
        }
        return arrayList;
    }

    public static List getFaceList() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public static boolean needCompileFml(String string, String string2) throws ReadFailureException, UniverseFileException {
        File file = new File(string, string2);
        JetUUniverse jetUUniverse = null;
        try {
            jetUUniverse = JRServerResourceStoreFactory.getInstance().getResourceStoreByRealDiskPath(file.getAbsolutePath()).getMemoryStore().loadCatalog(file);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            throw new ReadFailureException((Throwable)resourceNotFoundException);
        }
        catch (ResourceLoadException resourceLoadException) {
            throw new ReadFailureException((Throwable)resourceLoadException);
        }
        return ServerUtil.URLDecode(jetUUniverse);
    }

    private static boolean URLDecode(JetUUniverse jetUUniverse) throws ReadFailureException, UniverseFileException {
        boolean bl = false;
        if (jetUUniverse.isNeedUpdateFmlFile()) {
            return true;
        }
        Vector vector = jetUUniverse.getAllDatabases();
        for (JetUDatabase jetUDatabase : vector) {
            String string = jetUDatabase.getResourceName();
            File file = jetUUniverse.getFMLFile(string);
            if (file.exists()) {
                if (jetUUniverse.isFMLFileMatch(file, string) && !jetUDatabase.isNeedGenerateJava()) continue;
                bl = true;
                break;
            }
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean saveCatFml(String string, String string2) throws ReadFailureException, UniverseFileException, WriteFailureException, FMLFileException {
        boolean bl = false;
        File file = new File(string, string2);
        JetUUniverse jetUUniverse = null;
        try {
            jetUUniverse = JRServerResourceStoreFactory.getInstance().getResourceStoreByRealDiskPath(file.getAbsolutePath()).getMemoryStore().loadCatalog(file);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            throw new ReadFailureException((Throwable)resourceNotFoundException);
        }
        catch (ResourceLoadException resourceLoadException) {
            throw new ReadFailureException((Throwable)resourceLoadException);
        }
        ServiceLogger.logDebug("catalog path=" + string + ", catalog name=" + string2, 6);
        bl = jetUUniverse.Save(string, string2);
        return bl;
    }

    public static boolean checkMLSAndFmlInCat(String string, String string2) throws ReadFailureException, UniverseFileException, WriteFailureException, FMLFileException {
        boolean bl = false;
        File file = new File(string, string2);
        JetUUniverse jetUUniverse = null;
        try {
            jetUUniverse = JRServerResourceStoreFactory.getInstance().getResourceStoreByRealDiskPath(file.getAbsolutePath()).getMemoryStore().loadCatalog(file);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            throw new ReadFailureException((Throwable)resourceNotFoundException);
        }
        catch (ResourceLoadException resourceLoadException) {
            throw new ReadFailureException((Throwable)resourceLoadException);
        }
        if (jetUUniverse.removeInvalidMLSItem((SecurityData)UserDataToolkit.getSecurityData()) || jetUUniverse.isNeedUpdateFmlFile()) {
            ServiceLogger.logDebug(5620026, string2, 5);
            jetUUniverse.Save(string, string2);
            bl = true;
        }
        return bl;
    }

    public static boolean updateMLSInCatalog(String string, String string2, int n) throws ReadFailureException, UniverseFileException, WriteFailureException, FMLFileException {
        boolean bl = false;
        JetUUniverse jetUUniverse = null;
        try {
            jetUUniverse = JRServerResourceStoreFactory.getInstance().getResourceStoreByRealDiskPath(string).getMemoryStore().loadCatalog(new File(string));
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            throw new ReadFailureException((Throwable)resourceNotFoundException);
        }
        catch (ResourceLoadException resourceLoadException) {
            throw new ReadFailureException((Throwable)resourceLoadException);
        }
        if (jetUUniverse.removeMLSItem(string2, n)) {
            File file = new File(string);
            bl = jetUUniverse.Save(file.getParent(), file.getName());
        }
        return bl;
    }

    public static String getLocaleName(Locale locale) {
        return locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
    }

    public static Locale getLocale(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("[_-]", 3);
        String string2 = stringArray[0];
        String string3 = stringArray.length > 1 ? stringArray[1] : "";
        String string4 = stringArray.length > 2 ? stringArray[2] : "";
        return new Locale(string2, string3, string4);
    }

    public static Locale getLocale(String string, String string2) {
        Locale locale = string != null ? (string2 != null ? new Locale(string, string2) : ServerUtil.getLocale(string)) : Locale.getDefault();
        return locale;
    }

    public static Locale getLocale(String string, String string2, String string3) {
        if (string != null && string.trim().length() > 0 && string2 != null && string2.trim().length() > 0 && string3 != null && string3.trim().length() > 0) {
            return new Locale(string, string2, string3);
        }
        return ServerUtil.getLocale(string, string2);
    }

    public static Locale[] sortLocale(Locale[] localeArray) {
        Arrays.sort(localeArray, new Comparator<Locale>(){

            @Override
            public int compare(Locale locale, Locale locale2) {
                if (locale == null || locale2 == null) {
                    return 0;
                }
                int n = locale.getLanguage().compareTo(locale2.getLanguage());
                if (n != 0) {
                    return n;
                }
                n = locale.getCountry().compareTo(locale2.getCountry());
                if (n != 0) {
                    return n;
                }
                return locale.getVariant().compareTo(locale2.getVariant());
            }
        });
        return localeArray;
    }

    public static String filterLogSecretInfo(String string) {
        if (string == null) {
            return string;
        }
        string = string.replaceAll("jrs\\.db_user=[^&\\W]*", "jrs.db_user=*****");
        string = string.replaceAll("jrs\\.db_pswd=[^&\\W]*", "");
        string = string.replaceAll("jrs\\.new_db_pswd=[^&\\W]*", "");
        string = string.replaceAll("jrs\\.ds_user=[^&\\W]*", "jrs.ds_user=*****");
        string = string.replaceAll("jrs\\.ds_pswd=[^&\\W]*", "");
        string = string.replaceAll("jrs\\.new_ds_pswd=[^&\\W]*", "");
        string = string.replaceAll("jrs\\.ds_pswd%3d[^&\\W]*%26", "");
        string = string.replaceAll("jrs\\.auth_pwd=[^&\\W]*", "jrs.auth_pwd=******");
        string = string.replaceAll("jrs\\.authorization=[^&\\W]*", "jrs.auth_pwd=******");
        return string;
    }

    public static boolean isOOMECause(Throwable throwable) {
        while (throwable != null) {
            List list;
            if (throwable instanceof OutOfMemoryError) {
                return true;
            }
            if (throwable instanceof RptServerException && (list = ((RptServerException)((Object)throwable)).getEngineErrors()) != null) {
                for (Object e : list) {
                    if (!(e instanceof Throwable) || !ServerUtil.isOOMECause((Throwable)e)) continue;
                    return true;
                }
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static void evalExpressionValues(Map map) {
        ParamUtil.evalExpressionValues(map);
    }

    public static void evalExpressionValues(Map map, boolean bl) throws InvalidParameterException {
        ParamUtil.evalExpressionValues(map, bl);
    }

    public static boolean parseExpression(String string) throws ParseFormulaFailedException {
        return ParamUtil.parseExpression(string);
    }

    public static String getFormulaExpr(String string) throws ParseFormulaFailedException {
        return ParamUtil.getFormulaExpr(string);
    }

    public static Object evalExpressionValue(String string, String string2) throws ParseFormulaFailedException, ExecFormulaFailedException {
        return ParamUtil.evalExpressionValue(string, string2);
    }

    public static DbValue evalExpressionValue(String string) throws ParseFormulaFailedException, ExecFormulaFailedException {
        return ParamUtil.evalExpressionValue(string);
    }

    public static String getExpression(Map map, String string) {
        return ParamUtil.getExpression(map, string);
    }

    public static Vector<String> parseSheetNames(Map map) {
        return JRTUtil.parseSheetNames(map);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isEmpty(List list) {
        return list == null || list.size() == 0;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.size() == 0;
    }

    public static String getSiteFromUrl(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("://");
        n = n == -1 ? 0 : (n += 3);
        int n2 = string.indexOf("/", n);
        if (n2 == -1) {
            n2 = string.length();
        }
        String string2 = string.substring(0, n2);
        return string2;
    }

    public static String getHostFromUrl(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("://");
        n = n == -1 ? 0 : (n += 3);
        int n2 = string.indexOf("/", n);
        int n3 = string.indexOf(":", n);
        int n4 = string.length();
        if (n2 > -1) {
            n4 = n2;
        }
        if (n3 != -1 && n3 < n4) {
            n4 = n3;
        }
        String string2 = string.substring(n, n4);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testConnecting(Properties properties) {
        String string = properties.getProperty("driver");
        String string2 = properties.getProperty("url");
        String string3 = properties.getProperty("user");
        String string4 = properties.getProperty("password");
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ServiceLogger.logError(classNotFoundException);
            return false;
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string2, string3, string4);
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static String[] parseQualifiedBVElementName(String string) {
        String[] stringArray = new String[3];
        int n = 0;
        n = string.indexOf(".");
        stringArray[0] = string.substring(0, n).replace("%" + Integer.toHexString(46), ".");
        int n2 = string.indexOf(".", n + 1);
        stringArray[1] = string.substring(n + 1, n2);
        stringArray[2] = string.substring(n2 + 1);
        return stringArray;
    }

    public static String getQualifiedDSName(String string) {
        return string.replace(".", "%" + Integer.toHexString(46));
    }

    public static String getQualifiedBVName(String string, String string2) {
        return ServerUtil.getQualifiedDSName(string) + "." + string2;
    }

    public static String getQualifiedBVElementName(String string, String string2, String string3) {
        return ServerUtil.getQualifiedDSName(string) + "." + string2 + "." + string3;
    }

    public static String getQualifiedBVElementName(String string, String string2, BLNode bLNode) {
        return ServerUtil.getQualifiedBVElementName(string, string2, bLNode.getQualifyDisplayName());
    }

    public static String escapeDataSourceConnectionName(String string, String string2) {
        return "QAZPLM$" + CSUtil.replWithEsc(string, null) + "." + CSUtil.replWithEsc(string2, null);
    }

    public static String[] parseDataSourceConnectionName(String string) {
        String[] stringArray = new String[2];
        if (null == string) {
            return stringArray;
        }
        if (!string.startsWith("QAZPLM$")) {
            stringArray[0] = string;
        } else {
            String string2 = string.substring("QAZPLM$".length());
            int n = 0;
            n = string2.indexOf(".");
            stringArray[0] = CSUtil.convertEscapes(string2.substring(0, n));
            stringArray[1] = CSUtil.convertEscapes(string2.substring(n + 1));
        }
        return stringArray;
    }

    public static boolean mapEquals(Map<String, String> map, Map<String, String> map2) {
        boolean bl = ServerUtil.isEmpty(map);
        boolean bl2 = ServerUtil.isEmpty(map2);
        if (bl && bl2) {
            return true;
        }
        if (bl || bl2) {
            return false;
        }
        boolean bl3 = false;
        if (map.size() == map2.size()) {
            bl3 = true;
            for (String string : map.keySet()) {
                if (map2.containsKey(string) && StringUtils.equals(map.get(string), map2.get(string))) continue;
                bl3 = false;
                break;
            }
        }
        return bl3;
    }

    public static boolean mapContains(Map<String, String> map, Map<String, String> map2) {
        boolean bl = ServerUtil.isEmpty(map);
        boolean bl2 = ServerUtil.isEmpty(map2);
        if (bl2) {
            return true;
        }
        if (bl || map.size() < map2.size()) {
            return false;
        }
        boolean bl3 = true;
        for (String string : map2.keySet()) {
            if (map.containsKey(string) && StringUtils.equals(map.get(string), map2.get(string))) continue;
            bl3 = false;
            break;
        }
        return bl3;
    }
}

