/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletContext;
import jet.server.util.AbstractResource;
import jet.server.util.Resource;
import jet.server.util.StringUtils;
import jet.server.util.WebUtils;

public class ServletContextResource
extends AbstractResource {
    private final ServletContext SEDU;
    private final String append;

    public ServletContextResource(ServletContext servletContext, String string) {
        if (servletContext == null) {
            throw new IllegalArgumentException("Cannot resolve ServletContextResource without ServletContext");
        }
        this.SEDU = servletContext;
        if (string == null) {
            throw new IllegalArgumentException("path is required");
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        this.append = StringUtils.cleanPath(string);
    }

    public final ServletContext getServletContext() {
        return this.SEDU;
    }

    public final String getPath() {
        return this.append;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.SEDU.getResourceAsStream(this.append);
        if (inputStream == null) {
            throw new FileNotFoundException("Could not open " + this.getDescription());
        }
        return inputStream;
    }

    @Override
    public URL getURL() throws IOException {
        URL uRL = this.SEDU.getResource(this.append);
        if (uRL == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return uRL;
    }

    @Override
    public File getFile() throws IOException {
        String string = WebUtils.getRealPath(this.SEDU, this.append);
        return new File(string);
    }

    @Override
    public Resource createRelative(String string) throws IOException {
        String string2 = StringUtils.applyRelativePath(this.append, string);
        return new ServletContextResource(this.SEDU, string2);
    }

    @Override
    public String getFilename() {
        return StringUtils.getFilename(this.append);
    }

    @Override
    public String getDescription() {
        return "ServletContext resource [" + this.append + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ServletContextResource) {
            ServletContextResource servletContextResource = (ServletContextResource)object;
            return this.SEDU.equals(servletContextResource.SEDU) && this.append.equals(servletContextResource.append);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.append.hashCode();
    }
}

