/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import guitools.toolkit.JDebug;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import toolkit.db.MiniSort;
import toolkit.db.SortCompareInterface;

public class SortExProperties
extends ExProperties
implements SortCompareInterface {
    public SortExProperties() {
    }

    public SortExProperties(Properties properties) {
        super(properties);
    }

    @Override
    protected void saveTo(OutputStream outputStream, String string) {
        try {
            Vector vector;
            PrintWriter printWriter = CSUtil.getUrlEncoding() != null ? new PrintWriter(new OutputStreamWriter(outputStream, CSUtil.getUrlEncoding())) : new PrintWriter(new OutputStreamWriter(outputStream, "ISO-8859-1"));
            Enumeration<Object> enumeration = this.keys();
            if (string != null && string.length() != 0) {
                this.writeLine(printWriter, "# " + string);
            }
            if ((vector = this.sort(enumeration)) != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string2 = (String)vector.elementAt(i);
                    String string3 = (String)this.get(string2);
                    if (string3.endsWith("\\")) {
                        string3 = string3 + " ";
                    }
                    this.writeLine(printWriter, string2 + "=" + string3);
                }
            }
            this.writeLine(printWriter, "");
            printWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDebug.WARNING((Throwable)unsupportedEncodingException);
        }
    }

    @Override
    protected void backUpAndSave(String string, String string2) throws IOException {
        File file = new File(string);
        File file2 = new File(string + ".bak");
        Object var5_5 = null;
        if (file.exists()) {
            file2.delete();
            file.renameTo(file2);
            file2 = new File(string + ".bak");
        }
        if (!file2.exists()) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            this.saveTo(bufferedOutputStream, string2);
            bufferedOutputStream.close();
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.saveTo(fileOutputStream, string2);
    }

    private Vector sort(Enumeration enumeration) {
        Vector<String> vector = new Vector<String>();
        try {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
            MiniSort.sort(vector, this);
            return vector;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean isExchangeSortOrder(Object object, Object object2) {
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object2;
            String string2 = (String)object;
            return CSUtil.compareIgnoreCase(string, string2) > 0;
        }
        return false;
    }

    @Override
    public boolean isLargerOrEqual(Object object, Object object2) {
        return false;
    }

    @Override
    public boolean isLessOrEqual(Object object, Object object2) {
        return false;
    }
}

