/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jet.cs.CSUtil;

public final class StringUtil {
    private static final String SEDU = "=: \t\r\n\f#!";
    private static final char[] URLDecode = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encode(String string) {
        return StringUtil.encode(string, true);
    }

    public static String encode(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(StringUtil.SEDU(c >> 12 & 0xF));
                        stringBuffer.append(StringUtil.SEDU(c >> 8 & 0xF));
                        stringBuffer.append(StringUtil.SEDU(c >> 4 & 0xF));
                        stringBuffer.append(StringUtil.SEDU(c & 0xF));
                        continue block8;
                    }
                    if (SEDU.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String decode(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    private static char SEDU(int n) {
        return URLDecode[n & 0xF];
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(string.length() * 6);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c)) {
                stringBuffer.append(c);
                continue;
            }
            if (c < '\u0100') {
                stringBuffer.append("%");
                if (c < '\u0010') {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toString(c, 16));
                continue;
            }
            stringBuffer.append("%u");
            stringBuffer.append(Integer.toString(c, 16));
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(string.length());
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            n2 = string.indexOf("%", n);
            if (n2 == n) {
                char c;
                if (string.charAt(n2 + 1) == 'u') {
                    c = (char)Integer.parseInt(string.substring(n2 + 2, n2 + 6), 16);
                    stringBuffer.append(c);
                    n = n2 + 6;
                    continue;
                }
                c = (char)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
                stringBuffer.append(c);
                n = n2 + 3;
                continue;
            }
            if (n2 == -1) {
                stringBuffer.append(string.substring(n));
                n = string.length();
                continue;
            }
            stringBuffer.append(string.substring(n, n2));
            n = n2;
        }
        return stringBuffer.toString();
    }

    public static String URLDecode(String string) {
        String string2 = null;
        String string3 = CSUtil.getUrlEncoding();
        string2 = string3 != null && string3.length() > 0 ? StringUtil.URLDecode(string, string3) : StringUtil.URLDecode(string, "UTF-8");
        return string2;
    }

    public static String URLDecode(String string, String string2) {
        String string3 = null;
        try {
            string3 = URLDecoder.decode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("Not Supposed " + string2 + " Encoding");
        }
        return string3;
    }

    public static String URLEncode(String string) {
        String string2 = null;
        String string3 = CSUtil.getUrlEncoding();
        string2 = string3 != null && string3.length() > 0 ? StringUtil.URLEncode(string, string3) : StringUtil.URLEncode(string, "UTF-8");
        return string2;
    }

    public static String URLEncode(String string, String string2) {
        String string3 = null;
        try {
            string3 = URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("Not Supposed " + string2 + " Encoding");
        }
        return string3;
    }

    public static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        HashSet<String> hashSet = new HashSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[hashSet.size()];
        hashSet.toArray(stringArray);
        return stringArray;
    }

    public static String toString(Object object) {
        if (object instanceof String[]) {
            return StringUtil.toString((String[])object);
        }
        if (object instanceof Map) {
            return StringUtil.toString((Map)object);
        }
        if (object instanceof List) {
            return StringUtil.toString((List)object);
        }
        return object == null ? "<NULL>" : object.toString();
    }

    public static String toString(List list) {
        if (list == null) {
            return "<NULL>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        for (Object e : list) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(e);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String toString(String[] stringArray) {
        if (stringArray == null) {
            return "<NULL>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        for (String string : stringArray) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String toString(Map map) {
        if (map == null) {
            return "<NULL>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            if (n > 0) {
                stringBuffer.append(", ");
            }
            if (v instanceof String[]) {
                stringBuffer.append(string).append(":").append(StringUtil.toString((String[])v));
            } else if (v instanceof List) {
                stringBuffer.append(string).append(":").append(StringUtil.toString((List)v));
            } else {
                stringBuffer.append(string).append(":").append(StringUtil.toString(v));
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

