/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import jet.util.IntStack;

public abstract class StringUtils {
    private static final String SEDU = "/";
    private static final String UP = "\\";
    private static final String add = "..";
    private static final String addAll = ".";
    private static final char append = '.';

    public static boolean equals(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public static boolean hasLength(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean hasText(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String trimWhitespace(String string) {
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() > 0 && Character.isWhitespace(stringBuffer.charAt(0))) {
            stringBuffer.deleteCharAt(0);
        }
        while (stringBuffer.length() > 0 && Character.isWhitespace(stringBuffer.charAt(stringBuffer.length() - 1))) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static String trimLeadingWhitespace(String string) {
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() > 0 && Character.isWhitespace(stringBuffer.charAt(0))) {
            stringBuffer.deleteCharAt(0);
        }
        return stringBuffer.toString();
    }

    public static String trimTrailingWhitespace(String string) {
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() > 0 && Character.isWhitespace(stringBuffer.charAt(stringBuffer.length() - 1))) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static String trimAllWhitespace(String string) {
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (stringBuffer.length() > n) {
            if (Character.isWhitespace(stringBuffer.charAt(n))) {
                stringBuffer.deleteCharAt(n);
                continue;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.startsWith(string2)) {
            return true;
        }
        if (string.length() < string2.length()) {
            return false;
        }
        String string3 = string.substring(0, string2.length()).toLowerCase();
        String string4 = string2.toLowerCase();
        return string3.equals(string4);
    }

    public static boolean endsWithIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.endsWith(string2)) {
            return true;
        }
        if (string.length() < string2.length()) {
            return false;
        }
        String string3 = string.substring(string.length() - string2.length()).toLowerCase();
        String string4 = string2.toLowerCase();
        return string3.equals(string4);
    }

    public static int countOccurrencesOf(String string, String string2) {
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n2)) != -1) {
            ++n;
            n2 = n3 + string2.length();
        }
        return n;
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null || string3 == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf(string2);
        int n3 = string2.length();
        while (n2 >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + n3;
            n2 = string.indexOf(string2, n);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String delete(String string, String string2) {
        return StringUtils.replace(string, string2, "");
    }

    public static String deleteAny(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String quote(String string) {
        return string != null ? "'" + string + "'" : null;
    }

    public static Object quoteIfString(Object object) {
        return object instanceof String ? StringUtils.quote((String)object) : object;
    }

    public static String unqualify(String string) {
        return StringUtils.unqualify(string, '.');
    }

    public static String unqualify(String string, char c) {
        return string.substring(string.lastIndexOf(c) + 1);
    }

    public static String capitalize(String string) {
        return StringUtils.SEDU(string, true);
    }

    public static String uncapitalize(String string) {
        return StringUtils.SEDU(string, false);
    }

    private static String SEDU(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (bl) {
            stringBuffer.append(Character.toUpperCase(string.charAt(0)));
        } else {
            stringBuffer.append(Character.toLowerCase(string.charAt(0)));
        }
        stringBuffer.append(string.substring(1));
        return stringBuffer.toString();
    }

    public static String getFilename(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(SEDU);
        return n != -1 ? string.substring(n + 1) : string;
    }

    public static String getFilenameExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(n + 1) : null;
    }

    public static String stripFilenameExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(0, n) : string;
    }

    public static String applyRelativePath(String string, String string2) {
        int n = string.lastIndexOf(SEDU);
        if (n != -1) {
            String string3 = string.substring(0, n);
            if (!string2.startsWith(SEDU)) {
                string3 = string3 + SEDU;
            }
            return string3 + string2;
        }
        return string2;
    }

    public static String cleanPath(String string) {
        int n;
        String string2 = StringUtils.replace(string, UP, SEDU);
        int n2 = string2.indexOf(":");
        String string3 = "";
        if (n2 != -1) {
            string3 = string2.substring(0, n2 + 1);
            string2 = string2.substring(n2 + 1);
        }
        String[] stringArray = StringUtils.delimitedListToStringArray(string2, SEDU);
        LinkedList<String> linkedList = new LinkedList<String>();
        int n3 = 0;
        for (n = stringArray.length - 1; n >= 0; --n) {
            if (addAll.equals(stringArray[n])) continue;
            if (add.equals(stringArray[n])) {
                ++n3;
                continue;
            }
            if (n3 > 0) {
                --n3;
                continue;
            }
            linkedList.add(0, stringArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            linkedList.add(0, add);
        }
        return string3 + StringUtils.collectionToDelimitedString(linkedList, SEDU);
    }

    public static boolean pathEquals(String string, String string2) {
        return StringUtils.cleanPath(string).equals(StringUtils.cleanPath(string2));
    }

    public static Locale parseLocaleString(String string) {
        String[] stringArray = StringUtils.tokenizeToStringArray(string, "_ ", false, false);
        String string2 = stringArray.length > 0 ? stringArray[0] : "";
        String string3 = stringArray.length > 1 ? stringArray[1] : "";
        String string4 = stringArray.length > 2 ? stringArray[2] : "";
        return string2.length() > 0 ? new Locale(string2, string3, string4) : null;
    }

    public static String[] addStringToArray(String[] stringArray, String string) {
        if (stringArray == null) {
            return new String[]{string};
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    public static String[] concatenateStringArrays(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2;
        }
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static String[] mergeStringArrays(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2;
        }
        if (stringArray2 == null) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return StringUtils.toStringArray(arrayList);
    }

    public static String[] sortStringArray(String[] stringArray) {
        if (stringArray == null) {
            return new String[0];
        }
        Arrays.sort(stringArray);
        return stringArray;
    }

    public static String[] toStringArray(Collection collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] removeDuplicateStrings(String[] stringArray) {
        if (stringArray == null) {
            return stringArray;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            treeSet.add(stringArray[i]);
        }
        return StringUtils.toStringArray(treeSet);
    }

    public static String[] split(String string, String string2) {
        if (!StringUtils.hasLength(string) || !StringUtils.hasLength(string2)) {
            return null;
        }
        int n = string.indexOf(string2);
        if (n < 0) {
            return null;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + string2.length());
        return new String[]{string3, string4};
    }

    public static Properties splitArrayElementsIntoProperties(String[] stringArray, String string) {
        return StringUtils.splitArrayElementsIntoProperties(stringArray, string, null);
    }

    public static Properties splitArrayElementsIntoProperties(String[] stringArray, String string, String string2) {
        if (stringArray == null) {
            return null;
        }
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            String string3 = stringArray[i];
            if (string2 != null) {
                string3 = StringUtils.deleteAny(stringArray[i], string2);
            }
            if ((stringArray2 = StringUtils.split(string3, string)) == null) continue;
            properties.setProperty(stringArray2[0].trim(), stringArray2[1].trim());
        }
        return properties;
    }

    public static String[] tokenizeToStringArray(String string, String string2) {
        return StringUtils.tokenizeToStringArray(string, string2, true, true);
    }

    public static String[] tokenizeToStringArray(String string, String string2, boolean bl, boolean bl2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (bl) {
                string3 = string3.trim();
            }
            if (bl2 && string3.length() <= 0) continue;
            arrayList.add(string3);
        }
        return StringUtils.toStringArray(arrayList);
    }

    public static String[] delimitedListToStringArray(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        if (string2 == null) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ("".equals(string2)) {
            for (int i = 0; i < string.length(); ++i) {
                arrayList.add(string.substring(i, i + 1));
            }
        } else {
            int n = 0;
            int n2 = 0;
            while ((n2 = string.indexOf(string2, n)) != -1) {
                arrayList.add(string.substring(n, n2));
                n = n2 + string2.length();
            }
            if (string.length() > 0 && n <= string.length()) {
                arrayList.add(string.substring(n));
            }
        }
        return StringUtils.toStringArray(arrayList);
    }

    public static String[] commaDelimitedListToStringArray(String string) {
        return StringUtils.delimitedListToStringArray(string, ",");
    }

    public static Set commaDelimitedListToSet(String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray = StringUtils.commaDelimitedListToStringArray(string);
        for (int i = 0; i < stringArray.length; ++i) {
            treeSet.add(stringArray[i]);
        }
        return treeSet;
    }

    public static String collectionToDelimitedString(Collection collection, String string, String string2, String string3) {
        if (collection == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(string2).append(iterator.next()).append(string3);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String collectionToDelimitedString(Collection collection, String string) {
        return StringUtils.collectionToDelimitedString(collection, string, "", "");
    }

    public static String collectionToCommaDelimitedString(Collection collection) {
        return StringUtils.collectionToDelimitedString(collection, ",");
    }

    public static String arrayToDelimitedString(Object[] objectArray, String string) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String arrayToCommaDelimitedString(Object[] objectArray) {
        return StringUtils.arrayToDelimitedString(objectArray, ",");
    }

    public static boolean matchWildcard(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        IntStack intStack = null;
        IntStack intStack2 = null;
        int n = string.length();
        int n2 = string2.length();
        if (bl) {
            string = string.toUpperCase();
            string2 = string2.toUpperCase();
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        block0: while (bl2 || n4 != n2) {
            int n6;
            if (n3 == n) {
                for (n6 = n4; n6 < n2; ++n6) {
                    if (string2.charAt(n6) == '*') continue;
                    return false;
                }
                return true;
            }
            if (n4 < n2) {
                n6 = string2.charAt(n4);
                if (n6 == 42) {
                    while (++n4 < n2 && string2.charAt(n4) == '*') {
                    }
                    if (n4 == n2) {
                        return true;
                    }
                    if (intStack == null) {
                        intStack = new IntStack();
                        intStack2 = new IntStack();
                    }
                    intStack.push(n3);
                    intStack2.push(n4);
                    continue;
                }
                char c = string.charAt(n3);
                if (n6 == c || n6 == 63) {
                    ++n3;
                    ++n4;
                    continue;
                }
            }
            while (true) {
                if (intStack == null || intStack.size() == 0) {
                    if (bl2 || bl3) {
                        return false;
                    }
                    n3 = ++n5;
                    n4 = 0;
                    intStack = null;
                    intStack2 = null;
                    continue block0;
                }
                n4 = intStack2.peek();
                n3 = intStack.pop();
                if (++n3 < n) {
                    intStack.push(n3);
                    continue block0;
                }
                intStack2.pop();
            }
            break;
        }
        return true;
    }

    public static String lineWrapByPixel(String string, String string2, int n, Font font, Component component, boolean bl) throws Exception {
        if (null == string || 0 == string.length()) {
            throw new Exception("Text can not be blank");
        }
        if (null == string2 || 0 == string2.length()) {
            throw new Exception("WrapStyle can not be blank");
        }
        if (0 >= n) {
            throw new Exception("EveryRowPixelWidth must be greater than 0");
        }
        if (null == font || null == component) {
            throw new Exception("Font or component can not be null");
        }
        FontMetrics fontMetrics = component.getFontMetrics(font);
        int n2 = fontMetrics.stringWidth(string);
        BigDecimal bigDecimal = new BigDecimal(n2).divide(new BigDecimal(string.length()), RoundingMode.UP);
        if (n < bigDecimal.intValueExact()) {
            throw new Exception("Pixel width of every row can not be smaller than pixel width of every char");
        }
        int n3 = n / bigDecimal.intValueExact();
        if (n2 <= n) {
            return string;
        }
        return StringUtils.lineWrapByLength(string, string2, n3, bl);
    }

    public static String lineWrapByLength(String string, String string2, int n, boolean bl) throws Exception {
        if (null == string || 0 == string.length()) {
            throw new Exception("Text can not be blank");
        }
        if (null == string2 || 0 == string2.length()) {
            throw new Exception("WrapStyle can not be blank");
        }
        if (0 >= n) {
            throw new Exception("EveryRowLength must be greater than 0");
        }
        if (string.length() <= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if ("<br>".equals(string2)) {
            stringBuffer.append("<html>");
        }
        if (bl) {
            char[] cArray = string.toCharArray();
            List<Integer> list = StringUtils.UP(string, n);
            for (int i = 0; i < cArray.length; ++i) {
                stringBuffer.append(cArray[i]);
                for (Integer n2 : list) {
                    if (i + 1 != n2) continue;
                    stringBuffer.append(string2);
                }
            }
        } else {
            int n3 = string.length() / n + 1;
            for (int i = 0; i < n3; ++i) {
                String string3;
                if (n3 == i + 1) {
                    string3 = string.substring(i * n, string.length());
                    stringBuffer.append(string3);
                    continue;
                }
                string3 = string.substring(i * n, (i + 1) * n);
                stringBuffer.append(string3).append(string2);
            }
        }
        if ("<br>".equals(string2)) {
            stringBuffer.append("</html>");
        }
        return stringBuffer.toString();
    }

    private static List<Integer> UP(String string, int n) {
        char[] cArray = string.toCharArray();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = n - 1;
        int n3 = 1;
        do {
            if (0 == (n2 = StringUtils.add(cArray, n2))) {
                arrayList.add(n3 * n);
                n2 = ++n3 * n;
                continue;
            }
            arrayList.add(n2);
            n2 += n;
        } while (n2 < string.length() - 1);
        return arrayList;
    }

    private static int add(char[] cArray, int n) {
        while (' ' != cArray[n] && 0 != n) {
            --n;
        }
        return n;
    }
}

