/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.util.ThreadQueueElement;

public class ThreadQueueController {
    private int SEDU = 1;
    private Object add = new Object();
    private List clear;
    private List clone;
    private int contains;
    private int continueWaiting;
    private List currentTimeMillis = new ArrayList();
    private List dequeue = new ArrayList();
    QueuePolicy queuePolicy;
    private boolean dequeueNotify = true;

    public ThreadQueueController(int n, boolean bl) {
        int n2 = this.SEDU = n > 0 ? n : 1;
        if (bl) {
            this.continueWaiting = ServerEnv.getAcceleratedQueueSize();
            if (this.continueWaiting < 0 || this.continueWaiting >= this.SEDU) {
                this.continueWaiting = 0;
            }
        } else {
            this.continueWaiting = 0;
        }
        this.contains = this.SEDU - this.continueWaiting;
        this.clone = new ArrayList(this.continueWaiting);
        this.clear = new ArrayList(this.contains);
        int n3 = 0;
        if (bl) {
            n3 = ServerEnv.getQueuePolicy();
        }
        this.queuePolicy = n3 == 1 ? new PriorityBasedQueuePolicy() : (n3 == 2 ? new DynamicTimeQueuePolicy() : (n3 == 3 ? new DynamicCounterQueuePolicy() : new FIFOBasedQueuePolicy()));
        this.dequeueNotify = false;
        if (ServiceLogger.isLoggable(4, 6)) {
            ServiceLogger.logDebug(6600213, new String[]{String.valueOf(this.contains), String.valueOf(this.continueWaiting), String.valueOf(n3)}, 6);
        }
    }

    public synchronized boolean isFullActive() {
        return this.clear.size() + this.clone.size() >= this.SEDU;
    }

    public synchronized boolean isTaskQueueFull(int n) {
        if (this.isFullActive()) {
            return true;
        }
        return this.clear.size() >= this.contains && this.clone.size() < this.continueWaiting && this.queuePolicy instanceof PriorityBasedQueuePolicy && !((PriorityBasedQueuePolicy)this.queuePolicy).isInAcceleratedLists(n);
    }

    public synchronized int getActiveAndWaitReportsCount() {
        return this.clear.size() + this.clone.size() + this.currentTimeMillis.size() + this.dequeue.size();
    }

    public synchronized int getActiveReportsCount() {
        return this.clear.size() + this.clone.size();
    }

    public synchronized int getWaitReportsCount() {
        return this.currentTimeMillis.size() + this.dequeue.size();
    }

    public synchronized int getReadyWaitingReportsCount() {
        return this.dequeue.size();
    }

    public synchronized int getNormalWaitingReportsCount() {
        return this.currentTimeMillis.size();
    }

    public synchronized int getAcceleratedRunningReportsCount() {
        return this.clone.size();
    }

    public synchronized int getNormalRunningReportsCount() {
        return this.clear.size();
    }

    public synchronized List getReadyWaitingList() {
        return (List)((ArrayList)this.dequeue).clone();
    }

    public synchronized List getNormalWaitingList() {
        return (List)((ArrayList)this.currentTimeMillis).clone();
    }

    public synchronized List getAcceleratedRunningList() {
        return (List)((ArrayList)this.clone).clone();
    }

    public synchronized List getNormalRunningList() {
        return (List)((ArrayList)this.clear).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queueUp(ThreadQueueElement[] threadQueueElementArray) {
        int n = 0;
        if (this.SEDU > 0) {
            Object object = this.add;
            synchronized (object) {
                for (int i = 0; i < threadQueueElementArray.length; ++i) {
                    this.SEDU(threadQueueElementArray[i]);
                }
                while (true) {
                    if (this.add(threadQueueElementArray[0])) {
                        ++n;
                        break;
                    }
                    if (!this.currentTimeMillis.contains(threadQueueElementArray[0]) && !this.dequeue.contains(threadQueueElementArray[0])) break;
                    try {
                        this.add.wait();
                    }
                    catch (Throwable throwable) {
                        ServiceLogger.logError(throwable);
                        for (ThreadQueueElement threadQueueElement : threadQueueElementArray) {
                            if (this.dequeue.contains(threadQueueElement)) {
                                this.dequeue.remove(threadQueueElement);
                            } else if (this.currentTimeMillis.contains(threadQueueElement)) {
                                this.currentTimeMillis.remove(threadQueueElement);
                            }
                            threadQueueElement.dequeue();
                            this.queuePolicy.dequeueNotify();
                        }
                        break;
                    }
                }
            }
            if (n > 0) {
                for (int i = 1; i < threadQueueElementArray.length; ++i) {
                    if (!this.add(threadQueueElementArray[i])) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueUp(ThreadQueueElement threadQueueElement) {
        boolean bl = false;
        if (this.SEDU > 0) {
            Object object = this.add;
            synchronized (object) {
                this.SEDU(threadQueueElement);
                while (true) {
                    if (this.add(threadQueueElement)) {
                        bl = true;
                        break;
                    }
                    if (!this.currentTimeMillis.contains(threadQueueElement) && !this.dequeue.contains(threadQueueElement)) break;
                    try {
                        this.add.wait();
                    }
                    catch (Throwable throwable) {
                        ServiceLogger.logError(throwable);
                        if (this.dequeue.contains(threadQueueElement)) {
                            this.dequeue.remove(threadQueueElement);
                        } else if (this.currentTimeMillis.contains(threadQueueElement)) {
                            this.currentTimeMillis.remove(threadQueueElement);
                        }
                        threadQueueElement.dequeue();
                        this.queuePolicy.dequeueNotify();
                        break;
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRelease(ThreadQueueElement threadQueueElement) {
        Object object = this.add;
        synchronized (object) {
            ThreadQueueController threadQueueController = this;
            synchronized (threadQueueController) {
                if (this.clone.contains(threadQueueElement)) {
                    this.clone.remove(threadQueueElement);
                } else if (this.clear.contains(threadQueueElement)) {
                    this.clear.remove(threadQueueElement);
                } else if (this.dequeue.contains(threadQueueElement)) {
                    this.dequeue.remove(threadQueueElement);
                } else if (this.currentTimeMillis.contains(threadQueueElement)) {
                    this.currentTimeMillis.remove(threadQueueElement);
                }
                threadQueueElement.dequeue();
                this.queuePolicy.dequeueNotify();
            }
            this.add.notifyAll();
        }
    }

    private synchronized void SEDU(ThreadQueueElement threadQueueElement) {
        if (this.dequeueNotify) {
            return;
        }
        if (!this.currentTimeMillis.contains(threadQueueElement) && !this.dequeue.contains(threadQueueElement)) {
            this.currentTimeMillis.add(threadQueueElement);
            threadQueueElement.startWait();
            threadQueueElement.setJoinTime(System.currentTimeMillis());
            threadQueueElement.setAdjustTime(threadQueueElement.getJoinTime());
        }
    }

    private synchronized boolean add(ThreadQueueElement threadQueueElement) {
        if (this.dequeueNotify) {
            return false;
        }
        if (this.clear.size() + this.clone.size() < this.SEDU) {
            if (this.clone.size() < this.continueWaiting && this.queuePolicy.tryToAccelerated(threadQueueElement)) {
                this.clone.add(threadQueueElement);
                threadQueueElement.enqueue();
                return true;
            }
            if (this.clear.size() < this.contains && this.queuePolicy.tryToActive(threadQueueElement)) {
                this.clear.add(threadQueueElement);
                threadQueueElement.enqueue();
                return true;
            }
        }
        this.queuePolicy.continueWaiting(threadQueueElement);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        Object object = this.add;
        synchronized (object) {
            this.dequeueNotify = true;
            this.clear.clear();
            this.clone.clear();
            this.currentTimeMillis.clear();
            this.dequeue.clear();
            this.add.notifyAll();
        }
    }

    private class DynamicCounterQueuePolicy
    extends PriorityBasedQueuePolicy {
        private final int SEDU;
        private int access$000;

        DynamicCounterQueuePolicy() {
            this.policy = 3;
            this.SEDU = ServerEnv.getQueuePolicyReadjust();
        }

        @Override
        public void dequeueNotify() {
            ++this.access$000;
            if (this.access$000 >= this.SEDU) {
                this.access$000 = 0;
                long l = Long.MAX_VALUE;
                ArrayList<ThreadQueueElement> arrayList = new ArrayList<ThreadQueueElement>();
                if (ThreadQueueController.this.dequeue.size() > 0) {
                    ThreadQueueElement threadQueueElement;
                    long l2;
                    Collections.sort(ThreadQueueController.this.dequeue, this.adjustComparator);
                    int n = ThreadQueueController.this.dequeue.size();
                    for (int i = 0; i < n && (l2 = (threadQueueElement = (ThreadQueueElement)ThreadQueueController.this.dequeue.get(i)).getAdjustTime()) <= l; ++i) {
                        l = l2;
                        arrayList.add(threadQueueElement);
                    }
                }
                if (ThreadQueueController.this.currentTimeMillis.size() > 0) {
                    Collections.sort(ThreadQueueController.this.currentTimeMillis, this.adjustComparator);
                    ThreadQueueElement threadQueueElement = (ThreadQueueElement)ThreadQueueController.this.currentTimeMillis.get(0);
                    long l3 = threadQueueElement.getAdjustTime();
                    if (l3 <= l) {
                        if (l3 < l) {
                            arrayList.clear();
                            l = l3;
                        }
                        arrayList.add(threadQueueElement);
                        int n = ThreadQueueController.this.currentTimeMillis.size();
                        for (int i = 1; i < n && (l3 = (threadQueueElement = (ThreadQueueElement)ThreadQueueController.this.currentTimeMillis.get(i)).getAdjustTime()) == l; ++i) {
                            arrayList.add(threadQueueElement);
                        }
                    }
                }
                if (arrayList.size() > 0) {
                    for (ThreadQueueElement threadQueueElement : arrayList) {
                        int n = threadQueueElement.getPriority();
                        if (n >= 10) continue;
                        threadQueueElement.setPriority(++n);
                    }
                }
            }
        }
    }

    private class DynamicTimeQueuePolicy
    extends PriorityBasedQueuePolicy {
        private long I;

        DynamicTimeQueuePolicy() {
            this.policy = 2;
            this.I = (long)ServerEnv.getQueuePolicyWaitingTime() * 1000L;
        }

        @Override
        public void continueWaiting(ThreadQueueElement threadQueueElement) {
            super.continueWaiting(threadQueueElement);
            int n = threadQueueElement.getPriority();
            if (n < 10 && System.currentTimeMillis() - threadQueueElement.getAdjustTime() >= this.I) {
                threadQueueElement.setPriority(++n);
                threadQueueElement.setAdjustTime(System.currentTimeMillis());
            }
        }
    }

    private class PriorityBasedQueuePolicy
    extends FIFOBasedQueuePolicy {
        protected ThreadQueueElementComparator priorityComparator;
        protected ThreadQueueElementComparator adjustComparator;
        private int[] access$200;

        PriorityBasedQueuePolicy() {
            this.policy = 1;
            if (ThreadQueueController.this.continueWaiting > 0) {
                String string = ServerEnv.getQueueAccelerated();
                this.access$200 = this.I(string);
                if (this.access$200 == null) {
                    string = "10,9";
                    this.access$200 = this.I(string);
                }
            }
            this.priorityComparator = new ThreadQueueElementComparator(){

                @Override
                public int compareBy(ThreadQueueElement threadQueueElement, ThreadQueueElement threadQueueElement2) {
                    return threadQueueElement2.getPriority() - threadQueueElement.getPriority();
                }
            };
            this.adjustComparator = new ThreadQueueElementComparator(){

                @Override
                public int compareBy(ThreadQueueElement threadQueueElement, ThreadQueueElement threadQueueElement2) {
                    return (int)(threadQueueElement.getAdjustTime() - threadQueueElement2.getAdjustTime());
                }
            };
        }

        @Override
        public boolean tryToAccelerated(ThreadQueueElement threadQueueElement) {
            if (this.isInAcceleratedLists(threadQueueElement.getPriority())) {
                return this.isMostEligible(threadQueueElement);
            }
            return false;
        }

        @Override
        protected boolean isInWaiting(List list, ThreadQueueElement threadQueueElement) {
            Collections.sort(list, this.priorityComparator);
            return super.isInWaiting(list, threadQueueElement);
        }

        public boolean isInAcceleratedLists(int n) {
            boolean bl = false;
            for (int i = 0; i < this.access$200.length; ++i) {
                if (n != this.access$200[i]) continue;
                bl = true;
                break;
            }
            return bl;
        }

        private int[] I(String string) {
            int[] nArray = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,", false);
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        return null;
                    }
                    try {
                        nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                }
            }
            return nArray;
        }

        private abstract class ThreadQueueElementComparator
        implements Comparator {
            public int compare(Object object, Object object2) {
                if (!(object instanceof ThreadQueueElement) || !(object2 instanceof ThreadQueueElement)) {
                    return 0;
                }
                return this.compareBy((ThreadQueueElement)object, (ThreadQueueElement)object2);
            }

            public abstract int compareBy(ThreadQueueElement var1, ThreadQueueElement var2);
        }
    }

    private class FIFOBasedQueuePolicy
    implements QueuePolicy {
        protected int policy = 0;

        FIFOBasedQueuePolicy() {
        }

        @Override
        public int getPolicy() {
            return this.policy;
        }

        @Override
        public boolean tryToAccelerated(ThreadQueueElement threadQueueElement) {
            return this.isMostEligible(threadQueueElement);
        }

        @Override
        public boolean tryToActive(ThreadQueueElement threadQueueElement) {
            return this.isMostEligible(threadQueueElement);
        }

        @Override
        public void continueWaiting(ThreadQueueElement threadQueueElement) {
        }

        @Override
        public void dequeueNotify() {
        }

        protected boolean isMostEligible(ThreadQueueElement threadQueueElement) {
            if (this.isInWaiting(ThreadQueueController.this.dequeue, threadQueueElement)) {
                ThreadQueueController.this.dequeue.remove(threadQueueElement);
                return true;
            }
            if (ThreadQueueController.this.dequeue.size() == 0 && this.isInWaiting(ThreadQueueController.this.currentTimeMillis, threadQueueElement)) {
                ThreadQueueController.this.currentTimeMillis.remove(threadQueueElement);
                return true;
            }
            return false;
        }

        protected boolean isInWaiting(List list, ThreadQueueElement threadQueueElement) {
            int n = list.size();
            return n > 0 && list.get(0) == threadQueueElement;
        }
    }

    private static interface QueuePolicy {
        public static final int FIFO_BASED = 0;
        public static final int STATIC_PRIORITY_BASED = 1;
        public static final int DYNAMIC_WAITING_TIME_BASED = 2;
        public static final int DYNAMIC_COUNTER_BASED = 3;

        public int getPolicy();

        public boolean tryToAccelerated(ThreadQueueElement var1);

        public boolean tryToActive(ThreadQueueElement var1);

        public void continueWaiting(ThreadQueueElement var1);

        public void dequeueNotify();
    }
}

