/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jet.server.log.ServiceLogger;
import jet.server.util.WebSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static Document newDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ServiceLogger.logError(parserConfigurationException, 2);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadDocument(File file) {
        BufferedInputStream bufferedInputStream = null;
        Document document = null;
        if (file.exists()) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                document = documentBuilder.parse(bufferedInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ServiceLogger.logError(fileNotFoundException, 2);
                Document document2 = null;
                return document2;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ServiceLogger.logError(parserConfigurationException, 2);
                Document document3 = null;
                return document3;
            }
            catch (SAXException sAXException) {
                ServiceLogger.logError(sAXException, 2);
                Document document4 = null;
                return document4;
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 2);
                Document document5 = null;
                return document5;
            }
            finally {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException, 3);
                }
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadDocument(String string) {
        BufferedInputStream bufferedInputStream = null;
        Document document = null;
        File file = WebSecurityUtil.validateFilePath(string);
        if (file != null && file.exists()) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                document = documentBuilder.parse(bufferedInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ServiceLogger.logError(fileNotFoundException, 2);
                Document document2 = null;
                return document2;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ServiceLogger.logError(parserConfigurationException, 2);
                Document document3 = null;
                return document3;
            }
            catch (SAXException sAXException) {
                ServiceLogger.logError(sAXException, 2);
                Document document4 = null;
                return document4;
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 2);
                Document document5 = null;
                return document5;
            }
            finally {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException, 3);
                }
            }
        }
        return document;
    }

    public static Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            document.setXmlVersion("1.0");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ServiceLogger.logError(parserConfigurationException, 2);
            return null;
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadDocument(byte[] byArray) {
        BufferedInputStream bufferedInputStream = null;
        Document document = null;
        try {
            if (byArray != null) {
                bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
                document = XMLUtil.loadDocument(bufferedInputStream);
            }
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadDocument(InputStream inputStream) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (inputStream != null) {
                document = documentBuilder.parse(inputStream);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ServiceLogger.logError(parserConfigurationException, 2);
            Document document2 = null;
            return document2;
        }
        catch (SAXException sAXException) {
            ServiceLogger.logError(sAXException, 2);
            Document document3 = null;
            return document3;
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 2);
            Document document4 = null;
            return document4;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized byte[] saveDocument(Document document) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(dOMSource, streamResult);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            ServiceLogger.logError(transformerConfigurationException, 2);
        }
        catch (TransformerException transformerException) {
            ServiceLogger.logError(transformerException, 2);
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void saveDocument(Document document, String string) {
        OutputStreamWriter outputStreamWriter = null;
        Document document2 = document;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DOMSource dOMSource = new DOMSource(document2);
            File file = WebSecurityUtil.validateFilePath(string);
            file.getParentFile().mkdirs();
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            StreamResult streamResult = new StreamResult(outputStreamWriter);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(dOMSource, streamResult);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ServiceLogger.logError(fileNotFoundException, 2);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            ServiceLogger.logError(transformerConfigurationException, 2);
        }
        catch (TransformerException transformerException) {
            ServiceLogger.logError(transformerException, 2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ServiceLogger.logError(unsupportedEncodingException, 2);
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static synchronized Element[] getChildElements(Element element) {
        Element[] elementArray;
        if (element == null) {
            return null;
        }
        Vector<Element> vector = new Vector<Element>();
        for (elementArray = element.getFirstChild(); elementArray != null; elementArray = elementArray.getNextSibling()) {
            if (elementArray.getNodeType() != 1) continue;
            vector.add((Element)elementArray);
        }
        elementArray = new Element[vector.size()];
        vector.toArray(elementArray);
        return elementArray;
    }

    public static synchronized Element[] getChildElements(Element element, String string) {
        Element[] elementArray;
        if (element == null || string == null || string.length() == 0) {
            return null;
        }
        Vector<Element> vector = new Vector<Element>();
        for (elementArray = element.getFirstChild(); elementArray != null; elementArray = elementArray.getNextSibling()) {
            if (elementArray.getNodeType() != 1 || !elementArray.getNodeName().equals(string)) continue;
            vector.add((Element)elementArray);
        }
        elementArray = new Element[vector.size()];
        vector.toArray(elementArray);
        return elementArray;
    }

    public static synchronized Node[] getChildNodes(Node node) {
        Node[] nodeArray;
        if (node == null) {
            return null;
        }
        Vector<Element> vector = new Vector<Element>();
        for (nodeArray = node.getFirstChild(); nodeArray != null; nodeArray = nodeArray.getNextSibling()) {
            vector.add((Element)nodeArray);
        }
        nodeArray = new Element[vector.size()];
        vector.toArray(nodeArray);
        return nodeArray;
    }

    public static synchronized Element getChildElement(Element element, String string) {
        if (element == null || string == null || string.length() == 0) {
            return null;
        }
        Element element2 = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNodeName().equals(string)) continue;
            element2 = (Element)node;
            break;
        }
        return element2;
    }

    public static synchronized Element getChildElement(Element element) {
        if (element == null) {
            return null;
        }
        Element element2 = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            element2 = (Element)node;
            break;
        }
        return element2;
    }

    public static synchronized String[] getElementValues(Element element) {
        String[] stringArray;
        if (element == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (stringArray = element.getFirstChild(); stringArray != null; stringArray = stringArray.getNextSibling()) {
            if (stringArray.getNodeType() != 3) continue;
            vector.add(stringArray.getNodeValue());
        }
        stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    public static synchronized String getElementValue(Element element) {
        if (element == null) {
            return null;
        }
        String string = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string2;
            if (node.getNodeType() != 3 || (string2 = node.getNodeValue()) == null || string2.length() == 0 || string2.trim().length() == 0) continue;
            string = string2;
            break;
        }
        return string;
    }

    public static synchronized Element getElementByName(Element element, String string) {
        int n;
        if (element == null || string == null || string.length() == 0) {
            return null;
        }
        String string2 = null;
        Element[] elementArray = XMLUtil.getChildElements(element);
        for (n = 0; n < elementArray.length; ++n) {
            string2 = elementArray[n].getNodeName();
            if (!string.equals(string2)) continue;
            return elementArray[n];
        }
        for (n = 0; n < elementArray.length; ++n) {
            Element element2 = XMLUtil.getElementByName(elementArray[n], string);
            if (element2 == null) continue;
            return element2;
        }
        return null;
    }

    public static synchronized Element getElementByAttr(Element element, String string, String string2) {
        return XMLUtil.getElementByAttr(element, string, string2, true);
    }

    public static synchronized Element getElementByAttr(Element element, String string, String string2, boolean bl) {
        int n;
        if (element == null || string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return null;
        }
        String string3 = null;
        Element[] elementArray = XMLUtil.getChildElements(element);
        for (n = 0; n < elementArray.length; ++n) {
            string3 = elementArray[n].getAttribute(string);
            if (!string2.equals(string3)) continue;
            return elementArray[n];
        }
        if (bl) {
            for (n = 0; n < elementArray.length; ++n) {
                Element element2 = XMLUtil.getElementByAttr(elementArray[n], string, string2);
                if (element2 == null) continue;
                return element2;
            }
        }
        return null;
    }

    public static synchronized void appendElement(Element element, Node node) {
        if (element == null || node == null) {
            return;
        }
        Document document = element.getOwnerDocument();
        Node node2 = document.importNode(node, true);
        element.appendChild(node2);
        element.appendChild(document.createTextNode("\n\t"));
    }

    public static synchronized void insertElement(Element element, Node node) {
        XMLUtil.insertElement(element, node, 0);
    }

    public static synchronized void insertElement(Element element, Node node, int n) {
        if (element == null || node == null) {
            return;
        }
        Element[] elementArray = XMLUtil.getChildElements(element);
        if (elementArray == null || elementArray.length == 0) {
            Document document = element.getOwnerDocument();
            Node node2 = document.importNode(node, true);
            element.appendChild(node2);
        } else {
            int n2 = n;
            if (n2 <= 0) {
                n2 = 1;
            }
            if (n2 > elementArray.length) {
                n2 = elementArray.length;
            }
            Document document = element.getOwnerDocument();
            Node node3 = document.importNode(node, true);
            Element element2 = elementArray[n2 - 1];
            element.insertBefore(node3, element2);
            element.insertBefore(document.createTextNode("\n\t"), element2);
        }
    }

    public static synchronized void setAttribute(Element element, String string, String string2) {
        if (element == null || string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return;
        }
        element.setAttribute(string, string2);
    }

    public static synchronized String getAttribute(Element element, String string) {
        return XMLUtil.getAttribute(element, string, null);
    }

    public static synchronized String getAttribute(Element element, String string, String string2) {
        if (element == null || string == null || string.length() == 0) {
            return string2;
        }
        return element.getAttribute(string);
    }

    public static synchronized void removeElement(Element element, String[] stringArray) {
        int n;
        if (element == null || stringArray == null || stringArray.length == 0) {
            return;
        }
        Vector<Element> vector = new Vector<Element>();
        Element[] elementArray = XMLUtil.getChildElements(element);
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            if (string == null || string.length() == 0) continue;
            for (int i = 0; i < elementArray.length; ++i) {
                if (!string.equals(elementArray[i].getNodeName())) continue;
                vector.add(elementArray[i]);
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            element.removeChild((Element)vector.get(n));
        }
    }

    public static synchronized void removeElement(Element element, Element element2) {
        if (element == null || element2 == null) {
            return;
        }
        element.removeChild(element2);
    }

    public static synchronized void deleteXMLFile(String string) {
        File file = WebSecurityUtil.validateFilePath(string);
        if (file != null && file.exists()) {
            file.delete();
        }
    }
}

