/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util.nls;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import jet.server.util.ClassUtils;

public abstract class PropertyMessageResourcesFactory {
    protected static Locale defalutLocale = Locale.ENGLISH;
    protected Map messages = new HashMap();
    protected Map messagesArray = new HashMap();
    protected String languagePath;
    protected boolean inited = false;
    protected Locale locale;
    protected String localeDir;

    protected PropertyMessageResourcesFactory(String string) {
        String[] stringArray = string.split("_");
        this.locale = stringArray.length == 3 ? new Locale(stringArray[0], stringArray[1], stringArray[2]) : (stringArray.length == 2 ? new Locale(stringArray[0], stringArray[1]) : new Locale(stringArray[0]));
        this.localeDir = string.toLowerCase().replace('_', '-');
    }

    protected synchronized void init() {
        String string;
        String string2;
        Properties properties;
        if (this.inited) {
            return;
        }
        String string3 = "resources" + File.separator + "server" + File.separator + "languages" + File.separator;
        if (this.languagePath != null && this.languagePath.trim().length() > 0 && !(string3 = this.languagePath).endsWith("/") && !string3.endsWith("\\")) {
            string3 = string3 + File.separator;
        }
        if ((properties = PropertyMessageResourcesFactory.loadResources(string2 = (string = string3 + this.localeDir.toLowerCase() + File.separator + "properties" + File.separator) + this.getFileName(), this.languagePath == null || this.languagePath.trim().length() == 0)) != null) {
            Iterator<Object> iterator = properties.keySet().iterator();
            String string4 = "";
            String string5 = "";
            String string6 = ".*\\[.*\\].*";
            while (iterator.hasNext()) {
                string4 = "";
                string5 = "";
                string4 = (String)iterator.next();
                string5 = properties.getProperty(string4);
                this.messages.put(string4, string5);
                if (!string4.matches(string6)) continue;
                this.messagesArray.put(string4, string5);
            }
        }
        this.inited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties loadResources(String string, boolean bl) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            if (!bl) {
                inputStream = new FileInputStream(new File(string));
            } else {
                ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
                inputStream = classLoader.getResourceAsStream(string.replace('\\', '/'));
            }
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (Throwable throwable) {
            Properties properties2 = null;
            return properties2;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return properties;
    }

    public String getMessage(String string) {
        return this.getMessage(string, new Object[0]);
    }

    protected abstract PropertyMessageResourcesFactory findFactory(String var1);

    public String getMessage(String string, Object[] objectArray) {
        this.init();
        String string2 = (String)this.messages.get(string);
        if (string2 == null) {
            string2 = "";
        }
        MessageFormat messageFormat = new MessageFormat(PropertyMessageResourcesFactory.escape(string2));
        messageFormat.setLocale(this.locale);
        return messageFormat.format(objectArray);
    }

    protected String getDefaultMessage(String string, Object[] objectArray) {
        String string2 = null;
        if (this.locale.getCountry() != null && this.locale.getCountry().trim().length() > 0) {
            PropertyMessageResourcesFactory propertyMessageResourcesFactory = this.findFactory(this.locale.getLanguage());
            propertyMessageResourcesFactory.setLanguagePath(this.languagePath);
            string2 = propertyMessageResourcesFactory.getMessage(string, objectArray);
        } else if (!this.locale.equals(defalutLocale)) {
            PropertyMessageResourcesFactory propertyMessageResourcesFactory = this.findFactory(defalutLocale.toString());
            propertyMessageResourcesFactory.setLanguagePath(this.languagePath);
            string2 = propertyMessageResourcesFactory.getMessage(string, objectArray);
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = "???" + string + "???";
        }
        return string2;
    }

    public HashMap<String, String> getHashMapMessage(String string) {
        return this.getHashMapMessage(string, new Object[0]);
    }

    public HashMap<String, String> getHashMapMessage(String string, Object[] objectArray) {
        this.init();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = 0;
        int n2 = 0;
        MessageFormat messageFormat = null;
        try {
            Iterator iterator = this.messagesArray.keySet().iterator();
            while (iterator.hasNext()) {
                string2 = "";
                string3 = "";
                string4 = "";
                string2 = (String)iterator.next();
                if (string2.indexOf(string) < 0) continue;
                string4 = (String)this.messagesArray.get(string2);
                if (string4 == null) {
                    string4 = "";
                }
                messageFormat = new MessageFormat(PropertyMessageResourcesFactory.escape(string4));
                messageFormat.setLocale(this.locale);
                n = string2.indexOf("[");
                n2 = string2.lastIndexOf("]");
                string3 = string2.substring(n + 1, n2);
                string3 = string3.replaceAll("&&", " ").trim();
                hashMap.put(string3, messageFormat.format(objectArray));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    protected HashMap<String, String> getDefaultHashMapMessage(String string, Object[] objectArray) {
        HashMap<String, String> hashMap = null;
        if (this.locale.getCountry() != null && this.locale.getCountry().trim().length() > 0) {
            PropertyMessageResourcesFactory propertyMessageResourcesFactory = this.findFactory(this.locale.getLanguage());
            propertyMessageResourcesFactory.setLanguagePath(this.languagePath);
            hashMap = propertyMessageResourcesFactory.getHashMapMessage(string, objectArray);
        } else if (!this.locale.equals(defalutLocale)) {
            PropertyMessageResourcesFactory propertyMessageResourcesFactory = this.findFactory(defalutLocale.toString());
            propertyMessageResourcesFactory.setLanguagePath(this.languagePath);
            hashMap = propertyMessageResourcesFactory.getHashMapMessage(string, objectArray);
        }
        if (hashMap == null || hashMap.size() == 0) {
            hashMap = new HashMap<String, String>();
            hashMap.put(string, ("???" + string + "???").toString());
        }
        return hashMap;
    }

    protected abstract String getFileName();

    protected static String escape(String string) {
        if (string == null || string.indexOf(39) < 0) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2;
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuffer.append('\'');
            } else if (c == '{' && (n2 = string.indexOf("}", i)) > i) {
                String string2 = string.substring(i + 1, n2);
                try {
                    Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    stringBuffer.append('\'').append(c).append('\'');
                    bl = true;
                }
            }
            if (!bl) {
                stringBuffer.append(c);
                continue;
            }
            bl = false;
        }
        return stringBuffer.toString();
    }

    public String getLanguagePath() {
        return this.languagePath;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLanguagePath(String string) {
        if (string != null && string.equals(this.languagePath)) {
            return;
        }
        if (string == null && this.languagePath == null) {
            return;
        }
        this.languagePath = string;
        this.inited = false;
    }
}

