/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util.ui;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.util.ui.UINode;
import jet.server.util.ui.UITreeJSONWriter;
import jet.server.util.ui.UITreeXMLWriter;

public class UITree
implements Serializable {
    private UINodeImpl root = null;
    private Hashtable nodeTable = new Hashtable();
    private String treeId = "";
    private String treeName = "";
    private int level = 0;

    public UITree() {
    }

    public UITree(String string, String string2, String string3, String string4, String string5, String string6) {
        this.root = new UINodeImpl(string3, string4, string5, string6);
        this.treeId = string;
        this.treeName = string2;
        String string7 = this.root.getNodeId();
        this.root.setParent("Root");
        if (!this.nodeTable.containsValue(this.root)) {
            this.addNodeToHT(string7, this.root);
        }
    }

    public UINode addChild(String string, String string2, String string3, String string4) {
        UINode uINode = this.root.addChild(string, string2, string3, string4);
        return uINode;
    }

    public UINode getRoot() {
        return this.root;
    }

    public void addNodeToHT(String string, UINode uINode) {
        this.nodeTable.put(string, uINode);
    }

    public UINode getNode(String string) {
        if (this.nodeTable.containsKey(string)) {
            return (UINode)this.nodeTable.get(string);
        }
        return null;
    }

    public UINode addChildToParentNode(String string, String string2, String string3, String string4, String string5) {
        UINode uINode = this.getNode(string);
        if (uINode == null) {
            return null;
        }
        UINode uINode2 = uINode.addChild(string2, string3, string4, string5);
        return uINode2;
    }

    public boolean removeNode(String string, String string2) {
        UINode uINode = this.getNode(string);
        if (uINode == null) {
            return false;
        }
        boolean bl = uINode.removeChild(string2);
        return bl;
    }

    public boolean rename(String string, String string2) {
        UINode uINode = this.getNode(string);
        if (uINode == null) {
            return false;
        }
        uINode.rename(string2);
        return true;
    }

    public boolean toXML(String string) {
        UITreeXMLWriter uITreeXMLWriter = new UITreeXMLWriter(this, string);
        boolean bl = uITreeXMLWriter.writeXml();
        return bl;
    }

    public boolean toXML(OutputStream outputStream) {
        UITreeXMLWriter uITreeXMLWriter = new UITreeXMLWriter(this, null);
        return uITreeXMLWriter.writeXml(outputStream);
    }

    public boolean toJSON(OutputStream outputStream) {
        UITreeJSONWriter uITreeJSONWriter = new UITreeJSONWriter(this, null);
        return uITreeJSONWriter.writeJson(outputStream);
    }

    public String getTreeId() {
        return this.treeId;
    }

    private final class UINodeImpl
    implements UINode {
        private String SEDU = "";
        private String access$000 = "";
        private String add = "";
        private String contains = "";
        private String containsKey = "";
        private int get = 0;
        Vector childrenIdList = new Vector();

        public UINodeImpl() {
        }

        public UINodeImpl(String string, String string2, String string3, String string4) {
            this.SEDU = string;
            this.access$000 = string2;
            this.contains = string3;
        }

        private boolean SEDU(UINode uINode) {
            String string = uINode.getNodeId();
            if (!UITree.this.nodeTable.containsKey(string) && !this.childrenIdList.contains(string)) {
                uINode.setLevel(this.get + 1);
                uINode.setParent(this.SEDU);
                UITree.this.nodeTable.put(string, uINode);
                this.childrenIdList.add(string);
                return true;
            }
            return false;
        }

        @Override
        public UINode addChild(String string, String string2, String string3, String string4) {
            UINodeImpl uINodeImpl = new UINodeImpl(string, string2, string3, string4);
            if (this.SEDU(uINodeImpl)) {
                return uINodeImpl;
            }
            return null;
        }

        @Override
        public UINode getChild(String string) {
            if (UITree.this.nodeTable.containsKey(string)) {
                return (UINode)UITree.this.nodeTable.get(string);
            }
            return null;
        }

        @Override
        public Vector getChildren() {
            Vector<UINode> vector = new Vector<UINode>();
            if (this.childrenIdList.size() > 0) {
                for (int i = 0; i < this.childrenIdList.size(); ++i) {
                    UINode uINode = (UINode)UITree.this.nodeTable.get(this.childrenIdList.get(i));
                    vector.add(uINode);
                }
                return vector;
            }
            return null;
        }

        @Override
        public String getNodeType() {
            return this.contains;
        }

        @Override
        public String getNodeName() {
            return this.access$000;
        }

        @Override
        public String getNodeParent() {
            return this.add;
        }

        @Override
        public boolean removeChild(String string) {
            if (!UITree.this.nodeTable.containsKey(string)) {
                return false;
            }
            Object v = UITree.this.nodeTable.get(string);
            UITree.this.nodeTable.remove(v);
            if (!this.childrenIdList.contains(string)) {
                return false;
            }
            this.childrenIdList.remove(string);
            return true;
        }

        @Override
        public void rename(String string) {
            this.access$000 = string;
        }

        @Override
        public String getNodeId() {
            return this.SEDU;
        }

        @Override
        public int getLevel() {
            return this.get;
        }

        @Override
        public void setLevel(int n) {
            this.get = n;
        }

        @Override
        public void setParent(String string) {
            this.add = string;
        }

        @Override
        public void setPermissions(String string) {
            this.containsKey = string;
        }

        @Override
        public String getPermissions() {
            return this.containsKey;
        }
    }
}

