/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util.webxml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jet.server.util.webxml.LazyList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser {
    private Map SEDU = new HashMap();
    private SAXParser _error;
    private Map _top;
    private Stack add = new Stack();
    private String clear;
    private Object get;

    public XmlParser() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            this._error = sAXParserFactory.newSAXParser();
            this._error.getXMLReader().setFeature("http://xml.org/sax/features/validation", false);
            this._error.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", false);
            this._error.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XmlParser(boolean bl) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(bl);
            this._error = sAXParserFactory.newSAXParser();
            try {
                if (bl) {
                    this._error.getXMLReader().setFeature("http://apache.org/xml/features/validation/schema", bl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._error.getXMLReader().setFeature("http://xml.org/sax/features/validation", bl);
            this._error.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", bl);
            this._error.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void redirectEntity(String string, URL uRL) {
        if (uRL != null) {
            this.SEDU.put(string, uRL);
        }
    }

    public String getXpath() {
        return this.clear;
    }

    public void setXpath(String string) {
        this.clear = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "| ");
        while (stringTokenizer.hasMoreTokens()) {
            this.get = LazyList.add(this.get, stringTokenizer.nextToken());
        }
    }

    public synchronized void addContentHandler(String string, ContentHandler contentHandler) {
        if (this._top == null) {
            this._top = new HashMap();
        }
        this._top.put(string, contentHandler);
    }

    public synchronized Node parse(InputSource inputSource) throws IOException, SAXException {
        Handler handler = new Handler();
        XMLReader xMLReader = this._error.getXMLReader();
        xMLReader.setContentHandler(handler);
        xMLReader.setErrorHandler(handler);
        xMLReader.setEntityResolver(handler);
        this._error.parse(inputSource, (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node node = (Node)handler._top.get(0);
        handler.clear();
        return node;
    }

    public synchronized Node parse(String string) throws IOException, SAXException {
        return this.parse(new InputSource(string));
    }

    public synchronized Node parse(File file) throws IOException, SAXException {
        return this.parse(new InputSource(file.toURL().toString()));
    }

    public synchronized Node parse(InputStream inputStream) throws IOException, SAXException {
        Handler handler = new Handler();
        XMLReader xMLReader = this._error.getXMLReader();
        xMLReader.setContentHandler(handler);
        xMLReader.setErrorHandler(handler);
        xMLReader.setEntityResolver(handler);
        this._error.parse(new InputSource(inputStream), (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node node = (Node)handler._top.get(0);
        handler.clear();
        return node;
    }

    public static class Node
    extends AbstractList {
        Node _parent;
        private ArrayList SEDU;
        private String add;
        private Attribute[] append;
        private boolean clear = false;
        private String equals;

        Node(Node node, String string, Attributes attributes) {
            this._parent = node;
            this.add = string;
            if (attributes != null) {
                this.append = new Attribute[attributes.getLength()];
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string2 = attributes.getLocalName(i);
                    if (string2 == null || string2.equals("")) {
                        string2 = attributes.getQName(i);
                    }
                    this.append[i] = new Attribute(string2, attributes.getValue(i));
                }
            }
        }

        public Node getParent() {
            return this._parent;
        }

        public String getTag() {
            return this.add;
        }

        public String getPath() {
            if (this.equals == null) {
                this.equals = this.getParent() != null && this.getParent().getTag() != null ? this.getParent().getPath() + "/" + this.add : "/" + this.add;
            }
            return this.equals;
        }

        public Attribute[] getAttributes() {
            return this.append;
        }

        public String getAttribute(String string) {
            return this.getAttribute(string, null);
        }

        public String getAttribute(String string, String string2) {
            if (this.append == null || string == null) {
                return string2;
            }
            for (int i = 0; i < this.append.length; ++i) {
                if (!string.equals(this.append[i].getName())) continue;
                return this.append[i].getValue();
            }
            return string2;
        }

        @Override
        public int size() {
            if (this.SEDU != null) {
                return this.SEDU.size();
            }
            return 0;
        }

        @Override
        public Object get(int n) {
            if (this.SEDU != null) {
                return this.SEDU.get(n);
            }
            return null;
        }

        public Node get(String string) {
            if (this.SEDU != null) {
                for (int i = 0; i < this.SEDU.size(); ++i) {
                    Object e = this.SEDU.get(i);
                    if (!(e instanceof Node)) continue;
                    Node node = (Node)e;
                    if (!string.equals(node.add)) continue;
                    return node;
                }
            }
            return null;
        }

        @Override
        public void add(int n, Object object) {
            if (this.SEDU == null) {
                this.SEDU = new ArrayList();
            }
            if (object instanceof String) {
                if (this.clear) {
                    int n2 = this.SEDU.size() - 1;
                    this.SEDU.set(n2, (String)this.SEDU.get(n2) + object);
                } else {
                    this.SEDU.add(n, object);
                }
                this.clear = true;
            } else {
                this.clear = false;
                this.SEDU.add(n, object);
            }
        }

        @Override
        public void clear() {
            if (this.SEDU != null) {
                this.SEDU.clear();
            }
            this.SEDU = null;
        }

        public String getString(String string, boolean bl, boolean bl2) {
            Node node = this.get(string);
            if (node == null) {
                return null;
            }
            String string2 = node.toString(bl);
            if (string2 != null && bl2) {
                string2 = string2.trim();
            }
            return string2;
        }

        @Override
        public synchronized String toString() {
            return this.toString(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized String toString(boolean bl) {
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
            synchronized (stringBuffer2) {
                this.toString(stringBuffer, bl);
                return stringBuffer.toString();
            }
        }

        public synchronized String toString(boolean bl, boolean bl2) {
            String string = this.toString(bl);
            if (string != null && bl2) {
                string = string.trim();
            }
            return string;
        }

        private synchronized void toString(StringBuffer stringBuffer, boolean bl) {
            int n;
            if (bl) {
                stringBuffer.append("<");
                stringBuffer.append(this.add);
                if (this.append != null) {
                    for (n = 0; n < this.append.length; ++n) {
                        stringBuffer.append(' ');
                        stringBuffer.append(this.append[n].getName());
                        stringBuffer.append("=\"");
                        stringBuffer.append(this.append[n].getValue());
                        stringBuffer.append("\"");
                    }
                }
            }
            if (this.SEDU != null) {
                if (bl) {
                    stringBuffer.append(">");
                }
                for (n = 0; n < this.SEDU.size(); ++n) {
                    Object e = this.SEDU.get(n);
                    if (e == null) continue;
                    if (e instanceof Node) {
                        ((Node)e).toString(stringBuffer, bl);
                        continue;
                    }
                    stringBuffer.append(e.toString());
                }
                if (bl) {
                    stringBuffer.append("</");
                    stringBuffer.append(this.add);
                    stringBuffer.append(">");
                }
            } else if (bl) {
                stringBuffer.append("/>");
            }
        }

        public Iterator iterator(final String string) {
            return new Iterator(){
                int c = 0;
                Node _node;

                @Override
                public boolean hasNext() {
                    if (this._node != null) {
                        return true;
                    }
                    while (Node.this.SEDU != null && this.c < Node.this.SEDU.size()) {
                        Node node;
                        Object e = Node.this.SEDU.get(this.c);
                        if (e instanceof Node && string.equals((node = (Node)e).add)) {
                            this._node = node;
                            return true;
                        }
                        ++this.c;
                    }
                    return false;
                }

                public Object next() {
                    try {
                        if (this.hasNext()) {
                            Node node = this._node;
                            return node;
                        }
                        throw new NoSuchElementException();
                    }
                    finally {
                        this._node = null;
                        ++this.c;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported");
                }
            };
        }
    }

    public static class Attribute {
        private String SEDU;
        private String I;

        Attribute(String string, String string2) {
            this.SEDU = string;
            this.I = string2;
        }

        public String getName() {
            return this.SEDU;
        }

        public String getValue() {
            return this.I;
        }
    }

    private class Handler
    extends DefaultHandler {
        Node _top;
        SAXParseException _error;
        private Node SEDU;
        private NoopHandler _parent;

        Handler() {
            this.SEDU = this._top = new Node(null, null, null);
            this._parent = new NoopHandler(this);
        }

        void clear() {
            this._top = null;
            this._error = null;
            this.SEDU = null;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            int n;
            Object object;
            String string4 = string == null || string.equals("") ? string3 : string2;
            Node node = new Node(this.SEDU, string4, attributes);
            if (XmlParser.this.get != null) {
                object = node.getPath();
                n = 0;
                int n2 = LazyList.size(XmlParser.this.get);
                while (n == 0 && n2-- > 0) {
                    String string5 = (String)LazyList.get(XmlParser.this.get, n2);
                    n = ((String)object).equals(string5) || string5.startsWith((String)object) && string5.length() > ((String)object).length() && string5.charAt(((String)object).length()) == '/' ? 1 : 0;
                }
                if (n != 0) {
                    this.SEDU.add(node);
                    this.SEDU = node;
                } else {
                    XmlParser.this._error.getXMLReader().setContentHandler(this._parent);
                }
            } else {
                this.SEDU.add(node);
                this.SEDU = node;
            }
            object = null;
            if (XmlParser.this._top != null) {
                object = (ContentHandler)XmlParser.this._top.get(string4);
            }
            XmlParser.this.add.push(object);
            for (n = 0; n < XmlParser.this.add.size(); ++n) {
                if (XmlParser.this.add.get(n) == null) continue;
                ((ContentHandler)XmlParser.this.add.get(n)).startElement(string, string2, string3, attributes);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            this.SEDU = this.SEDU._parent;
            for (int i = 0; i < XmlParser.this.add.size(); ++i) {
                if (XmlParser.this.add.get(i) == null) continue;
                ((ContentHandler)XmlParser.this.add.get(i)).endElement(string, string2, string3);
            }
            XmlParser.this.add.pop();
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            for (int i = 0; i < XmlParser.this.add.size(); ++i) {
                if (XmlParser.this.add.get(i) == null) continue;
                ((ContentHandler)XmlParser.this.add.get(i)).ignorableWhitespace(cArray, n, n2);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.SEDU.add(new String(cArray, n, n2));
            for (int i = 0; i < XmlParser.this.add.size(); ++i) {
                if (XmlParser.this.add.get(i) == null) continue;
                ((ContentHandler)XmlParser.this.add.get(i)).characters(cArray, n, n2);
            }
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            Object object;
            URL uRL = null;
            if (string != null) {
                uRL = (URL)XmlParser.this.SEDU.get(string);
            }
            if (uRL == null) {
                uRL = (URL)XmlParser.this.SEDU.get(string2);
            }
            if (uRL == null) {
                object = string2;
                if (((String)object).lastIndexOf(47) >= 0) {
                    object = ((String)object).substring(((String)object).lastIndexOf(47) + 1);
                }
                uRL = (URL)XmlParser.this.SEDU.get(object);
            }
            if (uRL != null) {
                try {
                    object = uRL.openStream();
                    InputSource inputSource = new InputSource((InputStream)object);
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private class NoopHandler
    extends DefaultHandler {
        Handler _next;
        int _depth;

        NoopHandler(Handler handler) {
            this._next = handler;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this._depth;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this._depth == 0) {
                XmlParser.this._error.getXMLReader().setContentHandler(this._next);
            } else {
                --this._depth;
            }
        }
    }
}

