/*
 * Decompiled with CFR 0.152.
 */
package jet.web.dhtml;

import com.jinfonet.api.datatypes.Types;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.Vector;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.report.JetRptDBField;
import jet.report.JetRptObject;
import jet.util.DbValueFormat;
import jet.util.ReportFormat;
import util.ConvertDbChar;

public class DataTools {
    public static byte[] getStringBytes(String string) {
        byte[] byArray = new byte[string.length() * 2];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u00ff') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c > '\uffff') continue;
            byArray[n++] = (byte)(c >> 8);
            byArray[n++] = (byte)(c & 0xFF);
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static String getString(String string, String string2) {
        try {
            if (string2 == null) {
                string2 = "8859_1";
            }
            if (string == null) {
                return null;
            }
            byte[] byArray = DataTools.getStringBytes(string);
            String string3 = new String(byArray, string2);
            return string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String parseValueToString(DbValue dbValue, String string) {
        String string2;
        block15: {
            string2 = null;
            SimpleDateFormat simpleDateFormat = null;
            int n = dbValue.getSqlType();
            if (n == 91) {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                string2 = simpleDateFormat.format(((DbDate)dbValue).getDate());
            } else if (n == 92) {
                simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                string2 = simpleDateFormat.format(((DbTime)dbValue).getTime());
            } else if (n == 93) {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                string2 = simpleDateFormat.format(((DbTimestamp)dbValue).getTimestamp());
            } else if (n == -6 || n == 5 || n == 4 || n == -5 || n == 6 || n == 7 || n == 8 || n == 3 || n == 2) {
                string2 = dbValue.toString();
            } else if (string != null) {
                if (dbValue instanceof DbChar) {
                    try {
                        string2 = ConvertDbChar.getConvertedString((DbChar)((DbChar)dbValue), (String)string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        DbValueFormat dbValueFormat = DataTools.makeDbValueFormat(dbValue.getSqlType(), string, Locale.getDefault());
                        if (dbValueFormat != null) {
                            string2 = dbValueFormat.format(dbValue);
                            break block15;
                        }
                        string2 = dbValue.toString();
                    }
                } else {
                    DbValueFormat dbValueFormat = DataTools.makeDbValueFormat(dbValue.getSqlType(), string, Locale.getDefault());
                    string2 = dbValueFormat != null ? dbValueFormat.format(dbValue) : dbValue.toString();
                }
            } else {
                string2 = dbValue.toString();
            }
        }
        return string2;
    }

    public static DbValue makeDbValue(int n) {
        DbSmallInt dbSmallInt = null;
        switch (n) {
            case 5: {
                dbSmallInt = new DbSmallInt();
                break;
            }
            case -6: {
                dbSmallInt = new DbTinyInt();
                break;
            }
            case 4: {
                dbSmallInt = new DbInteger();
                break;
            }
            case -5: {
                dbSmallInt = new DbBigInt();
                break;
            }
            case 7: {
                dbSmallInt = new DbReal();
                break;
            }
            case 2: 
            case 3: {
                dbSmallInt = new DbDecimal();
                break;
            }
            case 6: 
            case 8: {
                dbSmallInt = new DbDouble();
                break;
            }
            case -7: {
                dbSmallInt = new DbBit();
                break;
            }
            case 91: {
                dbSmallInt = new DbDate();
                break;
            }
            case 92: {
                dbSmallInt = new DbTime();
                break;
            }
            case 93: {
                dbSmallInt = new DbTimestamp();
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                dbSmallInt = new DbChar();
                break;
            }
            case -4: 
            case -2: 
            case 2004: {
                dbSmallInt = new DbBinary();
                break;
            }
            default: {
                throw new Error("unknow sql type : " + n);
            }
        }
        DbColDesc dbColDesc = new DbColDesc();
        dbColDesc.setSqlType(n);
        dbSmallInt.setColDesc(dbColDesc);
        return dbSmallInt;
    }

    public static String getKey(int n, Locale locale) {
        return String.valueOf(n) + "|" + locale.getCountry() + "|" + locale.getLanguage() + "|";
    }

    public static DbValueFormat makeDbValueFormat(int n, String string, Locale locale) {
        return ReportFormat.getOneFormat((int)n, (String)string, (Locale)locale);
    }

    public static String format(DbValueFormat dbValueFormat, DbValue dbValue, String string) {
        if (dbValue instanceof DbChar) {
            try {
                return ConvertDbChar.getConvertedString((DbChar)((DbChar)dbValue), (String)string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return dbValueFormat.format(dbValue);
            }
        }
        return dbValueFormat.format(dbValue);
    }

    public static String format(DbValue dbValue, String string, Locale locale, String string2) {
        DbValueFormat dbValueFormat = DataTools.makeDbValueFormat(dbValue.getSqlType(), string, locale);
        return DataTools.format(dbValueFormat, dbValue, string2);
    }

    public static DbValue getDbValueFromInput(int n, String string, Locale locale, String string2) throws ParseException {
        if (!(n != 16 && n != -7 || "true".equalsIgnoreCase(string2) || "false".equalsIgnoreCase(string2) || "T".equalsIgnoreCase(string2) || "F".equalsIgnoreCase(string2) || "1".equalsIgnoreCase(string2) || "0".equalsIgnoreCase(string2))) {
            throw new ParseException("", 0);
        }
        DbValue dbValue = DataTools.makeDbValue(n);
        if (string == null || string.equals("")) {
            if (!(n != 16 && n != -7 || "true".equalsIgnoreCase(string2) || "false".equalsIgnoreCase(string2))) {
                throw new ParseException("", 0);
            }
            dbValue.setValue(string2);
        } else {
            DbValueFormat dbValueFormat = DataTools.makeDbValueFormat(n, string, locale);
            dbValueFormat.parse(dbValue, string2);
        }
        return dbValue;
    }

    public static String getValue(int n, DbValue dbValue, String string, Locale locale, String string2) {
        if (string == null || string.equals("")) {
            return DataTools.parseValueToString(dbValue, string2);
        }
        if (n != -6 && n != 5 && n != 4 && n != -5 && n != 6 && n != 7 && n != 8 && n != 3 && n != 2 && n != 91 && n != 92 && n != 93) {
            return DataTools.parseValueToString(dbValue, string2);
        }
        DbColDesc dbColDesc = new DbColDesc();
        dbColDesc.setSqlType(n);
        dbValue.setColDesc(dbColDesc);
        DbValueFormat dbValueFormat = DataTools.makeDbValueFormat(n, string, locale);
        String string3 = dbValueFormat.format(dbValue);
        return string3;
    }

    public static JetRptDBField getDBFiledByMappingName(JetRptObject jetRptObject, String string) {
        JetRptDBField jetRptDBField = null;
        if (jetRptObject instanceof JetRptDBField) {
            jetRptDBField = (JetRptDBField)jetRptObject;
            if (jetRptDBField.runtimeColumnName.get().equals(string)) {
                return jetRptDBField;
            }
            return null;
        }
        Vector vector = jetRptObject.getChildren();
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            JetRptObject jetRptObject2;
            JetRptDBField jetRptDBField2;
            if (!(vector.get(i) instanceof JetRptObject) || (jetRptDBField2 = DataTools.getDBFiledByMappingName(jetRptObject2 = (JetRptObject)vector.get(i), string)) == null) continue;
            return jetRptDBField2;
        }
        return null;
    }

    public static Vector parseWord(String string, char c, char c2) throws ParseException {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringBuffer stringBuffer = new StringBuffer();
        Vector<String> vector = new Vector<String>();
        char c3 = stringCharacterIterator.first();
        while (c3 != '\uffff') {
            if (c3 != c2 && c3 != c) {
                stringBuffer.append(c3);
            } else if (c3 == c2) {
                c3 = stringCharacterIterator.next();
                if (c3 != c2 && c3 != c) {
                    throw new ParseException("parse expression error", stringCharacterIterator.getIndex());
                }
                if (c3 == c2 || c3 == c) {
                    stringBuffer.append(c3);
                }
            } else if (c3 == c) {
                vector.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
            }
            c3 = stringCharacterIterator.next();
        }
        vector.add(stringBuffer.toString());
        return vector;
    }

    public static boolean isStringSQLType(int n) {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2006: {
                return true;
            }
        }
        return false;
    }

    public static char getDataType(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 'n';
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return 'c';
            }
            case 91: 
            case 92: 
            case 93: {
                return 'd';
            }
            case 2004: 
            case 2005: {
                return 'B';
            }
            case -7: 
            case 16: {
                return 'b';
            }
            case 0: 
            case 2000: 
            case 2002: 
            case 2003: {
                return 'O';
            }
            case 70: 
            case 1111: 
            case 2001: 
            case 2006: {
                return 'o';
            }
        }
        return 'u';
    }

    public static boolean isBooleanSQLType(int n) {
        return Types.isBooleanType((int)n);
    }
}

