/*
 * Decompiled with CFR 0.152.
 */
package jet.web.dhtml;

import chart.ChartDefinition;
import com.jinfonet.util.JDLog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.JDException;
import jet.controls.JetBoolean;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.controls.JetStringList;
import jet.cs.util.APIUtil;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.datastream.DSField;
import jet.datastream.DSPicture;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.report.JetLink;
import jet.report.JetRptArea;
import jet.report.JetRptCTAggField;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptCTDBField;
import jet.report.JetRptCTHdDBField;
import jet.report.JetRptCTHdDBTitleField;
import jet.report.JetRptDataContainer;
import jet.report.JetRptDetailPanel;
import jet.report.JetRptField;
import jet.report.JetRptGroupFooterPanel;
import jet.report.JetRptGroupHeaderPanel;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptMap;
import jet.report.JetRptObject;
import jet.report.JetRptPagePanel;
import jet.report.JetRptPicture;
import jet.report.JetRptSection;
import jet.report.JetRptSectionObject;
import jet.report.JetRptSectionPageFooter;
import jet.report.JetRptSectionPageHeader;
import jet.report.JetRptSort;
import jet.report.JetRptTable;
import jet.report.chart.JetRptChartPlatform;
import jet.report.conditionallink.JetRptConditionalLinkItem;
import jet.report.table.JetRptNewTable;
import jet.report.table.JetRptTableDetail;
import jet.report.table.JetRptTableFooter;
import jet.report.table.JetRptTableGroup;
import jet.report.table.JetRptTableHeader;
import jet.reportset.DataSet;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptservice.api.design.DesignService;
import jet.rptservice.api.design.QueryCategory;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.util.ReportTools;
import jet.util.Propertiable;
import jet.web.dhtml.DExpression;
import jet.web.dhtml.DHTMLRptSet;
import jet.web.dhtml.DHTMLService;
import jet.web.dhtml.DHTMLSession;
import jet.web.dhtml.DataTools;
import jet.web.dhtml.DisplayNames;
import jet.web.dhtml.WebActLogic;
import jet.web.dhtml.exception.AlertMessage;
import jet.web.dhtml.filter.FilterCondition;
import jet.web.dhtml.filter.FilterToolkit;
import jet.web.dhtml.scene.UISceneContainer;
import jet.web.dhtml.scene.bsfilter.BSFilterEditor;
import jet.web.dhtml.scene.bsfilter.BSFilterScene;
import jet.web.dhtml.scene.filter.Condition;

public class RptToolkit {
    private static final int SEDU = 0;
    private static final int Z = 1;
    private static final int add = 2;
    private static final int addAll = 3;
    private static final int append = 4;
    private static final int bNIsXHeader = 5;
    private static final int blColumnName = 6;
    private static final int booleanValue = 7;
    private static final int buildColumnList = 8;
    private static final int checkCanFilter = 9;
    private static final int checkCanSort = 10;
    private static final int childrenSize = 11;
    private static final int clear = 12;
    private static final int clone = 13;
    private static final int clone2lVector = 14;
    private static final String[] createBinaryLogicExpression = new String[]{"CrossTab", "Chart", "NewTable", "Table", "GroupPanel", "GroupHeader", "GroupFooter", "DetailPanel", "SectionObject", "PagePanel", "TableDetail", "SectionPageHeader", "SectionPageFooter", "TableHeader", "TableFooter"};
    public static final int CROSSTAB = 0;
    public static final int CHART = 1;
    public static final int TABLE = 2;

    public static String getComponentTypeString(JetRptObject jetRptObject) {
        int n = RptToolkit.Z(jetRptObject);
        return n == -1 ? null : createBinaryLogicExpression[n];
    }

    private static int[] SEDU(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{"CrossTab", "Chart", "NewTable", "GroupPanel", "DetailPanel", "SectionObject"};
        }
        int[] nArray = new int[stringArray.length];
        block0: for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = -1;
            for (int j = 0; j < createBinaryLogicExpression.length; ++j) {
                if (!stringArray[i].equalsIgnoreCase(createBinaryLogicExpression[j])) continue;
                nArray[i] = j;
                continue block0;
            }
        }
        return nArray;
    }

    private static int Z(JetRptObject jetRptObject) {
        if (jetRptObject instanceof JetRptTable) {
            return 3;
        }
        if (jetRptObject instanceof JetRptCTCrossTab) {
            return 0;
        }
        if (jetRptObject instanceof JetRptChartPlatform) {
            return 1;
        }
        if (jetRptObject instanceof JetRptDetailPanel) {
            return 7;
        }
        if (jetRptObject instanceof JetRptGroupPanel) {
            return 4;
        }
        if (jetRptObject instanceof JetRptGroupHeaderPanel) {
            return 5;
        }
        if (jetRptObject instanceof JetRptGroupFooterPanel) {
            return 6;
        }
        if (jetRptObject instanceof JetRptNewTable) {
            return 2;
        }
        if (jetRptObject instanceof JetRptSectionPageHeader) {
            return 11;
        }
        if (jetRptObject instanceof JetRptSectionPageFooter) {
            return 12;
        }
        if (jetRptObject instanceof JetRptTableHeader) {
            return 13;
        }
        if (jetRptObject instanceof JetRptTableFooter) {
            return 14;
        }
        if (jetRptObject instanceof JetRptSectionObject && RptToolkit.add(jetRptObject)) {
            return 8;
        }
        if (jetRptObject instanceof JetRptPagePanel) {
            return 9;
        }
        if (jetRptObject instanceof JetRptTableDetail) {
            return 10;
        }
        return -1;
    }

    private static boolean add(JetRptObject jetRptObject) {
        Vector vector = jetRptObject.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (!(e instanceof JetRptObject)) continue;
            JetRptObject jetRptObject2 = (JetRptObject)e;
            if (jetRptObject2 instanceof JetRptSection && RptToolkit.append(jetRptObject2, new String[]{"GroupHeader", "GroupFooter", "DetailPanel"}) != -1) {
                return true;
            }
            if (jetRptObject2 instanceof JetRptCTCrossTab || jetRptObject2 instanceof JetRptChartPlatform || jetRptObject2.getChildren() == null || !RptToolkit.add(jetRptObject2)) continue;
            return true;
        }
        return false;
    }

    public static String getDataSet(JetRptObject jetRptObject) {
        DataSet dataSet = ReportTools.getDataSet((JetObject)jetRptObject);
        if (dataSet != null) {
            return dataSet.getName();
        }
        return null;
    }

    public static boolean isHDS(JetRptObject jetRptObject) {
        DataSet dataSet = ReportTools.getDataSet((JetObject)jetRptObject);
        if (dataSet == null) {
            return false;
        }
        return dataSet.isHDS();
    }

    public static Vector getSortComponent(JetRptReport jetRptReport, String[] stringArray) {
        Vector vector = new Vector();
        RptToolkit.getSomeLevelComponent(vector, (JetRptObject)jetRptReport, stringArray);
        return vector;
    }

    public static Vector getFilterComponent(JetRptReport jetRptReport, String[] stringArray) {
        Vector vector = new Vector();
        RptToolkit.getSomeLevelComponent(vector, (JetRptObject)jetRptReport, stringArray);
        return vector;
    }

    public static Vector getTopNComponent(JetRptReport jetRptReport, String[] stringArray) {
        Vector vector = new Vector();
        RptToolkit.getSomeLevelComponent(vector, (JetRptObject)jetRptReport, stringArray);
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void getTopLevelComponent(Vector vector, JetRptObject jetRptObject, String[] stringArray) {
        Vector vector2;
        Object object;
        int n;
        if (stringArray == null) {
            stringArray = new String[]{"CrossTab", "Chart", "NewTable", "GroupPanel", "GroupHeader", "GorupFooter", "DetailPanel", "SectionObject"};
        }
        if (jetRptObject instanceof JetRptDataContainer) {
            if (RptToolkit.getDataSet(jetRptObject) != null) {
                n = -1;
                n = RptToolkit.append(jetRptObject, stringArray);
                if (n != -1) {
                    JetRptObject jetRptObject2 = jetRptObject;
                    if (n != 5 && n != 6) {
                        vector.add(jetRptObject2.getInstName());
                        return;
                    }
                    jetRptObject2 = (JetRptObject)jetRptObject2.getParent();
                    object = jetRptObject2.getInstName();
                    for (int i = 0; i < vector.size(); ++i) {
                        if (!vector.get(i).equals(object)) continue;
                        object = null;
                    }
                    if (object != null) {
                        vector.add(object);
                        return;
                    }
                }
            }
        } else if (jetRptObject instanceof JetRptTableGroup && (n = RptToolkit.append(jetRptObject, stringArray)) != -1) {
            vector.add(jetRptObject.getInstName());
            return;
        }
        if ((vector2 = jetRptObject.getChildren()) != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                object = vector2.elementAt(i);
                if (!(object instanceof JetRptObject)) continue;
                JetRptObject jetRptObject3 = (JetRptObject)object;
                RptToolkit.getTopLevelComponent(vector, jetRptObject3, stringArray);
            }
        }
    }

    public static void getSubComponents(Vector vector, JetRptObject jetRptObject, String[] stringArray) {
        Vector vector2;
        if (stringArray == null) {
            stringArray = new String[]{"CrossTab", "Chart", "NewTable", "GroupPanel", "GroupHeader", "GorupFooter", "DetailPanel", "SectionObject"};
        }
        int n = -1;
        n = RptToolkit.append(jetRptObject, stringArray);
        if (n != -1) {
            vector.add(jetRptObject.getInstName());
        }
        if ((vector2 = jetRptObject.getChildren()) != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                JetRptObject jetRptObject2 = (JetRptObject)vector2.elementAt(i);
                RptToolkit.getSubComponents(vector, jetRptObject2, stringArray);
            }
        }
    }

    private static boolean addAll(JetRptObject jetRptObject) {
        JetBoolean jetBoolean = (JetBoolean)jetRptObject.nameToProperty("ExportToDHTML");
        return jetBoolean != null && !jetBoolean.booleanValue();
    }

    public static void getSomeLevelComponent(Vector vector, JetRptObject jetRptObject, String[] stringArray) {
        String string;
        int n;
        if (stringArray == null) {
            stringArray = new String[]{"CrossTab", "Chart", "NewTable", "GroupPanel", "GroupHeader", "GorupFooter", "DetailPanel", "SectionObject"};
        }
        if (jetRptObject instanceof JetRptDataContainer) {
            if (RptToolkit.getDataSet(jetRptObject) != null) {
                n = -1;
                n = RptToolkit.append(jetRptObject, stringArray);
                if (n != -1) {
                    JetRptObject jetRptObject2 = jetRptObject;
                    if (n == 5 || n == 6) {
                        jetRptObject2 = (JetRptObject)jetRptObject2.getParent();
                        string = jetRptObject2.getInstName();
                        for (int i = 0; i < vector.size(); ++i) {
                            if (!vector.get(i).equals(string)) continue;
                            string = null;
                        }
                        if (string != null && !RptToolkit.addAll(jetRptObject2)) {
                            vector.add(string);
                        }
                    } else if (!RptToolkit.addAll(jetRptObject2)) {
                        vector.add(jetRptObject2.getInstName());
                    }
                }
            }
        } else if (jetRptObject instanceof JetRptTableGroup && (n = RptToolkit.append(jetRptObject, stringArray)) != -1 && !RptToolkit.addAll(jetRptObject)) {
            vector.add(jetRptObject.getInstName());
        }
        if (RptToolkit.addAll(jetRptObject)) {
            return;
        }
        Vector vector2 = jetRptObject.getChildren();
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                if (!(vector2.elementAt(i) instanceof JetRptObject)) continue;
                string = (JetRptObject)vector2.elementAt(i);
                RptToolkit.getSomeLevelComponent(vector, (JetRptObject)string, stringArray);
            }
        }
    }

    public static JetRptObject getComponentByName(JetRptObject jetRptObject, String string) {
        return (JetRptObject)jetRptObject.nameToObject(string);
    }

    public static JetRptObject getCrosstabLevelComponentBySubObject(JetRptObject jetRptObject, String[] stringArray) {
        JetRptObject jetRptObject2 = jetRptObject;
        while (!(jetRptObject2 instanceof JetRptReport)) {
            if (RptToolkit.append(jetRptObject2, stringArray) != -1) {
                return jetRptObject2;
            }
            jetRptObject2 = (JetRptObject)jetRptObject2.getParent();
        }
        return null;
    }

    public static JetRptObject getGroupByAreaLink(JetRptObject jetRptObject) {
        if (jetRptObject == null || !(jetRptObject instanceof JetRptArea)) {
            return null;
        }
        JetRptObject jetRptObject2 = (JetRptObject)((JetRptObject)jetRptObject.getParent()).getParent();
        Vector vector = jetRptObject2.getParent().getChildren();
        JetRptObject jetRptObject3 = null;
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (!(e instanceof JetRptGroupPanel)) continue;
            jetRptObject3 = (JetRptObject)e;
            break;
        }
        return jetRptObject3;
    }

    private static int append(JetRptObject jetRptObject, String[] stringArray) {
        int[] nArray = RptToolkit.SEDU(stringArray);
        int n = RptToolkit.Z(jetRptObject);
        if (n != -1) {
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                return n;
            }
        }
        return -1;
    }

    public static JetRptCTDBField getCTDBFieldFromCTHDTitle(JetRptCTHdDBTitleField jetRptCTHdDBTitleField, JetRptCTCrossTab jetRptCTCrossTab) {
        JetRptCTHdDBTitleField jetRptCTHdDBTitleField2;
        if (jetRptCTCrossTab == null && (jetRptCTCrossTab = (JetRptCTCrossTab)RptToolkit.getCrosstabLevelComponentBySubObject((JetRptObject)(jetRptCTHdDBTitleField2 = jetRptCTHdDBTitleField), new String[]{"CrossTab"})) == null) {
            return null;
        }
        boolean bl = jetRptCTHdDBTitleField.getIsXHeader(null);
        int n = jetRptCTHdDBTitleField.getDepth(null);
        Vector vector = jetRptCTCrossTab.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            JetRptObject jetRptObject = (JetRptObject)vector.get(i);
            if (!(jetRptObject instanceof JetRptCTDBField) || ((JetRptCTDBField)jetRptObject).getIsXHeader(null) != bl || ((JetRptCTDBField)jetRptObject).getDepth(null) != n) continue;
            return (JetRptCTDBField)jetRptObject;
        }
        return null;
    }

    public static Vector getUsedDimensionByCrosstab(JetRptCTCrossTab jetRptCTCrossTab) {
        Vector<JetRptObject> vector = new Vector<JetRptObject>();
        Vector vector2 = jetRptCTCrossTab.getChildren();
        for (int i = 0; i < vector2.size(); ++i) {
            JetRptObject jetRptObject = (JetRptObject)vector2.get(i);
            if (!(jetRptObject instanceof JetRptCTDBField)) continue;
            vector.add(jetRptObject);
        }
        return vector;
    }

    public static Vector getUsedMeasureByCrosstab(JetRptCTCrossTab jetRptCTCrossTab) {
        Vector<JetRptObject> vector = new Vector<JetRptObject>();
        Vector vector2 = jetRptCTCrossTab.getChildren();
        for (int i = 0; i < vector2.size(); ++i) {
            JetRptObject jetRptObject = (JetRptObject)vector2.get(i);
            if (!(jetRptObject instanceof JetRptCTAggField)) continue;
            vector.add(jetRptObject);
        }
        return vector;
    }

    public static boolean isLinkSelf(DHTMLRptSet dHTMLRptSet, JetLink jetLink, String string) {
        boolean bl = false;
        if (jetLink != null && jetLink.getLinkType() == 0) {
            String string2 = jetLink.getFileName();
            String string3 = jetLink.getRptInstName();
            String string4 = dHTMLRptSet.getReportSetName().substring(dHTMLRptSet.getReportSetName().lastIndexOf(47) + 1);
            bl = string2.equals(string4) && string3.equals(string);
        }
        return bl;
    }

    public static boolean hasDetail(JRObjectResult jRObjectResult) {
        if (jRObjectResult instanceof DSPicture) {
            return RptToolkit.hasDetail((DSPicture)jRObjectResult);
        }
        if (jRObjectResult instanceof DSField) {
            return RptToolkit.hasDetail((DSField)jRObjectResult);
        }
        return false;
    }

    public static boolean hasDetail(DSField dSField) {
        Propertiable propertiable = dSField.getPropertyByName("DetailReport");
        String string = null;
        if (propertiable != null) {
            string = (String)propertiable.getObject();
        }
        return string != null && string.length() > 0;
    }

    public static boolean hasDetail(DSPicture dSPicture) {
        Propertiable propertiable = dSPicture.getPropertyByName("DetailReport");
        String string = null;
        if (propertiable != null) {
            string = (String)propertiable.getObject();
        }
        return string != null && string.length() > 0;
    }

    public static Vector getCTHdDbFilelds(JetRptCTCrossTab jetRptCTCrossTab) {
        Vector vector = RptToolkit.getUsedDimensionByCrosstab(jetRptCTCrossTab);
        int n = vector.size();
        for (int i = n - 1; i >= 0; --i) {
            Object e = vector.get(i);
            if (e instanceof JetRptCTHdDBField) continue;
            vector.remove(i);
        }
        return vector;
    }

    static Vector clone2lVector(Vector vector) {
        Vector vector2 = (Vector)vector.clone();
        for (int i = 0; i < vector2.size(); ++i) {
            vector2.setElementAt(((Vector)vector2.get(i)).clone(), i);
        }
        return vector2;
    }

    static void insertTopNsNode(Vector vector, Vector vector2) {
        vector2.set(4, "AND");
        vector.insertElementAt(vector2, 0);
        for (int i = 1; i < vector.size(); ++i) {
            Vector vector3 = (Vector)vector.get(i);
            if (!((String)vector3.get(4)).equals("OR")) continue;
            vector.insertElementAt(vector2, ++i);
        }
    }

    private static Vector bNIsXHeader(Vector vector, Vector vector2, Vector vector3) {
        Vector vector4 = RptToolkit.clone2lVector(vector);
        Vector vector5 = RptToolkit.clone2lVector(vector);
        vector.clear();
        RptToolkit.insertTopNsNode(vector4, vector2);
        RptToolkit.insertTopNsNode(vector5, vector3);
        Vector vector6 = (Vector)vector4.lastElement();
        vector6.set(4, "OR");
        vector.addAll(vector4);
        vector.addAll(vector5);
        return vector;
    }

    public static IExpression getTopNIExpression(DesignService designService, String string, String string2, String string3, String string4, String string5, Vector vector, String string6) throws Exception {
        Object object;
        String string7 = RptToolkit.getDatasetIdByComName(designService, string2, string3, string4, string5);
        String string8 = null;
        string8 = designService.isFormula(string2, string7, string6) ? "formula" : "dbfiled";
        int n = vector.size() - 1;
        Object e = vector.get(n);
        Vector<Object> vector2 = new Vector<Object>();
        if (e instanceof Boolean) {
            vector.remove(n);
            object = new FilterCondition(string6, "isnull", "", vector.size() > 0 ? "OR" : "END", string8);
            vector2.add(object);
        }
        if (vector.size() > 0) {
            object = RptToolkit.getDatasetIdByComName(designService, string2, string3, string4, string5);
            int n2 = designService.getResourceSqlTypeForDataset(string2, string3, (String)object, string6, string4);
            boolean bl = DataTools.isBooleanSQLType(n2);
            if (!bl) {
                FilterCondition filterCondition = new FilterCondition(string6, "in", vector.toArray(new String[0]), "END", string8);
                vector2.add(filterCondition);
            } else {
                for (int i = 0; i < vector.size(); ++i) {
                    FilterCondition filterCondition = new FilterCondition(string6, "eq", vector.get(i), i == vector.size() - 1 ? "END" : "OR", string8);
                    vector2.add(filterCondition);
                }
            }
        }
        object = vector2.size() > 0 ? FilterToolkit.getFilterExpression(vector2) : null;
        IExpression iExpression = RptToolkit.getExpression(designService, string2, string3, string4, string5);
        if (iExpression != null) {
            if (object == null) {
                return iExpression;
            }
            return FilterToolkit.createBinaryLogicExpression(iExpression, object, "AND");
        }
        return object;
    }

    public static Vector getFilterConditions(DesignService designService, String string, String string2, String string3, String string4, String string5) {
        DHTMLService dHTMLService = DHTMLService.getInstance();
        DHTMLSession dHTMLSession = dHTMLService.getDHTMLSession(string);
        try {
            IExpression iExpression = RptToolkit.getExpression(dHTMLService.ds, string2, string3, string4, string5);
            String[][] stringArray = BSFilterScene.buildColumnList(string, string2, string3, string4, string5);
            BSFilterEditor bSFilterEditor = new BSFilterEditor(dHTMLSession.getSceneContainer(), stringArray, iExpression, string2, string3, string4, string5);
            Condition condition = bSFilterEditor.getNormalModeEditor().getRootCondition();
            if (condition != null) {
                Vector vector = new Vector();
                RptToolkit.checkCanFilter(vector, condition);
                bSFilterEditor.destroy();
                return vector;
            }
            bSFilterEditor.destroy();
            return null;
        }
        catch (Exception exception) {
            if (JDLog.isError((int)3)) {
                JDLog.error((int)3, (int)3910017, (Throwable)exception);
            }
            return null;
        }
    }

    private static void blColumnName(Vector vector, Condition condition) {
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add("");
        vector2.add(condition.getColumn());
        vector2.add(RptToolkit.buildColumnList(condition));
        vector2.add(RptToolkit.booleanValue(condition));
        vector2.add("END");
        vector.add(vector2);
    }

    private static Object booleanValue(Condition condition) {
        Vector vector = condition.getValues();
        if (vector != null) {
            int n = vector.size();
            if (n == 1) {
                return ((String[])vector.get(0))[0];
            }
            if (n > 1) {
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    String[] stringArray2 = (String[])vector.get(i);
                    stringArray[i] = stringArray2[0];
                }
                return stringArray;
            }
            return null;
        }
        return null;
    }

    private static String buildColumnList(Condition condition) {
        switch (condition.get_operate()) {
            case 4: {
                return "eq";
            }
            case 5: {
                return "gt";
            }
            case 6: {
                return "geq";
            }
            case 7: {
                return "lt";
            }
            case 8: {
                return "leq";
            }
            case 9: {
                return "neq";
            }
            case 10: {
                return "in";
            }
            case 11: {
                return "notin";
            }
            case 14: {
                return "between";
            }
            case 15: {
                return "notbetween";
            }
            case 16: {
                return "isnull";
            }
            case 17: {
                return "isnotnull";
            }
        }
        return null;
    }

    private static void checkCanFilter(Vector vector, Condition condition) {
        if (condition.isLogicGroup()) {
            for (int i = 0; i < condition.childrenSize(); ++i) {
                Condition condition2 = condition.getChild(i);
                RptToolkit.checkCanFilter(vector, condition2);
            }
        } else {
            RptToolkit.blColumnName(vector, condition);
        }
    }

    public static String[][] getSortConditions(DesignService designService, String string, String string2, String string3, String string4, String string5) throws JRScheduleException {
        JetRptReportSet jetRptReportSet;
        String[][] stringArray = null;
        JetRptReport jetRptReport = null;
        if (string4 != null) {
            jetRptReport = designService.getReport(string2, string3, string4);
        } else {
            jetRptReportSet = designService.getReportSetById(string2);
            jetRptReport = jetRptReportSet.getReport(string3);
        }
        jetRptReportSet = RptToolkit.getComponentByName((JetRptObject)jetRptReport, string5);
        try {
            JetRptSort jetRptSort;
            int n;
            Object object;
            Vector vector;
            Object object2;
            if (jetRptReportSet instanceof JetRptCTHdDBField) {
                JetRptCTHdDBField jetRptCTHdDBField = (JetRptCTHdDBField)jetRptReportSet;
                int n2 = jetRptCTHdDBField.sortOrder.get();
                String string6 = jetRptCTHdDBField.orderby.get();
                if (string6.equals("") || n2 == 3) {
                    return null;
                }
                String string7 = n2 == 0 ? "true" : "false";
                stringArray = new String[][]{{string6, string7}};
                return stringArray;
            }
            if (jetRptReportSet instanceof JetRptGroupPanel) {
                object2 = (JetRptGroupPanel)jetRptReportSet;
                vector = ((JetRptGroupPanel)object2).sortBy.get();
                object = ((JetRptGroupPanel)object2).sortOrder.get();
                if (vector == null) {
                    return null;
                }
                n = vector.size();
                if (n == 0) {
                    return null;
                }
                jetRptSort = new String[n][2];
                for (int i = 0; i < n; ++i) {
                    jetRptSort[i][0] = (String)vector.get(i);
                    jetRptSort[i][1] = ((String)((Vector)object).get(i)).equalsIgnoreCase("ASCENDING") ? "true" : "false";
                }
                stringArray = jetRptSort;
            } else if (jetRptReportSet instanceof JetRptSectionObject || jetRptReportSet instanceof JetRptNewTable) {
                object2 = designService.getSortContainerForBrowseAction(string2, string3, string4, string5);
                if (object2 == null || object2.size() == 0) {
                    return null;
                }
                vector = object2.getChildren();
                object = new String[vector.size()][2];
                for (n = 0; n < vector.size(); ++n) {
                    jetRptSort = (JetRptSort)vector.get(n);
                    object[n][0] = jetRptSort.getColumn();
                    object[n][1] = jetRptSort.getOrder() == 0 ? "true" : "false";
                }
                stringArray = object;
            } else {
                object2 = RptToolkit.getExpression(designService, string2, string3, string4, string5);
                if (object2 != null) {
                    try {
                        stringArray = DExpression.toSortConditions((IExpression)object2);
                    }
                    catch (ConditionException conditionException) {
                        if (JDLog.isError((int)2)) {
                            JDLog.error((int)2, (Throwable)conditionException);
                        }
                        throw new JDException((Throwable)conditionException);
                    }
                }
            }
            if (stringArray != null) {
                object2 = new Vector();
                for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i][0];
                    n = RptToolkit.checkCanSort(designService, string, string2, string4, string3, string5, (String)object) ? 1 : 0;
                    if (n == 0) continue;
                    ((Vector)object2).add(stringArray[i]);
                }
                String[][] stringArray2 = new String[((Vector)object2).size()][2];
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    stringArray2[i] = (String[])((Vector)object2).get(i);
                }
                stringArray = stringArray2;
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (JDLog.isError((int)3)) {
                JDLog.error((int)3, (int)3910234, (Throwable)exception);
            }
            return null;
        }
    }

    public static int getSortColState(DesignService designService, String string, String string2, String string3, String string4, String string5, String string6) {
        String[][] stringArray;
        block4: {
            stringArray = null;
            try {
                stringArray = RptToolkit.getSortConditions(designService, string, string2, string3, string4, string5);
            }
            catch (JRScheduleException jRScheduleException) {
                if (!JDLog.isError((int)3)) break block4;
                JDLog.error((int)3, (Throwable)jRScheduleException);
            }
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i][0].equalsIgnoreCase(string6)) continue;
                return stringArray[i][1].equalsIgnoreCase("true") ? 0 : 1;
            }
            return 2;
        }
        return 2;
    }

    public static String getDatasetIdByComName(DesignService designService, String string, String string2, String string3, String string4) throws JRScheduleException {
        JetRptReportSet jetRptReportSet;
        JetRptReport jetRptReport = null;
        if (string3 != null) {
            jetRptReport = designService.getReport(string, string2, string3);
        } else {
            jetRptReportSet = designService.getReportSetById(string);
            jetRptReport = jetRptReportSet.getReport(string2);
        }
        jetRptReportSet = RptToolkit.getComponentByName((JetRptObject)jetRptReport, string4);
        String string5 = RptToolkit.getDataSet((JetRptObject)jetRptReportSet);
        return string5;
    }

    public static boolean checkCanSort(DesignService designService, String string, String string2, String string3, String string4, String string5, String string6) throws JRScheduleException {
        DHTMLService dHTMLService = DHTMLService.getInstance();
        String[] stringArray = dHTMLService.getDHTMLDataInfo().getSortComponents(string2, string4, string3);
        if (!RptToolkit.isInVector(stringArray, string5)) {
            return false;
        }
        String[][] stringArray2 = DisplayNames.getCanSortMappingNamesAndDisplayNames(string, string2, string4, string3, string5, false);
        return RptToolkit.checkCanSort(stringArray2, string6, 0);
    }

    public static String[] getMappingNames(DesignService designService, String string, String string2, String string3, String string4, boolean bl) throws JRScheduleException {
        String[] stringArray;
        String string5 = null;
        if (bl) {
            stringArray = designService.getMappingNamesInDataSet(string, string2, string3, string4);
            string5 = string3;
        } else {
            stringArray = designService.getMappingNamesInComponent(string, string2, string3, string4);
            string5 = RptToolkit.getDatasetIdByComName(designService, string, string2, string4, string3);
        }
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = designService.getResourceSqlTypeForDataset(string, string2, string5, stringArray[i], string4);
            boolean bl2 = designService.isArray(string, string2, string5, stringArray[i], string4);
            if (n == 2004 || bl2 || stringArray[i] == null) continue;
            vector.add(stringArray[i]);
        }
        if (vector.size() == 0) {
            return new String[0];
        }
        stringArray = new String[vector.size()];
        return vector.toArray(stringArray);
    }

    public static boolean checkCanFilter(DesignService designService, String string, String string2, String string3, String string4, String string5, String string6) throws JRScheduleException {
        String[][] stringArray = DisplayNames.getCanFilterMappingNamesAndDisplayNames(string, string2, string3, string4, string5, false);
        return RptToolkit.checkCanSort(stringArray, string6, 0);
    }

    private static boolean checkCanSort(String[][] stringArray, String string, int n) {
        if (stringArray != null && stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length <= n || stringArray[i][n] == null || !stringArray[i][n].equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInVector(String[] stringArray, String string) {
        if (stringArray != null && stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || !stringArray[i].equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInVector(Vector vector, String string) {
        if (vector != null && vector.size() != 0) {
            String string2 = null;
            for (int i = 0; i < vector.size(); ++i) {
                string2 = (String)vector.get(i);
                if (string2 == null || !string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkCanSearch(DesignService designService, String string, String string2, String string3, String string4, String string5, String string6) throws JRScheduleException {
        Vector vector = designService.getRptDbFieldMappingNames(string2, string3, string4);
        if (!RptToolkit.isInVector(vector, string6)) {
            return false;
        }
        return RptToolkit.checkCanFilter(designService, string, string2, string3, string4, string5, string6);
    }

    public static boolean checkCanFilterClear(DesignService designService, String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            IExpression iExpression = RptToolkit.getExpression(designService, string2, string3, string4, string5);
            DHTMLService dHTMLService = DHTMLService.getInstance();
            DHTMLSession dHTMLSession = dHTMLService.getDHTMLSession(string);
            UISceneContainer uISceneContainer = dHTMLSession.getSceneContainer();
            String[][] stringArray = BSFilterScene.buildColumnList(string, string2, string3, string4, string5);
            BSFilterEditor bSFilterEditor = new BSFilterEditor(uISceneContainer, stringArray, iExpression, string2, string3, string4, string5);
            boolean bl = bSFilterEditor.haveColumnCondition(string6);
            bSFilterEditor.destroy();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static IExpression filterClearByCol(DesignService designService, String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        IExpression iExpression = RptToolkit.getExpression(designService, string2, string3, string4, string5);
        DHTMLService dHTMLService = DHTMLService.getInstance();
        DHTMLSession dHTMLSession = dHTMLService.getDHTMLSession(string);
        UISceneContainer uISceneContainer = dHTMLSession.getSceneContainer();
        String[][] stringArray = BSFilterScene.buildColumnList(string, string2, string3, string4, string5);
        BSFilterEditor bSFilterEditor = new BSFilterEditor(uISceneContainer, stringArray, iExpression, string2, string3, string4, string5);
        bSFilterEditor.removeColumn(string6);
        IExpression iExpression2 = bSFilterEditor.toIExpression();
        bSFilterEditor.destroy();
        return iExpression2;
    }

    public static IExpression getExpression(DesignService designService, String string, String string2, String string3, String string4) throws JRScheduleException {
        JetRptReport jetRptReport = designService.getReport(string, string2, string3);
        JetRptObject jetRptObject = RptToolkit.getComponentByName((JetRptObject)jetRptReport, string4);
        if (jetRptObject instanceof JetRptDataContainer || jetRptObject instanceof JetRptDataSet) {
            IExpression iExpression = designService.getIExpressionForBrowseAction(string, string2, string3, string4);
            return iExpression;
        }
        return null;
    }

    public static int getDatasetValuesList(DesignService designService, String string, String string2, String string3, String string4, String string5, String string6, int n, int n2, List list) {
        throw new UnsupportedOperationException("The method will not be invoked.");
    }

    public static int getComponentValuesList(DesignService designService, String string, String string2, String string3, String string4, String string5, String string6, int n, int n2, List list, boolean bl) {
        try {
            List list2 = null;
            list2 = bl ? designService.getCurrentValueListForComp(string2, string3, string5, string6, n, n2, string4) : designService.getOriginalValueListForComp(string2, string3, string5, string6, n, n2, string4);
            list.clear();
            if (list2 == null || list2.size() < 2) {
                return -1;
            }
            if (list2.get(0).equals("0") && n != 0) {
                return RptToolkit.getComponentValuesList(designService, string, string2, string3, string4, string5, string6, 0, n2, list, bl);
            }
            if (list2.size() == 2) {
                int n3 = Integer.parseInt((String)list2.get(1));
                if (n >= n3 && n != 0 && n3 != 0) {
                    n = n3 - n2 + 1;
                    if (n < 0) {
                        n = 0;
                    }
                    return RptToolkit.getComponentValuesList(designService, string, string2, string3, string4, string5, string6, n, n2, list, bl);
                }
            } else {
                for (int i = 2; i < list2.size(); ++i) {
                    list.add(list2.get(i));
                }
            }
            return n;
        }
        catch (Throwable throwable) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)throwable);
            }
            return -1;
        }
    }

    public static String[][] getSupportedEncoding() {
        return APIUtil.getSupportedEncodings();
    }

    public static void pushFilterParam(DHTMLRptSet dHTMLRptSet, Hashtable hashtable) {
        ArrayList<Hashtable> arrayList = null;
        arrayList = dHTMLRptSet.getFilterParam();
        if (arrayList == null) {
            arrayList = new ArrayList<Hashtable>();
        }
        arrayList.add(hashtable);
        dHTMLRptSet.setFilterParam(arrayList);
    }

    public static List getAllFilterParam(DHTMLRptSet dHTMLRptSet) {
        return dHTMLRptSet.getFilterParam();
    }

    public static void pushSortParam(DHTMLRptSet dHTMLRptSet, Hashtable hashtable) {
        ArrayList<Hashtable> arrayList = null;
        arrayList = dHTMLRptSet.getSortParam();
        if (arrayList == null) {
            arrayList = new ArrayList<Hashtable>();
        }
        arrayList.add(hashtable);
        dHTMLRptSet.setSortParam(arrayList);
    }

    public static List getAllSortParam(DHTMLRptSet dHTMLRptSet) {
        return dHTMLRptSet.getSortParam();
    }

    public static boolean checkCanDoFilterByComponent(JetRptObject jetRptObject, JetRptObject jetRptObject2, String string, String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        JetRptObject jetRptObject3 = jetRptObject;
        while (!(jetRptObject3 instanceof JetRptSectionObject || jetRptObject3 instanceof JetRptNewTable || jetRptObject3 instanceof JetRptReport)) {
            jetRptObject3 = (JetRptObject)jetRptObject3.getParent();
        }
        String string2 = RptToolkit.getComponentTypeString(jetRptObject3);
        if (JDLog.isAd()) {
            JDLog.print((Object)("tmpname=" + string2));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equals(stringArray[i]) || !(bl2 = RptToolkit.findCanDoFilterDBFieldObj(jetRptObject3, string))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean findCanDoFilterDBFieldObj(JetRptObject jetRptObject, String string) {
        Vector vector = null;
        if (jetRptObject == null) {
            return false;
        }
        vector = jetRptObject.getChildren();
        JetRptObject jetRptObject2 = null;
        boolean bl = false;
        String string2 = null;
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                jetRptObject2 = (JetRptObject)vector.elementAt(i);
                if (jetRptObject2 instanceof JetRptField && (string2 = ((JetRptField)jetRptObject2).getColumnName(null)) != null && string != null && string.trim().equals(string2.trim())) {
                    bl = true;
                    break;
                }
                if (!RptToolkit.findCanDoFilterDBFieldObj(jetRptObject2, string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static void checkAddLableAvailability(String string, String string2, String string3, JRObjectResult jRObjectResult) throws AlertMessage, JRScheduleException {
        if (string.equals("special_sqlstatement")) {
            String string4;
            DSTemplatible dSTemplatible = jRObjectResult.getTemplate();
            DataSet dataSet = ReportTools.getDataSet((JetObject)((JetRptObject)dSTemplatible));
            if (dataSet == null) {
                return;
            }
            String string5 = dataSet.getDataSourceName();
            QueryCategory queryCategory = DHTMLService.getInstance().ds.getQueryCategory(string3, string5, string4 = dataSet.getQueryName());
            if (queryCategory == null) {
                return;
            }
            if (queryCategory.isHDS()) {
                String string6 = WebActLogic.getMsgFactory(string2, string3, DHTMLService.getInstance()).getMessage("31012822");
                throw new AlertMessage(string2, string3, string6);
            }
        }
    }

    public static String getGoToDetailTarget(JRObjectResult jRObjectResult, boolean bl) {
        String string = bl ? "_blank" : "_self";
        DSTemplatible dSTemplatible = jRObjectResult.getTemplate();
        String string2 = null;
        if (dSTemplatible instanceof JetRptPicture) {
            JetStringList jetStringList = (JetStringList)((JetRptPicture)dSTemplatible).getPropertyByName("DetailTargetFrame");
            string2 = jetStringList.get();
        } else if (dSTemplatible instanceof JetRptField) {
            JetStringList jetStringList = (JetStringList)((JetRptField)dSTemplatible).getPropertyByName("DetailTargetFrame");
            string2 = jetStringList.get();
        } else if (dSTemplatible instanceof JetRptMap) {
            JetStringList jetStringList = (JetStringList)((JetRptMap)dSTemplatible).getPropertyByName("DetailTargetFrame");
            string2 = jetStringList.get();
        } else {
            string2 = "";
        }
        if (string2.equals("")) {
            return string;
        }
        return string2;
    }

    public static String getLinkTarget(JRObjectResult jRObjectResult, boolean bl) {
        String string = bl ? "_blank" : "_self";
        return RptToolkit.childrenSize(jRObjectResult, string);
    }

    private static String childrenSize(JRObjectResult jRObjectResult, String string) {
        JetRptObject jetRptObject = (JetRptObject)jRObjectResult.getTemplate();
        return RptToolkit.getLinkTarget(jetRptObject, string);
    }

    public static String getLinkTarget(JetRptObject jetRptObject, String string) {
        JetEnumeration jetEnumeration = null;
        JetString jetString = null;
        JetLink jetLink = null;
        if (jetRptObject instanceof JetRptPicture || jetRptObject instanceof JetRptField || jetRptObject instanceof JetRptConditionalLinkItem) {
            jetLink = (JetLink)jetRptObject.nameToProperty("Link");
            jetEnumeration = (JetEnumeration)jetRptObject.nameToProperty("LinkURLTargetFrame");
            jetString = (JetString)jetRptObject.nameToProperty("CusTargetFrame");
        } else if (jetRptObject instanceof JetRptArea) {
            if (((JetBoolean)jetRptObject.nameToProperty("UseDefault")).booleanValue()) {
                jetRptObject = (JetRptObject)((JetRptArea)jetRptObject).getBasedArea();
            }
            jetLink = (JetLink)jetRptObject.nameToProperty("Link");
            jetEnumeration = (JetEnumeration)jetRptObject.nameToProperty("LinkURLTargetFrame");
            jetString = (JetString)jetRptObject.nameToProperty("CusTargetFrame");
        } else {
            return "";
        }
        if (jetLink != null && jetLink.getLinkType() == 3) {
            return "_self";
        }
        switch (jetEnumeration.intValue()) {
            case 0: {
                return "_blank";
            }
            case 1: {
                return "_parent";
            }
            case 2: {
                return "_self";
            }
            case 3: {
                return "_top";
            }
            case 4: {
                return string;
            }
            case 5: {
                return jetString.get();
            }
        }
        return "";
    }

    public static Vector getComponentStructure(JetRptReport jetRptReport, String string) {
        Vector<Serializable> vector = new Vector<Serializable>();
        JetRptObject jetRptObject = RptToolkit.getComponentByName((JetRptObject)jetRptReport, string);
        if (jetRptObject == null) {
            return vector;
        }
        if (jetRptObject instanceof JetRptTable) {
            Vector vector2 = new Vector();
            RptToolkit.getSubComponents(vector2, jetRptObject, new String[]{"GroupPanel"});
            Vector<String> vector3 = new Vector<String>();
            for (Object e : vector2) {
                vector3.add(((JetRptGroupPanel)e).blColumnName.get());
            }
            vector.add(Integer.valueOf(2));
            vector.add(vector3);
        } else if (jetRptObject instanceof JetRptCTCrossTab) {
            Vector vector4 = ((JetRptCTCrossTab)jetRptObject).getChildren();
            Vector<String> vector5 = new Vector<String>();
            Vector<String> vector6 = new Vector<String>();
            for (Object e : vector4) {
                if (!(e instanceof JetRptCTHdDBField)) continue;
                JetRptCTHdDBField jetRptCTHdDBField = (JetRptCTHdDBField)e;
                if (jetRptCTHdDBField.bNIsXHeader) {
                    vector5.add(jetRptCTHdDBField.blColumnName.get());
                    continue;
                }
                vector6.add(jetRptCTHdDBField.blColumnName.get());
            }
            if (vector5.size() > 0 || vector6.size() > 0) {
                vector.add(Integer.valueOf(0));
                vector.add(vector5);
                vector.add(vector6);
            }
        } else if (jetRptObject instanceof JetRptChartPlatform) {
            ChartDefinition chartDefinition = ((JetRptChartPlatform)jetRptObject).getChartDefinition();
            String string2 = chartDefinition.getCategory();
            String string3 = chartDefinition.getSeries();
            Vector<String> vector7 = new Vector<String>();
            Vector<String> vector8 = new Vector<String>();
            if (string2 != null) {
                vector7.add(string2);
            }
            if (string3 != null) {
                vector8.add(string3);
            }
            if (vector7.size() > 0 || vector8.size() > 0) {
                vector.add(Integer.valueOf(1));
                vector.add(vector7);
                vector.add(vector8);
            }
        } else if (jetRptObject instanceof JetRptNewTable) {
            Vector vector9 = ((JetRptNewTable)jetRptObject).getGroupPanels();
            Vector<String> vector10 = new Vector<String>();
            for (Object e : vector9) {
                vector10.add(((JetRptTableGroup)e).blColumnName.get());
            }
            vector.add(Integer.valueOf(2));
            vector.add(vector10);
        }
        return vector;
    }
}

