/*
 * Decompiled with CFR 0.152.
 */
package jet.web.dhtml.util;

import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import jet.web.dhtml.DHTMLConfig;
import jet.web.dhtml.DHTMLServiceFactory;
import jet.web.dhtml.DHTMLUtil;
import jet.web.dhtml.util.HashtablePlus;
import jet.webreport.client.DHTMLContext;

public class WebUtil {
    public static final String RequestURI = "WebToolkitRequestURI";
    public static final String QueryString = "WebToolkitQueryString";
    public static final String PathInfo = "WebToolkitPathInfo";
    public static final String RequestAttributes = "WebRequestAttributes";

    public static Object getRequestParam(HttpServletRequest httpServletRequest, String string) {
        return httpServletRequest.getParameter(string);
    }

    public static Object getRequestParam(HttpServletRequest httpServletRequest, String string, Object object) {
        return WebUtil.getRequestParam(httpServletRequest, string, object, true);
    }

    public static Object getRequestParam(HttpServletRequest httpServletRequest, String string, Object object, boolean bl) {
        Object object2 = null;
        if (string.equals(RequestURI)) {
            object2 = httpServletRequest.getRequestURI();
        } else if (string.equals(QueryString)) {
            object2 = httpServletRequest.getQueryString();
        } else if (string.equals(PathInfo)) {
            object2 = httpServletRequest.getPathInfo();
        } else if (bl) {
            object2 = httpServletRequest.getAttribute(string);
            if (object2 == null) {
                String[] stringArray = httpServletRequest.getParameterValues(string);
                if (stringArray != null && stringArray.length > 1) {
                    object2 = stringArray;
                } else if (stringArray != null && stringArray.length == 1) {
                    object2 = stringArray[0];
                }
            }
        } else {
            String[] stringArray = httpServletRequest.getParameterValues(string);
            if (stringArray != null && stringArray.length > 1) {
                object2 = stringArray;
            } else if (stringArray != null && stringArray.length == 1) {
                object2 = stringArray[0];
            }
            if (object2 == null) {
                object2 = httpServletRequest.getAttribute(string);
            }
        }
        if (object2 == null) {
            object2 = object;
        }
        return object2;
    }

    public static Object setRequestParam(HttpServletRequest httpServletRequest, String string, Object object) {
        if (string != null && object != null) {
            httpServletRequest.setAttribute(string, object);
            return object;
        }
        return null;
    }

    public static String getServletPath(HttpServletRequest httpServletRequest) {
        int n;
        String string = httpServletRequest.getServletPath();
        if (null != string && !"".equals(string)) {
            return string;
        }
        String string2 = httpServletRequest.getRequestURI();
        int n2 = httpServletRequest.getContextPath().equals("") ? 0 : httpServletRequest.getContextPath().length();
        int n3 = n = httpServletRequest.getPathInfo() == null ? string2.length() : string2.lastIndexOf(httpServletRequest.getPathInfo());
        if (n2 > n) {
            n = n2;
        }
        return string2.substring(n2, n);
    }

    public static Map getAttributes(HttpServletRequest httpServletRequest) {
        HashtablePlus hashtablePlus = new HashtablePlus();
        Enumeration enumeration = httpServletRequest.getAttributeNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                hashtablePlus.put(string, httpServletRequest.getAttribute(string));
            }
        }
        return hashtablePlus;
    }

    public static boolean isMultiPart(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getContentType();
        return string != null && string.indexOf("multipart/form-data") != -1;
    }

    public static String getQuery(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf("//");
        int n2 = string.indexOf(47, n >= 0 ? (string.lastIndexOf(47, n - 1) >= 0 ? 0 : n + 2) : 0);
        int n3 = string.length();
        n = string.indexOf(63, n2);
        if (n < 0) {
            return null;
        }
        n2 = n + 1;
        if (string.lastIndexOf(35) > n2) {
            n3 = string.lastIndexOf(35);
        }
        return n2 < 0 || n2 == n3 ? null : string.substring(n2, n3);
    }

    public static String getPath(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("//");
        int n2 = string.indexOf(47, n >= 0 ? (string.lastIndexOf(47, n - 1) >= 0 ? 0 : n + 2) : 0);
        int n3 = string.length();
        if (string.indexOf(63, n2) != -1) {
            n3 = string.indexOf(63, n2);
        }
        if (string.lastIndexOf(35) > n2 && string.lastIndexOf(35) < n3) {
            n3 = string.lastIndexOf(35);
        }
        return n2 < 0 ? (n >= 0 ? "/" : string) : string.substring(n2, n3);
    }

    public static String getPathQuery(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("//");
        int n2 = string.indexOf(47, n >= 0 ? (string.lastIndexOf(47, n - 1) >= 0 ? 0 : n + 2) : 0);
        int n3 = string.length();
        if (string.lastIndexOf(35) > n2) {
            n3 = string.lastIndexOf(35);
        }
        return n2 < 0 ? (n >= 0 ? "/" : string) : string.substring(n2, n3);
    }

    public static String getRightTargetURL(HttpServletRequest httpServletRequest, String string) throws Exception {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equals("")) {
            return null;
        }
        if (!string.toLowerCase().startsWith("/")) {
            String string2;
            DHTMLConfig dHTMLConfig = DHTMLServiceFactory.getDHTMLClientService(httpServletRequest).getDHTMLConfig();
            String string3 = DHTMLUtil.getSessionID(httpServletRequest);
            String string4 = dHTMLConfig.getDHTMLContextPath(string3);
            String string5 = dHTMLConfig.getDHTMLJspUrl(string3);
            String string6 = DHTMLUtil.getWebContextPath(string4);
            if (string6.equals(string2 = httpServletRequest.getContextPath()) && string5.startsWith(string6)) {
                string5 = string5.substring(string6.length());
            }
            if (string2.length() > 0 && !string2.equals(string6)) {
                String string7 = dHTMLConfig.getDHTMLServletUrl(string3, null);
                string7 = string7.substring(string6.length());
                String string8 = httpServletRequest.getRequestURI();
                if ((string8 = string8.substring(string2.length())).indexOf(string7) > 0) {
                    String string9 = string8.substring(0, string8.indexOf(string7));
                    string5 = string9 + string5;
                }
            }
            if ((string = string5 + string).indexOf(string2) > -1) {
                string = string.substring(string2.length());
            }
        }
        return string;
    }

    public static RequestDispatcher getRequestDispatcher(HttpServletRequest httpServletRequest, String string) throws Exception {
        return DHTMLContext.getForwardDispatcher(httpServletRequest, string);
    }

    public static Map parseQueryString(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (string != null) {
            String[] stringArray = string.split("&");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].trim().length() <= 0) continue;
                String[] stringArray2 = stringArray[i].split("=");
                String string2 = null;
                String string3 = "";
                if (stringArray2.length > 0) {
                    string2 = stringArray2[0];
                }
                if (stringArray2.length > 1) {
                    string3 = stringArray2[1];
                }
                if (string2 == null) continue;
                linkedHashMap.put(string2, string3);
            }
        }
        return linkedHashMap;
    }
}

