/*
 * Decompiled with CFR 0.152.
 */
package jet.webreport.service;

import com.jinfonet.util.JDLog;
import com.jinfonet.web.util.FileUtil;
import com.jinfonet.web.util.StringUtil;
import com.jinfonet.web.util.Tools;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import jet.api.CatalogAPI;
import jet.api.DHTMLDesigner;
import jet.api.Designer;
import jet.api.DesignerUserInfo;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.icontrols.QueryInfo;
import jet.report.JetRptDBField;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptObject;
import jet.report.JetRptSystemField;
import jet.reportset.DataSet;
import jet.reportset.JetRptReport;
import jet.rptservice.api.design.DesignService;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.design.DisplayName;
import jet.rptservice.design.DisplayNameInformation;
import jet.rptservice.util.ReportTools;
import jet.universe.businesslogic.DataElementInfo;
import jet.util.DbValueFormat;
import jet.util.ReportFormat;
import jet.webreport.CatalogInfo;
import jet.webreport.beans.FieldName;
import jet.webreport.beans.FieldValue;
import jet.webreport.beans.Name;
import jet.webreport.service.CatalogInfoImpl;
import jet.webreport.service.ComponentKit;
import jet.webreport.service.builder.ResourceTreeBuilder;
import jet.webreport.util.JNode;
import util.ConvertDbChar;

public final class DataKit {
    private static final String[] I = new String[]{"CTHdDBField", "GroupPanel", "TableGroup"};

    public static String getDataSetNameByComponent(DesignService designService, String string, String string2, String string3, String string4) {
        DataSet dataSet = DataKit.getDataSetByComponent(designService, string, string2, string3, string4);
        if (dataSet == null) {
            return null;
        }
        return dataSet.getName();
    }

    public static DataSet getDataSetByComponent(DesignService designService, String string, String string2, String string3, String string4) {
        JetRptReport jetRptReport = DataKit.getJetRptReport(designService, string, string2, string3);
        if (jetRptReport == null) {
            return null;
        }
        JetRptObject jetRptObject = (JetRptObject)jetRptReport.nameToObject(string4);
        return DataKit.getDataSetByJetRptObject(jetRptObject);
    }

    public static DataSet getDataSetByJetRptObject(JetRptObject jetRptObject) {
        return ReportTools.getDataSet((JetObject)jetRptObject);
    }

    public static List getFilterableColumns(DesignService designService, String string, String string2, String string3, String string4, int n) {
        DisplayNameInformation displayNameInformation;
        List<FieldName> list = new ArrayList();
        JetRptReport jetRptReport = DataKit.getJetRptReport(designService, string, string2, string3);
        boolean bl = DataKit.isBC(designService, string, string2, string3, string4);
        try {
            displayNameInformation = designService.getDisplayNameInfomationInComponent(string, string2, string4, string3);
        }
        catch (JRScheduleException jRScheduleException) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)jRScheduleException);
            }
            return list;
        }
        if (displayNameInformation == null) {
            return list;
        }
        boolean bl2 = displayNameInformation.isActionLimitedByDisplayName();
        Vector vector = displayNameInformation.getDisplayNames();
        for (DisplayName displayName : vector) {
            if (bl2 && !displayName.isCanFilter()) continue;
            String string5 = displayName.getMappingName();
            int n2 = displayName.getNameType();
            String string6 = displayName.getDisplayName();
            if (string6 == null) {
                string6 = displayName.getBlDisplayName();
            }
            if (string6 == null) {
                string6 = string5;
            }
            FieldName fieldName = new FieldName(string5, string6);
            int n3 = ((JetNumber)displayName.getProperty("Precision")).get();
            int n4 = ((JetNumber)displayName.getProperty("Scale")).get();
            fieldName.setSqlType(displayName.getSqlType());
            fieldName.setPrecision(n3);
            fieldName.setScale(n4);
            String string7 = null;
            JetRptDBField jetRptDBField = DataKit.getJetRptDBField(designService, string, string2, string3, string4, (JetRptObject)jetRptReport, string5, bl);
            if (jetRptDBField != null) {
                string7 = (String)jetRptDBField.getPropertyByName("Format").getObject();
            }
            fieldName.setFormatPattern(string7);
            int n5 = fieldName.getFieldType();
            if (n2 == 0) {
                n5 &= 0xFFFFFFF9;
                n5 |= 1;
            } else if (n2 == 2) {
                n5 &= 0xFFFFFFFA;
                n5 |= 2;
            } else if (n2 == 1) {
                n5 &= 0xFFFFFFFC;
                n5 |= 4;
            }
            fieldName.setFieldType(n5);
            if (list.indexOf(fieldName) != -1) continue;
            list.add(fieldName);
        }
        if (displayNameInformation.isAlphabeticOrder()) {
            list = Tools.sort(list, (int)n, (Comparator)new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((FieldName)object).compareTo((FieldName)object2);
                }
            });
        }
        return list;
    }

    public static List getSortableColumns(DesignService designService, String string, String string2, String string3, String string4, int n) {
        DisplayNameInformation displayNameInformation;
        JetRptObject jetRptObject;
        List<FieldName> list = new ArrayList();
        try {
            jetRptObject = designService.getObjectByInstName(string, string2, string4, string3);
        }
        catch (JRScheduleException jRScheduleException) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)jRScheduleException);
            }
            return list;
        }
        boolean bl = jetRptObject instanceof JetRptGroupPanel;
        try {
            displayNameInformation = designService.getDisplayNameInfomationInComponent(string, string2, string4, string3);
        }
        catch (JRScheduleException jRScheduleException) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)jRScheduleException);
            }
            return list;
        }
        if (displayNameInformation == null) {
            return list;
        }
        boolean bl2 = displayNameInformation.isActionLimitedByDisplayName();
        Vector vector = displayNameInformation.getDisplayNames();
        for (DisplayName displayName : vector) {
            String string5 = displayName.getMappingName();
            int n2 = displayName.getNameType();
            boolean bl3 = displayName.isCanSort();
            boolean bl4 = true;
            if (bl) {
                try {
                    bl4 = designService.canSortOnGroup(string, string2, string5, string4, string3);
                    bl3 = bl4 || n2 == 1 || n2 == 2;
                }
                catch (JRScheduleException jRScheduleException) {
                    if (!JDLog.isError((int)2)) continue;
                    JDLog.error((int)2, (Throwable)jRScheduleException);
                    continue;
                }
            }
            if (bl2 && !bl3) continue;
            String string6 = displayName.getDisplayName();
            if (string6 == null) {
                string6 = displayName.getBlDisplayName();
            }
            if (string6 == null) {
                string6 = string5;
            }
            FieldName fieldName = new FieldName(string5, string6);
            int n3 = ((JetNumber)displayName.getProperty("Precision")).get();
            int n4 = ((JetNumber)displayName.getProperty("Scale")).get();
            fieldName.setSqlType(displayName.getSqlType());
            fieldName.setPrecision(n3);
            fieldName.setScale(n4);
            int n5 = fieldName.getFieldType();
            if (n2 == 0) {
                n5 &= 0xFFFFFFF9;
                n5 |= 1;
            } else if (n2 == 2) {
                n5 &= 0xFFFFFFFA;
                n5 |= 2;
            } else if (n2 == 1) {
                n5 &= 0xFFFFFFFC;
                n5 |= 4;
            }
            fieldName.setFieldType(n5);
            if (list.indexOf(fieldName) != -1) continue;
            list.add(fieldName);
        }
        if (displayNameInformation.isAlphabeticOrder()) {
            list = Tools.sort(list, (int)n, (Comparator)new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((FieldName)object).compareTo((FieldName)object2);
                }
            });
        }
        return list;
    }

    public static List getDrillToDimensions(DesignService designService, String string, String string2, String string3, String string4, int n) {
        Object object;
        JetRptObject jetRptObject;
        List<Name> list = new ArrayList();
        try {
            jetRptObject = designService.getObjectByInstName(string, string2, string4, string3);
            object = ComponentKit.getMatchedChildComponents(null, jetRptObject, I);
            if (object.size() > 0) {
                string4 = ((Name)object.get(0)).getName();
                jetRptObject = designService.getObjectByInstName(string, string2, string4, string3);
            }
        }
        catch (JRScheduleException jRScheduleException) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)jRScheduleException);
            }
            return list;
        }
        object = designService.getAvailableDrillBLName(string, string2, jetRptObject);
        if (object == null) {
            return list;
        }
        for (String string5 : ((Hashtable)object).keySet()) {
            String string6 = (String)((Hashtable)object).get(string5);
            Name name = new Name(string5, string6);
            list.add(name);
        }
        list = Tools.sort(list, (int)n, (Comparator)new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Name)object).compareTo((Name)object2);
            }
        });
        return list;
    }

    public static List getColumnValues(DesignService designService, String string, String string2, String string3, String string4, FieldName fieldName, Locale locale, String string5, int n, int n2, boolean bl) {
        List list;
        ArrayList<FieldValue> arrayList = new ArrayList<FieldValue>();
        String string6 = fieldName.getName();
        String string7 = fieldName.getFormatPattern();
        try {
            list = bl ? designService.getCurrentValueListForComp(string, string2, string4, string6, n, n2, string3) : designService.getOriginalValueListForComp(string, string2, string4, string6, n, n2, string3);
        }
        catch (JRScheduleException jRScheduleException) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)jRScheduleException);
            }
            return arrayList;
        }
        if (list == null || list.size() < 2) {
            return arrayList;
        }
        int n3 = list.size();
        if ("0".equals(list.get(0)) && n != 0) {
            return DataKit.getColumnValues(designService, string, string2, string3, string4, fieldName, locale, string5, 0, n2, bl);
        }
        if (n3 == 2) {
            int n4 = Integer.parseInt((String)list.get(1));
            if (n4 != 0 && n != 0 && n >= n4) {
                int n5 = n4 - n2 + 1;
                n5 = n5 < 0 ? 0 : n5;
                return DataKit.getColumnValues(designService, string, string2, string3, string4, fieldName, locale, string5, n5, n2, bl);
            }
        } else {
            DbValue dbValue = (DbValue)list.get(2);
            int n6 = dbValue.getSqlType();
            DbValueFormat dbValueFormat = DataKit.makeDbValueFormat(n6, string7, locale);
            for (int i = 2; i < n3; ++i) {
                dbValue = (DbValue)list.get(i);
                String string8 = dbValue.toString();
                String string9 = DataKit.formatValue(dbValue, dbValueFormat, string7, locale, string5);
                FieldValue fieldValue = new FieldValue();
                fieldValue.setMultiRealValue(new String[]{string8});
                fieldValue.setMultiDispValue(new String[]{string9});
                arrayList.add(fieldValue);
            }
        }
        return arrayList;
    }

    public static boolean isBC(DesignService designService, String string, String string2, String string3, String string4) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = designService.isBaseOnBusinessLogic(string, string2, string3, string4);
            }
            catch (Exception exception) {
                if (!JDLog.isError((int)2)) break block2;
                JDLog.error((int)2, (Throwable)exception);
            }
        }
        return bl;
    }

    public static boolean convertToBC(DesignService designService, String string, String string2, String string3, String string4) {
        boolean bl = DataKit.isBC(designService, string, string2, string3, string4);
        try {
            if (!bl) {
                boolean bl2;
                List list = designService.getCanConvertBVInfos(string, string2, string4, string3);
                boolean bl3 = bl2 = list != null && list.size() > 0;
                if (bl2) {
                    designService.toBusinessCubeComp(string, string2, string4, string3, ((QueryInfo)list.get(0)).getBLName());
                }
                bl = bl2;
            }
        }
        catch (Exception exception) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)exception);
            }
            bl = false;
        }
        return bl;
    }

    public static String formatValue(int n, int n2, int n3, String string, String string2, Locale locale, String string3) {
        if (string2 != null && "XXXXXXXXX...".equals(string2)) {
            return string;
        }
        DbValueFormat dbValueFormat = DataKit.makeDbValueFormat(n, string2, locale);
        DbValue dbValue = DataKit.makeDbValue(n, n2, n3, string, locale);
        return DataKit.formatValue(dbValue, dbValueFormat, string2, locale, string3);
    }

    public static String formatValue(DbValue dbValue, DbValueFormat dbValueFormat, String string, Locale locale, String string2) {
        String string3 = null;
        if (dbValueFormat != null) {
            if (dbValue instanceof DbChar) {
                DbChar dbChar = (DbChar)dbValue;
                try {
                    string3 = ConvertDbChar.getConvertedString((DbChar)dbChar, (String)string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            string3 = string3 == null ? dbValueFormat.format(dbValue) : string3;
            return string3;
        }
        int n = dbValue.getSqlType();
        switch (n) {
            case 91: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                string3 = simpleDateFormat.format(((DbDate)dbValue).getDate());
                break;
            }
            case 92: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                string3 = simpleDateFormat.format(((DbTime)dbValue).getTime());
                break;
            }
            case 93: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                string3 = simpleDateFormat.format(((DbTimestamp)dbValue).getTimestamp());
                break;
            }
            default: {
                if (string == null || (dbValueFormat = DataKit.makeDbValueFormat(n, string, locale = locale == null ? Locale.getDefault() : locale)) == null) break;
                string3 = DataKit.formatValue(dbValue, dbValueFormat, string, locale, string2);
            }
        }
        return string3 == null ? dbValue.toString() : string3;
    }

    public static DbValueFormat makeDbValueFormat(int n, String string, Locale locale) {
        if (string == null) {
            return null;
        }
        return ReportFormat.getOneFormat((int)n, (String)string, (Locale)locale);
    }

    public static DbValue makeDbValue(int n, int n2, int n3, String string, Locale locale) {
        String string2;
        DbSmallInt dbSmallInt = null;
        DbColDesc dbColDesc = new DbColDesc();
        dbColDesc.setSqlType(n);
        dbColDesc.precision = n2;
        dbColDesc.scale = n3;
        switch (n) {
            case 5: {
                dbSmallInt = new DbSmallInt();
                break;
            }
            case -6: {
                dbSmallInt = new DbTinyInt();
                break;
            }
            case 4: {
                dbSmallInt = new DbInteger();
                break;
            }
            case -5: {
                dbSmallInt = new DbBigInt();
                break;
            }
            case 7: {
                dbSmallInt = new DbReal();
                break;
            }
            case 2: 
            case 3: {
                dbSmallInt = new DbDecimal();
                break;
            }
            case 6: 
            case 8: {
                dbSmallInt = new DbDouble();
                break;
            }
            case -7: {
                dbSmallInt = new DbBit();
                break;
            }
            case 91: {
                dbSmallInt = new DbDate();
                break;
            }
            case 92: {
                dbSmallInt = new DbTime();
                break;
            }
            case 93: {
                dbSmallInt = new DbTimestamp();
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                dbSmallInt = new DbChar();
                break;
            }
            case -4: 
            case -2: 
            case 2004: {
                dbSmallInt = new DbBinary();
                break;
            }
            default: {
                dbSmallInt = new DbChar();
            }
        }
        try {
            string2 = StringUtil.unformat((int)n, (String)string, (Locale)locale);
        }
        catch (ParseException parseException) {
            string2 = string;
        }
        SimpleDateFormat simpleDateFormat = null;
        switch (n) {
            case 91: {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", locale);
                break;
            }
            case 92: {
                simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS", locale);
                break;
            }
            case 93: {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", locale);
            }
        }
        if (simpleDateFormat != null) {
            try {
                Date date = simpleDateFormat.parse(string2);
                ((DbDateTime)dbSmallInt).set(date.getTime());
            }
            catch (ParseException parseException) {
                if (JDLog.isError((int)2)) {
                    JDLog.error((int)2, (Throwable)parseException);
                }
            }
        } else {
            dbSmallInt.setValue(string2);
        }
        dbSmallInt.setColDesc(dbColDesc);
        return dbSmallInt;
    }

    public static JetRptReport getJetRptReport(DesignService designService, String string, String string2, String string3) {
        JetRptReport jetRptReport;
        try {
            jetRptReport = designService.getReport(string, string2, string3);
        }
        catch (JRScheduleException jRScheduleException) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)jRScheduleException);
            }
            return null;
        }
        return jetRptReport;
    }

    public static JetRptDBField getJetRptDBField(DesignService designService, String string, String string2, String string3, String string4, JetRptObject jetRptObject, String string5, boolean bl) {
        JetRptDBField jetRptDBField = null;
        if (jetRptObject instanceof JetRptDBField || jetRptObject instanceof JetRptSystemField) {
            String string6 = DataKit.I(designService, string, string2, string3, string4, jetRptObject, bl);
            if (string6 != null && string6.equalsIgnoreCase(string5)) {
                return jetRptDBField;
            }
            return null;
        }
        Vector vector = jetRptObject.getChildren();
        if (vector == null) {
            return null;
        }
        for (Object e : vector) {
            if (!(e instanceof JetRptObject) || (jetRptDBField = DataKit.getJetRptDBField(designService, string, string2, string3, string4, (JetRptObject)e, string5, bl)) == null) continue;
            return jetRptDBField;
        }
        return jetRptDBField;
    }

    private static String I(DesignService designService, String string, String string2, String string3, String string4, JetRptObject jetRptObject, boolean bl) {
        String string5;
        block9: {
            string5 = "";
            if (jetRptObject instanceof JetRptSystemField) {
                try {
                    string5 = JetRptSystemField.getPresentationName((int)((JetRptSystemField)jetRptObject).getFieldType());
                }
                catch (Exception exception) {
                    if (JDLog.isError((int)2)) {
                        JDLog.error((int)2, (Throwable)exception);
                    }
                    break block9;
                }
            }
            if (bl) {
                JetRptDBField jetRptDBField = (JetRptDBField)jetRptObject;
                string5 = (String)jetRptDBField.blColumnName.getValue();
                try {
                    DataElementInfo dataElementInfo = (DataElementInfo)designService.getRefDataElement(string, string2, string4, string5, string3);
                    if (dataElementInfo != null) {
                        string5 = dataElementInfo.getRefMappingName();
                    }
                    break block9;
                }
                catch (Exception exception) {
                    if (JDLog.isError((int)2)) {
                        JDLog.error((int)2, (Throwable)exception);
                    }
                    break block9;
                }
            }
            JetRptDBField jetRptDBField = (JetRptDBField)jetRptObject;
            string5 = (String)jetRptDBField.columnName.getValue();
        }
        return string5;
    }

    public static String unformatValue(int n, int n2, int n3, String string, String string2, Locale locale, String string3) {
        if (string2 != null && "XXXXXXXXX...".equals(string2)) {
            return string;
        }
        DbValueFormat dbValueFormat = DataKit.makeDbValueFormat(n, string2, locale);
        if (dbValueFormat != null) {
            DbValue dbValue = DataKit.makeDbValue(n, n2, n3, string, locale);
            try {
                dbValueFormat.parse(dbValue, string);
                return dbValue.toString();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        try {
            return StringUtil.unformat((int)n, (String)string, (Locale)locale);
        }
        catch (ParseException parseException) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)parseException);
            }
            return string;
        }
    }

    public static CatalogInfo getCatalogInfo(CatalogAPI catalogAPI, String string, String string2, String string3, String string4) {
        CatalogInfoImpl catalogInfoImpl = new CatalogInfoImpl();
        ResourceTreeBuilder resourceTreeBuilder = new ResourceTreeBuilder(string2, string3);
        resourceTreeBuilder.setCatName(string4);
        JNode jNode = resourceTreeBuilder.buildCatalogDSTree(catalogAPI, string);
        catalogInfoImpl.setDataSourcesTree(jNode);
        return catalogInfoImpl;
    }

    public static CatalogInfo getCatalogInfo(DesignService designService, String string, String string2, String string3, String string4) {
        CatalogInfoImpl catalogInfoImpl = new CatalogInfoImpl();
        ResourceTreeBuilder resourceTreeBuilder = new ResourceTreeBuilder(string, string2);
        JNode jNode = resourceTreeBuilder.buildReportDSTree(string2, string3, string4);
        catalogInfoImpl.setDataSourcesTree(jNode);
        return catalogInfoImpl;
    }

    public static Designer getDesigner(String string) {
        DHTMLDesigner dHTMLDesigner;
        block2: {
            dHTMLDesigner = null;
            DesignerUserInfo designerUserInfo = new DesignerUserInfo("Pasdf56q890weB2s5fC43fDE", null);
            try {
                String string2 = FileUtil.getFilePath((String)string);
                String string3 = FileUtil.getFileName((String)string);
                dHTMLDesigner = new DHTMLDesigner(string2, string3, designerUserInfo);
            }
            catch (Exception exception) {
                if (!JDLog.isError((int)2)) break block2;
                JDLog.error((int)2, (Throwable)exception);
            }
        }
        return dHTMLDesigner;
    }

    public static String[] getReportEngineKeys(DesignService designService, String string, String string2, String string3) {
        String[] stringArray = null;
        if (string3 == null) {
            String[] stringArray2;
            block5: {
                stringArray2 = null;
                try {
                    stringArray2 = designService.getSubEngineKeyword(string, string2);
                }
                catch (JRScheduleException jRScheduleException) {
                    if (!JDLog.isError((int)2)) break block5;
                    JDLog.error((int)2, (Throwable)jRScheduleException);
                }
            }
            if (stringArray2 != null) {
                int n = stringArray2.length;
                stringArray = new String[n + 1];
                System.arraycopy(stringArray2, 0, stringArray, 1, n);
            }
        }
        if (stringArray == null) {
            stringArray = string3 != null ? new String[]{null, string3} : new String[]{null};
        }
        return stringArray;
    }

    public static boolean hasBusinessLogic(DesignService designService, String string) {
        boolean bl = false;
        HashMap hashMap = new HashMap();
        List list = null;
        try {
            list = designService.getAllBLNames(string, hashMap);
        }
        catch (Exception exception) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)exception);
            }
            return bl;
        }
        for (String string2 : list) {
            Vector vector = (Vector)hashMap.get(string2);
            if (vector == null || vector.size() <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

