/*
 * Decompiled with CFR 0.152.
 */
package jet.webreport.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import jet.webreport.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class JNode
implements Serializable {
    private static final long serialVersionUID = -7423997138864004151L;
    public static final transient String TAG_SURFIX = ".tag";
    public static final transient String ATT_PREFIX = "att.";
    public static final transient String MAP_SURFIX = ".map";
    public static final transient String HIDE_SURFIX = ".hide";
    public static final transient String NODE_TYPE = "node.type";
    public static final transient String NODE_NAME = "node.name";
    public static final transient String NODE_VALU = "node.value";
    public static final transient String NODE_DESC = "node.desc";
    public static final transient String NODE_PATH = "node.path";
    public static final transient String NODE_ID = "node.id";
    public static final transient String TYPE_ROOT = "root";
    private Properties attrs = new Properties();
    private LinkedList children = new LinkedList();
    private String text;
    private String path_prefix = "/";
    private JNode parent = null;

    public JNode(String string) {
        this.attrs.setProperty(NODE_TYPE, string == null ? "UNKNOWN" : string);
    }

    public JNode(String string, String string2, String string3, String string4) {
        this(string);
        this.setName(string2);
        this.setValue(string3);
        this.setDescription(string4);
    }

    public JNode getParent() {
        return this.parent;
    }

    public String getAttribute(String string) {
        return this.attrs.getProperty(string, "");
    }

    public void setAttribute(String string, String string2) {
        if (string2 != null) {
            this.attrs.setProperty(string, string2);
        }
    }

    public Iterator getAttributeNames() {
        return this.attrs.keySet().iterator();
    }

    public String getType() {
        return this.getAttribute(NODE_TYPE);
    }

    public String getName() {
        return this.getAttribute(NODE_NAME);
    }

    public void setName(String string) {
        this.setAttribute(NODE_NAME, string);
    }

    public String getValue() {
        return this.getAttribute(NODE_VALU);
    }

    public void setValue(String string) {
        this.setAttribute(NODE_VALU, string);
    }

    public String getDescription() {
        return this.getAttribute(NODE_DESC);
    }

    public void setDescription(String string) {
        this.setAttribute(NODE_DESC, string);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getPath() {
        if (this.parent == null) {
            return this.path_prefix;
        }
        class Stack
        extends ArrayList {
            Stack() {
            }

            void push(String string) {
                this.add(0, string);
            }

            String pop() {
                return (String)this.remove(0);
            }
        }
        Stack stack = new Stack();
        stack.push(this.getName());
        JNode jNode = this.parent;
        while (jNode != null) {
            stack.push(jNode.getName());
            jNode = jNode.parent;
        }
        StringBuffer stringBuffer = new StringBuffer(this.path_prefix);
        while (!stack.isEmpty()) {
            if (stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
                stringBuffer.append("/");
            }
            String string = stack.pop();
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void setPathPrefix(String string) {
        this.path_prefix = string;
    }

    public String getID() {
        return JNode.getPathID(this.getPath());
    }

    public static String getPathID(String string) {
        return Integer.toHexString(string.hashCode());
    }

    public int size() {
        return this.children.size();
    }

    public Iterator getChildren() {
        return this.children.iterator();
    }

    public void addChild(JNode jNode) {
        this.addChild(this.children.size(), jNode);
    }

    public void addChild(int n, JNode jNode) {
        this.children.add(n, jNode);
        jNode.parent = this;
    }

    public JNode getChild(int n) {
        return (JNode)this.children.get(n);
    }

    public JNode getChild(String string) {
        int n = this.indexOfChild(string);
        if (n < 0) {
            return null;
        }
        return this.getChild(n);
    }

    public JNode removeChild(int n) {
        return (JNode)this.children.remove(n);
    }

    public JNode removeChild(String string) {
        int n = this.indexOfChild(string);
        if (n < 0) {
            return null;
        }
        return this.removeChild(n);
    }

    public int indexOfChild(String string) {
        return this.children.indexOf(new Dumb(string));
    }

    public String[] getChildNames() {
        int n = this.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getChild(i).getName();
        }
        return stringArray;
    }

    public boolean isRoot() {
        return TYPE_ROOT.equals(this.getType());
    }

    public void clear() {
        this.attrs.clear();
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            JNode jNode = (JNode)iterator.next();
            jNode.clear();
            iterator.remove();
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public static JNode clone(JNode jNode) {
        String string;
        JNode jNode2 = new JNode(jNode.getType());
        Iterator iterator = jNode.getAttributeNames();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            jNode2.setAttribute(string, jNode.getAttribute(string));
        }
        string = jNode.getText();
        jNode2.setText(string);
        return jNode2;
    }

    public String toXML(Properties properties) {
        return JNode.writeXML(this, properties).toString();
    }

    public static StringBuffer writeXML(JNode jNode, Properties properties) {
        properties = XMLUtil.initProperties(properties);
        StringBuffer stringBuffer = new StringBuffer("");
        if (jNode == null) {
            return stringBuffer;
        }
        String string = properties.getProperty("xml.encoding", XMLUtil.ENCODING);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append(string).append("\"?>");
        JNode.ENCODING(jNode, stringBuffer, 0, properties);
        return stringBuffer;
    }

    private static void ENCODING(JNode jNode, StringBuffer stringBuffer, int n, Properties properties) {
        properties = XMLUtil.initProperties(properties);
        if (jNode == null) {
            return;
        }
        String string = properties.getProperty(jNode.getType() + HIDE_SURFIX, "0");
        int n2 = Integer.parseInt(string);
        switch (n2) {
            case 1: {
                Iterator iterator = jNode.getChildren();
                while (iterator.hasNext()) {
                    JNode jNode2 = (JNode)iterator.next();
                    JNode.ENCODING(jNode2, stringBuffer, n, properties);
                }
                break;
            }
            case 2: {
                break;
            }
            default: {
                JNode.INDENT(jNode, stringBuffer, n, properties);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void INDENT(JNode jNode, StringBuffer stringBuffer, int n, Properties properties) {
        Object object;
        boolean bl = Boolean.valueOf(properties.getProperty("xml.indent", Boolean.toString(XMLUtil.INDENT)));
        stringBuffer.append("\r\n");
        if (bl) {
            for (int i = 0; i < n << 2; ++i) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append("<");
        String string2 = jNode.getType();
        String string3 = properties.getProperty(string2 + TAG_SURFIX, string2);
        stringBuffer.append(string3).append(" ");
        Iterator iterator = jNode.getAttributeNames();
        while (iterator.hasNext()) {
            void var9_14;
            String string4 = (String)iterator.next();
            if ("src".equals(string4)) {
                String string = jNode.getAttribute(string4) + jNode.getPath();
            } else {
                String string = jNode.getAttribute(string4);
            }
            String string5 = XMLUtil.normalize((String)var9_14);
            object = properties.getProperty(string4 + MAP_SURFIX, string4);
            stringBuffer.append((String)object).append("=\"").append(string5).append("\" ");
        }
        boolean bl2 = string2.equals("dynamic.formula") || string2.equals("dynamic.formula.used") || string2.equals("dynamic.formula.used.error") || string2.equals("dynamic.formula.error");
        for (String string : properties.keySet()) {
            String string4;
            int n2;
            if (!string.startsWith(ATT_PREFIX)) continue;
            object = properties.getProperty(string);
            String string5 = jNode.getType();
            if (bl2 && (n2 = jNode.size()) > 0) {
                JNode jNode2 = jNode.getChild(jNode.size() - 1);
                String string6 = jNode2.getText();
                try {
                    int n3 = Integer.parseInt(string6);
                    switch (n3) {
                        case 1: {
                            string5 = "detail";
                            break;
                        }
                        case 2: {
                            string5 = "dimension";
                            break;
                        }
                        case 3: {
                            string5 = "measure";
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string4 = properties.getProperty(string5 + "." + (String)object)) == null) continue;
            String string7 = XMLUtil.normalize(string4);
            stringBuffer.append((String)object).append("=\"").append(string7).append("\" ");
        }
        stringBuffer.append(NODE_ID).append("=\"").append(jNode.getID()).append("\" ");
        String string = XMLUtil.normalize(jNode.getText());
        if (string != null && string.length() != 0) {
            stringBuffer.append(">");
            stringBuffer.append(string);
        }
        if (jNode.size() != 0) {
            stringBuffer.append(">");
            iterator = jNode.getChildren();
            while (iterator.hasNext()) {
                object = (JNode)iterator.next();
                JNode.ENCODING((JNode)object, stringBuffer, n + 1, properties);
            }
            stringBuffer.append("\r\n</").append(string3).append(">");
        } else if (string != null && string.length() != 0) {
            stringBuffer.append("</").append(string3).append(">");
        } else {
            stringBuffer.append("/>");
        }
    }

    public static Document toDocument(JNode jNode, Properties properties) {
        properties = XMLUtil.initProperties(properties);
        if (jNode == null) {
            return null;
        }
        Document document = XMLUtil.newDocument();
        Element element = jNode.SEDU(document, null, properties);
        document.appendChild(element);
        return document;
    }

    private Element SEDU(Document document, Element element, Properties properties) {
        String string = this.getType();
        String string2 = properties.getProperty(string + TAG_SURFIX, string);
        if (element == null) {
            Element element2 = document.createElement(string2);
            this.add(element2, properties);
            Iterator iterator = this.getChildren();
            this.Z(document, element2, iterator, properties);
            return element2;
        }
        String string3 = properties.getProperty(this.getType() + HIDE_SURFIX, "0");
        int n = Integer.parseInt(string3);
        Iterator iterator = null;
        switch (n) {
            case 1: {
                iterator = this.getChildren();
                this.Z(document, element, iterator, properties);
                break;
            }
            case 2: {
                break;
            }
            default: {
                Element element3 = document.createElement(string2);
                this.add(element3, properties);
                element.appendChild(element3);
                iterator = this.getChildren();
                this.Z(document, element3, iterator, properties);
            }
        }
        return null;
    }

    private void Z(Document document, Element element, Iterator iterator, Properties properties) {
        Object object;
        while (iterator.hasNext()) {
            object = (JNode)iterator.next();
            super.SEDU(document, element, properties);
        }
        object = this.getText();
        if (object != null) {
            element.appendChild(document.createTextNode((String)object));
        }
    }

    private void add(Element element, Properties properties) {
        String string;
        Iterator<Object> iterator = this.getAttributeNames();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            string = this.getAttribute(string2);
            String string22 = properties.getProperty(string2 + MAP_SURFIX, string2);
            element.setAttribute(string22, string);
        }
        for (String string3 : properties.keySet()) {
            if (!string3.startsWith(ATT_PREFIX)) continue;
            string = properties.getProperty(string3);
            String string4 = properties.getProperty(this.getType() + "." + string);
            if (string4 == null) continue;
            element.setAttribute(string, string4);
        }
    }

    static class Dumb {
        String s;

        Dumb(String string) {
            this.s = string;
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean equals(Object object) {
            return object != null && this.hashCode() == object.hashCode();
        }
    }
}

