/*
 * Decompiled with CFR 0.152.
 */
package server.servlet;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import jet.server.log.ServiceLogger;

public class ServletLoader
extends ClassLoader {
    protected Hashtable classes = new Hashtable();
    protected Hashtable servlets = new Hashtable();
    protected String dir;

    public ServletLoader(String string) {
        this.dir = string;
    }

    public synchronized Servlet loadServlet(String string, ServletConfig servletConfig) throws ServletException {
        Servlet servlet = (Servlet)this.servlets.get(string);
        if (servlet != null) {
            return servlet;
        }
        try {
            servlet = (Servlet)this.loadClass(string, true).newInstance();
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        ServletLoader.initProperties(servlet, servletConfig);
        servlet.init(servletConfig);
        this.servlets.put(string, servlet);
        return servlet;
    }

    public static void initProperties(Servlet servlet, ServletConfig servletConfig) throws UnavailableException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(servlet.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                int n;
                Method method;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                String string = Introspector.decapitalize(propertyDescriptor.getName());
                String string2 = servletConfig.getInitParameter(string);
                if (string2 == null || (method = propertyDescriptor.getWriteMethod()) == null || !Modifier.isPublic(n = method.getModifiers())) continue;
                Class<?> clazz = propertyDescriptor.getPropertyType();
                Object[] objectArray = new Object[1];
                if (clazz.equals(String.class)) {
                    objectArray[0] = string2;
                } else if (clazz.equals(Boolean.TYPE)) {
                    objectArray[0] = new Boolean(string2);
                } else if (clazz.equals(Byte.TYPE)) {
                    objectArray[0] = new Byte(string2);
                } else if (clazz.equals(Short.TYPE)) {
                    objectArray[0] = new Short(string2);
                } else if (clazz.equals(Integer.TYPE)) {
                    objectArray[0] = new Integer(string2);
                } else if (clazz.equals(Long.TYPE)) {
                    objectArray[0] = new Long(string2);
                } else if (clazz.equals(Float.TYPE)) {
                    objectArray[0] = new Float(string2);
                } else if (clazz.equals(Double.TYPE)) {
                    objectArray[0] = new Double(string2);
                }
                method.invoke((Object)servlet, objectArray);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new UnavailableException(exception.getMessage());
        }
    }

    public Enumeration getServlets() {
        return this.servlets.elements();
    }

    public Enumeration getServletNames() {
        return this.servlets.keys();
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = (Class)this.classes.get(string);
        if (clazz == null) {
            try {
                return this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.loadClass(string, this.dir);
                if (clazz == null) {
                    throw new ClassNotFoundException();
                }
                if (!string.equals(clazz.getName())) {
                    throw new ClassFormatError();
                }
                this.classes.put(string, clazz);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String string, String string2) {
        FileInputStream fileInputStream;
        String string3 = string.replace('.', File.separatorChar) + ".class";
        File file = new File(string2, string3);
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        try {
            int n2;
            for (int i = 0; i < n; i += n2) {
                n2 = fileInputStream.read(byArray, i, n - i);
                if (i != -1) continue;
                Class clazz = null;
                return clazz;
            }
        }
        catch (IOException iOException) {
            Class clazz = null;
            return clazz;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return this.defineClass(byArray, 0, n);
    }
}

