/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.servlets.RcServlet;
import jet.server.util.HtmlEncoder;
import jet.server.util.ServerUtil;
import server.servlet.http.HttpAdminServer;
import server.servlet.http.HttpRequest;
import server.servlet.http.HttpResponse;
import server.servlet.http.HttpServerHandlerBase;
import server.servlet.http.MessageBytes;

public class HttpAdminServerHandler
extends HttpServerHandlerBase {
    protected HttpAdminServerHandler(HttpAdminServer httpAdminServer) {
        super(httpAdminServer);
    }

    @Override
    protected void service(HttpRequest httpRequest, HttpResponse httpResponse) throws ServletException, IOException {
        MessageBytes messageBytes = httpRequest.getRequestPath();
        String string = this.parsePath(messageBytes, httpRequest);
        ServiceLogger.logDebug(6680135, string, 6);
        String string2 = this.getValidPath(string);
        if (ServerEnv.isVirtualLicence() && ServerEnv.checkExpired() != null && (string2 == null || !string2.endsWith(".gif") && !string2.endsWith(".css"))) {
            string2 = "/admin/expired.jsp";
        }
        if (string2 == null) {
            httpResponse.sendError(404, "The requested resource (" + messageBytes.toString() + ") is not available.");
            return;
        }
        if (string2.equals("") || string2.equals("/")) {
            string2 = "/admin/select.jsp";
        }
        string = string2;
        httpRequest.setServletPath(string);
        boolean bl = false;
        if (string.startsWith("/jinfonet") || string.startsWith("/adhoc")) {
            httpResponse.sendError(403, "Please use http server port " + this.server.port + " to access it!");
            return;
        }
        if (string.toLowerCase().indexOf("<script>") != -1 || string.toLowerCase().indexOf("%3cscript%3e") != -1 || string.toLowerCase().indexOf("javascript:") != -1 || string.toLowerCase().indexOf("vbscript:") != -1) {
            httpResponse.sendError(404, "File not found!");
            return;
        }
        if (string.startsWith("/jradmin")) {
            httpRequest.setServletPath("/jradmin");
            String string3 = string.substring("/jradmin".length());
            if (string3.equals("") || string3.equals("/")) {
                string3 = null;
            }
            httpRequest.setPathInfo(string3);
            RcServlet rcServlet = ((HttpAdminServer)this.server).getRcServlet();
            if (rcServlet != null) {
                rcServlet.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            } else {
                httpResponse.sendError(404, "Cannot load jrservlet for serving request");
            }
            bl = true;
        } else if (string.startsWith("/vt") || string.toLowerCase().endsWith(".vt")) {
            block27: {
                Servlet servlet = this.server.getServlet("webos");
                if (servlet == null) {
                    httpResponse.sendError(404, "Cannot load servlet webos for serving request");
                    return;
                }
                if (string.startsWith("/vt")) {
                    String string4 = "/vt";
                    this.I(httpRequest, string, string4);
                }
                try {
                    servlet.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
                catch (ServletException servletException) {
                    String string5 = servletException.getMessage();
                    if (string5 == null || string5.indexOf("can't mix text and binary input") >= 0) break block27;
                    throw servletException;
                }
            }
            bl = true;
        } else if (string.toLowerCase().endsWith(".jsp")) {
            block28: {
                if (!new File(this.server.getRealPath(string)).exists()) {
                    httpResponse.sendError(404, "File not found: " + HtmlEncoder.encode(string));
                    return;
                }
                Servlet servlet = ((HttpAdminServer)this.server).getServer().getServlet("jspservlet");
                if (servlet == null) {
                    httpResponse.sendError(404, "Cannot load servlet jspservlet for serving request");
                    return;
                }
                try {
                    servlet.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
                catch (ServletException servletException) {
                    String string6 = servletException.getMessage();
                    if (string6 == null || string6.indexOf("can't mix text and binary input") >= 0) break block28;
                    throw servletException;
                }
            }
            bl = true;
        } else if (string.indexOf("/help/") != -1) {
            block29: {
                Servlet servlet = ((HttpAdminServer)this.server).getServer().getServlet("sendfile");
                if (servlet == null) {
                    httpResponse.sendError(404, "Cannot load sendfile jspservlet for serving request");
                    return;
                }
                try {
                    String string7 = "/servlet/sendfile";
                    this.I(httpRequest, string, string7);
                    servlet.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
                catch (ServletException servletException) {
                    String string8 = servletException.getMessage();
                    if (string8 == null || string8.indexOf("can't mix text and binary input") >= 0) break block29;
                    throw servletException;
                }
            }
            bl = true;
        }
        if (!bl) {
            this.SEDU(httpRequest, httpResponse, string);
        }
    }

    private void I(HttpRequest httpRequest, String string, String string2) {
        httpRequest.setServletPath(string2);
        String string3 = string.substring(string2.length());
        if (string3.equals("") || string3.equals("/")) {
            string3 = null;
        }
        httpRequest.setPathInfo(string3);
    }

    private void SEDU(HttpRequest httpRequest, HttpResponse httpResponse, String string) throws IOException {
        Object object;
        ServiceLogger.logDebug(6680029, string, 6);
        if (string == null || string.equals("") || string.equals("/")) {
            string = "/admin/select.htm";
        }
        String string2 = string;
        String string3 = "";
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string3 = string2.substring(n);
        }
        String[] stringArray = ServerEnv.getMimeTypeTable().getMimeTypeAndEncoding(string3);
        httpResponse.setContentType(stringArray[0]);
        if (stringArray[1] != null) {
            httpResponse.setHeader("Content-Encoding", stringArray[1]);
        }
        try {
            if (string.endsWith("/") || string.endsWith(File.separator) || string.startsWith("/..") || string.endsWith(".jsp.bak")) {
                httpResponse.sendError(404, "File " + string + " not found!");
                return;
            }
            if (string.indexOf("<script>") > 0 || string.indexOf("javascript:") > 0) {
                httpResponse.sendError(404, "File not found!");
                return;
            }
            object = new File(this.server.getRealPath(string));
            if (((File)object).isDirectory()) {
                httpResponse.sendError(404, "File " + string + " not found!");
                return;
            }
            if (ServerUtil.isFileNotModified((File)object, httpRequest, httpResponse)) {
                HttpSession httpSession = httpRequest.getSession(false);
                String string4 = httpSession == null ? null : httpSession.getId();
                ServiceLogger.logAccessSuccessEvent(ServerEnv.getActiveRealm(), httpRequest.getRemoteUser(), string4, 5680030, string, 5);
                return;
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        httpResponse.setStatus(200);
        object = httpResponse.getOutputStream();
        InputStream inputStream = this.server.getResourceAsStream(string);
        if (inputStream == null) {
            httpResponse.sendError(404, "File " + string + " not found!");
            return;
        }
        httpResponse.setContentLength(inputStream.available());
        byte[] byArray = new byte[8192];
        try {
            int n2 = inputStream.read(byArray);
            while (n2 > 0) {
                ((OutputStream)object).write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        inputStream.close();
        ((OutputStream)object).close();
        HttpSession httpSession = httpRequest.getSession(false);
        String string5 = httpSession == null ? null : httpSession.getId();
        ServiceLogger.logAccessSuccessEvent(ServerEnv.getActiveRealm(), httpRequest.getRemoteUser(), string5, 5680031, string, 6);
    }
}

