/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.security.Principal;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jet.JSRuntimeException;
import jet.cs.CSUtil;
import jet.server.log.ServiceLogger;
import server.servlet.ServletConnection;
import server.servlet.http.HttpInputStream;
import server.servlet.http.HttpRequestLine;
import server.servlet.http.HttpResponse;
import server.servlet.http.HttpServerBase;
import server.servlet.http.HttpServerHandlerBase;
import server.servlet.http.HttpSessionImpl;
import server.servlet.http.InvalidRequestException;
import server.servlet.http.MessageBytes;
import server.servlet.http.MessageString;
import server.servlet.http.MimeHeaders;
import server.servlet.http.SessionContextImpl;

public class HttpRequest
implements HttpServletRequest,
Cloneable {
    private String KeepAliveInitValue = "http";
    private String SEDU = "session";
    protected HttpRequestLine line = new HttpRequestLine();
    protected final MessageString servletPath = new MessageString();
    protected final MessageString pathInfo = new MessageString();
    protected String assignedRequestURI;
    protected boolean isRequestURIAssigned;
    protected MessageBytes requestPath;
    protected final MessageString remoteUser = new MessageString();
    protected final MessageString authType = new MessageString();
    protected MimeHeaders headers = new MimeHeaders();
    protected HttpInputStream in = new HttpInputStream();
    protected ServletConnection con;
    protected int length;
    private boolean addElement;
    private String append;
    private MessageBytes charAt;
    private String clear;
    private int clone = -1;
    private int containsKey = -1;
    protected Dictionary params;
    private Dictionary cookiesSupported;
    protected HttpSessionImpl session;
    protected String requestedSessionID;
    protected SessionContextImpl sessionContext;
    protected HttpResponse response;
    private Map copyInto = new Hashtable();
    private static final String createSessionCookie = "GET";
    private static final String dump = "POST";
    private Hashtable elements = new Hashtable();
    private String equals;
    private BufferedReader equalsIgnoreCase;
    private boolean find;
    private boolean finish;
    private boolean get = false;
    private HttpServerHandlerBase getBytes;
    private String getContentCharset = null;

    public HttpRequest() {
    }

    public HttpRequest(HttpServerHandlerBase httpServerHandlerBase) {
        this.getBytes = httpServerHandlerBase;
    }

    public Cookie[] getCookies() {
        String[] stringArray = null;
        stringArray = this.getHeaders().getHeaders("Cookie");
        if (stringArray == null) {
            return null;
        }
        Vector<Cookie> vector = new Vector<Cookie>();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], ",;");
            Cookie cookie = null;
            while (stringTokenizer.hasMoreElements()) {
                String string = null;
                String string2 = null;
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
                if (!stringTokenizer2.hasMoreElements()) continue;
                string = stringTokenizer2.nextToken().trim();
                if (!stringTokenizer2.hasMoreElements()) continue;
                string2 = stringTokenizer2.nextToken().trim();
                if (stringTokenizer2.hasMoreElements()) continue;
                if (string.charAt(0) == '$') {
                    if (string.equalsIgnoreCase("$Version")) {
                        n = Integer.parseInt(string2);
                        continue;
                    }
                    if (string.equalsIgnoreCase("$Domain") && cookie != null) {
                        cookie.setDomain(string2);
                        continue;
                    }
                    if (!string.equalsIgnoreCase("$Path") || cookie == null) continue;
                    cookie.setPath(string2);
                    continue;
                }
                try {
                    cookie = new Cookie(string, string2);
                    cookie.setVersion(n);
                    vector.addElement(cookie);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        Object[] objectArray = new Cookie[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void init(ServletConnection servletConnection) throws IOException {
        this.con = servletConnection;
        this.addElement = HttpResponse.KeepAliveInitValue;
        this.KeepAliveInitValue();
        this.in.init(servletConnection.getInputStream());
    }

    private void KeepAliveInitValue() {
        this.equals = null;
        this.equalsIgnoreCase = null;
        this.find = false;
        this.finish = false;
        this.append = null;
        this.charAt = null;
        this.clear = null;
        this.clone = -1;
        this.containsKey = -1;
        this.params = null;
        this.session = null;
        this.requestedSessionID = null;
        this.assignedRequestURI = null;
        this.isRequestURIAssigned = false;
        this.requestPath = null;
        this.servletPath.reset();
        this.remoteUser.reset();
        this.pathInfo.reset();
        this.headers.clear();
        this.copyInto.clear();
    }

    public boolean next() throws IOException, InvalidRequestException {
        boolean bl = false;
        while (!bl) {
            this.in.next();
            try {
                if (!this.line.parse(this.in)) {
                    return false;
                }
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.line.line == null || this.line.line.length() != 0) {
                    throw new InvalidRequestException();
                }
                throw new InvalidRequestException("Bad request:" + this.line.toString());
            }
            catch (SocketException socketException) {
                String string = socketException.getMessage();
                String string2 = this.line.line.toString();
                if (string2 != null && string2.length() > 0) {
                    String string3 = this.con.getRemoteAddr() + "(" + this.con.getRemoteHost() + ")";
                    ServiceLogger.logError(6680039, new Object[]{string, this.line.line, string3}, 6);
                }
                return false;
            }
        }
        this.KeepAliveInitValue();
        if (this.line.isFullRequest()) {
            try {
                this.headers.read(this.in);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidRequestException();
            }
            MessageBytes messageBytes = this.line.getMethod();
            this.length = messageBytes.equals(createSessionCookie) || messageBytes.equals("HEAD") ? -1 : this.headers.getIntHeader("Content-Length");
            if (this.length != -1) {
                this.in.setContentLength(this.length);
            }
            if (this.addElement) {
                String string = this.getHeader("Connection");
                if (string != null) {
                    if (this.getProtocolBytes().equals("HTTP/1.0")) {
                        if (!string.equalsIgnoreCase("Keep-Alive")) {
                            this.addElement = false;
                        }
                    } else if (string.equalsIgnoreCase("Close")) {
                        this.addElement = false;
                    }
                } else if (this.getProtocolBytes().equals("HTTP/1.0")) {
                    this.addElement = false;
                }
            }
        } else {
            this.addElement = false;
            this.length = -1;
        }
        return true;
    }

    public void finish() throws IOException {
        this.in.finish();
    }

    public void reset() throws IOException {
        this.KeepAliveInitValue();
        this.in.resets();
        this.line.reset();
    }

    public boolean isFullRequest() {
        return this.line.isFullRequest();
    }

    public boolean isProxyRequest() {
        return this.line.isProxyRequest();
    }

    public MimeHeaders getHeaders() {
        return this.headers;
    }

    public void setKeepAlive(boolean bl) {
        this.addElement = bl;
    }

    public boolean getKeepAlive() {
        return this.addElement;
    }

    public MessageBytes getRequestPath() {
        if (this.requestPath != null) {
            return this.requestPath;
        }
        return this.line.getRequestPath();
    }

    public void setRequestPath(String string) {
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, byArray.length, byArray, 0);
        this.requestPath = new MessageBytes(byArray, 0, byArray.length);
    }

    public MessageBytes getRequestLine() {
        return this.line.getRequestLine();
    }

    public HttpRequestLine getReqLine() {
        return this.line;
    }

    public void setServletPath(String string) {
        this.servletPath.setString(string);
    }

    public void setServletPath(byte[] byArray, int n, int n2) {
        this.servletPath.setBytes(byArray, n, n2);
    }

    public void setPathInfo(String string) {
        this.pathInfo.setString(string);
    }

    public void setPathInfo(byte[] byArray, int n, int n2) {
        this.pathInfo.setBytes(byArray, n, n2);
    }

    public int getContentLength() {
        return this.length;
    }

    public String getContentType() {
        if (this.equals == null) {
            this.equals = this.headers.getHeader("Content-Type");
        }
        return this.equals;
    }

    public String getProtocol() {
        if (this.append != null) {
            return this.append;
        }
        this.append = this.getProtocolBytes().toString();
        return this.append;
    }

    public MessageBytes getProtocolBytes() {
        if (this.charAt != null) {
            return this.charAt;
        }
        this.charAt = this.line.getProtocol();
        return this.charAt;
    }

    public String getScheme() {
        return this.KeepAliveInitValue;
    }

    public void setScheme(String string) {
        this.KeepAliveInitValue = string;
    }

    public String getVersion() {
        if (this.clear != null) {
            return this.clear;
        }
        String string = this.getProtocol();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(47);
        if (n == -1) {
            return null;
        }
        this.clear = string.substring(n + 1);
        return this.clear;
    }

    public int getMajorVersion() {
        if (this.clone != -1) {
            return this.clone;
        }
        String string = this.getVersion();
        if (this.clear == null) {
            return 0;
        }
        int n = this.clear.indexOf(46);
        if (n == -1) {
            return 0;
        }
        this.clone = Integer.parseInt(this.clear.substring(0, n));
        return this.clone;
    }

    public int getMinorVersion() {
        if (this.containsKey != -1) {
            return this.containsKey;
        }
        String string = this.getVersion();
        if (this.clear == null) {
            return 0;
        }
        int n = this.clear.indexOf(46);
        if (n == -1) {
            return 0;
        }
        this.containsKey = Integer.parseInt(this.clear.substring(n + 1));
        return this.containsKey;
    }

    public String getServerName() {
        String string = this.getHeader("Host");
        if (string == null) {
            string = this.con.getServerName();
        } else {
            int n = string.indexOf(58);
            if (n != -1) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    public int getServerPort() {
        return this.con.getServerPort();
    }

    public String getRemoteAddr() {
        return this.con.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.con.getRemoteHost();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.find) {
            throw new IllegalStateException("can't mix text and binary input");
        }
        this.finish = true;
        return this.in;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this.finish) {
            throw new IllegalStateException("can't mix text and binary input");
        }
        if (this.equalsIgnoreCase == null) {
            this.find = true;
            String string = HttpResponse.getContentCharset(this.getContentType());
            this.equalsIgnoreCase = new BufferedReader(new InputStreamReader((InputStream)((Object)this.in), string));
        }
        return this.equalsIgnoreCase;
    }

    public String getParameter(String string) {
        String[] stringArray;
        if (this.params == null) {
            this.params = this.addElement();
        }
        if ((stringArray = (String[])this.params.get(string)) == null) {
            return null;
        }
        String string2 = stringArray[0];
        return string2;
    }

    public String[] getParameterValues(String string) {
        if (this.params == null) {
            this.params = this.addElement();
        }
        return (String[])this.params.get(string);
    }

    public Enumeration getParameterNames() {
        if (this.params == null) {
            this.params = this.addElement();
        }
        return this.params.keys();
    }

    public void setSessionContext(SessionContextImpl sessionContextImpl) {
        this.sessionContext = sessionContextImpl;
    }

    public void setResponse(HttpResponse httpResponse) {
        this.response = httpResponse;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        if (this.session != null && this.session.isValid()) {
            return this.session;
        }
        if (this.isRequestedSessionIdValid()) {
            return this.session;
        }
        if (bl) {
            Cookie cookie = this.createSessionCookie();
            this.session = new HttpSessionImpl(this.sessionContext, this.getBytes.server, cookie);
            if (this.cookiesSupported()) {
                this.session.setCookieSupported(true);
            }
        } else {
            this.session = null;
        }
        this.response.setHttpSession(this.session);
        return this.session;
    }

    protected boolean cookiesSupported() {
        return this.getHeaders().find("Cookie") != null;
    }

    protected Cookie createSessionCookie() {
        String string = "JRSERVERCOOKIE";
        Cookie cookie = new Cookie(this.SEDU, string);
        cookie.setComment("Session ID");
        cookie.setPath("/");
        return cookie;
    }

    public String getRequestedSessionId() {
        if (this.requestedSessionID != null) {
            return this.requestedSessionID;
        }
        Cookie cookie = this.getCookie(this.SEDU);
        if (cookie != null) {
            this.requestedSessionID = cookie.getValue();
        }
        return this.requestedSessionID;
    }

    protected Cookie getCookie(String string) {
        Cookie[] cookieArray = this.getCookies();
        Cookie cookie = null;
        if (cookieArray == null) {
            return null;
        }
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals(string)) continue;
            cookie = (Cookie)cookieArray[i].clone();
            break;
        }
        return cookie;
    }

    public boolean isRequestedSessionIdFromCookie() {
        String string = this.getRequestedSessionId();
        return string != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        if (this.isRequestedSessionIdFromCookie()) {
            this.session = (HttpSessionImpl)this.sessionContext.getSession(this.requestedSessionID);
            if (this.session != null) {
                this.session.setNew(false);
                this.session.setCookieSupported(true);
                this.session.setLastAccessedTime();
                this.response.setHttpSession(this.session);
                return true;
            }
        }
        return false;
    }

    public String getLine() {
        return this.line.toString();
    }

    public String getMethod() {
        MessageBytes messageBytes = this.line.getMethod();
        if (createSessionCookie.equals(messageBytes.toString())) {
            return createSessionCookie;
        }
        if (dump.equals(messageBytes.toString())) {
            return dump;
        }
        return messageBytes.toString();
    }

    public String getRequestURI() {
        String string = this.isRequestURIAssigned ? this.assignedRequestURI : this.line.getURI().toString();
        return string;
    }

    public void setRequestURI(String string) {
        this.isRequestURIAssigned = true;
        this.assignedRequestURI = string;
    }

    public String getServletPath() {
        return this.servletPath.toString();
    }

    public String getPathInfo() {
        return this.SEDU(this.pathInfo.toString());
    }

    public String getPathTranslated() {
        String string = this.getPathInfo();
        if (string != null) {
            return this.con.getRealPath(string);
        }
        return null;
    }

    public String getRealPath(String string) {
        return this.con.getRealPath(string);
    }

    public String getQueryString() {
        return this.line.getQueryString().toString();
    }

    public void setRemoteUser(String string) {
        this.remoteUser.setString(string);
    }

    public void setRemoteUser(byte[] byArray, int n, int n2) {
        this.remoteUser.setBytes(byArray, n, n2);
    }

    public String getRemoteUser() {
        return this.remoteUser.toString();
    }

    public void setAuthType(String string) {
        this.authType.setString(string);
    }

    public void setAuthType(byte[] byArray, int n, int n2) {
        this.authType.setBytes(byArray, n, n2);
    }

    public String getAuthType() {
        return this.authType.toString();
    }

    public String getHeader(String string) {
        return this.headers.getHeader(string);
    }

    public void setHeader(String string, String string2) {
        this.headers.putHeader(string, string2);
    }

    public int getIntHeader(String string) {
        return this.headers.getIntHeader(string);
    }

    public long getDateHeader(String string) {
        return this.headers.getDateHeader(string);
    }

    public Enumeration getHeaderNames() {
        return this.headers.names();
    }

    public Enumeration getAttributeNames() {
        return new Vector(this.copyInto.keySet()).elements();
    }

    public Object getAttribute(String string) {
        return this.copyInto.get(string);
    }

    public void removeAttribute(String string) {
        this.copyInto.remove(string);
    }

    public void setAttribute(String string, Object object) {
        this.copyInto.put(string, object);
    }

    public void dump(PrintStream printStream) {
        printStream.println(">> REQUEST LINE INFO");
        this.line.dump(printStream);
        printStream.println(">> HEADERS");
        this.headers.dump(printStream);
        printStream.println();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new JSRuntimeException(670017);
        }
    }

    public void addIncluldeParameters(Dictionary dictionary) {
        if (this.params != null) {
            this.cookiesSupported = this.params;
            Enumeration enumeration = this.cookiesSupported.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (dictionary.get(k) != null) continue;
                dictionary.put(k, this.cookiesSupported.get(k));
            }
        }
        this.params = dictionary;
    }

    public void resetParametersDictionary() {
        if (this.cookiesSupported != null) {
            this.params = this.cookiesSupported;
            this.cookiesSupported = null;
        }
    }

    public void setRawInputStream(InputStream inputStream) throws IOException {
        this.finish = false;
        this.find = false;
        this.in.init(inputStream);
    }

    public ServletConnection getConnection() {
        return this.con;
    }

    public boolean isFilterRequest() {
        return this.get;
    }

    public void setFilterRequest(boolean bl) {
        this.get = bl;
    }

    private String SEDU(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(37) == -1) {
            return string;
        }
        int n = string.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                byArray[n2++] = (byte)Integer.parseInt(string.substring(i + 1, i + 3), 16);
                i += 2;
                continue;
            }
            byArray[n2++] = (byte)c;
        }
        try {
            if (CSUtil.getUrlEncoding() != null) {
                return new String(byArray, 0, n2, CSUtil.getUrlEncoding());
            }
            return new String(byArray, 0, n2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, 0, n2);
        }
    }

    private Hashtable addElement() {
        Hashtable hashtable = null;
        String string = this.line.getQueryString().toString();
        if (string != null) {
            try {
                hashtable = CSUtil.parseQueryString(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                hashtable = null;
            }
        }
        if (this.line.getMethod().equals(dump) && this.getContentType() != null && this.getContentType().indexOf("application/x-www-form-urlencoded") != -1) {
            Hashtable hashtable2 = null;
            byte[] byArray = new byte[this.getContentLength()];
            try {
                this.getInputStream().read(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
            try {
                string = CSUtil.getUrlEncoding() != null ? new String(byArray, CSUtil.getUrlEncoding()) : new String(byArray, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = new String(byArray);
            }
            try {
                hashtable2 = CSUtil.parseQueryString(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                hashtable2 = null;
            }
            if (hashtable2 != null) {
                if (hashtable == null) {
                    hashtable = hashtable2;
                } else {
                    Enumeration enumeration = hashtable2.keys();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        if (hashtable.containsKey(string2)) continue;
                        hashtable.put(string2, hashtable2.get(string2));
                    }
                }
            }
        }
        if (hashtable == null) {
            hashtable = this.elements;
        }
        return hashtable;
    }

    public void refreshtoGetCurReqParameters() {
        Hashtable hashtable = this.addElement();
        if (this.params == null) {
            this.params = new Hashtable();
        }
        Enumeration enumeration = hashtable.keys();
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.params.put(string, hashtable.get(string));
        }
    }

    protected void setRequest(HttpRequest httpRequest) {
        this.line = httpRequest.line;
    }

    public HttpServerHandlerBase getHandler() {
        return this.getBytes;
    }

    public String getContextPath() {
        return "";
    }

    public Enumeration getHeaders(String string) {
        return null;
    }

    public boolean isUserInRole(String string) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public StringBuffer getRequestURL() {
        String string = this.getHeader("Host");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getScheme()).append("://").append(string).append(this.getRequestPath().toString());
        return stringBuffer;
    }

    public String getCharacterEncoding() {
        if (this.getContentCharset != null) {
            return this.getContentCharset;
        }
        this.getContentCharset = HttpResponse.getContentCharset(this.getContentType());
        return this.getContentCharset;
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        this.getContentCharset = string;
    }

    public Map getParameterMap() {
        return null;
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        String string2;
        Object object;
        if (string == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            int n;
            object = this.getServletPath();
            string2 = this.getPathInfo();
            String string3 = object;
            if (string2 != null) {
                string3 = string3 + string2;
            }
            string = (n = string3.lastIndexOf(47)) >= 0 ? HttpRequest.append(string3.substring(0, n + 1) + string) : HttpRequest.append(string3 + string);
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("getRequestDispatcher, illeagal path: " + string);
        }
        string = HttpRequest.append(string);
        object = this.getBytes.server;
        string2 = ((HttpServerBase)object).getRequestDispatcher(string);
        return string2;
    }

    private static String append(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2.equals("/.")) {
            return "/";
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n2) + string2.substring(n + 3);
        }
        return string2;
    }
}

