/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.Servlet;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.servlets.JRServlet;
import jet.server.util.ServerUtil;
import jet.server.util.SortExProperties;
import jet.util.AsciiProperties;
import server.servlet.ServletLoader;
import server.servlet.http.HttpAdminServer;
import server.servlet.http.HttpDashboardServer;
import server.servlet.http.HttpResponse;
import server.servlet.http.HttpServerBase;
import server.servlet.http.HttpServerHandler;
import server.servlet.http.JRequestDispatcherImpl;
import server.servlet.http.PreviewServerLocker;

public class HttpServer
extends HttpServerBase {
    private JRServlet I;
    private HttpAdminServer ID_ADMINSERVER;
    private HttpDashboardServer ID_SERVER;
    private Properties SEDU = null;
    static boolean bRestart = false;

    public HttpServer(ExProperties exProperties, boolean bl) throws Exception {
        super(exProperties);
        this.maxHandlers = 100;
        this.maxConnections = 150;
        this.loadProperties(exProperties, bl);
        this.maxHandlers = this.serverProps.getProperty("httpserver.max.handlers", 100);
        this.maxConnections = this.serverProps.getProperty("httpserver.max.connections", 150);
        if (this.maxHandlers > this.maxConnections) {
            this.maxHandlers = this.maxConnections;
        }
        this.mimeTypeTable = ServerEnv.getMimeTypeTable();
        this.shutdownTimeout = ServerEnv.getShutdownTimeout();
        this.htmlPath = ServerEnv.htmlPath;
        JRequestDispatcherImpl.useOldForwardMethod = ServerEnv.isUseOldForwardMethod();
        HttpResponse.outputEncoding = ServerEnv.getOutputEncoding();
    }

    public void setAdminServer(HttpAdminServer httpAdminServer) {
        this.ID_ADMINSERVER = httpAdminServer;
    }

    public HttpAdminServer getAdminServer() {
        return this.ID_ADMINSERVER;
    }

    public void setDashboardServer(HttpDashboardServer httpDashboardServer) {
        this.ID_SERVER = httpDashboardServer;
    }

    public Properties getMappings() {
        if (this.SEDU == null) {
            this.SEDU = new AsciiProperties();
            try {
                String string = ServerEnv.homePath + "bin" + File.separator + "mapping.properties";
                this.SEDU.load(new FileInputStream(string));
            }
            catch (IOException iOException) {
                ServiceLogger.logError(2680075, 2);
                ServiceLogger.logError(iOException);
            }
        }
        return this.SEDU;
    }

    public void loadProperties(ExProperties exProperties, boolean bl) throws Exception {
        Object object;
        if (exProperties.size() > 0) {
            this.servPropName = ServerEnv.getServPropName();
            object = new SortExProperties();
            if (new File(this.servPropName).exists()) {
                ((ExProperties)object).load(this.servPropName);
            }
            ((ExProperties)object).merge(exProperties);
            ((ExProperties)object).save(this.servPropName, "");
        }
        if (!bl) {
            ServerEnv.check();
        } else {
            ServerEnv.recheck();
        }
        this.servPropName = ServerEnv.getServPropName();
        this.serverProps = ServerEnv.getServerProps();
        this.useAllHosts = this.serverProps.getProperty("httpserver.host.all", true);
        this.hostName = this.serverProps.getProperty("httpserver.host.name");
        if (this.hostName == null || this.hostName.trim().length() == 0) {
            this.hostName = "*";
        }
        if (this.useAllHosts || this.hostName.equals("*")) {
            try {
                this.hostAddrs = ServerUtil.getAllLocalAddresses().toArray(new InetAddress[0]);
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println("Unknown host address " + unknownHostException.getMessage());
            }
        } else {
            object = new StringTokenizer(this.hostName, " \t;");
            Vector<InetAddress> vector = new Vector<InetAddress>();
            while (((StringTokenizer)object).hasMoreElements()) {
                String string = ((StringTokenizer)object).nextToken();
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    if (!vector.contains(inetAddress)) {
                        vector.addElement(inetAddress);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    System.err.println("Unknown host address " + string);
                }
                this.hostAddrs = new InetAddress[vector.size()];
                vector.copyInto(this.hostAddrs);
            }
        }
        this.port = this.serverProps.getProperty("httpserver.port", this.port);
        this.securePort = this.serverProps.getProperty("httpserver.ssl.port", this.port);
        this.adminport = this.serverProps.getProperty("httpserver.admin.port", this.adminport);
        this.backlog = this.serverProps.getProperty("httpserver.backlog", this.backlog);
        this.maxHandlers = this.serverProps.getProperty("httpserver.max.handlers", this.maxHandlers);
        this.timeout = this.serverProps.getProperty("httpserver.timeout", this.timeout);
        this.name = this.serverProps.getProperty("httpserver.name", this.name);
        this.servletPropFile = this.serverProps.getProperty("httpserver.servlet.propfile", System.getProperty("reporthome", ".") + File.separator + "bin" + File.separator + "servlet.properties");
        this.loadServletProps();
        this.saveProperties();
    }

    @Override
    public void initLoader() {
        this.setAttribute(ServerEnv.ID_SERVER, this);
        this.setAttribute(ServerEnv.ID_ADMINSERVER, this.ID_ADMINSERVER);
        this.loader = new ServletLoader(".");
        if (this.autoStartedServlets != null) {
            for (int i = 0; i < this.autoStartedServlets.length; ++i) {
                Servlet servlet = this.getServletEx(this.autoStartedServlets[i]);
                if (!(servlet instanceof JRServlet)) continue;
                this.I = (JRServlet)servlet;
            }
        }
    }

    @Override
    protected int getServicePort() {
        return this.port;
    }

    @Override
    protected int getSecureServicePort() {
        return this.securePort;
    }

    JRServlet getJRServlet() {
        return this.I;
    }

    @Override
    protected String getThreadGroupName() {
        return "Server Service";
    }

    @Override
    public void startHandler() {
        HttpServerHandler httpServerHandler = new HttpServerHandler(this);
        this.handlerThreads.addElement(httpServerHandler);
        new Thread(this.handlers, httpServerHandler).start();
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void quit() {
        super.quit();
        ServiceLogger.closeAll();
        PreviewServerLocker.newInstance().destory();
        PreviewServerLocker.releaseInstance();
        System.exit(0);
    }

    public void quitWithoutExit() {
        super.quit();
        ServiceLogger.closeAll();
    }

    public void restart() {
        this.shutdown();
        ExProperties exProperties = new ExProperties();
        try {
            HttpServer httpServer = new HttpServer(exProperties, true);
            this.ID_ADMINSERVER.setServer(httpServer);
            httpServer.setAdminServer(this.ID_ADMINSERVER);
            httpServer.setDashboardServer(this.ID_SERVER);
            httpServer.start();
            bRestart = false;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void needRestart() {
        bRestart = true;
        RestartWaiter restartWaiter = new RestartWaiter(this);
        new Thread(restartWaiter).start();
    }

    @Override
    public String getInitParameter(String string) {
        Hashtable hashtable = this.getAppInitParameters();
        String string2 = (String)hashtable.get(string);
        return string2;
    }

    @Override
    public Enumeration getInitParameterNames() {
        Hashtable hashtable = this.getAppInitParameters();
        return hashtable.keys();
    }

    public void lockForPreviewServer() {
        PreviewServerLocker.newInstance().lock();
    }

    class RestartWaiter
    implements Runnable {
        HttpServer server;

        RestartWaiter(HttpServer httpServer2) {
            this.server = httpServer2;
        }

        @Override
        public void run() {
            this.server.restart();
        }
    }
}

