/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import server.servlet.http.HttpDate;
import server.servlet.http.MessageString;

public class MimeHeaderField {
    protected final MessageString name = new MessageString();
    protected final MessageString value = new MessageString();
    protected int intValue;
    protected final HttpDate dateValue = new HttpDate(0L);
    protected int type = 0;
    protected static final int T_NULL = 0;
    protected static final int T_STR = 1;
    protected static final int T_INT = 2;
    protected static final int T_DATE = 3;
    private static final byte[] DATELEN = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public void reset() {
        this.name.reset();
        this.value.reset();
        this.type = 0;
    }

    public void setName(String string) {
        this.name.setString(string);
    }

    public void setName(byte[] byArray, int n, int n2) {
        this.name.setBytes(byArray, n, n2);
    }

    public void setValue(String string) {
        this.value.setString(string);
        this.type = 1;
    }

    public void setValue(byte[] byArray, int n, int n2) {
        this.value.setBytes(byArray, n, n2);
        this.type = 1;
    }

    public void setIntValue(int n) {
        this.intValue = n;
        this.type = 2;
    }

    public void setDateValue(long l) {
        this.dateValue.setTime(l);
        this.type = 3;
    }

    public void setDateValue() {
        this.dateValue.setTime();
        this.type = 3;
    }

    public String getName() {
        return this.name.toString();
    }

    public String getValue() {
        switch (this.type) {
            case 1: {
                return this.value.toString();
            }
            case 2: {
                return "" + this.intValue;
            }
            case 3: {
                return this.dateValue.toString();
            }
        }
        return null;
    }

    public int getIntValue() throws NumberFormatException {
        switch (this.type) {
            case 1: {
                return this.value.toInteger();
            }
            case 2: {
                return this.intValue;
            }
        }
        throw new NumberFormatException("invalid integer format");
    }

    public long getDateValue() throws IllegalArgumentException {
        switch (this.type) {
            case 1: {
                return this.value.toDate(this.dateValue);
            }
            case 3: {
                return this.dateValue.getTime();
            }
        }
        throw new IllegalArgumentException("invalid date format");
    }

    private int DATELEN(int n, byte[] byArray, int n2) {
        int n3 = 0;
        if (n == 0) {
            byArray[n2] = DATELEN[0];
            return 1;
        }
        for (int i = 1000000000; i > 0; i /= 10) {
            int n4 = n / i;
            if (n4 != 0 && n3 > 0) {
                byArray[n2 + n3++] = DATELEN[n4];
            }
            n %= i;
        }
        return n3;
    }

    public int getBytes(byte[] byArray, int n) {
        int n2 = n;
        n += this.name.getBytes(byArray, n);
        byArray[n++] = 58;
        byArray[n++] = 32;
        switch (this.type) {
            case 1: {
                n += this.value.getBytes(byArray, n);
                break;
            }
            case 2: {
                n += this.DATELEN(this.intValue, byArray, n);
                break;
            }
            case 3: {
                n += this.dateValue.getBytes(byArray, n, HttpDate.DATELEN);
            }
        }
        byArray[n++] = 13;
        byArray[n++] = 10;
        return n - n2;
    }

    public void parse(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        try {
            byte by;
            int n3 = n;
            while ((by = byArray[n++]) != 58 && by != 32) {
                if (by != 10) continue;
                throw new IllegalArgumentException("invalid header format");
            }
            this.setName(byArray, n3, n - n3 - 1);
            while (by == 32) {
                by = byArray[n++];
            }
            if (by != 58) {
                throw new IllegalArgumentException("invalid header format");
            }
            while ((by = byArray[n++]) == 32) {
            }
            this.setValue(byArray, n - 1, n2 - (n - n3 - 1));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid header format");
        }
    }

    public void write(ServletOutputStream servletOutputStream) throws IOException {
        this.name.write(servletOutputStream);
        servletOutputStream.print(": ");
        switch (this.type) {
            case 1: {
                this.value.write(servletOutputStream);
                servletOutputStream.println();
                return;
            }
            case 2: {
                servletOutputStream.println(this.intValue);
                return;
            }
            case 3: {
                this.dateValue.write((OutputStream)servletOutputStream);
                servletOutputStream.println();
                return;
            }
        }
        servletOutputStream.println();
    }

    public boolean nameEquals(String string) {
        return this.name.equalsIgnoreCase(string);
    }

    public boolean nameEquals(byte[] byArray, int n, int n2) {
        return this.name.equalsIgnoreCase(byArray, n, n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name.toString());
        stringBuffer.append(": ");
        switch (this.type) {
            case 1: {
                stringBuffer.append(this.value.toString());
                break;
            }
            case 2: {
                stringBuffer.append(this.intValue);
                break;
            }
            case 3: {
                stringBuffer.append(this.dateValue.toString());
            }
        }
        return stringBuffer.toString();
    }
}

