/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import jet.server.log.ServiceLogger;
import server.servlet.http.HttpServerBase;
import server.servlet.http.JRServerSocketFactory;

public class ServiceHandler
implements Runnable {
    ServerSocket serverSocket;
    int port;
    int backlog;
    InetAddress hostAddr;
    HttpServerBase server;
    int soTimeout;
    private static SSLServerSocketFactory SEDU = null;
    private static JRServerSocketFactory Z = null;

    public InetAddress getHostAddr() {
        return this.hostAddr;
    }

    public String getHostName() {
        String string = this.hostAddr.getHostName();
        if (string != null) {
            return string;
        }
        return this.hostAddr.getHostAddress();
    }

    public ServiceHandler(HttpServerBase httpServerBase, int n, int n2, InetAddress inetAddress, int n3) throws IOException {
        this.server = httpServerBase;
        this.port = n;
        this.backlog = n2;
        this.hostAddr = inetAddress;
        this.soTimeout = n3;
        this.serverSocket = new ServerSocket(n, n2, inetAddress);
    }

    public ServiceHandler(HttpServerBase httpServerBase, int n, int n2, InetAddress inetAddress, boolean bl, int n3) throws IOException {
        this.server = httpServerBase;
        this.port = n;
        this.backlog = n2;
        this.hostAddr = inetAddress;
        this.soTimeout = n3;
        if (bl) {
            try {
                this.serverSocket = this.SEDU(n, n2, inetAddress);
            }
            catch (Exception exception) {
                ServiceLogger.logError("Error when get secure socket, port: " + n + ", hostAddr: " + inetAddress);
                ServiceLogger.logError(exception);
            }
        } else {
            this.serverSocket = new ServerSocket(n, n2, inetAddress);
        }
    }

    private ServerSocket SEDU(int n, int n2, InetAddress inetAddress) throws Exception {
        return JRServerSocketFactory.getInstance().createSocket(n, n2, inetAddress);
    }

    private ServerSocket Z(int n, int n2, InetAddress inetAddress) throws Exception {
        Object object;
        if (SEDU == null) {
            char[] cArray = System.getProperty("server.ssl.cacerts.password", "jinfonet").toCharArray();
            object = SSLContext.getInstance("SSL");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            KeyStore keyStore = KeyStore.getInstance("JKS");
            String string = System.getProperty("server.ssl.cacerts", System.getProperty("reporthome", ".") + File.separator + "lib" + File.separator + "jinserver");
            if (!new File(string).exists()) {
                throw new FileNotFoundException(string);
            }
            keyStore.load(new FileInputStream(string), cArray);
            keyManagerFactory.init(keyStore, cArray);
            ((SSLContext)object).init(keyManagerFactory.getKeyManagers(), null, null);
            SEDU = ((SSLContext)object).getServerSocketFactory();
        }
        object = SEDU.createServerSocket(n, n2, inetAddress);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        block11: {
            try {
                while (!this.server.stop && this.serverSocket != null) {
                    object = this.serverSocket.accept();
                    ((Socket)object).setSoTimeout(this.soTimeout);
                    this.server.addAcceptedConnection((Socket)object);
                }
            }
            catch (IOException iOException) {
                if (this.server.stop) break block11;
                ServiceLogger.logError(iOException, 1);
                if (this.serverSocket == null) break block11;
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
        object = this.server.serviceHandlers;
        synchronized (object) {
            this.server.serviceHandlers.removeElement(this);
        }
        object = this.server;
        synchronized (object) {
            this.server.notifyAll();
        }
    }
}

