/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db;

import java.io.File;
import java.util.Vector;
import jet.dataengine.util.DSLog;
import toolkit.db.JdbcScalarFunctions;
import toolkit.db.SortCompareInterface;

public class MiniSort
implements SortCompareInterface {
    private Vector SEDU;
    private SortCompareInterface compareTo = null;
    private boolean debug = false;
    private boolean elementAt = true;

    public MiniSort(Vector vector, SortCompareInterface sortCompareInterface, boolean bl, boolean bl2) {
        this.SEDU = vector;
        this.compareTo = sortCompareInterface;
        this.debug = bl;
        this.elementAt = bl2;
        if (this.compareTo == null) {
            this.compareTo = this;
        }
    }

    public MiniSort(Vector vector, SortCompareInterface sortCompareInterface, boolean bl) {
        this(vector, sortCompareInterface, false, true);
    }

    public MiniSort(Vector vector, SortCompareInterface sortCompareInterface) {
        this(vector, sortCompareInterface, false);
    }

    public Vector getResult() {
        int n;
        if (this.SEDU == null || this.compareTo == null) {
            return this.SEDU;
        }
        int n2 = this.SEDU.size();
        if (n2 < 2) {
            return this.SEDU;
        }
        int[] nArray = new int[20];
        int n3 = 0;
        int n4 = 1;
        while (true) {
            nArray[n3] = (n4 <<= 1) - 1;
            if (n4 - 1 >= n2) break;
            ++n3;
        }
        int[] nArray2 = new int[n3];
        --n3;
        n4 = 0;
        while (n3 >= 0) {
            nArray2[n4] = nArray[n3];
            --n3;
            ++n4;
        }
        int n5 = 0;
        do {
            n = nArray2[n5];
            for (int i = 0; i < n; ++i) {
                for (n3 = i + n; n3 < n2; n3 += n) {
                    Object e = this.SEDU.elementAt(n3);
                    n4 = n3 - n;
                    while (this.compareTo.isExchangeSortOrder(e, this.SEDU.elementAt(n4))) {
                        this.SEDU.setElementAt(this.SEDU.elementAt(n4), n4 + n);
                        if ((n4 -= n) >= 0) continue;
                    }
                    this.SEDU.setElementAt(e, n4 + n);
                }
            }
            ++n5;
        } while (n > 1);
        return this.SEDU;
    }

    public static Vector sort(Vector vector, SortCompareInterface sortCompareInterface, boolean bl, boolean bl2) {
        return new MiniSort(vector, sortCompareInterface, bl, bl2).getResult();
    }

    public static Vector sort(Vector vector, SortCompareInterface sortCompareInterface, boolean bl) {
        return MiniSort.sort(vector, sortCompareInterface, bl, true);
    }

    public static Vector sort(Vector vector, SortCompareInterface sortCompareInterface) {
        return MiniSort.sort(vector, sortCompareInterface, false);
    }

    public static Vector sort(Vector vector, boolean bl, boolean bl2) {
        return MiniSort.sort(vector, null, bl, bl2);
    }

    public static Vector sort(Vector vector) {
        return MiniSort.sort(vector, false, true);
    }

    @Override
    public boolean isExchangeSortOrder(Object object, Object object2) {
        try {
            if (object != null && object2 != null) {
                String string;
                String string2;
                if (object instanceof String) {
                    string2 = (String)object;
                    string = (String)object2;
                } else if (object instanceof File && object2 instanceof File) {
                    string2 = ((File)object).getName();
                    string = ((File)object2).getName();
                } else {
                    string2 = object.toString();
                    string = object2.toString();
                }
                if (this.elementAt) {
                    string2 = string2.toUpperCase();
                    string = string.toUpperCase();
                }
                if (this.debug ? string2.compareTo(string) > 0 : string2.compareTo(string) < 0) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            DSLog.getDSLog((String)JdbcScalarFunctions.class.getName()).debug((Object)throwable.getMessage());
        }
        return false;
    }

    @Override
    public boolean isLargerOrEqual(Object object, Object object2) {
        return false;
    }

    @Override
    public boolean isLessOrEqual(Object object, Object object2) {
        return false;
    }
}

