package com.ericsson.jreport;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import org.apache.log4j.Logger;

import jet.server.api.UserSession;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUserSessionManager;
import jet.server.api.http.HttpUtil;


public class SessionListener implements HttpSessionListener 
{
	final static Logger log = Logger.getLogger(SessionListener.class);
	
	@Override
	public void sessionCreated(HttpSessionEvent ev) {
	}

	
	@Override
	public void sessionDestroyed(HttpSessionEvent ev) {
		log.debug("Session destroyed.");
		
		try {
			HttpSession hSes = ev.getSession();
			String sesId = (String)hSes.getAttribute("jrs.userssn");
			
			HttpRptServer SEDU = HttpUtil.getHttpRptServer();
			HttpUserSessionManager mgr = SEDU.getHttpUserSessionManager();
			UserSession uSes = mgr.getUserSession(sesId);
			
			if(uSes != null) {
				mgr.logout(uSes);
				log.debug("Logged out of session " + sesId);
			}
		}
		catch(Exception ex) {
			log.error("", ex);
		}
	}

}
