/*
* Created on Dec 4, 2008
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.reports.server.entity;

import static javax.persistence.GenerationType.SEQUENCE;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 * The user session entry.
 * 
 * @author <a href="mailto:francisco.neto@venturus.org.br">xfranet - Francisco Bento</a>
 *
 */
@Entity
@Table(name = "CMS_USER_SESSION")
@NamedQueries({
        @NamedQuery(name = "CMSUserSession.FindBySessionId", query = "SELECT userSession FROM CMSUserSession userSession WHERE userSession.cmsSessionId = :cmsSessionId and userSession.id = :id")
})
public class CMSUserSession implements Serializable {

	/* Serialization UID */
	private static final long serialVersionUID = -7960347958825347186L;

	/* Fields */
    @Id
    @Column(name = "USERSESSIONID")
    @SequenceGenerator(name = "UserSessionID Sequence Generator", sequenceName = "CMS_USER_SESSION_SEQ", allocationSize = 20)
    @GeneratedValue(strategy = SEQUENCE, generator = "UserSessionID Sequence Generator")
	private Long id;

    @Column(name = "USERNAME", nullable = false)
    @Basic(optional = false)
	private String userName;
    
    @Column(name = "CMS_SESSION_ID", nullable = false)
    @Basic(optional = false)
	private String cmsSessionId;
    
    @Column(name = "CREATEDATE", nullable = false)
    @Basic(optional = false)
	private Date creationDate;
    
    @Column(name = "UPDATEDATE", nullable = false)
    @Basic(optional = false)
    private Date updateDate;

	/**
	 * Default Constructor.
	 */
	public CMSUserSession() {
	}

	public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }


    public String getUserName() {
        return userName;
    }


    public void setUserName(String userName) {
        this.userName = userName;
    }


    public String getCmsSessionId() {
        return cmsSessionId;
    }

    public void setCmsSessionId(String cmsSessionId) {
        this.cmsSessionId = cmsSessionId;
    }

    public Date getCreationDate() {
        return creationDate;
    }


    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /*
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		int hashCode = 0;

		if (this.id == null)
			hashCode = super.hashCode();
		else
			hashCode = this.id.hashCode() * 3 + 67;

		return hashCode;
	}

	/*
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof CMSUserSession))
			return false;

		CMSUserSession other = (CMSUserSession) obj;
		if (this.id == null && other.id == null)
			return super.equals(obj);

		return this.id.equals(other.id);
	}
}
